/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfIntValues;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSetOfCharArray;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.index.MemoryIndex;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.SimpleWordSet;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class DiskIndex {
    File indexFile;
    private int headerInfoOffset;
    private int numberOfChunks;
    private int sizeOfLastChunk;
    private int[] chunkOffsets;
    private int documentReferenceSize;
    private int startOfCategoryTables;
    private HashtableOfIntValues categoryOffsets;
    private HashtableOfIntValues categoryEnds;
    private int cacheUserCount;
    private String[][] cachedChunks;
    private HashtableOfObject categoryTables;
    private char[] cachedCategoryName;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static int BUFFER_READ_SIZE = 2048;
    private static final int BUFFER_WRITE_SIZE = 2048;
    private byte[] streamBuffer;
    private int bufferIndex;
    private int bufferEnd;
    private int streamEnd;
    public static final String SIGNATURE = "INDEX VERSION 1.121";
    private static final char[] SIGNATURE_CHARS = "INDEX VERSION 1.121".toCharArray();
    public static boolean DEBUG = false;
    private static final int RE_INDEXED = -1;
    private static final int DELETED = -2;
    private static final int CHUNK_SIZE = 100;
    private static final SimpleSetOfCharArray INTERNED_CATEGORY_NAMES = new SimpleSetOfCharArray(20);

    DiskIndex(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.indexFile = new File(string);
        this.headerInfoOffset = -1;
        this.numberOfChunks = -1;
        this.sizeOfLastChunk = -1;
        this.chunkOffsets = null;
        this.documentReferenceSize = -1;
        this.cacheUserCount = -1;
        this.cachedChunks = null;
        this.categoryTables = null;
        this.cachedCategoryName = null;
        this.categoryOffsets = null;
        this.categoryEnds = null;
    }

    SimpleSet addDocumentNames(String string, MemoryIndex memoryIndex) throws IOException {
        String[] stringArray = this.readAllDocumentNames();
        SimpleSet simpleSet = new SimpleSet(stringArray.length);
        if (string == null) {
            if (memoryIndex == null) {
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    simpleSet.add(stringArray[n]);
                    ++n;
                }
            } else {
                SimpleLookupTable simpleLookupTable = memoryIndex.docsToReferences;
                int n = 0;
                int n3 = stringArray.length;
                while (n < n3) {
                    String string2 = stringArray[n];
                    if (!simpleLookupTable.containsKey(string2)) {
                        simpleSet.add(string2);
                    }
                    ++n;
                }
            }
        } else if (memoryIndex == null) {
            int n = 0;
            int n4 = stringArray.length;
            while (n < n4) {
                if (stringArray[n].startsWith(string, 0)) {
                    simpleSet.add(stringArray[n]);
                }
                ++n;
            }
        } else {
            SimpleLookupTable simpleLookupTable = memoryIndex.docsToReferences;
            int n = 0;
            int n5 = stringArray.length;
            while (n < n5) {
                String string3 = stringArray[n];
                if (string3.startsWith(string, 0) && !simpleLookupTable.containsKey(string3)) {
                    simpleSet.add(string3);
                }
                ++n;
            }
        }
        return simpleSet;
    }

    private HashtableOfObject addQueryResult(HashtableOfObject hashtableOfObject, char[] cArray, HashtableOfObject hashtableOfObject2, MemoryIndex memoryIndex) throws IOException {
        if (hashtableOfObject == null) {
            hashtableOfObject = new HashtableOfObject(13);
        }
        EntryResult entryResult = (EntryResult)hashtableOfObject.get(cArray);
        if (memoryIndex == null) {
            if (entryResult == null) {
                hashtableOfObject.put(cArray, new EntryResult(cArray, hashtableOfObject2));
            } else {
                entryResult.addDocumentTable(hashtableOfObject2);
            }
        } else {
            SimpleLookupTable simpleLookupTable = memoryIndex.docsToReferences;
            if (entryResult == null) {
                entryResult = new EntryResult(cArray, null);
            }
            int[] nArray = this.readDocumentNumbers(hashtableOfObject2.get(cArray));
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                String string = this.readDocumentName(nArray[n]);
                if (!simpleLookupTable.containsKey(string)) {
                    entryResult.addDocumentName(string);
                }
                ++n;
            }
            if (!entryResult.isEmpty()) {
                hashtableOfObject.put(cArray, entryResult);
            }
        }
        return hashtableOfObject;
    }

    HashtableOfObject addQueryResults(char[][] cArray, char[] cArray2, int n, MemoryIndex memoryIndex) throws IOException {
        if (this.categoryOffsets == null) {
            return null;
        }
        HashtableOfObject hashtableOfObject = null;
        if (cArray2 == null) {
            int n2 = 0;
            int n3 = cArray.length;
            while (n2 < n3) {
                HashtableOfObject hashtableOfObject2 = this.readCategoryTable(cArray[n2], true);
                if (hashtableOfObject2 != null) {
                    char[][] cArray3 = hashtableOfObject2.keyTable;
                    if (hashtableOfObject == null) {
                        hashtableOfObject = new HashtableOfObject(hashtableOfObject2.elementSize);
                    }
                    int n4 = 0;
                    int n5 = cArray3.length;
                    while (n4 < n5) {
                        if (cArray3[n4] != null) {
                            hashtableOfObject = this.addQueryResult(hashtableOfObject, cArray3[n4], hashtableOfObject2, memoryIndex);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (hashtableOfObject != null && this.cachedChunks == null) {
                this.cacheDocumentNames();
            }
        } else {
            switch (n) {
                case 8: {
                    int n6 = 0;
                    int n7 = cArray.length;
                    while (n6 < n7) {
                        HashtableOfObject hashtableOfObject3 = this.readCategoryTable(cArray[n6], false);
                        if (hashtableOfObject3 != null && hashtableOfObject3.containsKey(cArray2)) {
                            hashtableOfObject = this.addQueryResult(hashtableOfObject, cArray2, hashtableOfObject3, memoryIndex);
                        }
                        ++n6;
                    }
                    break;
                }
                case 9: {
                    int n8 = 0;
                    int n9 = cArray.length;
                    while (n8 < n9) {
                        HashtableOfObject hashtableOfObject4 = this.readCategoryTable(cArray[n8], false);
                        if (hashtableOfObject4 != null) {
                            char[][] cArray4 = hashtableOfObject4.keyTable;
                            int n10 = 0;
                            int n11 = cArray4.length;
                            while (n10 < n11) {
                                char[] cArray5 = cArray4[n10];
                                if (cArray5 != null && cArray2[0] == cArray5[0] && CharOperation.prefixEquals(cArray2, cArray5)) {
                                    hashtableOfObject = this.addQueryResult(hashtableOfObject, cArray5, hashtableOfObject4, memoryIndex);
                                }
                                ++n10;
                            }
                        }
                        ++n8;
                    }
                    break;
                }
                default: {
                    int n12 = 0;
                    int n13 = cArray.length;
                    while (n12 < n13) {
                        HashtableOfObject hashtableOfObject5 = this.readCategoryTable(cArray[n12], false);
                        if (hashtableOfObject5 != null) {
                            char[][] cArray6 = hashtableOfObject5.keyTable;
                            int n14 = 0;
                            int n15 = cArray6.length;
                            while (n14 < n15) {
                                char[] cArray7 = cArray6[n14];
                                if (cArray7 != null && Index.isMatch(cArray2, cArray7, n)) {
                                    hashtableOfObject = this.addQueryResult(hashtableOfObject, cArray7, hashtableOfObject5, memoryIndex);
                                }
                                ++n14;
                            }
                        }
                        ++n12;
                    }
                    break block0;
                }
            }
        }
        if (hashtableOfObject == null) {
            return null;
        }
        return hashtableOfObject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cacheDocumentNames() throws IOException {
        this.cachedChunks = new String[this.numberOfChunks][];
        FileInputStream fileInputStream = new FileInputStream(this.indexFile);
        try {
            try {
                if (this.numberOfChunks > 5) {
                    BUFFER_READ_SIZE <<= 1;
                }
                int n = this.chunkOffsets[0];
                fileInputStream.skip(n);
                this.streamBuffer = new byte[BUFFER_READ_SIZE];
                this.bufferIndex = 0;
                this.bufferEnd = fileInputStream.read(this.streamBuffer, 0, this.streamBuffer.length);
                int n2 = 0;
                while (n2 < this.numberOfChunks) {
                    int n3 = n2 == this.numberOfChunks - 1 ? this.sizeOfLastChunk : 100;
                    this.cachedChunks[n2] = new String[n3];
                    this.readChunk(this.cachedChunks[n2], fileInputStream, 0, n3);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                this.cachedChunks = null;
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            fileInputStream.close();
            this.streamBuffer = null;
            BUFFER_READ_SIZE = 2048;
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        fileInputStream.close();
        this.streamBuffer = null;
        BUFFER_READ_SIZE = 2048;
    }

    private String[] computeDocumentNames(String[] stringArray, int[] nArray, SimpleLookupTable simpleLookupTable, MemoryIndex memoryIndex) {
        int n;
        Object[] objectArray;
        int n2 = stringArray.length;
        Object[] objectArray2 = memoryIndex.docsToReferences.keyTable;
        Object[] objectArray3 = memoryIndex.docsToReferences.valueTable;
        if (n2 == 0) {
            int n3 = 0;
            int n4 = objectArray3.length;
            while (n3 < n4) {
                if (objectArray3[n3] != null) {
                    simpleLookupTable.put(objectArray2[n3], null);
                }
                ++n3;
            }
            String[] stringArray2 = new String[simpleLookupTable.elementSize];
            n4 = 0;
            Object[] objectArray4 = simpleLookupTable.keyTable;
            int n5 = 0;
            int n6 = objectArray4.length;
            while (n5 < n6) {
                if (objectArray4[n5] != null) {
                    stringArray2[n4++] = (String)objectArray4[n5];
                }
                ++n5;
            }
            Util.sort(stringArray2);
            n5 = 0;
            n6 = stringArray2.length;
            while (n5 < n6) {
                simpleLookupTable.put(stringArray2[n5], new Integer(n5));
                ++n5;
            }
            return stringArray2;
        }
        int n7 = 0;
        while (n7 < n2) {
            nArray[n7] = n7;
            ++n7;
        }
        n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = objectArray2.length;
        while (n9 < n10) {
            block26: {
                objectArray = (Object[])objectArray2[n9];
                if (objectArray != null) {
                    n = 0;
                    while (n < n2) {
                        if (objectArray.equals(stringArray[n])) {
                            if (objectArray3[n9] == null) {
                                nArray[n] = -2;
                                ++n7;
                            } else {
                                nArray[n] = -1;
                                ++n8;
                            }
                            break block26;
                        }
                        ++n;
                    }
                    if (objectArray3[n9] != null) {
                        simpleLookupTable.put(objectArray, null);
                    }
                }
            }
            ++n9;
        }
        String[] stringArray3 = stringArray;
        if (n7 > 0 || simpleLookupTable.elementSize > 0) {
            stringArray3 = new String[n2 + simpleLookupTable.elementSize - n7];
            n10 = 0;
            int n11 = 0;
            while (n11 < n2) {
                if (nArray[n11] >= -1) {
                    stringArray3[n10++] = stringArray[n11];
                }
                ++n11;
            }
            objectArray = simpleLookupTable.keyTable;
            n = 0;
            int n12 = objectArray.length;
            while (n < n12) {
                if (objectArray[n] != null) {
                    stringArray3[n10++] = (String)objectArray[n];
                }
                ++n;
            }
            Util.sort(stringArray3);
            n = 0;
            n12 = stringArray3.length;
            while (n < n12) {
                if (simpleLookupTable.containsKey(stringArray3[n])) {
                    simpleLookupTable.put(stringArray3[n], new Integer(n));
                }
                ++n;
            }
        }
        n10 = -1;
        int n13 = 0;
        block13: while (n13 < n2) {
            switch (nArray[n13]) {
                case -2: {
                    ++n13;
                    break;
                }
                case -1: {
                    String string = stringArray3[++n10];
                    if (!string.equals(stringArray[n13])) continue block13;
                    simpleLookupTable.put(string, new Integer(n10));
                    ++n13;
                    break;
                }
                default: {
                    if (!stringArray3[++n10].equals(stringArray[n13])) continue block13;
                    nArray[n13++] = n10;
                }
            }
        }
        return stringArray3;
    }

    private void copyQueryResults(HashtableOfObject hashtableOfObject, int n) {
        char[][] cArray = hashtableOfObject.keyTable;
        Object[] objectArray = hashtableOfObject.valueTable;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            char[] cArray2 = cArray[n2];
            if (cArray2 != null) {
                SimpleWordSet simpleWordSet = (SimpleWordSet)objectArray[n2];
                HashtableOfObject hashtableOfObject2 = (HashtableOfObject)this.categoryTables.get(cArray2);
                if (hashtableOfObject2 == null) {
                    hashtableOfObject2 = new HashtableOfObject(simpleWordSet.elementSize);
                    this.categoryTables.put(cArray2, hashtableOfObject2);
                }
                char[][] cArray3 = simpleWordSet.words;
                int n4 = 0;
                int n5 = cArray3.length;
                while (n4 < n5) {
                    char[] cArray4 = cArray3[n4];
                    if (cArray4 != null) {
                        Object object = hashtableOfObject2.get(cArray4);
                        if (object == null) {
                            hashtableOfObject2.put(cArray4, new int[]{n});
                        } else if (object instanceof IntList) {
                            ((IntList)object).add(n);
                        } else {
                            IntList intList = new IntList((int[])object);
                            intList.add(n);
                            hashtableOfObject2.put(cArray4, intList);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize(boolean bl) throws IOException {
        if (this.indexFile.exists()) {
            if (bl) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "r");
                try {
                    String string = randomAccessFile.readUTF();
                    if (!string.equals(SIGNATURE)) {
                        throw new IOException(Messages.exception_wrongFormat);
                    }
                    this.headerInfoOffset = randomAccessFile.readInt();
                    if (this.headerInfoOffset > 0) {
                        this.readHeaderInfo(randomAccessFile);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    randomAccessFile.close();
                    throw throwable;
                }
                {
                    Object var4_9 = null;
                    randomAccessFile.close();
                    return;
                }
            }
            if (!this.indexFile.delete()) {
                if (!DEBUG) throw new IOException("Failed to delete index " + this.indexFile);
                System.out.println("initialize - Failed to delete index " + this.indexFile);
                throw new IOException("Failed to delete index " + this.indexFile);
            }
        }
        if (!this.indexFile.createNewFile()) {
            if (!DEBUG) throw new IOException("Failed to create new index " + this.indexFile);
            System.out.println("initialize - Failed to create new index " + this.indexFile);
            throw new IOException("Failed to create new index " + this.indexFile);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
        try {
            randomAccessFile.writeUTF(SIGNATURE);
            randomAccessFile.writeInt(-1);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            randomAccessFile.close();
            throw throwable;
        }
        {
            Object var3_6 = null;
            randomAccessFile.close();
            return;
        }
    }

    private void initializeFrom(DiskIndex diskIndex, File file) throws IOException {
        if (file.exists() && !file.delete()) {
            if (DEBUG) {
                System.out.println("initializeFrom - Failed to delete temp index " + this.indexFile);
            }
        } else if (!file.createNewFile()) {
            if (DEBUG) {
                System.out.println("initializeFrom - Failed to create temp index " + this.indexFile);
            }
            throw new IOException("Failed to create temp index " + this.indexFile);
        }
        int n = diskIndex.categoryOffsets == null ? 8 : diskIndex.categoryOffsets.elementSize;
        this.categoryOffsets = new HashtableOfIntValues(n);
        this.categoryEnds = new HashtableOfIntValues(n);
        this.categoryTables = new HashtableOfObject(n);
    }

    private void mergeCategories(DiskIndex diskIndex, int[] nArray, FileOutputStream fileOutputStream) throws IOException {
        char[][] cArray = diskIndex.categoryOffsets.keyTable;
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char[] cArray2 = cArray[n];
            if (cArray2 != null && !this.categoryTables.containsKey(cArray2)) {
                this.categoryTables.put(cArray2, null);
            }
            ++n;
        }
        char[][] cArray3 = this.categoryTables.keyTable;
        n2 = 0;
        int n3 = cArray3.length;
        while (n2 < n3) {
            if (cArray3[n2] != null) {
                this.mergeCategory(cArray3[n2], diskIndex, nArray, fileOutputStream);
            }
            ++n2;
        }
        this.categoryTables = null;
    }

    private void mergeCategory(char[] cArray, DiskIndex diskIndex, int[] nArray, FileOutputStream fileOutputStream) throws IOException {
        HashtableOfObject hashtableOfObject;
        block12: {
            HashtableOfObject hashtableOfObject2;
            hashtableOfObject = (HashtableOfObject)this.categoryTables.get(cArray);
            if (hashtableOfObject == null) {
                hashtableOfObject = new HashtableOfObject(3);
            }
            if ((hashtableOfObject2 = diskIndex.readCategoryTable(cArray, true)) == null) break block12;
            char[][] cArray2 = hashtableOfObject2.keyTable;
            Object[] objectArray = hashtableOfObject2.valueTable;
            int n = 0;
            int n2 = cArray2.length;
            while (n < n2) {
                block13: {
                    Object object;
                    int n3;
                    int[] nArray2;
                    char[] cArray3;
                    block14: {
                        cArray3 = cArray2[n];
                        if (cArray3 == null) break block13;
                        int[] nArray3 = (int[])objectArray[n];
                        int n4 = nArray3.length;
                        nArray2 = new int[n4];
                        n3 = 0;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = nArray[nArray3[n5]];
                            if (n6 > -1) {
                                nArray2[n3++] = n6;
                            }
                            ++n5;
                        }
                        if (n3 >= n4) break block14;
                        if (n3 == 0) break block13;
                        int[] nArray4 = nArray2;
                        nArray2 = new int[n3];
                        System.arraycopy(nArray4, 0, nArray2, 0, n3);
                    }
                    if ((object = hashtableOfObject.get(cArray3)) == null) {
                        hashtableOfObject.put(cArray3, nArray2);
                    } else {
                        IntList intList = null;
                        if (object instanceof IntList) {
                            intList = (IntList)object;
                        } else {
                            intList = new IntList((int[])object);
                            hashtableOfObject.put(cArray3, intList);
                        }
                        int n7 = 0;
                        while (n7 < n3) {
                            intList.add(nArray2[n7]);
                            ++n7;
                        }
                    }
                }
                ++n;
            }
            diskIndex.categoryTables.put(cArray, null);
        }
        this.writeCategoryTable(cArray, hashtableOfObject, fileOutputStream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DiskIndex mergeWith(MemoryIndex memoryIndex) throws IOException {
        String[] stringArray = this.readAllDocumentNames();
        int n = stringArray.length;
        int[] nArray = new int[n];
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(3);
        if ((stringArray = this.computeDocumentNames(stringArray, nArray, simpleLookupTable, memoryIndex)).length == 0) {
            if (n == 0) {
                return this;
            }
            DiskIndex diskIndex = new DiskIndex(this.indexFile.getPath());
            diskIndex.initialize(false);
            return diskIndex;
        }
        DiskIndex diskIndex = new DiskIndex(String.valueOf(this.indexFile.getPath()) + ".tmp");
        try {
            diskIndex.initializeFrom(this, diskIndex.indexFile);
            FileOutputStream fileOutputStream = new FileOutputStream(diskIndex.indexFile, false);
            int n2 = -1;
            try {
                diskIndex.writeAllDocumentNames(stringArray, fileOutputStream);
                stringArray = null;
                if (simpleLookupTable.elementSize > 0) {
                    Object[] objectArray = simpleLookupTable.keyTable;
                    Object[] objectArray2 = simpleLookupTable.valueTable;
                    int n3 = 0;
                    int n4 = objectArray.length;
                    while (n3 < n4) {
                        if (objectArray[n3] != null) {
                            diskIndex.copyQueryResults((HashtableOfObject)memoryIndex.docsToReferences.get(objectArray[n3]), (Integer)objectArray2[n3]);
                        }
                        ++n3;
                    }
                }
                simpleLookupTable = null;
                if (n == 0) {
                    diskIndex.writeCategories(fileOutputStream);
                } else {
                    diskIndex.mergeCategories(this, nArray, fileOutputStream);
                }
                n2 = diskIndex.streamEnd;
                diskIndex.writeHeaderInfo(fileOutputStream);
                nArray = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                fileOutputStream.close();
                this.streamBuffer = null;
                throw throwable;
            }
            {
                Object var13_17 = null;
            }
            fileOutputStream.close();
            this.streamBuffer = null;
            diskIndex.writeOffsetToHeader(n2);
            if (this.indexFile.exists() && !this.indexFile.delete()) {
                if (DEBUG) {
                    System.out.println("mergeWith - Failed to delete " + this.indexFile);
                }
                throw new IOException("Failed to delete index file " + this.indexFile);
            }
            if (!diskIndex.indexFile.renameTo(this.indexFile)) {
                if (DEBUG) {
                    System.out.println("mergeWith - Failed to rename " + this.indexFile);
                }
                throw new IOException("Failed to rename index file " + this.indexFile);
            }
        }
        catch (IOException iOException) {
            if (diskIndex.indexFile.exists() && !diskIndex.indexFile.delete() && DEBUG) {
                System.out.println("mergeWith - Failed to delete temp index " + diskIndex.indexFile);
            }
            throw iOException;
        }
        diskIndex.indexFile = this.indexFile;
        return diskIndex;
    }

    private synchronized String[] readAllDocumentNames() throws IOException {
        String[] stringArray;
        if (this.numberOfChunks <= 0) {
            return CharOperation.NO_STRINGS;
        }
        FileInputStream fileInputStream = new FileInputStream(this.indexFile);
        try {
            int n = this.chunkOffsets[0];
            fileInputStream.skip(n);
            this.streamBuffer = new byte[BUFFER_READ_SIZE];
            this.bufferIndex = 0;
            this.bufferEnd = fileInputStream.read(this.streamBuffer, 0, this.streamBuffer.length);
            int n2 = this.numberOfChunks - 1;
            String[] stringArray2 = new String[n2 * 100 + this.sizeOfLastChunk];
            int n3 = 0;
            while (n3 < this.numberOfChunks) {
                this.readChunk(stringArray2, fileInputStream, n3 * 100, n3 < n2 ? 100 : this.sizeOfLastChunk);
                ++n3;
            }
            stringArray = stringArray2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            fileInputStream.close();
            this.streamBuffer = null;
            throw throwable;
        }
        fileInputStream.close();
        this.streamBuffer = null;
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized HashtableOfObject readCategoryTable(char[] cArray, boolean bl) throws IOException {
        HashtableOfObject hashtableOfObject;
        block30: {
            int n;
            Object object;
            int n2 = this.categoryOffsets.get(cArray);
            if (n2 == Integer.MIN_VALUE) {
                return null;
            }
            if (this.categoryTables == null) {
                this.categoryTables = new HashtableOfObject(3);
            } else {
                object = (HashtableOfObject)this.categoryTables.get(cArray);
                if (object != null) {
                    if (bl) {
                        Object[] objectArray = ((HashtableOfObject)object).valueTable;
                        int n3 = 0;
                        int n4 = objectArray.length;
                        while (n3 < n4) {
                            if (objectArray[n3] instanceof Integer) {
                                objectArray[n3] = this.readDocumentNumbers(objectArray[n3]);
                            }
                            ++n3;
                        }
                    }
                    return object;
                }
            }
            object = new FileInputStream(this.indexFile);
            hashtableOfObject = null;
            Object object2 = null;
            int n5 = 0;
            int n6 = -1;
            this.streamBuffer = new byte[BUFFER_READ_SIZE];
            try {
                try {
                    ((FileInputStream)object).skip(n2);
                    this.bufferIndex = 0;
                    this.bufferEnd = ((FileInputStream)object).read(this.streamBuffer, 0, this.streamBuffer.length);
                    n = this.readStreamInt((FileInputStream)object);
                    try {
                        if (n < 0) {
                            System.err.println("-------------------- DEBUG --------------------");
                            System.err.println("file = " + this.indexFile);
                            System.err.println("offset = " + n2);
                            System.err.println("size = " + n);
                            System.err.println("--------------------   END   --------------------");
                        }
                        hashtableOfObject = new HashtableOfObject(n);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        outOfMemoryError.printStackTrace();
                        System.err.println("-------------------- DEBUG --------------------");
                        System.err.println("file = " + this.indexFile);
                        System.err.println("offset = " + n2);
                        System.err.println("size = " + n);
                        System.err.println("--------------------   END   --------------------");
                        throw outOfMemoryError;
                    }
                    int n7 = 256;
                    int n8 = 0;
                    while (true) {
                        if (n8 >= n) {
                            this.categoryTables.put(INTERNED_CATEGORY_NAMES.get(cArray), hashtableOfObject);
                        }
                        char[] cArray2 = this.readStreamChars((FileInputStream)object);
                        int n9 = this.readStreamInt((FileInputStream)object);
                        if (n9 <= 0) {
                            hashtableOfObject.put(cArray2, new int[]{-n9});
                        } else if (n9 < n7) {
                            hashtableOfObject.put(cArray2, this.readStreamDocumentArray((FileInputStream)object, n9));
                        } else {
                            n9 = this.readStreamInt((FileInputStream)object);
                            if (bl) {
                                if (object2 == null) {
                                    object2 = new char[n][];
                                }
                                if (n5 == 0) {
                                    n6 = n9;
                                }
                                object2[n5++] = cArray2;
                            }
                            hashtableOfObject.put(cArray2, new Integer(n9));
                        }
                        ++n8;
                    }
                    this.cachedCategoryName = (char[])(hashtableOfObject.elementSize < 20000 ? cArray : null);
                }
                catch (IOException iOException) {
                    this.streamBuffer = null;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                ((FileInputStream)object).close();
                throw throwable;
            }
            {
                Object var14_25 = null;
            }
            ((FileInputStream)object).close();
            if (object2 == null || n5 <= 0) break block30;
            object = new FileInputStream(this.indexFile);
            try {
                try {
                    ((FileInputStream)object).skip(n6);
                    this.bufferIndex = 0;
                    this.bufferEnd = ((FileInputStream)object).read(this.streamBuffer, 0, this.streamBuffer.length);
                    n = 0;
                    while (n < n5) {
                        hashtableOfObject.put(object2[n], this.readStreamDocumentArray((FileInputStream)object, this.readStreamInt((FileInputStream)object)));
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    this.streamBuffer = null;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                ((FileInputStream)object).close();
                throw throwable;
            }
            {
                Object var10_18 = null;
            }
            ((FileInputStream)object).close();
        }
        this.streamBuffer = null;
        return hashtableOfObject;
    }

    private void readChunk(String[] stringArray, FileInputStream fileInputStream, int n, int n2) throws IOException {
        String string = new String(this.readStreamChars(fileInputStream));
        stringArray[n++] = string;
        int n3 = 1;
        while (n3 < n2) {
            int n4;
            if (fileInputStream != null && this.bufferIndex + 2 >= this.bufferEnd) {
                this.readStreamBuffer(fileInputStream);
            }
            int n5 = this.streamBuffer[this.bufferIndex++] & 0xFF;
            int n6 = this.streamBuffer[this.bufferIndex++] & 0xFF;
            String string2 = new String(this.readStreamChars(fileInputStream));
            if (n5 > 0) {
                if (n6 > 0) {
                    n4 = string.length();
                    string2 = String.valueOf(string.substring(0, n5)) + string2 + string.substring(n4 - n6, n4);
                } else {
                    string2 = String.valueOf(string.substring(0, n5)) + string2;
                }
            } else if (n6 > 0) {
                n4 = string.length();
                string2 = String.valueOf(string2) + string.substring(n4 - n6, n4);
            }
            stringArray[n++] = string2;
            string = string2;
            ++n3;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized String readDocumentName(int n) throws IOException {
        int n2;
        String[] stringArray;
        block10: {
            int n3;
            if (this.cachedChunks == null) {
                this.cachedChunks = new String[this.numberOfChunks][];
            }
            if ((stringArray = this.cachedChunks[n2 = n / 100]) != null) break block10;
            boolean bl = n2 == this.numberOfChunks - 1;
            int n4 = (bl ? this.startOfCategoryTables : this.chunkOffsets[n2 + 1]) - (n3 = this.chunkOffsets[n2]);
            if (n4 < 0) {
                throw new IllegalArgumentException();
            }
            this.streamBuffer = new byte[n4];
            this.bufferIndex = 0;
            FileInputStream fileInputStream = new FileInputStream(this.indexFile);
            try {
                try {
                    fileInputStream.skip(n3);
                    if (fileInputStream.read(this.streamBuffer, 0, n4) != n4) {
                        throw new IOException();
                    }
                }
                catch (IOException iOException) {
                    this.streamBuffer = null;
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                fileInputStream.close();
                throw throwable;
            }
            {
                Object var9_12 = null;
            }
            fileInputStream.close();
            int n5 = bl ? this.sizeOfLastChunk : 100;
            stringArray = new String[n5];
            try {
                this.readChunk(stringArray, null, 0, n5);
            }
            catch (IOException iOException) {
                this.streamBuffer = null;
                throw iOException;
            }
            this.cachedChunks[n2] = stringArray;
        }
        this.streamBuffer = null;
        return stringArray[n - n2 * 100];
    }

    synchronized int[] readDocumentNumbers(Object object) throws IOException {
        int[] nArray;
        if (object instanceof int[]) {
            return (int[])object;
        }
        FileInputStream fileInputStream = new FileInputStream(this.indexFile);
        try {
            int n = (Integer)object;
            fileInputStream.skip(n);
            this.streamBuffer = new byte[BUFFER_READ_SIZE];
            this.bufferIndex = 0;
            this.bufferEnd = fileInputStream.read(this.streamBuffer, 0, this.streamBuffer.length);
            nArray = this.readStreamDocumentArray(fileInputStream, this.readStreamInt(fileInputStream));
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            fileInputStream.close();
            this.streamBuffer = null;
            throw throwable;
        }
        fileInputStream.close();
        this.streamBuffer = null;
        return nArray;
    }

    private void readHeaderInfo(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(this.headerInfoOffset);
        this.numberOfChunks = randomAccessFile.readInt();
        this.sizeOfLastChunk = randomAccessFile.readUnsignedByte();
        this.documentReferenceSize = randomAccessFile.readUnsignedByte();
        this.chunkOffsets = new int[this.numberOfChunks];
        int n = 0;
        while (n < this.numberOfChunks) {
            this.chunkOffsets[n] = randomAccessFile.readInt();
            ++n;
        }
        this.startOfCategoryTables = randomAccessFile.readInt();
        n = randomAccessFile.readInt();
        this.categoryOffsets = new HashtableOfIntValues(n);
        this.categoryEnds = new HashtableOfIntValues(n);
        char[] cArray = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            char[] cArray2 = INTERNED_CATEGORY_NAMES.get(randomAccessFile.readUTF().toCharArray());
            n2 = randomAccessFile.readInt();
            this.categoryOffsets.put(cArray2, n2);
            if (cArray != null) {
                this.categoryEnds.put(cArray, n2);
            }
            cArray = cArray2;
            ++n3;
        }
        if (cArray != null) {
            this.categoryEnds.put(cArray, this.headerInfoOffset);
        }
        this.categoryTables = new HashtableOfObject(3);
    }

    synchronized void startQuery() {
        ++this.cacheUserCount;
    }

    synchronized void stopQuery() {
        if (--this.cacheUserCount < 0) {
            this.cacheUserCount = -1;
            this.cachedChunks = null;
            if (this.categoryTables != null) {
                if (this.cachedCategoryName == null) {
                    this.categoryTables = null;
                } else if (this.categoryTables.elementSize > 1) {
                    HashtableOfObject hashtableOfObject = new HashtableOfObject(3);
                    hashtableOfObject.put(this.cachedCategoryName, this.categoryTables.get(this.cachedCategoryName));
                    this.categoryTables = hashtableOfObject;
                }
            }
        }
    }

    private void readStreamBuffer(FileInputStream fileInputStream) throws IOException {
        if (this.bufferEnd < this.streamBuffer.length) {
            return;
        }
        int n = this.bufferEnd - this.bufferIndex;
        if (n > 0) {
            System.arraycopy(this.streamBuffer, this.bufferIndex, this.streamBuffer, 0, n);
        }
        this.bufferEnd = n + fileInputStream.read(this.streamBuffer, n, this.bufferIndex);
        this.bufferIndex = 0;
    }

    private char[] readStreamChars(FileInputStream fileInputStream) throws IOException {
        if (fileInputStream != null && this.bufferIndex + 2 >= this.bufferEnd) {
            this.readStreamBuffer(fileInputStream);
        }
        int n = (this.streamBuffer[this.bufferIndex++] & 0xFF) << 8;
        char[] cArray = new char[n += this.streamBuffer[this.bufferIndex++] & 0xFF];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + (this.bufferEnd - this.bufferIndex) / 3;
            if (n3 > n || this.bufferEnd != this.streamBuffer.length || fileInputStream == null) {
                n3 = n;
            }
            while (n2 < n3) {
                byte by = this.streamBuffer[this.bufferIndex++];
                switch (by & 0xF0) {
                    case 0: 
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: 
                    case 96: 
                    case 112: {
                        cArray[n2++] = (char)by;
                        break;
                    }
                    case 192: 
                    case 208: {
                        char c = (char)this.streamBuffer[this.bufferIndex++];
                        if ((c & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        char c2 = (char)((by & 0x1F) << 6);
                        c2 = (char)(c2 | c & 0x3F);
                        cArray[n2++] = c2;
                        break;
                    }
                    case 224: {
                        char c = (char)this.streamBuffer[this.bufferIndex++];
                        char c3 = (char)this.streamBuffer[this.bufferIndex++];
                        if ((c & c3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        char c2 = (char)((by & 0xF) << 12);
                        c2 = (char)(c2 | (c & 0x3F) << 6);
                        c2 = (char)(c2 | c3 & 0x3F);
                        cArray[n2++] = c2;
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException();
                    }
                }
            }
            if (n2 >= n || fileInputStream == null) continue;
            this.readStreamBuffer(fileInputStream);
        }
        return cArray;
    }

    private int[] readStreamDocumentArray(FileInputStream fileInputStream, int n) throws IOException {
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        int n2 = 0;
        switch (this.documentReferenceSize) {
            case 1: {
                while (n2 < n) {
                    int n3 = n2 + this.bufferEnd - this.bufferIndex;
                    if (n3 > n) {
                        n3 = n;
                    }
                    while (n2 < n3) {
                        nArray[n2++] = this.streamBuffer[this.bufferIndex++] & 0xFF;
                    }
                    if (n2 >= n || fileInputStream == null) continue;
                    this.readStreamBuffer(fileInputStream);
                }
                break;
            }
            case 2: {
                while (n2 < n) {
                    int n4 = n2 + (this.bufferEnd - this.bufferIndex) / 2;
                    if (n4 > n) {
                        n4 = n;
                    }
                    while (n2 < n4) {
                        int n5 = (this.streamBuffer[this.bufferIndex++] & 0xFF) << 8;
                        nArray[n2++] = n5 + (this.streamBuffer[this.bufferIndex++] & 0xFF);
                    }
                    if (n2 >= n || fileInputStream == null) continue;
                    this.readStreamBuffer(fileInputStream);
                }
                break;
            }
            default: {
                while (n2 < n) {
                    nArray[n2++] = this.readStreamInt(fileInputStream);
                }
                break block0;
            }
        }
        return nArray;
    }

    private int readStreamInt(FileInputStream fileInputStream) throws IOException {
        if (this.bufferIndex + 4 >= this.bufferEnd) {
            this.readStreamBuffer(fileInputStream);
        }
        int n = (this.streamBuffer[this.bufferIndex++] & 0xFF) << 24;
        n += (this.streamBuffer[this.bufferIndex++] & 0xFF) << 16;
        return (n += (this.streamBuffer[this.bufferIndex++] & 0xFF) << 8) + (this.streamBuffer[this.bufferIndex++] & 0xFF);
    }

    private void writeAllDocumentNames(String[] stringArray, FileOutputStream fileOutputStream) throws IOException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.streamBuffer = new byte[2048];
        this.bufferIndex = 0;
        this.streamEnd = 0;
        this.writeStreamChars(fileOutputStream, SIGNATURE_CHARS);
        this.headerInfoOffset = this.streamEnd;
        this.writeStreamInt(fileOutputStream, -1);
        int n = stringArray.length;
        this.numberOfChunks = n / 100 + 1;
        this.sizeOfLastChunk = n % 100;
        if (this.sizeOfLastChunk == 0) {
            --this.numberOfChunks;
            this.sizeOfLastChunk = 100;
        }
        this.documentReferenceSize = n <= 127 ? 1 : (n <= Short.MAX_VALUE ? 2 : 4);
        this.chunkOffsets = new int[this.numberOfChunks];
        int n2 = this.numberOfChunks - 1;
        int n3 = 0;
        while (n3 < this.numberOfChunks) {
            this.chunkOffsets[n3] = this.streamEnd;
            int n4 = n3 == n2 ? this.sizeOfLastChunk : 100;
            int n5 = n3 * 100;
            String string = stringArray[n5];
            this.writeStreamChars(fileOutputStream, string.toCharArray());
            int n6 = 1;
            while (n6 < n4) {
                int n7;
                String string2 = stringArray[n5 + n6];
                int n8 = string.length();
                int n9 = n8 < (n7 = string2.length()) ? n8 : n7;
                int n10 = 0;
                while (string.charAt(n10) == string2.charAt(n10)) {
                    if (n9 == ++n10) break;
                }
                if (n10 > 255) {
                    n10 = 255;
                }
                int n11 = 0;
                while (string.charAt(--n8) == string2.charAt(--n7)) {
                    ++n11;
                    if (n7 == n10 || n8 == 0) break;
                }
                if (n11 > 255) {
                    n11 = 255;
                }
                if (this.bufferIndex + 2 >= 2048) {
                    fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
                    this.bufferIndex = 0;
                }
                this.streamBuffer[this.bufferIndex++] = (byte)n10;
                this.streamBuffer[this.bufferIndex++] = (byte)n11;
                this.streamEnd += 2;
                int n12 = string2.length() - n11;
                this.writeStreamChars(fileOutputStream, n10 < n12 ? CharOperation.subarray(string2.toCharArray(), n10, n12) : CharOperation.NO_CHAR);
                string = string2;
                ++n6;
            }
            ++n3;
        }
        this.startOfCategoryTables = this.streamEnd + 1;
    }

    private void writeCategories(FileOutputStream fileOutputStream) throws IOException {
        char[][] cArray = this.categoryTables.keyTable;
        Object[] objectArray = this.categoryTables.valueTable;
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (cArray[n] != null) {
                this.writeCategoryTable(cArray[n], (HashtableOfObject)objectArray[n], fileOutputStream);
            }
            ++n;
        }
        this.categoryTables = null;
    }

    private void writeCategoryTable(char[] cArray, HashtableOfObject hashtableOfObject, FileOutputStream fileOutputStream) throws IOException {
        Object object;
        int n = 256;
        Object[] objectArray = hashtableOfObject.valueTable;
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Object object2 = objectArray[n2];
            if (object2 != null) {
                if (object2 instanceof IntList) {
                    int[] nArray = ((IntList)objectArray[n2]).asArray();
                    objectArray[n2] = nArray;
                    object2 = nArray;
                }
                if (((int[])(object = (int[])object2)).length >= n) {
                    objectArray[n2] = new Integer(this.streamEnd);
                    this.writeDocumentNumbers((int[])object, fileOutputStream);
                }
            }
            ++n2;
        }
        this.categoryOffsets.put(cArray, this.streamEnd);
        this.categoryTables.put(cArray, null);
        this.writeStreamInt(fileOutputStream, hashtableOfObject.elementSize);
        char[][] cArray2 = hashtableOfObject.keyTable;
        n3 = 0;
        int n4 = cArray2.length;
        while (n3 < n4) {
            object = objectArray[n3];
            if (object != null) {
                this.writeStreamChars(fileOutputStream, cArray2[n3]);
                if (object instanceof int[]) {
                    Object object3 = object;
                    if (((int[])object3).length == 1) {
                        this.writeStreamInt(fileOutputStream, -object3[0]);
                    } else {
                        this.writeDocumentNumbers((int[])object3, fileOutputStream);
                    }
                } else {
                    this.writeStreamInt(fileOutputStream, n);
                    this.writeStreamInt(fileOutputStream, (Integer)object);
                }
            }
            ++n3;
        }
    }

    private void writeDocumentNumbers(int[] nArray, FileOutputStream fileOutputStream) throws IOException {
        int n = nArray.length;
        this.writeStreamInt(fileOutputStream, n);
        Util.sort(nArray);
        int n2 = 0;
        switch (this.documentReferenceSize) {
            case 1: {
                while (this.bufferIndex + n - n2 >= 2048) {
                    int n3 = 2048 - this.bufferIndex;
                    int n4 = 0;
                    while (n4 < n3) {
                        this.streamBuffer[this.bufferIndex++] = (byte)nArray[n2++];
                        ++n4;
                    }
                    fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
                    this.bufferIndex = 0;
                }
                while (n2 < n) {
                    this.streamBuffer[this.bufferIndex++] = (byte)nArray[n2++];
                }
                this.streamEnd += n;
                break;
            }
            case 2: {
                while (this.bufferIndex + (n - n2) * 2 >= 2048) {
                    int n5 = (2048 - this.bufferIndex) / 2;
                    int n6 = 0;
                    while (n6 < n5) {
                        this.streamBuffer[this.bufferIndex++] = (byte)(nArray[n2] >> 8);
                        this.streamBuffer[this.bufferIndex++] = (byte)nArray[n2++];
                        ++n6;
                    }
                    fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
                    this.bufferIndex = 0;
                }
                while (n2 < n) {
                    this.streamBuffer[this.bufferIndex++] = (byte)(nArray[n2] >> 8);
                    this.streamBuffer[this.bufferIndex++] = (byte)nArray[n2++];
                }
                this.streamEnd += n * 2;
                break;
            }
            default: {
                while (n2 < n) {
                    this.writeStreamInt(fileOutputStream, nArray[n2++]);
                }
                break block0;
            }
        }
    }

    private void writeHeaderInfo(FileOutputStream fileOutputStream) throws IOException {
        this.writeStreamInt(fileOutputStream, this.numberOfChunks);
        if (this.bufferIndex + 2 >= 2048) {
            fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
        this.streamBuffer[this.bufferIndex++] = (byte)this.sizeOfLastChunk;
        this.streamBuffer[this.bufferIndex++] = (byte)this.documentReferenceSize;
        this.streamEnd += 2;
        int n = 0;
        while (n < this.numberOfChunks) {
            this.writeStreamInt(fileOutputStream, this.chunkOffsets[n]);
            ++n;
        }
        this.writeStreamInt(fileOutputStream, this.startOfCategoryTables);
        this.writeStreamInt(fileOutputStream, this.categoryOffsets.elementSize);
        char[][] cArray = this.categoryOffsets.keyTable;
        int[] nArray = this.categoryOffsets.valueTable;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            if (cArray[n2] != null) {
                this.writeStreamChars(fileOutputStream, cArray[n2]);
                this.writeStreamInt(fileOutputStream, nArray[n2]);
            }
            ++n2;
        }
        if (this.bufferIndex > 0) {
            fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeOffsetToHeader(int n) throws IOException {
        if (n <= 0) return;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
        try {
            randomAccessFile.seek(this.headerInfoOffset);
            randomAccessFile.writeInt(n);
            this.headerInfoOffset = n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            randomAccessFile.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        randomAccessFile.close();
    }

    private void writeStreamChars(FileOutputStream fileOutputStream, char[] cArray) throws IOException {
        if (this.bufferIndex + 2 >= 2048) {
            fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
        int n = cArray.length;
        this.streamBuffer[this.bufferIndex++] = (byte)(n >>> 8 & 0xFF);
        this.streamBuffer[this.bufferIndex++] = (byte)(n & 0xFF);
        this.streamEnd += 2;
        int n2 = n * 3;
        if (n2 <= 2048) {
            if (this.bufferIndex + n2 > 2048) {
                fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
                this.bufferIndex = 0;
            }
            this.writeStreamChars(fileOutputStream, cArray, 0, n);
        } else {
            int n3 = 682;
            int n4 = 0;
            while (n4 < n) {
                fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
                this.bufferIndex = 0;
                int n5 = n - n4;
                int n6 = n4 + (n3 < n5 ? n3 : n5);
                this.writeStreamChars(fileOutputStream, cArray, n4, n6);
                n4 = n6;
            }
        }
    }

    private void writeStreamChars(FileOutputStream fileOutputStream, char[] cArray, int n, int n2) throws IOException {
        int n3 = this.bufferIndex;
        while (n < n2) {
            byte by;
            char c;
            if (((c = cArray[n++]) & 0x7F) == c) {
                this.streamBuffer[this.bufferIndex++] = (byte)c;
                continue;
            }
            if ((c & 0x7FF) == c) {
                by = (byte)(c >> 6);
                by = (byte)(by & 0x1F);
                by = (byte)(by | 0xC0);
                this.streamBuffer[this.bufferIndex++] = by;
                by = (byte)(c & 0x3F);
                by = (byte)(by | 0x80);
                this.streamBuffer[this.bufferIndex++] = by;
                continue;
            }
            by = (byte)(c >> 12);
            by = (byte)(by & 0xF);
            by = (byte)(by | 0xE0);
            this.streamBuffer[this.bufferIndex++] = by;
            by = (byte)(c >> 6);
            by = (byte)(by & 0x3F);
            by = (byte)(by | 0x80);
            this.streamBuffer[this.bufferIndex++] = by;
            by = (byte)(c & 0x3F);
            by = (byte)(by | 0x80);
            this.streamBuffer[this.bufferIndex++] = by;
        }
        this.streamEnd += this.bufferIndex - n3;
    }

    private void writeStreamInt(FileOutputStream fileOutputStream, int n) throws IOException {
        if (this.bufferIndex + 4 >= 2048) {
            fileOutputStream.write(this.streamBuffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
        this.streamBuffer[this.bufferIndex++] = (byte)(n >> 24);
        this.streamBuffer[this.bufferIndex++] = (byte)(n >> 16);
        this.streamBuffer[this.bufferIndex++] = (byte)(n >> 8);
        this.streamBuffer[this.bufferIndex++] = (byte)n;
        this.streamEnd += 4;
    }

    static class IntList {
        int size;
        int[] elements;

        IntList(int[] nArray) {
            this.elements = nArray;
            this.size = nArray.length;
        }

        void add(int n) {
            if (this.size == this.elements.length) {
                int n2 = this.size * 3;
                if (n2 < 7) {
                    n2 = 7;
                }
                this.elements = new int[n2];
                System.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
            this.elements[this.size++] = n;
        }

        int[] asArray() {
            int[] nArray = new int[this.size];
            System.arraycopy(this.elements, 0, nArray, 0, this.size);
            return nArray;
        }
    }
}

