/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.jdom.IDOMInitializer;
import org.eclipse.wst.jsdt.core.jdom.IDOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMMember;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class DOMInitializer
extends DOMMember
implements IDOMInitializer {
    protected String fBody;
    protected int[] fBodyRange;

    DOMInitializer() {
    }

    DOMInitializer(char[] cArray, int[] nArray, int[] nArray2, int n, int[] nArray3, int n2) {
        super(cArray, nArray, null, new int[]{-1, -1}, nArray2, n, nArray3);
        this.fBodyRange = new int[2];
        this.fBodyRange[0] = n2;
        this.fBodyRange[1] = nArray[1];
        this.setHasBody(true);
        this.setMask(2048, true);
    }

    DOMInitializer(char[] cArray, int[] nArray, int n) {
        this(cArray, nArray, new int[]{-1, -1}, n, new int[]{-1, -1}, -1);
        this.setMask(2048, false);
    }

    protected void appendMemberBodyContents(CharArrayBuffer charArrayBuffer) {
        if (this.hasBody()) {
            charArrayBuffer.append(this.getBody()).append(this.fDocument, this.fBodyRange[1] + 1, this.fSourceRange[1] - this.fBodyRange[1]);
        } else {
            charArrayBuffer.append("{}").append(Util.getLineSeparator(charArrayBuffer.toString(), null));
        }
    }

    protected void appendMemberDeclarationContents(CharArrayBuffer charArrayBuffer) {
    }

    protected void appendSimpleContents(CharArrayBuffer charArrayBuffer) {
        charArrayBuffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
        charArrayBuffer.append(this.fName);
        charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
    }

    public String getBody() {
        this.becomeDetailed();
        if (this.hasBody()) {
            if (this.fBody != null) {
                return this.fBody;
            }
            return new String(this.fDocument, this.fBodyRange[0], this.fBodyRange[1] + 1 - this.fBodyRange[0]);
        }
        return null;
    }

    protected DOMNode getDetailedNode() {
        return (DOMNode)((Object)this.getFactory().createInitializer(this.getContents()));
    }

    public IJavaElement getJavaElement(IJavaElement iJavaElement) throws IllegalArgumentException {
        if (iJavaElement.getElementType() == 7) {
            int n = 1;
            IDOMNode iDOMNode = this.getPreviousNode();
            while (iDOMNode != null) {
                if (iDOMNode instanceof DOMInitializer) {
                    ++n;
                }
                iDOMNode = iDOMNode.getPreviousNode();
            }
            return ((IType)iJavaElement).getInitializer(n);
        }
        throw new IllegalArgumentException(Messages.element_illegalParent);
    }

    protected int getMemberDeclarationStartPosition() {
        return this.fBodyRange[0];
    }

    public int getNodeType() {
        return 7;
    }

    public boolean isSignatureEqual(IDOMNode iDOMNode) {
        return false;
    }

    protected DOMNode newDOMNode() {
        return new DOMInitializer();
    }

    protected void offset(int n) {
        super.offset(n);
        this.offsetRange(this.fBodyRange, n);
    }

    public void setBody(String string) {
        this.becomeDetailed();
        this.fBody = string;
        this.setHasBody(string != null);
        this.fragment();
    }

    public void setName(String string) {
    }

    protected void shareContents(DOMNode dOMNode) {
        super.shareContents(dOMNode);
        DOMInitializer dOMInitializer = (DOMInitializer)dOMNode;
        this.fBody = dOMInitializer.fBody;
        this.fBodyRange = this.rangeCopy(dOMInitializer.fBodyRange);
    }

    public String toString() {
        return "INITIALIZER";
    }
}

