/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddLibraryFileToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddLibraryFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public AddLibraryFolderToIndex(IPath iPath, IProject iProject, char[][] cArray, char[][] cArray2, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.folderPath = iPath;
        this.project = iProject;
        this.inclusionPatterns = cArray;
        this.exclusionPatterns = cArray2;
    }

    private void indexFile(IFile iFile) {
        AddLibraryFileToIndex addLibraryFileToIndex = new AddLibraryFileToIndex(iFile, this.manager);
        if (!this.manager.isJobWaiting(addLibraryFileToIndex)) {
            this.manager.request(addLibraryFileToIndex);
        }
    }

    private void indexFile(IPath iPath) {
        AddLibraryFileToIndex addLibraryFileToIndex = new AddLibraryFileToIndex(iPath, this.manager);
        if (!this.manager.isJobWaiting(addLibraryFileToIndex)) {
            this.manager.request(addLibraryFileToIndex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.isCancelled) return true;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource iResource = this.project.getParent().findMember(this.folderPath);
        if (iResource == null) return true;
        if (iResource.getType() == 1) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = index.monitor;
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                readWriteMonitor.enterRead();
                IndexManager indexManager = this.manager;
                indexManager.getSourceElementParser(JavaCore.create(this.project), null);
                if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                    iResource.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy iResourceProxy) {
                            if (iResourceProxy.getType() == 1) {
                                if (Util.isJavaLikeFileName(iResourceProxy.getName())) {
                                    AddLibraryFolderToIndex.this.indexFile((IFile)iResourceProxy.requestResource());
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    iResource.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy iResourceProxy) {
                            switch (iResourceProxy.getType()) {
                                case 1: {
                                    IResource iResource;
                                    if (Util.isJavaLikeFileName(iResourceProxy.getName()) && !Util.isExcluded(iResource = iResourceProxy.requestResource(), AddLibraryFolderToIndex.this.inclusionPatterns, AddLibraryFolderToIndex.this.exclusionPatterns)) {
                                        AddLibraryFolderToIndex.this.indexFile((IFile)iResourceProxy.requestResource());
                                    }
                                    return false;
                                }
                                case 2: {
                                    if (AddLibraryFolderToIndex.this.exclusionPatterns == null || AddLibraryFolderToIndex.this.inclusionPatterns != null || !Util.isExcluded(iResourceProxy.requestFullPath(), AddLibraryFolderToIndex.this.inclusionPatterns, AddLibraryFolderToIndex.this.exclusionPatterns, true)) break;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                }
            }
            catch (CoreException coreException) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:", System.err);
                    coreException.printStackTrace();
                }
                Object var6_7 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
        {
            Object var6_9 = null;
            readWriteMonitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.containerPath;
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }
}

