/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddJarFileToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddLibraryFileToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddLibraryFolderToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexAllProject;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexBinaryFolder;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.RemoveFromIndex;
import org.eclipse.wst.jsdt.internal.core.search.processing.IJob;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private SimpleLookupTable indexes = new SimpleLookupTable();
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath javaPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getSavedIndexesDirectory(), "savedIndexNames.txt");
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);

    public synchronized void aboutToUpdateIndex(IPath iPath, Integer n) {
        Integer n2;
        IPath iPath2 = this.computeIndexLocation(iPath);
        Object object = this.getIndexStates().get(iPath2);
        Integer n3 = n2 = object == null ? UNKNOWN_STATE : (Integer)object;
        if (n2.equals(REBUILDING_STATE)) {
            return;
        }
        int n4 = n.compareTo(n2);
        if (n4 > 0) {
            this.updateIndexState(iPath2, n);
        } else if (n4 < 0 && this.indexes.get(iPath2) == null) {
            this.rebuildIndex(iPath2, iPath);
        }
    }

    public void addBinary(IFile iFile, IPath iPath) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant searchParticipant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument searchDocument = searchParticipant.getDocument(iFile.getFullPath().toString());
        IPath iPath2 = this.computeIndexLocation(iPath);
        this.scheduleDocumentIndexing(searchDocument, iPath, iPath2, searchParticipant);
    }

    public void addSource(IFile iFile, IPath iPath, SourceElementParser sourceElementParser) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant searchParticipant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument searchDocument = searchParticipant.getDocument(iFile.getFullPath().toString());
        searchDocument.parser = sourceElementParser;
        IPath iPath2 = this.computeIndexLocation(iPath);
        this.scheduleDocumentIndexing(searchDocument, iPath, iPath2, searchParticipant);
    }

    public void cleanUpIndexes() {
        SimpleSet simpleSet = new SimpleSet();
        IJavaSearchScope iJavaSearchScope = BasicSearchEngine.createWorkspaceScope();
        PatternSearchJob patternSearchJob = new PatternSearchJob(null, SearchEngine.getDefaultSearchParticipant(), iJavaSearchScope, null);
        Index[] indexArray = patternSearchJob.getIndexes(null);
        int n = 0;
        int n2 = indexArray.length;
        while (n < n2) {
            String string = indexArray[n].getIndexFile().getAbsolutePath();
            simpleSet.add(string);
            ++n;
        }
        if (this.indexStates != null) {
            Object[] objectArray = this.indexStates.keyTable;
            IPath[] iPathArray = new IPath[this.indexStates.elementSize];
            int n3 = 0;
            int n4 = 0;
            int n5 = objectArray.length;
            while (n4 < n5) {
                IPath iPath = (IPath)objectArray[n4];
                if (iPath != null && !simpleSet.includes(iPath.toOSString())) {
                    iPathArray[n3++] = iPath;
                }
                ++n4;
            }
            if (n3 > 0) {
                this.removeIndexesState(iPathArray);
            }
        }
        this.deleteIndexFiles(simpleSet);
    }

    public IPath computeIndexLocation(IPath iPath) {
        IPath iPath2 = (IPath)this.indexLocations.get(iPath);
        if (iPath2 == null) {
            String string = iPath.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(string.getBytes());
            String string2 = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> index name for " + string + " is " + string2);
            }
            iPath2 = (IPath)this.getIndexStates().getKey(this.getJavaPluginWorkingLocation().append(string2));
            this.indexLocations.put(iPath, iPath2);
        }
        return iPath2;
    }

    public void deleteIndexFiles() {
        this.savedIndexNamesFile.delete();
        this.deleteIndexFiles(null);
    }

    private void deleteIndexFiles(SimpleSet simpleSet) {
        File[] fileArray = this.getSavedIndexesDirectory().listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            String string = fileArray[n].getAbsolutePath();
            if (simpleSet == null || !simpleSet.includes(string)) {
                String string2 = ".index";
                if (string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length())) {
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("Deleting index file " + fileArray[n]);
                    }
                    fileArray[n].delete();
                }
            }
            ++n;
        }
    }

    public void ensureIndexExists(IPath iPath, IPath iPath2) {
        SimpleLookupTable simpleLookupTable = this.getIndexStates();
        Object object = simpleLookupTable.get(iPath);
        if (object == null) {
            this.updateIndexState(iPath, REBUILDING_STATE);
            this.getIndex(iPath2, iPath, true, true);
        }
    }

    public SourceElementParser getSourceElementParser(IJavaProject iJavaProject, ISourceElementRequestor iSourceElementRequestor) {
        Map map = iJavaProject.getOptions(true);
        map.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
        IndexingParser indexingParser = new IndexingParser(iSourceElementRequestor, new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(map), true, true, false);
        indexingParser.reportOnlyOneSyntaxError = true;
        indexingParser.javadocParser.checkDocComment = true;
        indexingParser.javadocParser.reportProblems = false;
        return indexingParser;
    }

    public synchronized Index getIndex(IPath iPath, boolean bl, boolean bl2) {
        IPath iPath2 = this.computeIndexLocation(iPath);
        return this.getIndex(iPath, iPath2, bl, bl2);
    }

    public synchronized Index getIndex(IPath iPath, IPath iPath2, boolean bl, boolean bl2) {
        Index index = this.getIndex(iPath2);
        if (index == null) {
            Integer n;
            Object object = this.getIndexStates().get(iPath2);
            Integer n2 = n = object == null ? UNKNOWN_STATE : (Integer)object;
            if (n == UNKNOWN_STATE) {
                this.rebuildIndex(iPath2, iPath);
                return null;
            }
            String string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
            String string2 = iPath2.toOSString();
            if (bl) {
                block13: {
                    File file = new File(string2);
                    if (file.exists()) {
                        try {
                            index = new Index(string2, string, true);
                            this.indexes.put(iPath2, index);
                            return index;
                        }
                        catch (IOException iOException) {
                            if (n == REBUILDING_STATE) break block13;
                            if (VERBOSE) {
                                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> cannot reuse existing index: " + string2 + " path: " + string);
                            }
                            this.rebuildIndex(iPath2, iPath);
                            return null;
                        }
                    }
                }
                if (n == SAVED_STATE) {
                    this.rebuildIndex(iPath2, iPath);
                    return null;
                }
            }
            if (bl2) {
                try {
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> create empty index: " + string2 + " path: " + string);
                    }
                    index = new Index(string2, string, false);
                    this.indexes.put(iPath2, index);
                    return index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> unable to create empty index: " + string2 + " path: " + string);
                    }
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized Index getIndex(IPath iPath) {
        return (Index)this.indexes.get(iPath);
    }

    public synchronized Index getIndexForUpdate(IPath iPath, boolean bl, boolean bl2) {
        IPath iPath2 = this.computeIndexLocation(iPath);
        if (this.getIndexStates().get(iPath2) == REBUILDING_STATE) {
            return this.getIndex(iPath, iPath2, bl, bl2);
        }
        return null;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        IPath iPath = this.getJavaPluginWorkingLocation();
        char[][] cArray = this.readIndexState(iPath.toOSString());
        if (cArray != null) {
            int n = 1;
            int n2 = cArray.length;
            while (n < n2) {
                char[] cArray2 = cArray[n];
                if (cArray2.length > 0) {
                    IPath iPath2 = iPath.append(new String(cArray2));
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("Reading saved index file " + iPath2);
                    }
                    this.indexStates.put(iPath2, SAVED_STATE);
                }
                ++n;
            }
        } else {
            this.deleteIndexFiles();
        }
        return this.indexStates;
    }

    private IPath getJavaPluginWorkingLocation() {
        IPath iPath;
        if (this.javaPluginLocation != null) {
            return this.javaPluginLocation;
        }
        this.javaPluginLocation = iPath = JavaCore.getPlugin().getStateLocation();
        return this.javaPluginLocation;
    }

    private File getSavedIndexesDirectory() {
        return new File(this.getJavaPluginWorkingLocation().toOSString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath iPath) {
        try {
            searchDocument.index = index;
            searchParticipant.indexDocument(searchDocument, iPath);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            searchDocument.index = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            searchDocument.index = null;
            return;
        }
    }

    public void indexAll(IProject iProject) {
        Object object;
        if (JavaCore.getPlugin() == null) {
            return;
        }
        try {
            object = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject javaProject = (JavaProject)((JavaModel)object).getJavaProject((IResource)iProject);
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                if (iClasspathEntry.getEntryKind() == 1) {
                    this.indexLibrary(iClasspathEntry, iProject);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
        object = new IndexAllProject(iProject, this);
        if (!this.isJobWaiting((IJob)object)) {
            this.request((IJob)object);
        }
    }

    public void indexLibrary(IClasspathEntry iClasspathEntry, IProject iProject) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        IndexRequest indexRequest = null;
        Object object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iClasspathEntry.getPath(), true);
        if (object instanceof IFolder || object instanceof File && ((File)object).isDirectory()) {
            char[][] cArray = ((ClasspathEntry)iClasspathEntry).fullInclusionPatternChars();
            char[][] cArray2 = ((ClasspathEntry)iClasspathEntry).fullExclusionPatternChars();
            indexRequest = new AddLibraryFolderToIndex(iClasspathEntry.getPath(), iProject, cArray, cArray2, this);
        } else {
            indexRequest = new AddLibraryFileToIndex(iClasspathEntry.getPath(), this);
        }
        if (!this.isJobWaiting(indexRequest)) {
            this.request(indexRequest);
        }
    }

    public void indexLibrary(LibraryFragmentRoot libraryFragmentRoot, IProject iProject) {
        try {
            this.indexLibrary(libraryFragmentRoot.getRawClasspathEntry(), iProject);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    public void indexSourceFolder(JavaProject javaProject, IPath iPath, char[][] cArray, char[][] cArray2) {
        IndexAllProject indexAllProject;
        IProject iProject = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(indexAllProject = new IndexAllProject(iProject, this))) {
            return;
        }
        this.request(new AddFolderToIndex(iPath, iProject, cArray, cArray2, this));
    }

    public synchronized void jobWasCancelled(IPath iPath) {
        IPath iPath2 = this.computeIndexLocation(iPath);
        Index index = this.getIndex(iPath2);
        if (index != null) {
            index.monitor = null;
            this.indexes.removeKey(iPath2);
        }
        this.updateIndexState(iPath2, UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long l) {
        if (l > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public String processName() {
        return Messages.process_name;
    }

    private void rebuildIndex(IPath iPath, IPath iPath2) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace == null) {
            return;
        }
        Object object = JavaModel.getTarget((IContainer)iWorkspace.getRoot(), iPath2, true);
        if (object == null) {
            return;
        }
        if (VERBOSE) {
            org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> request to rebuild index: " + iPath + " path: " + iPath2);
        }
        this.updateIndexState(iPath, REBUILDING_STATE);
        IndexRequest indexRequest = null;
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            if (JavaProject.hasJavaNature(iProject)) {
                indexRequest = new IndexAllProject(iProject, this);
            }
        } else if (object instanceof IFolder) {
            indexRequest = new IndexBinaryFolder((IContainer)((IFolder)object), this);
        } else if (object instanceof IFile) {
            indexRequest = new AddJarFileToIndex((IFile)object, this);
        } else if (object instanceof File) {
            indexRequest = new AddLibraryFileToIndex(iPath2, this);
        }
        if (indexRequest != null) {
            this.request(indexRequest);
        }
    }

    public synchronized Index recreateIndex(IPath iPath) {
        String string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
        try {
            ReadWriteMonitor readWriteMonitor;
            IPath iPath2 = this.computeIndexLocation(iPath);
            Index index = this.getIndex(iPath2);
            ReadWriteMonitor readWriteMonitor2 = readWriteMonitor = index == null ? null : index.monitor;
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> recreating index: " + iPath2 + " for path: " + string);
            }
            index = new Index(iPath2.toOSString(), string, false);
            this.indexes.put(iPath2, index);
            index.monitor = readWriteMonitor;
            return index;
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> failed to recreate index for path: " + string);
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String string, IPath iPath) {
        this.request(new RemoveFromIndex(string, iPath, this));
    }

    public synchronized void removeIndex(IPath iPath) {
        if (VERBOSE) {
            org.eclipse.wst.jsdt.internal.core.util.Util.verbose("removing index " + iPath);
        }
        IPath iPath2 = this.computeIndexLocation(iPath);
        Index index = this.getIndex(iPath2);
        File file = null;
        if (index != null) {
            index.monitor = null;
            file = index.getIndexFile();
        }
        if (file == null) {
            file = new File(iPath2.toOSString());
        }
        if (file.exists()) {
            file.delete();
        }
        this.indexes.removeKey(iPath2);
        this.updateIndexState(iPath2, null);
    }

    public synchronized void removeIndexPath(IPath iPath) {
        Object[] objectArray = this.indexes.keyTable;
        Object[] objectArray2 = this.indexes.valueTable;
        IPath[] iPathArray = null;
        int n = this.indexes.elementSize;
        int n2 = 0;
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            IPath iPath2 = (IPath)objectArray[n3];
            if (iPath2 != null) {
                if (iPath.isPrefixOf(iPath2)) {
                    Index index = (Index)objectArray2[n3];
                    index.monitor = null;
                    if (iPathArray == null) {
                        iPathArray = new IPath[n];
                    }
                    iPathArray[n2++] = iPath2;
                    File file = index.getIndexFile();
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    --n;
                }
            }
            ++n3;
        }
        if (iPathArray != null) {
            n3 = 0;
            while (n3 < n2) {
                this.indexes.removeKey(iPathArray[n3]);
                ++n3;
            }
            this.removeIndexesState(iPathArray);
        }
    }

    public synchronized void removeIndexFamily(IPath iPath) {
        ArrayList<IPath> arrayList = null;
        Object[] objectArray = this.indexLocations.keyTable;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            IPath iPath2 = (IPath)objectArray[n];
            if (iPath2 != null && iPath.isPrefixOf(iPath2)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IPath>();
                }
                arrayList.add(iPath2);
            }
            ++n;
        }
        if (arrayList != null) {
            n = 0;
            n2 = arrayList.size();
            while (n < n2) {
                this.removeIndex((IPath)arrayList.get(n));
                ++n;
            }
        }
    }

    public void removeSourceFolderFromIndex(JavaProject javaProject, IPath iPath, char[][] cArray, char[][] cArray2) {
        IndexAllProject indexAllProject;
        IProject iProject = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(indexAllProject = new IndexAllProject(iProject, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(iPath, cArray, cArray2, iProject, this));
    }

    public synchronized void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new SimpleLookupTable();
            this.indexStates = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.javaPluginLocation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(Index index) throws IOException {
        if (index.hasChanged()) {
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Path path = new Path(index.containerPath);
            if (this.jobEnd > this.jobStart) {
                int n = this.jobEnd;
                while (n > this.jobStart) {
                    IJob iJob = this.awaitingJobs[n];
                    if (iJob instanceof IndexRequest && ((IndexRequest)iJob).containerPath.equals((Object)path)) {
                        return;
                    }
                    --n;
                }
            }
            IPath iPath = this.computeIndexLocation((IPath)path);
            this.updateIndexState(iPath, SAVED_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        Object object;
        int n;
        ArrayList<Index> arrayList = new ArrayList<Index>();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Object[] objectArray = this.indexes.valueTable;
            n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                object = (Index)objectArray[n];
                if (object != null) {
                    arrayList.add((Index)object);
                }
                ++n;
            }
        }
        boolean bl = true;
        int n3 = 0;
        n = arrayList.size();
        while (n3 < n) {
            Index index = (Index)arrayList.get(n3);
            object = index.monitor;
            if (object != null) {
                Object var10_12;
                try {
                    ((ReadWriteMonitor)object).enterRead();
                    if (index.hasChanged()) {
                        if (((ReadWriteMonitor)object).exitReadEnterWrite()) {
                            Object var8_11;
                            try {
                                try {
                                    this.saveIndex(index);
                                }
                                catch (IOException iOException) {
                                    if (VERBOSE) {
                                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> got the following exception while saving:", System.err);
                                        iOException.printStackTrace();
                                    }
                                    bl = false;
                                }
                                var8_11 = null;
                                ((ReadWriteMonitor)object).exitWriteEnterRead();
                            }
                            catch (Throwable throwable) {
                                var8_11 = null;
                                ((ReadWriteMonitor)object).exitWriteEnterRead();
                                throw throwable;
                            }
                        } else {
                            bl = false;
                        }
                    }
                    var10_12 = null;
                    ((ReadWriteMonitor)object).exitRead();
                }
                catch (Throwable throwable) {
                    var10_12 = null;
                    ((ReadWriteMonitor)object).exitRead();
                    throw throwable;
                }
            }
            ++n3;
        }
        this.needToSave = !bl;
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, IPath iPath, final IPath iPath2, final SearchParticipant searchParticipant) {
        this.request(new IndexRequest(iPath, this){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean execute(IProgressMonitor iProgressMonitor) {
                if (this.isCancelled) return true;
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    return true;
                }
                Index index = IndexManager.this.getIndex(this.containerPath, iPath2, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor readWriteMonitor = index.monitor;
                if (readWriteMonitor == null) {
                    return true;
                }
                try {
                    readWriteMonitor.enterWrite();
                    IndexManager.this.indexDocument(searchDocument, searchParticipant, index, iPath2);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    readWriteMonitor.exitWrite();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    readWriteMonitor.exitWrite();
                    return true;
                }
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }
        });
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(super.toString());
        stringBuffer.append("In-memory indexes:\n");
        int n = 0;
        Object[] objectArray = this.indexes.valueTable;
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Index index = (Index)objectArray[n2];
            if (index != null) {
                stringBuffer.append(++n).append(" - ").append(index.toString()).append('\n');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private char[][] readIndexState(String string) {
        block3: {
            try {
                String string2;
                char[][] cArray;
                char[] cArray2 = Util.getFileCharContent(this.savedIndexNamesFile, null);
                if (cArray2.length > 0 && (cArray = CharOperation.splitOn('\n', cArray2)).length > 1 && (string2 = "INDEX VERSION 1.121+" + string).equals(new String(cArray[0]))) {
                    return cArray;
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block3;
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("Failed to read saved index file names");
            }
        }
        return null;
    }

    private synchronized void removeIndexesState(IPath[] iPathArray) {
        this.getIndexStates();
        int n = iPathArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (iPathArray[n2] != null && this.indexStates.removeKey(iPathArray[n2]) != null) {
                bl = true;
                if (VERBOSE) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> index state updated to: ? for: " + iPathArray[n2]);
                }
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        this.writeSavedIndexNamesFile();
    }

    private synchronized void updateIndexState(IPath iPath, Integer n) {
        if (iPath.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.getIndexStates();
        if (n != null) {
            if (n.equals(this.indexStates.get(iPath))) {
                return;
            }
            this.indexStates.put(iPath, n);
        } else {
            if (!this.indexStates.containsKey(iPath)) {
                return;
            }
            this.indexStates.removeKey(iPath);
        }
        this.writeSavedIndexNamesFile();
        if (VERBOSE) {
            String string = "?";
            if (n == SAVED_STATE) {
                string = "SAVED";
            } else if (n == UPDATING_STATE) {
                string = "UPDATING";
            } else if (n == UNKNOWN_STATE) {
                string = "UNKNOWN";
            } else if (n == REBUILDING_STATE) {
                string = "REBUILDING";
            }
            org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> index state updated to: " + string + " for: " + iPath);
        }
    }

    /*
     * Exception decompiling
     */
    private void writeSavedIndexNamesFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 186->190)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

