/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryField;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryType;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;

public class ClassFileMatchLocator
implements IIndexConstants {
    public static char[] convertClassFileFormat(char[] cArray) {
        return CharOperation.replaceOnCopy(cArray, '/', '.');
    }

    private boolean checkDeclaringType(IBinaryType iBinaryType, char[] cArray, char[] cArray2, boolean bl, boolean bl2) {
        if (cArray == null && cArray2 == null) {
            return true;
        }
        if (iBinaryType == null) {
            return true;
        }
        char[] cArray3 = ClassFileMatchLocator.convertClassFileFormat(iBinaryType.getName());
        return this.checkTypeName(cArray, cArray2, cArray3, bl, bl2);
    }

    private boolean checkParameters(char[] cArray, char[][] cArray2, char[][] cArray3, boolean bl, boolean bl2) {
        int n = cArray2.length;
        char[][] cArray4 = Signature.getParameterTypes(cArray);
        if (n != cArray4.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.checkTypeName(cArray2[n2], cArray3[n2], Signature.toCharArray(cArray4[n2]), bl, bl2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkTypeName(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, boolean bl2) {
        char[] cArray4 = PatternLocator.qualifiedPattern(cArray, cArray2);
        if (cArray4 == null) {
            return true;
        }
        return CharOperation.match(cArray4, cArray3, bl);
    }

    public void locateMatches(MatchLocator matchLocator, ClassFile classFile, IBinaryType iBinaryType) throws CoreException {
        IBinaryField[] iBinaryFieldArray;
        String[] stringArray;
        String string;
        Object object;
        int n;
        Object object2;
        SearchPattern searchPattern = matchLocator.pattern;
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (this.matchBinary(searchPattern, iBinaryType, null)) {
            binaryType = new ResolvedBinaryType((JavaElement)binaryType.getParent(), binaryType.getElementName(), binaryType.getKey());
            matchLocator.reportBinaryMemberDeclaration(null, binaryType, null, iBinaryType, 0);
        }
        int n2 = 0;
        if (searchPattern.mustResolve) {
            try {
                object2 = matchLocator.cacheBinaryType(binaryType, iBinaryType);
                if (object2 != null) {
                    IMember iMember;
                    Object object3;
                    if (!matchLocator.typeInHierarchy((ReferenceBinding)object2)) {
                        return;
                    }
                    MethodBinding[] methodBindingArray = ((BinaryTypeBinding)object2).methods();
                    int n3 = 0;
                    int n4 = methodBindingArray.length;
                    while (n3 < n4) {
                        MethodBinding methodBinding = methodBindingArray[n3];
                        if (matchLocator.patternLocator.resolveLevel(methodBinding) == 3) {
                            object3 = methodBinding.genericSignature();
                            if (object3 == null) {
                                object3 = methodBinding.signature();
                            }
                            iMember = binaryType.getMethod(new String(methodBinding.isConstructor() ? ((BinaryTypeBinding)object2).compoundName[((BinaryTypeBinding)object2).compoundName.length - 1] : methodBinding.selector), CharOperation.toStrings(Signature.getParameterTypes(ClassFileMatchLocator.convertClassFileFormat(object3))));
                            matchLocator.reportBinaryMemberDeclaration(null, iMember, methodBinding, iBinaryType, 0);
                        }
                        ++n3;
                    }
                    FieldBinding[] fieldBindingArray = ((BinaryTypeBinding)object2).fields();
                    n4 = 0;
                    int n5 = fieldBindingArray.length;
                    while (n4 < n5) {
                        object3 = fieldBindingArray[n4];
                        if (matchLocator.patternLocator.resolveLevel((Binding)object3) == 3) {
                            iMember = binaryType.getField(new String(object3.name));
                            matchLocator.reportBinaryMemberDeclaration(null, iMember, (Binding)object3, iBinaryType, 0);
                        }
                        ++n4;
                    }
                    return;
                }
            }
            catch (AbortCompilation abortCompilation) {}
            n2 = 1;
        }
        if ((object2 = iBinaryType.getMethods()) != null) {
            int n6 = 0;
            n = ((IBinaryMethod[])object2).length;
            while (n6 < n) {
                Object object4 = object2[n6];
                if (this.matchBinary(searchPattern, object4, iBinaryType)) {
                    if (object4.isConstructor()) {
                        object = iBinaryType.getName();
                        int n7 = CharOperation.lastIndexOf('/', (char[])object);
                        if (n7 != -1) {
                            object = CharOperation.subarray((char[])object, n7 + 1, ((Object)object).length);
                        }
                    } else {
                        object = object4.getSelector();
                    }
                    string = new String((char[])object);
                    stringArray = CharOperation.toStrings(Signature.getParameterTypes(ClassFileMatchLocator.convertClassFileFormat(object4.getMethodDescriptor())));
                    IMethod iMethod = binaryType.getMethod(string, stringArray);
                    iMethod = new ResolvedBinaryMethod(binaryType, string, stringArray, iMethod.getKey());
                    matchLocator.reportBinaryMemberDeclaration(null, iMethod, null, iBinaryType, n2);
                }
                ++n6;
            }
        }
        if ((iBinaryFieldArray = iBinaryType.getFields()) != null) {
            n = 0;
            int n8 = iBinaryFieldArray.length;
            while (n < n8) {
                object = iBinaryFieldArray[n];
                if (this.matchBinary(searchPattern, object, iBinaryType)) {
                    string = new String(object.getName());
                    stringArray = binaryType.getField(string);
                    stringArray = new ResolvedBinaryField(binaryType, string, stringArray.getKey());
                    matchLocator.reportBinaryMemberDeclaration(null, (IMember)stringArray, null, iBinaryType, n2);
                }
                ++n;
            }
        }
    }

    boolean matchBinary(SearchPattern searchPattern, Object object, IBinaryType iBinaryType) {
        switch (searchPattern.kind) {
            case 32: {
                return this.matchConstructor((ConstructorPattern)searchPattern, object, iBinaryType);
            }
            case 64: {
                return this.matchField((FieldPattern)searchPattern, object, iBinaryType);
            }
            case 128: {
                return this.matchMethod((MethodPattern)searchPattern, object, iBinaryType);
            }
            case 16: {
                return this.matchSuperTypeReference((SuperTypeReferencePattern)searchPattern, object, iBinaryType);
            }
            case 8: {
                return this.matchTypeDeclaration((TypeDeclarationPattern)searchPattern, object, iBinaryType);
            }
            case 256: {
                SearchPattern[] searchPatternArray = ((OrPattern)searchPattern).patterns;
                int n = 0;
                int n2 = searchPatternArray.length;
                while (n < n2) {
                    if (this.matchBinary(searchPatternArray[n], object, iBinaryType)) {
                        return true;
                    }
                    ++n;
                }
                break;
            }
        }
        return false;
    }

    boolean matchConstructor(ConstructorPattern constructorPattern, Object object, IBinaryType iBinaryType) {
        char[] cArray;
        if (!constructorPattern.findDeclarations) {
            return false;
        }
        if (!(object instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod iBinaryMethod = (IBinaryMethod)object;
        if (!iBinaryMethod.isConstructor()) {
            return false;
        }
        if (!this.checkDeclaringType(iBinaryType, constructorPattern.declaringSimpleName, constructorPattern.declaringQualification, constructorPattern.isCaseSensitive(), constructorPattern.isCamelCase())) {
            return false;
        }
        return constructorPattern.parameterSimpleNames == null || this.checkParameters(cArray = ClassFileMatchLocator.convertClassFileFormat(iBinaryMethod.getMethodDescriptor()), constructorPattern.parameterSimpleNames, constructorPattern.parameterQualifications, constructorPattern.isCaseSensitive(), constructorPattern.isCamelCase());
    }

    boolean matchField(FieldPattern fieldPattern, Object object, IBinaryType iBinaryType) {
        if (!fieldPattern.findDeclarations) {
            return false;
        }
        if (!(object instanceof IBinaryField)) {
            return false;
        }
        IBinaryField iBinaryField = (IBinaryField)object;
        if (!fieldPattern.matchesName(fieldPattern.name, iBinaryField.getName())) {
            return false;
        }
        if (!this.checkDeclaringType(iBinaryType, fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, fieldPattern.isCaseSensitive(), fieldPattern.isCamelCase())) {
            return false;
        }
        char[] cArray = Signature.toCharArray(ClassFileMatchLocator.convertClassFileFormat(iBinaryField.getTypeName()));
        return this.checkTypeName(fieldPattern.typeSimpleName, fieldPattern.typeQualification, cArray, fieldPattern.isCaseSensitive(), fieldPattern.isCamelCase());
    }

    boolean matchMethod(MethodPattern methodPattern, Object object, IBinaryType iBinaryType) {
        boolean bl;
        if (!methodPattern.findDeclarations) {
            return false;
        }
        if (!(object instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod iBinaryMethod = (IBinaryMethod)object;
        if (!methodPattern.matchesName(methodPattern.selector, iBinaryMethod.getSelector())) {
            return false;
        }
        if (!this.checkDeclaringType(iBinaryType, methodPattern.declaringSimpleName, methodPattern.declaringQualification, methodPattern.isCaseSensitive(), methodPattern.isCamelCase())) {
            return false;
        }
        boolean bl2 = methodPattern.declaringSimpleName == null && (methodPattern.returnSimpleName != null || methodPattern.returnQualification != null);
        boolean bl3 = bl = methodPattern.parameterSimpleNames != null;
        if (bl2 || bl) {
            char[] cArray;
            char[] cArray2 = ClassFileMatchLocator.convertClassFileFormat(iBinaryMethod.getMethodDescriptor());
            if (bl2 && !this.checkTypeName(methodPattern.returnSimpleName, methodPattern.returnQualification, cArray = Signature.toCharArray(Signature.getReturnType(cArray2)), methodPattern.isCaseSensitive(), methodPattern.isCamelCase())) {
                return false;
            }
            if (bl && !this.checkParameters(cArray2, methodPattern.parameterSimpleNames, methodPattern.parameterQualifications, methodPattern.isCaseSensitive(), methodPattern.isCamelCase())) {
                return false;
            }
        }
        return true;
    }

    boolean matchSuperTypeReference(SuperTypeReferencePattern superTypeReferencePattern, Object object, IBinaryType iBinaryType) {
        char[] cArray;
        Object object2;
        if (!(object instanceof IBinaryType)) {
            return false;
        }
        IBinaryType iBinaryType2 = (IBinaryType)object;
        if (superTypeReferencePattern.superRefKind != 1 && (object2 = iBinaryType2.getSuperclassName()) != null && this.checkTypeName(superTypeReferencePattern.superSimpleName, superTypeReferencePattern.superQualification, cArray = ClassFileMatchLocator.convertClassFileFormat(object2), superTypeReferencePattern.isCaseSensitive(), superTypeReferencePattern.isCamelCase())) {
            return true;
        }
        if (superTypeReferencePattern.superRefKind != 2 && (object2 = (Object)iBinaryType2.getInterfaceNames()) != null) {
            int n = 0;
            int n2 = ((char[])object2).length;
            while (n < n2) {
                char[] cArray2 = ClassFileMatchLocator.convertClassFileFormat((char[])object2[n]);
                if (this.checkTypeName(superTypeReferencePattern.superSimpleName, superTypeReferencePattern.superQualification, cArray2, superTypeReferencePattern.isCaseSensitive(), superTypeReferencePattern.isCamelCase())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    boolean matchTypeDeclaration(TypeDeclarationPattern typeDeclarationPattern, Object object, IBinaryType iBinaryType) {
        char[] cArray;
        if (!(object instanceof IBinaryType)) {
            return false;
        }
        IBinaryType iBinaryType2 = (IBinaryType)object;
        char[] cArray2 = ClassFileMatchLocator.convertClassFileFormat(iBinaryType2.getName());
        boolean bl = typeDeclarationPattern instanceof QualifiedTypeDeclarationPattern;
        if (typeDeclarationPattern.enclosingTypeNames == null || bl) {
            char[] cArray3;
            cArray = typeDeclarationPattern.getMatchMode() == 1 ? CharOperation.concat(typeDeclarationPattern.simpleName, IIndexConstants.ONE_STAR) : typeDeclarationPattern.simpleName;
            char[] cArray4 = cArray3 = bl ? ((QualifiedTypeDeclarationPattern)typeDeclarationPattern).qualification : typeDeclarationPattern.pkg;
            if (!this.checkTypeName(cArray, cArray3, cArray2, typeDeclarationPattern.isCaseSensitive(), typeDeclarationPattern.isCamelCase())) {
                return false;
            }
        } else {
            char[] cArray5;
            cArray = CharOperation.concatWith(typeDeclarationPattern.enclosingTypeNames, '.');
            char[] cArray6 = cArray5 = typeDeclarationPattern.pkg == null ? cArray : CharOperation.concat(typeDeclarationPattern.pkg, cArray, '.');
            if (!this.checkTypeName(typeDeclarationPattern.simpleName, cArray5, cArray2, typeDeclarationPattern.isCaseSensitive(), typeDeclarationPattern.isCamelCase())) {
                return false;
            }
        }
        int n = TypeDeclaration.kind(iBinaryType2.getModifiers());
        switch (typeDeclarationPattern.typeSuffix) {
            case 'C': {
                return n == 1;
            }
            case 'I': {
                return n == 2;
            }
            case 'E': {
                return n == 3;
            }
            case 'A': {
                return n == 4;
            }
            case '\n': {
                return n == 1 || n == 2;
            }
            case '\t': {
                return n == 1 || n == 3;
            }
            case '\u000b': {
                return n == 2 || n == 4;
            }
        }
        return true;
    }
}

