/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariablePattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class FieldPattern
extends VariablePattern {
    protected char[] declaringQualification;
    protected char[] declaringSimpleName;
    protected char[] typeQualification;
    protected char[] typeSimpleName;
    protected static char[][] REF_CATEGORIES = new char[][]{REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{REF, FIELD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{FIELD_DECL};
    protected static char[][] VAR_REF_AND_DECL_CATEGORIES = new char[][]{REF, VAR_DECL};
    protected static char[][] VAR_DECL_CATEGORIES = new char[][]{VAR_DECL};
    protected boolean isVar;

    public static char[] createIndexKey(char[] cArray) {
        return cArray;
    }

    public FieldPattern(boolean bl, boolean bl2, boolean bl3, boolean bl4, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char[] cArray5, int n, IField iField) {
        super(64, bl, bl2, bl3, cArray, n, iField);
        this.isVar = bl4;
        this.declaringQualification = this.isCaseSensitive() ? cArray2 : CharOperation.toLowerCase(cArray2);
        this.declaringSimpleName = this.isCaseSensitive() ? cArray3 : CharOperation.toLowerCase(cArray3);
        this.typeQualification = this.isCaseSensitive() ? cArray4 : CharOperation.toLowerCase(cArray4);
        this.typeSimpleName = this.isCaseSensitive() || this.isCamelCase() ? cArray5 : CharOperation.toLowerCase(cArray5);
        this.mustResolve = this.mustResolve();
    }

    public FieldPattern(boolean bl, boolean bl2, boolean bl3, boolean bl4, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char[] cArray5, String string, int n, IField iField) {
        this(bl, bl2, bl3, bl4, cArray, cArray2, cArray3, cArray4, cArray5, n, iField);
        if (string != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(string);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        }
    }

    public void decodeIndexKey(char[] cArray) {
        this.name = cArray;
    }

    public SearchPattern getBlankPattern() {
        return new FieldPattern(false, false, false, this.isVar, null, null, null, null, null, 8, null);
    }

    public char[] getIndexKey() {
        return this.name;
    }

    public char[][] getIndexCategories() {
        if (this.isVar) {
            if (this.findReferences) {
                return this.findDeclarations || this.writeAccess ? VAR_REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
            }
            if (this.findDeclarations) {
                return VAR_DECL_CATEGORIES;
            }
        } else {
            if (this.findReferences) {
                return this.findDeclarations || this.writeAccess ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
            }
            if (this.findDeclarations) {
                return DECL_CATEGORIES;
            }
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        return true;
    }

    protected boolean mustResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.typeSimpleName != null || this.typeQualification != null) {
            return true;
        }
        return super.mustResolve();
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        if (this.findDeclarations) {
            stringBuffer.append(this.findReferences ? "FieldCombinedPattern: " : "FieldDeclarationPattern: ");
        } else {
            stringBuffer.append("FieldReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            stringBuffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            stringBuffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            stringBuffer.append("*.");
        }
        if (this.name == null) {
            stringBuffer.append("*");
        } else {
            stringBuffer.append(this.name);
        }
        if (this.typeQualification != null) {
            stringBuffer.append(" --> ").append(this.typeQualification).append('.');
        } else if (this.typeSimpleName != null) {
            stringBuffer.append(" --> ");
        }
        if (this.typeSimpleName != null) {
            stringBuffer.append(this.typeSimpleName);
        } else if (this.typeQualification != null) {
            stringBuffer.append("*");
        }
        return super.print(stringBuffer);
    }
}

