/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;
    public char[][][] allSuperDeclaringTypeNames;
    private HashMap methodDeclarationsWithInvalidParam = new HashMap();

    public MethodLocator(MethodPattern methodPattern) {
        super(methodPattern);
        this.pattern = methodPattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    protected void clear() {
        this.methodDeclarationsWithInvalidParam = new HashMap();
    }

    public void initializePolymorphicSearch(MatchLocator matchLocator) {
        long l = 0L;
        if (BasicSearchEngine.VERBOSE) {
            l = System.currentTimeMillis();
        }
        try {
            this.allSuperDeclaringTypeNames = new SuperTypeNamesCollector(this.pattern, this.pattern.declaringSimpleName, this.pattern.declaringQualification, matchLocator, this.pattern.declaringType, matchLocator.progressMonitor).collect();
        }
        catch (JavaModelException javaModelException) {}
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Time to initialize polymorphic search: " + (System.currentTimeMillis() - l));
        }
    }

    private boolean isTypeInSuperDeclaringTypeNames(char[][] cArray) {
        if (this.allSuperDeclaringTypeNames == null) {
            return false;
        }
        int n = this.allSuperDeclaringTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            if (CharOperation.equals(this.allSuperDeclaringTypeNames[n2], cArray)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isVirtualInvoke(MethodBinding methodBinding, MessageSend messageSend) {
        return !methodBinding.isStatic() && !methodBinding.isPrivate() && !messageSend.isSuperAccess();
    }

    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        int n = 0;
        if (this.pattern.findReferences && aSTNode instanceof ImportReference) {
            ImportReference importReference = (ImportReference)aSTNode;
            int n2 = importReference.tokens.length - 1;
            if (importReference.isStatic() && (importReference.bits & 0x20000) == 0 && this.matchesName(this.pattern.selector, importReference.tokens[n2])) {
                char[][] cArrayArray = new char[n2][];
                System.arraycopy(importReference.tokens, 0, cArrayArray, 0, n2);
                char[] cArray = CharOperation.concat(this.pattern.declaringQualification, this.pattern.declaringSimpleName, '.');
                if (this.matchesName(cArray, CharOperation.concatWith(cArrayArray, '.'))) {
                    n = this.pattern.mustResolve ? 2 : 3;
                }
            }
        }
        return matchingNodeSet.addMatch(aSTNode, n);
    }

    public int match(MethodDeclaration methodDeclaration, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, methodDeclaration.selector)) {
            return 0;
        }
        boolean bl = this.pattern.mustResolve;
        if (this.pattern.parameterSimpleNames != null) {
            int n;
            int n2 = this.pattern.parameterSimpleNames.length;
            Argument[] argumentArray = methodDeclaration.arguments;
            int n3 = n = argumentArray == null ? 0 : argumentArray.length;
            if (n2 != n) {
                return 0;
            }
            int n4 = 0;
            while (n4 < n) {
                if (argumentArray != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[n4], argumentArray[n4].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            matchingNodeSet.mustResolve = true;
                            bl = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(methodDeclaration, null);
                    } else {
                        return 0;
                    }
                }
                ++n4;
            }
        }
        if (this.pattern.hasMethodArguments() && (methodDeclaration.typeParameters == null || methodDeclaration.typeParameters.length != this.pattern.methodArguments.length)) {
            return 0;
        }
        return matchingNodeSet.addMatch(methodDeclaration, bl ? 2 : 3);
    }

    public int match(MemberValuePair memberValuePair, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, memberValuePair.name)) {
            return 0;
        }
        return matchingNodeSet.addMatch(memberValuePair, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(MessageSend messageSend, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, messageSend.selector)) {
            return 0;
        }
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (messageSend.bits & 0x8000) == 0)) {
            int n;
            int n2 = this.pattern.parameterSimpleNames.length;
            Expression[] expressionArray = messageSend.arguments;
            int n3 = n = expressionArray == null ? 0 : expressionArray.length;
            if (n2 != n) {
                return 0;
            }
        }
        return matchingNodeSet.addMatch(messageSend, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(Annotation annotation, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        MemberValuePair[] memberValuePairArray = annotation.memberValuePairs();
        if (memberValuePairArray == null || memberValuePairArray.length == 0) {
            return 0;
        }
        int n = memberValuePairArray.length;
        MemberValuePair memberValuePair = null;
        int n2 = 0;
        while (n2 < n) {
            memberValuePair = annotation.memberValuePairs()[n2];
            if (this.matchesName(this.pattern.selector, memberValuePair.name)) {
                ASTNode aSTNode = annotation instanceof SingleMemberAnnotation ? annotation : memberValuePair;
                return matchingNodeSet.addMatch(aSTNode, this.pattern.mustResolve ? 2 : 3);
            }
            ++n2;
        }
        return 0;
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return this.pattern.isFunction ? 1 : 2;
    }

    protected void matchLevelAndReportImportRef(ImportReference importReference, Binding binding, MatchLocator matchLocator) throws CoreException {
        if (importReference.isStatic() && binding instanceof MethodBinding) {
            super.matchLevelAndReportImportRef(importReference, binding, matchLocator);
        }
    }

    protected int matchMethod(MethodBinding methodBinding, boolean bl) {
        int n;
        if (!this.matchesName(this.pattern.selector, methodBinding.selector)) {
            return 0;
        }
        int n2 = 3;
        if (this.pattern.declaringSimpleName == null && n2 > (n = this.resolveLevelForType(this.pattern.returnSimpleName, this.pattern.returnQualification, methodBinding.returnType))) {
            if (n == 0) {
                return 0;
            }
            n2 = n;
        }
        n = this.pattern.parameterSimpleNames == null ? -1 : this.pattern.parameterSimpleNames.length;
        return n2;
    }

    private boolean matchOverriddenMethod(ReferenceBinding referenceBinding, MethodBinding methodBinding, MethodBinding methodBinding2) {
        int n;
        Object object;
        if (referenceBinding == null || this.pattern.selector == null) {
            return false;
        }
        if (!referenceBinding.isInterface() && !CharOperation.equals(referenceBinding.compoundName, TypeConstants.JAVA_LANG_OBJECT)) {
            object = referenceBinding.superclass();
            if (((TypeBinding)object).isParameterizedType()) {
                MethodBinding[] methodBindingArray = ((ReferenceBinding)object).getMethods(this.pattern.selector);
                n = methodBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (methodBindingArray[n2].areParametersEqual(methodBinding) && (methodBinding2 == null ? this.methodParametersEqualsPattern(methodBindingArray[n2].original()) : methodBindingArray[n2].original().areParametersEqual(methodBinding2))) {
                        return true;
                    }
                    ++n2;
                }
            }
            if (this.matchOverriddenMethod((ReferenceBinding)object, methodBinding, methodBinding2)) {
                return true;
            }
        }
        if ((object = referenceBinding.superInterfaces()) == null) {
            return false;
        }
        int n3 = ((ReferenceBinding[])object).length;
        n = 0;
        while (n < n3) {
            if (((TypeBinding)object[n]).isParameterizedType()) {
                MethodBinding[] methodBindingArray = ((ReferenceBinding)object[n]).getMethods(this.pattern.selector);
                int n4 = methodBindingArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    if (methodBindingArray[n5].areParametersEqual(methodBinding) && (methodBinding2 == null ? this.methodParametersEqualsPattern(methodBindingArray[n5].original()) : methodBindingArray[n5].original().areParametersEqual(methodBinding2))) {
                        return true;
                    }
                    ++n5;
                }
            }
            if (this.matchOverriddenMethod((ReferenceBinding)object[n], methodBinding, methodBinding2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = aSTNode instanceof MessageSend ? ((MessageSend)aSTNode).binding : (methodBinding = binding instanceof MethodBinding ? (MethodBinding)binding : null);
        if (this.isDeclarationOfReferencedMethodsPattern) {
            if (methodBinding == null) {
                return;
            }
            if (n != 0) {
                return;
            }
            DeclarationOfReferencedMethodsPattern declarationOfReferencedMethodsPattern = (DeclarationOfReferencedMethodsPattern)this.pattern;
            while (iJavaElement != null && !declarationOfReferencedMethodsPattern.enclosingElement.equals(iJavaElement)) {
                iJavaElement = iJavaElement.getParent();
            }
            if (iJavaElement != null) {
                this.reportDeclaration(methodBinding, matchLocator, declarationOfReferencedMethodsPattern.knownMethods);
            }
        } else {
            this.match = matchLocator.newMethodReferenceMatch(iJavaElement, binding, n, -1, -1, false, false, aSTNode);
            if (this.pattern.findReferences && aSTNode instanceof MessageSend) {
                boolean bl;
                IJavaElement iJavaElement2 = this.pattern.focus;
                if (iJavaElement2 != null && iJavaElement2.getElementType() == 9 && methodBinding != null && (bl = Flags.isPrivate(((IMethod)iJavaElement2).getFlags())) && !CharOperation.equals(methodBinding.declaringClass.sourceName, iJavaElement2.getParent().getElementName().toCharArray())) {
                    return;
                }
                this.matchReportReference((MessageSend)aSTNode, matchLocator, ((MessageSend)aSTNode).binding);
            } else {
                if (aSTNode instanceof SingleMemberAnnotation) {
                    aSTNode = ((SingleMemberAnnotation)aSTNode).memberValuePairs()[0];
                    this.match.setImplicit(true);
                }
                int n2 = aSTNode.sourceStart;
                int n3 = aSTNode.sourceEnd - n2 + 1;
                this.match.setOffset(n2);
                this.match.setLength(n3);
                matchLocator.report(this.match);
            }
        }
    }

    void matchReportReference(MessageSend messageSend, MatchLocator matchLocator, MethodBinding methodBinding) throws CoreException {
        boolean bl;
        Binding binding;
        boolean bl2 = false;
        if (methodBinding instanceof ParameterizedGenericMethodBinding) {
            bl2 = true;
            binding = (ParameterizedGenericMethodBinding)methodBinding;
            this.match.setRaw(((ParameterizedGenericMethodBinding)binding).isRaw);
            TypeBinding[] typeBindingArray = ((ParameterizedGenericMethodBinding)binding).typeArguments;
            this.updateMatch(typeBindingArray, matchLocator, this.pattern.methodArguments, this.pattern.hasMethodParameters());
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!(!this.pattern.hasTypeArguments() && this.pattern.hasMethodArguments() || parameterizedTypeBinding.isParameterizedWithOwnVariables())) {
                    this.updateMatch(parameterizedTypeBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, matchLocator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (methodBinding instanceof ParameterizedMethodBinding) {
            bl2 = true;
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                binding = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!((TypeBinding)binding).isParameterizedWithOwnVariables()) {
                    this.updateMatch((ParameterizedTypeBinding)binding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, matchLocator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
            if (this.match.getRule() != 0 && messageSend.resolvedType == null) {
                this.match.setRule(16);
            }
        } else if (this.pattern.hasMethodArguments()) {
            this.match.setRule(16);
        }
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl3 = bl = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!bl) {
            return;
        }
        int n = (int)(messageSend.nameSourcePosition >>> 32);
        this.match.setOffset(n);
        this.match.setLength(messageSend.sourceEnd - n + 1);
        if (bl2 && this.pattern.hasMethodArguments()) {
            matchLocator.reportAccurateParameterizedMethodReference(this.match, messageSend, messageSend.typeArguments);
        } else {
            matchLocator.report(this.match);
        }
    }

    private boolean methodParametersEqualsPattern(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        if (n != this.pattern.parameterSimpleNames.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char[] cArray = MethodLocator.qualifiedPattern(this.pattern.parameterSimpleNames[n2], this.pattern.parameterQualifications[n2]);
            if (!CharOperation.match(cArray, typeBindingArray[n2].readableName(), this.isCaseSensitive)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public SearchMatch newDeclarationMatch(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, int n2, MatchLocator matchLocator) {
        if (binding != null) {
            MethodBinding methodBinding = (MethodBinding)binding;
            if (this.methodDeclarationsWithInvalidParam.containsKey(aSTNode)) {
                Boolean bl = (Boolean)this.methodDeclarationsWithInvalidParam.get(aSTNode);
                if (bl != null) {
                    if (bl.booleanValue()) {
                        return super.newDeclarationMatch(aSTNode, iJavaElement, binding, n, n2, matchLocator);
                    }
                    return null;
                }
                if (this.matchOverriddenMethod(methodBinding.declaringClass, methodBinding, null)) {
                    this.methodDeclarationsWithInvalidParam.put(aSTNode, Boolean.TRUE);
                    return super.newDeclarationMatch(aSTNode, iJavaElement, binding, n, n2, matchLocator);
                }
                if (this.isTypeInSuperDeclaringTypeNames(methodBinding.declaringClass.compoundName)) {
                    MethodBinding methodBinding2 = matchLocator.getMethodBinding(this.pattern);
                    if (methodBinding2 != null && !this.matchOverriddenMethod(methodBinding2.declaringClass, methodBinding2, methodBinding)) {
                        this.methodDeclarationsWithInvalidParam.put(aSTNode, Boolean.FALSE);
                        return null;
                    }
                    this.methodDeclarationsWithInvalidParam.put(aSTNode, Boolean.TRUE);
                    return super.newDeclarationMatch(aSTNode, iJavaElement, binding, n, n2, matchLocator);
                }
                this.methodDeclarationsWithInvalidParam.put(aSTNode, Boolean.FALSE);
                return null;
            }
        }
        return super.newDeclarationMatch(aSTNode, iJavaElement, binding, n, n2, matchLocator);
    }

    protected int referenceType() {
        return 9;
    }

    protected void reportDeclaration(MethodBinding methodBinding, MatchLocator matchLocator, SimpleSet simpleSet) throws CoreException {
        Object object;
        int n;
        Object object2;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        IType iType = matchLocator.lookupType(referenceBinding);
        if (iType == null) {
            return;
        }
        char[] cArray = methodBinding.selector;
        boolean bl = iType.isBinary();
        IMethod iMethod = null;
        TypeBinding[] typeBindingArray = methodBinding.original().parameters;
        int n2 = typeBindingArray.length;
        if (bl) {
            object2 = new char[n2][];
            n = 0;
            while (n < n2) {
                object = typeBindingArray[n].qualifiedSourceName();
                int n3 = 0;
                int n4 = typeBindingArray[n].dimensions();
                while (n3 < n4) {
                    object = CharOperation.concat(object, new char[]{'[', ']'});
                    ++n3;
                }
                object2[n] = object;
                ++n;
            }
            iMethod = matchLocator.createBinaryMethodHandle(iType, methodBinding.selector, (char[][])object2);
        } else {
            object2 = new String[n2];
            n = 0;
            while (n < n2) {
                object = typeBindingArray[n].shortReadableName();
                if (typeBindingArray[n].isMemberType()) {
                    object = CharOperation.subarray(object, CharOperation.indexOf('.', object) + 1, ((char[])object).length);
                }
                object2[n] = (char[])Signature.createTypeSignature(object, false);
                ++n;
            }
            iMethod = iType.getMethod(new String(cArray), (String[])object2);
        }
        if (iMethod == null || simpleSet.addIfNotIncluded(iMethod) == null) {
            return;
        }
        object2 = iType.getResource();
        IBinaryType iBinaryType = null;
        if (bl) {
            if (object2 == null) {
                object2 = iType.getJavaProject().getProject();
            }
            iBinaryType = matchLocator.getBinaryInfo((ClassFile)iType.getClassFile(), (IResource)object2);
            matchLocator.reportBinaryMemberDeclaration((IResource)object2, iMethod, methodBinding, iBinaryType, 0);
        } else {
            if (referenceBinding instanceof ParameterizedTypeBinding) {
                referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
            }
            if ((object = (Object)((ClassScope)((SourceTypeBinding)referenceBinding).scope)) != null) {
                TypeDeclaration typeDeclaration = object.referenceContext;
                AbstractMethodDeclaration abstractMethodDeclaration = null;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
                int n5 = 0;
                int n6 = abstractMethodDeclarationArray.length;
                while (n5 < n6) {
                    if (CharOperation.equals(cArray, abstractMethodDeclarationArray[n5].selector)) {
                        abstractMethodDeclaration = abstractMethodDeclarationArray[n5];
                        break;
                    }
                    ++n5;
                }
                if (abstractMethodDeclaration != null) {
                    n5 = abstractMethodDeclaration.sourceStart;
                    MethodBinding methodBinding2 = abstractMethodDeclaration.binding;
                    if (methodBinding2 != null) {
                        iMethod = (IMethod)((Object)((JavaElement)((Object)iMethod)).resolved(methodBinding2));
                    }
                    this.match = new MethodDeclarationMatch(iMethod, 0, n5, abstractMethodDeclaration.sourceEnd - n5 + 1, matchLocator.getParticipant(), (IResource)object2);
                    matchLocator.report(this.match);
                }
            }
        }
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (this.pattern.findReferences) {
            if (aSTNode instanceof MessageSend) {
                return this.resolveLevel((MessageSend)aSTNode);
            }
            if (aSTNode instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)aSTNode;
                return this.resolveLevel(singleMemberAnnotation.memberValuePairs()[0].binding);
            }
            if (aSTNode instanceof MemberValuePair) {
                MemberValuePair memberValuePair = (MemberValuePair)aSTNode;
                return this.resolveLevel(memberValuePair.binding);
            }
        }
        if (this.pattern.findDeclarations) {
            if (aSTNode instanceof MethodDeclaration) {
                return this.resolveLevel(((MethodDeclaration)aSTNode).binding);
            }
            if (aSTNode instanceof InferredMethod) {
                return this.resolveLevel(((InferredMethod)aSTNode).methodBinding);
            }
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        boolean bl;
        char[] cArray;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding methodBinding = (MethodBinding)binding;
        boolean bl2 = this.pattern.findDeclarations && this.mayBeGeneric;
        int n = this.matchMethod(methodBinding, bl2);
        if (n == 0) {
            if (methodBinding != methodBinding.original()) {
                n = this.matchMethod(methodBinding.original(), bl2);
            }
            if (n == 0) {
                return 0;
            }
            methodBinding = methodBinding.original();
        }
        if ((cArray = MethodLocator.qualifiedPattern(this.pattern.declaringSimpleName, this.pattern.declaringQualification)) == null) {
            return n;
        }
        boolean bl3 = bl = !methodBinding.isStatic() && !methodBinding.isPrivate();
        if (bl && this.pattern.declaringQualification != null && methodBinding.declaringClass != null && methodBinding.declaringClass.fPackage != null) {
            bl = CharOperation.compareWith(this.pattern.declaringQualification, methodBinding.declaringClass.fPackage.shortReadableName()) == 0;
        }
        int n2 = bl ? this.resolveLevelAsSubtype(cArray, methodBinding.declaringClass, null) : this.resolveLevelForType(cArray, methodBinding.declaringClass);
        return n > n2 ? n2 : n;
    }

    protected int resolveLevel(MessageSend messageSend) {
        int n;
        char[] cArray;
        MethodBinding methodBinding = messageSend.binding;
        if (methodBinding == null) {
            return 1;
        }
        if (messageSend.resolvedType == null) {
            int n2;
            int n3 = n2 = messageSend.arguments == null ? 0 : messageSend.arguments.length;
            if (this.pattern.parameterSimpleNames == null || n2 == this.pattern.parameterSimpleNames.length) {
                return 1;
            }
            return 0;
        }
        int n4 = this.matchMethod(methodBinding, false);
        if (n4 == 0) {
            if (methodBinding != methodBinding.original()) {
                n4 = this.matchMethod(methodBinding.original(), false);
            }
            if (n4 == 0) {
                return 0;
            }
            methodBinding = methodBinding.original();
        }
        if ((cArray = MethodLocator.qualifiedPattern(this.pattern.declaringSimpleName, this.pattern.declaringQualification)) == null) {
            return n4;
        }
        if (this.isVirtualInvoke(methodBinding, messageSend) && messageSend.actualReceiverType instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)messageSend.actualReceiverType;
            n = this.resolveLevelAsSubtype(cArray, referenceBinding, methodBinding.parameters);
            if (n == 0) {
                if (methodBinding.declaringClass == null || this.allSuperDeclaringTypeNames == null) {
                    n = 1;
                } else {
                    char[][] cArray2 = referenceBinding.compoundName;
                    int n5 = 0;
                    int n6 = this.allSuperDeclaringTypeNames.length;
                    while (n5 < n6) {
                        if (CharOperation.equals(this.allSuperDeclaringTypeNames[n5], cArray2)) {
                            return n4 | 0x200;
                        }
                        ++n5;
                    }
                }
            }
            if ((n & 0xFFFFFFF0) != 0) {
                return n;
            }
        } else {
            n = this.resolveLevelForType(cArray, methodBinding.declaringClass);
        }
        return n4 > n ? n : n4;
    }

    protected int resolveLevelAsSubtype(char[] cArray, ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        if (referenceBinding == null) {
            return 1;
        }
        int n = this.resolveLevelForType(cArray, referenceBinding);
        if (n != 0) {
            if (!referenceBinding.isAbstract() && !referenceBinding.isInterface()) {
                n |= 0x800;
            }
            return n;
        }
        if (!referenceBinding.isInterface() && !CharOperation.equals(referenceBinding.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (n = this.resolveLevelAsSubtype(cArray, referenceBinding.superclass(), typeBindingArray)) != 0) {
            if (typeBindingArray != null) {
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(this.pattern.selector);
                int n2 = 0;
                int n3 = methodBindingArray.length;
                while (n2 < n3) {
                    MethodBinding methodBinding = methodBindingArray[n2];
                    TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                    if (typeBindingArray.length == typeBindingArray2.length) {
                        boolean bl = true;
                        int n4 = 0;
                        int n5 = typeBindingArray2.length;
                        while (n4 < n5) {
                            if (typeBindingArray2[n4].erasure() != typeBindingArray[n4].erasure()) {
                                bl = false;
                                break;
                            }
                            ++n4;
                        }
                        if (bl) {
                            if ((n & 0x800) != 0) {
                                return 0;
                            }
                            if (!methodBinding.isAbstract() && !referenceBinding.isInterface()) {
                                n |= 0x800;
                            }
                        }
                    }
                    ++n2;
                }
            }
            return n | 0x400;
        }
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        if (referenceBindingArray == null) {
            return 1;
        }
        int n6 = 0;
        while (n6 < referenceBindingArray.length) {
            n = this.resolveLevelAsSubtype(cArray, referenceBindingArray[n6], null);
            if (n != 0) {
                if (!referenceBinding.isAbstract() && !referenceBinding.isInterface()) {
                    n |= 0x800;
                }
                return n | 0x400;
            }
            ++n6;
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    public int match(InferredMethod inferredMethod, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, inferredMethod.name)) {
            return 0;
        }
        boolean bl = this.pattern.mustResolve;
        if (this.pattern.parameterSimpleNames != null) {
            int n;
            int n2 = this.pattern.parameterSimpleNames.length;
            Argument[] argumentArray = inferredMethod.methodDeclaration.arguments;
            int n3 = n = argumentArray == null ? 0 : argumentArray.length;
            if (n2 != n) {
                return 0;
            }
            int n4 = 0;
            while (n4 < n) {
                if (argumentArray != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[n4], argumentArray[n4].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.mustResolve) {
                            matchingNodeSet.mustResolve = true;
                            bl = true;
                        }
                        this.methodDeclarationsWithInvalidParam.put(inferredMethod.methodDeclaration, null);
                    } else {
                        return 0;
                    }
                }
                ++n4;
            }
        }
        return matchingNodeSet.addMatch(inferredMethod, bl ? 2 : 3);
    }
}

