/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class TypeParameterPattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    protected char[] name;
    protected ITypeParameter typeParameter;
    protected char[] declaringMemberName;
    protected char[] methodDeclaringClassName;
    protected char[][] methodArgumentTypes;

    public TypeParameterPattern(boolean bl, boolean bl2, ITypeParameter iTypeParameter, int n) {
        super(1024, n);
        this.findDeclarations = bl;
        this.findReferences = bl2;
        this.typeParameter = iTypeParameter;
        this.name = iTypeParameter.getElementName().toCharArray();
        IMember iMember = iTypeParameter.getDeclaringMember();
        this.declaringMemberName = iMember.getElementName().toCharArray();
        if (iMember instanceof IMethod) {
            IMethod iMethod = (IMethod)iMember;
            this.methodDeclaringClassName = iMethod.getParent().getElementName().toCharArray();
            String[] stringArray = iMethod.getParameterTypes();
            int n2 = stringArray.length;
            this.methodArgumentTypes = new char[n2][];
            int n3 = 0;
            while (n3 < n2) {
                this.methodArgumentTypes[n3] = Signature.toCharArray(stringArray[n3].toCharArray());
                ++n3;
            }
        }
    }

    public void findIndexMatches(Index index, IndexQueryRequestor indexQueryRequestor, SearchParticipant searchParticipant, IJavaSearchScope iJavaSearchScope, IProgressMonitor iProgressMonitor) {
        AccessRuleSet accessRuleSet;
        String string;
        String string2;
        Object object;
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)this.typeParameter.getAncestor(3);
        if (iPackageFragmentRoot.isArchive()) {
            object = (IType)this.typeParameter.getAncestor(7);
            string2 = String.valueOf(object.getFullyQualifiedName('/').replace('.', '/')) + ".js";
            string = iPackageFragmentRoot.getPath() + "|" + string2;
        } else {
            object = this.typeParameter.getPath();
            string = object.toString();
            string2 = Util.relativePath((IPath)object, 1);
        }
        if (iJavaSearchScope instanceof JavaSearchScope ? (accessRuleSet = ((JavaSearchScope)(object = (JavaSearchScope)iJavaSearchScope)).getAccessRuleSet(string2, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !indexQueryRequestor.acceptIndexMatch(string, this, searchParticipant, accessRuleSet) : iJavaSearchScope.encloses(string) && !indexQueryRequestor.acceptIndexMatch(string, this, searchParticipant, null)) {
            throw new OperationCanceledException();
        }
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        if (this.findDeclarations) {
            stringBuffer.append(this.findReferences ? "TypeParamCombinedPattern: " : "TypeParamDeclarationPattern: ");
        } else {
            stringBuffer.append("TypeParamReferencePattern: ");
        }
        stringBuffer.append(this.typeParameter.toString());
        return super.print(stringBuffer);
    }
}

