/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.processing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.internal.core.search.processing.IJob;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread processingThread;
    protected Job progressJob;
    private int enableCount = 1;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public void disable() {
        --this.enableCount;
        if (VERBOSE) {
            Util.verbose("DISABLING background indexing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardJobs(String string) {
        block20: {
            if (VERBOSE) {
                Util.verbose("DISCARD   background job family - " + string);
            }
            try {
                IJob iJob;
                JobManager jobManager = this;
                synchronized (jobManager) {
                    iJob = this.currentJob();
                    this.disable();
                }
                if (iJob != null && (string == null || iJob.belongsTo(string))) {
                    iJob.cancel();
                    while (this.processingThread != null && this.executing) {
                        try {
                            if (VERBOSE) {
                                Util.verbose("-> waiting end of current background job - " + iJob);
                            }
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                int n = -1;
                JobManager jobManager2 = this;
                synchronized (jobManager2) {
                    int n2 = this.jobStart;
                    while (true) {
                        block21: {
                            if (n2 <= this.jobEnd) break block21;
                            this.jobStart = 0;
                            this.jobEnd = n;
                            break;
                        }
                        iJob = this.awaitingJobs[n2];
                        if (iJob != null) {
                            this.awaitingJobs[n2] = null;
                            if (string != null && !iJob.belongsTo(string)) {
                                this.awaitingJobs[++n] = iJob;
                            } else {
                                if (VERBOSE) {
                                    Util.verbose("-> discarding background job  - " + iJob);
                                }
                                iJob.cancel();
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.enable();
                throw throwable;
            }
            {
                Object var6_9 = null;
                this.enable();
                if (!VERBOSE) break block20;
            }
            Util.verbose("DISCARD   DONE with background job family - " + string);
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        if (VERBOSE) {
            Util.verbose("ENABLING  background indexing");
        }
        this.notifyAll();
    }

    public synchronized boolean isJobWaiting(IJob iJob) {
        int n = this.jobEnd;
        while (n > this.jobStart) {
            if (iJob.equals(this.awaitingJobs[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long l) {
    }

    /*
     * Exception decompiling
     */
    public boolean performConcurrentJob(IJob var1_1, int var2_2, IProgressMonitor var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 162->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract String processName();

    public synchronized void request(IJob iJob) {
        iJob.ensureReadyToRun();
        int n = this.awaitingJobs.length;
        if (++this.jobEnd == n) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[n * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = iJob;
        if (VERBOSE) {
            Util.verbose("REQUEST   background job - " + iJob);
            Util.verbose("AWAITING JOBS count: " + this.awaitingJobsCount());
        }
        this.notifyAll();
    }

    public synchronized void reset() {
        if (VERBOSE) {
            Util.verbose("Reset");
        }
        if (this.processingThread != null) {
            this.discardJobs(null);
        } else {
            this.processingThread = new Thread((Runnable)this, this.processName());
            this.processingThread.setDaemon(true);
            this.processingThread.setPriority(4);
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long l = -1L;
        this.activateProcessing();
        try {
            this.progressJob = null;
            while (true) {
                if (this.processingThread == null) {
                    return;
                }
                try {
                    IJob iJob;
                    JobManager jobManager = this;
                    synchronized (jobManager) {
                        if (this.processingThread == null) {
                            continue;
                        }
                        iJob = this.currentJob();
                        if (iJob == null) {
                            if (this.progressJob != null) {
                                this.progressJob.cancel();
                                this.progressJob = null;
                            }
                            if (l < 0L) {
                                l = System.currentTimeMillis();
                            } else {
                                this.notifyIdle(System.currentTimeMillis() - l);
                            }
                            this.wait();
                        } else {
                            l = -1L;
                        }
                    }
                    if (iJob == null) {
                        this.notifyIdle(System.currentTimeMillis() - l);
                        Thread.sleep(500L);
                        continue;
                    }
                    if (VERBOSE) {
                        Util.verbose(String.valueOf(this.awaitingJobsCount()) + " awaiting jobs");
                        Util.verbose("STARTING background job - " + iJob);
                    }
                    try {
                        this.executing = true;
                        if (this.progressJob == null) {
                            class ProgressJob
                            extends Job {
                                final /* synthetic */ JobManager this$0;

                                ProgressJob(JobManager jobManager, String string) {
                                    super(string);
                                    this.this$0 = jobManager;
                                }

                                protected IStatus run(IProgressMonitor iProgressMonitor) {
                                    int n;
                                    while (!iProgressMonitor.isCanceled() && (n = this.this$0.awaitingJobsCount()) > 0) {
                                        iProgressMonitor.subTask(Messages.bind(Messages.manager_filesToIndex, Integer.toString(n)));
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    return Status.OK_STATUS;
                                }
                            }
                            this.progressJob = new ProgressJob(this, Messages.manager_indexingInProgress);
                            this.progressJob.setPriority(30);
                            this.progressJob.setSystem(true);
                            this.progressJob.schedule();
                        }
                        iJob.execute(null);
                    }
                    catch (Throwable throwable) {
                        jobManager = null;
                        this.executing = false;
                        if (VERBOSE) {
                            Util.verbose("FINISHED background job - " + iJob);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) throw throwable;
                        Thread.sleep(50L);
                        throw throwable;
                    }
                    {
                        jobManager = null;
                        this.executing = false;
                        if (VERBOSE) {
                            Util.verbose("FINISHED background job - " + iJob);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) continue;
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.processingThread == null) throw runtimeException;
            Util.log(runtimeException, "Background Indexer Crash Recovery");
            this.discardJobs(null);
            this.processingThread = null;
            this.reset();
            throw runtimeException;
        }
        catch (Error error) {
            if (this.processingThread == null) throw error;
            if (error instanceof ThreadDeath) throw error;
            Util.log(error, "Background Indexer Crash Recovery");
            this.discardJobs(null);
            this.processingThread = null;
            this.reset();
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (VERBOSE) {
            Util.verbose("Shutdown");
        }
        this.disable();
        this.discardJobs(null);
        Thread thread = this.processingThread;
        try {
            JobManager jobManager;
            if (thread != null) {
                jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join();
            }
            if ((jobManager = this.progressJob) != null) {
                jobManager.cancel();
                jobManager.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("Enable count:").append(this.enableCount).append('\n');
        int n = this.jobEnd - this.jobStart + 1;
        stringBuffer.append("Jobs in queue:").append(n).append('\n');
        int n2 = 0;
        while (n2 < n && n2 < 15) {
            stringBuffer.append(n2).append(" - job[" + n2 + "]: ").append(this.awaitingJobs[this.jobStart + n2]).append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }
}

