/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAnnotation;
import org.eclipse.wst.jsdt.core.util.IAnnotationComponent;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.internal.core.util.AnnotationComponent;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;

public class Annotation
extends ClassFileStruct
implements IAnnotation {
    private static final IAnnotationComponent[] NO_ENTRIES = new IAnnotationComponent[0];
    private int typeIndex;
    private char[] typeName;
    private int componentsNumber;
    private IAnnotationComponent[] components;
    private int readOffset;

    public Annotation(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        int n2;
        IConstantPoolEntry iConstantPoolEntry;
        int n3;
        this.typeIndex = n3 = this.u2At(byArray, 0, n);
        if (n3 != 0) {
            iConstantPoolEntry = iConstantPool.decodeEntry(n3);
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
        } else {
            throw new ClassFormatException(3);
        }
        this.typeName = iConstantPoolEntry.getUtf8Value();
        this.componentsNumber = n2 = this.u2At(byArray, 2, n);
        this.readOffset = 4;
        if (n2 != 0) {
            this.components = new IAnnotationComponent[n2];
            int n4 = 0;
            while (n4 < n2) {
                AnnotationComponent annotationComponent = new AnnotationComponent(byArray, iConstantPool, n + this.readOffset);
                this.components[n4] = annotationComponent;
                this.readOffset += annotationComponent.sizeInBytes();
                ++n4;
            }
        } else {
            this.components = NO_ENTRIES;
        }
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getComponentsNumber() {
        return this.componentsNumber;
    }

    public IAnnotationComponent[] getComponents() {
        return this.components;
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    public char[] getTypeName() {
        return this.typeName;
    }
}

