/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.wst.jsdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRegion;
import org.eclipse.wst.jsdt.internal.formatter.comment.JavaDocRegion;
import org.eclipse.wst.jsdt.internal.formatter.comment.MultiCommentRegion;

public class DefaultCodeFormatter
extends CodeFormatter {
    public static final boolean DEBUG = false;
    private static Scanner ProbingScanner;
    private CodeSnippetParsingUtil codeSnippetParsingUtil;
    private Map defaultCompilerOptions;
    private CodeFormatterVisitor newCodeFormatter;
    private Map options;
    private DefaultCodeFormatterOptions preferences;

    public static CommentRegion createRegion(int n, IDocument iDocument, Position position, CodeFormatterVisitor codeFormatterVisitor) {
        switch (n) {
            case 16: {
                return new CommentRegion(iDocument, position, codeFormatterVisitor);
            }
            case 32: {
                return new MultiCommentRegion(iDocument, position, codeFormatterVisitor);
            }
            case 64: {
                return new JavaDocRegion(iDocument, position, codeFormatterVisitor);
            }
        }
        return null;
    }

    public DefaultCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings()), null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions) {
        this(defaultCodeFormatterOptions, null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map map) {
        if (map != null) {
            this.options = map;
            this.preferences = new DefaultCodeFormatterOptions(map);
        } else {
            this.options = JavaCore.getOptions();
            this.preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        }
        this.defaultCompilerOptions = this.getDefaultCompilerOptions();
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public DefaultCodeFormatter(Map map) {
        this(null, map);
    }

    public String createIndentationString(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = 0;
        switch (this.preferences.tab_char) {
            case 2: {
                n4 = n * this.preferences.tab_size;
                break;
            }
            case 1: {
                n3 = n;
                break;
            }
            case 4: {
                int n5 = this.preferences.tab_size;
                n2 = n * this.preferences.indentation_size;
                n3 = n2 / n5;
                n4 = n2 % n5;
                break;
            }
            default: {
                return Util.EMPTY_STRING;
            }
        }
        if (n3 == 0 && n4 == 0) {
            return Util.EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(n3 + n4);
        n2 = 0;
        while (n2 < n3) {
            stringBuffer.append('\t');
            ++n2;
        }
        n2 = 0;
        while (n2 < n4) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public TextEdit format(int n, String string, int n2, int n3, int n4, String string2) {
        if (n2 < 0 || n3 < 0 || n3 > string.length()) {
            throw new IllegalArgumentException();
        }
        this.codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        switch (n) {
            case 4: {
                return this.formatClassBodyDeclarations(string, n4, string2, n2, n3);
            }
            case 8: {
                return this.formatCompilationUnit(string, n4, string2, n2, n3);
            }
            case 1: {
                return this.formatExpression(string, n4, string2, n2, n3);
            }
            case 2: {
                return this.formatStatements(string, n4, string2, n2, n3);
            }
            case 0: {
                return this.probeFormatting(string, n4, string2, n2, n3);
            }
            case 16: 
            case 32: 
            case 64: {
                return this.formatComment(n, string, n4, string2, n2, n3);
            }
        }
        return null;
    }

    private TextEdit formatClassBodyDeclarations(String string, int n, String string2, int n2, int n3) {
        ASTNode[] aSTNodeArray = this.codeSnippetParsingUtil.parseClassBodyDeclarations(string.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (aSTNodeArray == null) {
            return null;
        }
        return this.internalFormatClassBodyDeclarations(string, n, string2, aSTNodeArray, n2, n3);
    }

    private TextEdit formatComment(int n, String string, int n2, String string2, int n3, int n4) {
        Object v = this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_comments");
        boolean bl = false;
        if (v == null) {
            switch (n) {
                case 16: {
                    bl = "true".equals(this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments"));
                    break;
                }
                case 32: {
                    bl = "true".equals(this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments"));
                    break;
                }
                case 64: {
                    bl = "true".equals(this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments"));
                }
            }
        } else {
            bl = "true".equals(v);
        }
        if (bl) {
            this.preferences.line_separator = string2 != null ? string2 : Util.LINE_SEPARATOR;
            this.preferences.initial_indentation_level = n2;
            this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, n3, n4, null);
            CommentRegion commentRegion = DefaultCodeFormatter.createRegion(n, (IDocument)new Document(string), new Position(n3, n4), this.newCodeFormatter);
            if (commentRegion != null) {
                return this.newCodeFormatter.format(string, commentRegion);
            }
        }
        return new MultiTextEdit();
    }

    private TextEdit formatCompilationUnit(String string, int n, String string2, int n2, int n3) {
        CompilationUnitDeclaration compilationUnitDeclaration = this.codeSnippetParsingUtil.parseCompilationUnit(string.toCharArray(), this.getDefaultCompilerOptions(), true);
        this.preferences.line_separator = string2 != null ? string2 : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = n;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, n2, n3, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(string, compilationUnitDeclaration);
    }

    private TextEdit formatExpression(String string, int n, String string2, int n2, int n3) {
        Expression expression = this.codeSnippetParsingUtil.parseExpression(string.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (expression == null) {
            return null;
        }
        return this.internalFormatExpression(string, n, string2, expression, n2, n3);
    }

    private TextEdit formatStatements(String string, int n, String string2, int n2, int n3) {
        ConstructorDeclaration constructorDeclaration = this.codeSnippetParsingUtil.parseStatements(string.toCharArray(), this.getDefaultCompilerOptions(), true, false);
        if (constructorDeclaration.statements == null) {
            return null;
        }
        return this.internalFormatStatements(string, n, string2, constructorDeclaration, n2, n3);
    }

    public String getDebugOutput() {
        return this.newCodeFormatter.scribe.toString();
    }

    private Map getDefaultCompilerOptions() {
        HashMap<String, String> hashMap;
        if (this.defaultCompilerOptions == null) {
            hashMap = new HashMap(30);
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "do not generate");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "do not generate");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "do not generate");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal", "preserve");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.methodWithConstructorName", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.undefinedField", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.hiddenCatchBlock", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameter", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.noEffectAssignment", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.noImplicitStringConversion", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "public");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "public");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsOverriding", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsVisibility", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsOverriding", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.finallyBlockNotCompletingNormally", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownException", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unqualifiedFieldAccess", "ignore");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.taskPriorities", "");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.taskCaseSensitive", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.problem.specialParameterHidingField", "disabled");
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.maxProblemPerUnit", String.valueOf(100));
            hashMap.put("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode", "disabled");
            this.defaultCompilerOptions = hashMap;
        }
        if ((hashMap = this.options.get("org.eclipse.wst.jsdt.core.compiler.source")) != null) {
            this.defaultCompilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", hashMap);
        } else {
            this.defaultCompilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
        }
        return this.defaultCompilerOptions;
    }

    private TextEdit internalFormatClassBodyDeclarations(String string, int n, String string2, ASTNode[] aSTNodeArray, int n2, int n3) {
        this.preferences.line_separator = string2 != null ? string2 : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = n;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, n2, n3, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(string, aSTNodeArray);
    }

    private TextEdit internalFormatExpression(String string, int n, String string2, Expression expression, int n2, int n3) {
        this.preferences.line_separator = string2 != null ? string2 : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = n;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, n2, n3, this.codeSnippetParsingUtil);
        TextEdit textEdit = this.newCodeFormatter.format(string, expression);
        return textEdit;
    }

    private TextEdit internalFormatStatements(String string, int n, String string2, ConstructorDeclaration constructorDeclaration, int n2, int n3) {
        this.preferences.line_separator = string2 != null ? string2 : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = n;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, n2, n3, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(string, constructorDeclaration);
    }

    private TextEdit probeFormatting(String string, int n, String string2, int n2, int n3) {
        if (ProbingScanner == null) {
            ProbingScanner = new Scanner(true, true, false, 0x2F0000L, 0x2F0000L, null, null, true);
        }
        ProbingScanner.setSource(string.toCharArray());
        ProbingScanner.resetTo(n2, n2 + n3);
        try {
            switch (ProbingScanner.getNextToken()) {
                case 1002: {
                    if (ProbingScanner.getCurrentTokenEndPosition() == n2 + n3 - 1) {
                        return this.formatComment(32, string, n, string2, n2, n3);
                    }
                    break;
                }
                case 1001: {
                    if (ProbingScanner.getCurrentTokenEndPosition() == n2 + n3 - 1) {
                        return this.formatComment(16, string, n, string2, n2, n3);
                    }
                    break;
                }
                case 1003: {
                    if (ProbingScanner.getCurrentTokenEndPosition() == n2 + n3 - 1) {
                        return this.formatComment(64, string, n, string2, n2, n3);
                    }
                    break;
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        ProbingScanner.setSource((char[])null);
        Expression expression = this.codeSnippetParsingUtil.parseExpression(string.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (expression != null) {
            return this.internalFormatExpression(string, n, string2, expression, n2, n3);
        }
        ASTNode[] aSTNodeArray = this.codeSnippetParsingUtil.parseClassBodyDeclarations(string.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (aSTNodeArray != null) {
            return this.internalFormatClassBodyDeclarations(string, n, string2, aSTNodeArray, n2, n3);
        }
        ConstructorDeclaration constructorDeclaration = this.codeSnippetParsingUtil.parseStatements(string.toCharArray(), this.getDefaultCompilerOptions(), true, false);
        if (constructorDeclaration.statements != null) {
            return this.internalFormatStatements(string, n, string2, constructorDeclaration, n2, n3);
        }
        return this.formatCompilationUnit(string, n, string2, n2, n3);
    }
}

