/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentFormatterUtil;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentLine;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRange;
import org.eclipse.wst.jsdt.internal.formatter.comment.HTMLEntity2JavaReader;
import org.eclipse.wst.jsdt.internal.formatter.comment.IJavaDocTagConstants;
import org.eclipse.wst.jsdt.internal.formatter.comment.Java2HTMLEntityReader;
import org.eclipse.wst.jsdt.internal.formatter.comment.JavaDocLine;
import org.eclipse.wst.jsdt.internal.formatter.comment.MultiCommentRegion;

public class JavaDocRegion
extends MultiCommentRegion
implements IJavaDocTagConstants {
    private final ArrayList fCodePositions = new ArrayList();
    private final boolean fFormatHtml;
    private final boolean fFormatSource;

    public JavaDocRegion(IDocument iDocument, Position position, CodeFormatterVisitor codeFormatterVisitor) {
        super(iDocument, position, codeFormatterVisitor);
        this.fFormatSource = this.preferences.comment_format_source;
        this.fFormatHtml = this.preferences.comment_format_html;
        this.fClear = this.preferences.comment_clear_blank_lines_in_javadoc_comment;
    }

    protected boolean canFormat(CommentRange commentRange, CommentRange commentRange2) {
        if (commentRange != null) {
            boolean bl = commentRange2.hasAttribute(16);
            boolean bl2 = commentRange.hasAttribute(16);
            int n = this.getOffset();
            if (!bl2 && bl) {
                this.fCodePositions.add(new Position(n + commentRange.getOffset()));
            } else if (bl2 && !bl) {
                this.fCodePositions.add(new Position(n + commentRange2.getOffset() + commentRange2.getLength()));
            }
            return !commentRange.hasAttribute(64) || !commentRange2.hasAttribute(64);
        }
        return false;
    }

    protected final void formatRegion(String string, int n) {
        super.formatRegion(string, n);
        if (this.fFormatSource) {
            try {
                if (this.fCodePositions.size() > 0) {
                    int n2 = 0;
                    int n3 = 0;
                    Position position = null;
                    IDocument iDocument = this.getDocument();
                    int n4 = this.fCodePositions.size() - 1;
                    while (n4 >= 0) {
                        position = (Position)this.fCodePositions.get(n4--);
                        n2 = position.getOffset();
                        if (n4 >= 0) {
                            position = (Position)this.fCodePositions.get(n4--);
                            n3 = position.getOffset();
                        } else {
                            position = null;
                            n3 = this.getOffset() + this.getLength() - " */".trim().length();
                            while (n3 > n2 && ScannerHelper.isWhitespace(iDocument.getChar(n3 - 1))) {
                                --n3;
                            }
                        }
                        String string2 = iDocument.get(n2, n3 - n2);
                        string2 = this.preprocessCodeSnippet(string2);
                        string2 = this.formatCodeSnippet(string2);
                        string2 = this.postprocessCodeSnippet(string2, string);
                        this.logEdit(string2, n2 - this.getOffset(), n3 - n2);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                CommentFormatterUtil.log(badLocationException);
            }
        }
    }

    private String preprocessCodeSnippet(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
        String string2 = " * ".trim();
        stringBuffer.setLength(0);
        stringBuffer.append(string);
        defaultLineTracker.set(string);
        int n = defaultLineTracker.getNumberOfLines() - 1;
        while (n > 0) {
            int n2;
            try {
                n2 = defaultLineTracker.getLineOffset(n);
            }
            catch (BadLocationException badLocationException) {
                CommentFormatterUtil.log(badLocationException);
                return string;
            }
            int n3 = stringBuffer.indexOf(string2, n2);
            if (n3 >= 0 && stringBuffer.substring(n2, n3).trim().length() == 0) {
                stringBuffer.delete(n2, n3 + string2.length() + 1);
            }
            --n;
        }
        return this.convertHtml2Java(stringBuffer.toString());
    }

    private String formatCodeSnippet(String string) {
        String string2 = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
        TextEdit textEdit = CommentFormatterUtil.format2(0, string, 0, string2, this.preferences.getMap());
        if (textEdit != null) {
            string = CommentFormatterUtil.evaluateFormatterEdit(string, textEdit, null);
        }
        return string;
    }

    private String postprocessCodeSnippet(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
        String string3 = String.valueOf(string2) + " * ";
        int n = string.length();
        while (n > 0 && ' ' == string.charAt(n - 1)) {
            --n;
        }
        string = string.substring(0, n);
        stringBuffer.setLength(0);
        String string4 = this.getDelimiter();
        if (string4 != null && string.indexOf(string4) != 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.convertJava2Html(string));
        if (string4 != null && string.lastIndexOf(string4) != string.length() - string4.length()) {
            stringBuffer.append(string4);
        }
        defaultLineTracker.set(stringBuffer.toString());
        int n2 = defaultLineTracker.getNumberOfLines() - 1;
        while (n2 > 0) {
            try {
                stringBuffer.insert(defaultLineTracker.getLineOffset(n2), string3);
            }
            catch (BadLocationException badLocationException) {
                CommentFormatterUtil.log(badLocationException);
                return string;
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    protected final void markHtmlRanges() {
        this.markTagRanges(JAVADOC_IMMUTABLE_TAGS, 64, true);
        if (this.fFormatSource) {
            this.markTagRanges(JAVADOC_CODE_TAGS, 16, false);
        }
    }

    protected final void markHtmlTag(CommentRange commentRange, char[] cArray) {
        if (commentRange.hasAttribute(32)) {
            commentRange.markHtmlTag(JAVADOC_IMMUTABLE_TAGS, cArray, 64, true, true);
            if (this.fFormatHtml) {
                commentRange.markHtmlTag(JAVADOC_SEPARATOR_TAGS, cArray, 4096, true, true);
                commentRange.markHtmlTag(JAVADOC_BREAK_TAGS, cArray, 4, false, true);
                commentRange.markHtmlTag(JAVADOC_SINGLE_BREAK_TAG, cArray, 4, true, false);
                commentRange.markHtmlTag(JAVADOC_NEWLINE_TAGS, cArray, 128, true, false);
            } else {
                commentRange.markHtmlTag(JAVADOC_CODE_TAGS, cArray, 4096, true, true);
            }
        }
    }

    protected final void markJavadocTag(CommentRange commentRange, char[] cArray) {
        commentRange.markPrefixTag(JAVADOC_PARAM_TAGS, '@', cArray, 1024);
        if (cArray[0] == '@' && !commentRange.hasAttribute(1024)) {
            commentRange.setAttribute(2048);
        }
    }

    protected final void markTagRanges(char[][] cArray, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = null;
        CommentRange commentRange = null;
        int n4 = 0;
        while (n4 < cArray.length) {
            n2 = 0;
            Iterator iterator = this.getRanges().iterator();
            while (iterator.hasNext()) {
                commentRange = (CommentRange)iterator.next();
                n3 = commentRange.getLength();
                if (n3 <= 0 && n2 <= 0) continue;
                cArray2 = this.getText(commentRange.getOffset(), commentRange.getLength()).toCharArray();
                n2 = commentRange.markTagRange(cArray2, cArray[n4], n2, n, bl);
            }
            ++n4;
        }
    }

    protected boolean canAppend(CommentLine commentLine, CommentRange commentRange, CommentRange commentRange2, int n, int n2) {
        if (commentRange2.hasAttribute(8208) && commentLine.getSize() != 0) {
            return false;
        }
        return super.canAppend(commentLine, commentRange, commentRange2, n, n2);
    }

    private String convertJava2Html(String string) {
        Java2HTMLEntityReader java2HTMLEntityReader = new Java2HTMLEntityReader(new StringReader(string));
        char[] cArray = new char[256];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            do {
                if ((n = java2HTMLEntityReader.read(cArray)) == -1) continue;
                stringBuffer.append(cArray, 0, n);
            } while (n > 0);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private String convertHtml2Java(String string) {
        HTMLEntity2JavaReader hTMLEntity2JavaReader = new HTMLEntity2JavaReader(new StringReader(string));
        char[] cArray = new char[string.length()];
        try {
            int n = hTMLEntity2JavaReader.read(cArray);
            return new String(cArray, 0, n);
        }
        catch (IOException iOException) {
            return string;
        }
    }

    protected CommentLine createLine() {
        return new JavaDocLine(this);
    }
}

