/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;

public abstract class SubstitutionTextReader
extends Reader {
    private Reader fReader;
    private boolean fWasWhiteSpace;
    private int fCharAfterWhiteSpace;
    private boolean fSkipWhiteSpace = true;
    private boolean fReadFromBuffer;
    private StringBuffer fBuffer;
    private int fIndex;

    protected SubstitutionTextReader(Reader reader) {
        this.fReader = reader;
        this.fBuffer = new StringBuffer();
        this.fIndex = 0;
        this.fReadFromBuffer = false;
        this.fCharAfterWhiteSpace = -1;
        this.fWasWhiteSpace = true;
    }

    public String getString() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    protected abstract String computeSubstitution(int var1) throws IOException;

    protected Reader getReader() {
        return this.fReader;
    }

    protected int nextChar() throws IOException {
        boolean bl = this.fReadFromBuffer = this.fBuffer.length() > 0;
        if (this.fReadFromBuffer) {
            char c = this.fBuffer.charAt(this.fIndex++);
            if (this.fIndex >= this.fBuffer.length()) {
                this.fBuffer.setLength(0);
                this.fIndex = 0;
            }
            return c;
        }
        int n = this.fCharAfterWhiteSpace;
        if (n == -1) {
            n = this.fReader.read();
        }
        if (this.fSkipWhiteSpace && ScannerHelper.isWhitespace((char)n)) {
            while (ScannerHelper.isWhitespace((char)(n = this.fReader.read()))) {
            }
            if (n != -1) {
                this.fCharAfterWhiteSpace = n;
                return 32;
            }
        } else {
            this.fCharAfterWhiteSpace = -1;
        }
        return n;
    }

    public int read() throws IOException {
        int n;
        block0: do {
            n = this.nextChar();
            while (!this.fReadFromBuffer) {
                String string = this.computeSubstitution(n);
                if (string == null) continue block0;
                if (string.length() > 0) {
                    this.fBuffer.insert(0, string);
                }
                n = this.nextChar();
            }
        } while (this.fSkipWhiteSpace && this.fWasWhiteSpace && n == 32);
        this.fWasWhiteSpace = n == 32 || n == 13 || n == 10;
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = this.read();
            if (n5 == -1) {
                if (n4 == n) {
                    return -1;
                }
                return n4 - n;
            }
            cArray[n4] = (char)n5;
            ++n4;
        }
        return n2;
    }

    public boolean ready() throws IOException {
        return this.fReader.ready();
    }

    public void close() throws IOException {
        this.fReader.close();
    }

    public void reset() throws IOException {
        this.fReader.reset();
        this.fWasWhiteSpace = true;
        this.fCharAfterWhiteSpace = -1;
        this.fBuffer.setLength(0);
        this.fIndex = 0;
    }

    protected final void setSkipWhitespace(boolean bl) {
        this.fSkipWhiteSpace = bl;
    }

    protected final boolean isSkippingWhitespace() {
        return this.fSkipWhiteSpace;
    }
}

