/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.hyperlink;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;

class URLFileHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private URL fURL;

    public URLFileHyperlink(IRegion iRegion, URL uRL) {
        this.fRegion = iRegion;
        this.fURL = uRL;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        if (this.fURL != null) {
            StorageEditorInput storageEditorInput = new StorageEditorInput(new URLStorage(this.fURL));
            try {
                IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((String)storageEditorInput.getName());
                if (iEditorDescriptor != null) {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IEditorInput)storageEditorInput, (String)iEditorDescriptor.getId(), (boolean)true);
                }
            }
            catch (PartInitException partInitException) {
                Logger.log(202, partInitException.getMessage(), partInitException);
            }
        }
    }

    static class StorageEditorInput
    implements IStorageEditorInput {
        IStorage fStorage = null;

        StorageEditorInput(IStorage iStorage) {
            this.fStorage = iStorage;
        }

        public boolean exists() {
            return this.fStorage != null;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.fStorage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() throws CoreException {
            return this.fStorage;
        }

        public String getToolTipText() {
            return this.fStorage.getFullPath() != null ? this.fStorage.getFullPath().toString() : this.fStorage.getName();
        }
    }

    static class URLStorage
    implements IStorage {
        URL fURL = null;

        URLStorage(URL uRL) {
            this.fURL = uRL;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            InputStream inputStream = null;
            try {
                inputStream = this.fURL.openStream();
            }
            catch (Exception exception) {
                throw new CoreException((IStatus)new Status(4, JsUIPlugin.getDefault().getBundle().getSymbolicName(), 4, this.fURL.toString(), (Throwable)exception));
            }
            return inputStream;
        }

        public IPath getFullPath() {
            return new Path(this.fURL.toString());
        }

        public String getName() {
            return new Path(this.fURL.getFile()).lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

