/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.natures;

import org.eclipse.atf.natures.IClasspathInitializerDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ATFNature
implements IProjectNature {
    public static final String ATF_NATURE_ID = "org.eclipse.atf.core.ATFNature";
    protected static final String RUNTIME_PROP = "runtime";
    private static final String PLUGIN_POINT = "jsdtClasspathInitializer";
    private static final Object TAG_DELEGATE = "delegate";
    private IProject project;

    public void configure() throws CoreException {
        IClasspathInitializerDelegate iClasspathInitializerDelegate = this.classpathInitDelegate();
        if (iClasspathInitializerDelegate != null) {
            iClasspathInitializerDelegate.configure(this.project);
        }
    }

    public void deconfigure() throws CoreException {
        IClasspathInitializerDelegate iClasspathInitializerDelegate = this.classpathInitDelegate();
        if (iClasspathInitializerDelegate != null) {
            iClasspathInitializerDelegate.deconfigure(this.project);
        }
    }

    private IClasspathInitializerDelegate classpathInitDelegate() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.atf.core", PLUGIN_POINT);
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (iExtensionArray.length == 0) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionArray[0].getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals(TAG_DELEGATE)) {
                try {
                    return (IClasspathInitializerDelegate)iConfigurationElementArray[n].createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public static void addNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProject.hasNature(ATF_NATURE_ID)) {
            return;
        }
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = ATF_NATURE_ID;
        iProjectDescription.setNatureIds(stringArray2);
        try {
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
        catch (CoreException coreException) {
            iProjectDescription.setNatureIds(stringArray);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
            throw coreException;
        }
    }

    public static void removeNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iProject.hasNature(ATF_NATURE_ID)) {
            return;
        }
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals(ATF_NATURE_ID)) {
                stringArray2[n] = stringArray[n2];
                ++n;
            }
            ++n2;
        }
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }
}

