/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.project;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class FlexibleProjectUtils {
    private static final String[] J2EE_PROJECT_NATURE_IDS = new String[]{"org.eclipse.wst.common.project.facet.core.nature", "org.eclipse.jdt.core.javanature", "org.eclipse.wst.common.modulecore.ModuleCoreNature", "org.eclipse.jem.workbench.JavaEMFNature"};
    public static final String PHP_NATURE_ID = "org.eclipse.php.core.PHPNature";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getModuleNames(IProject iProject) throws CoreException {
        Object[] objectArray;
        if (iProject.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") == null) {
            return null;
        }
        StructureEdit structureEdit = StructureEdit.getStructureEditForRead((IProject)iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            objectArray = structureEdit.getWorkbenchModules();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n].getName());
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            structureEdit.dispose();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        structureEdit.dispose();
        objectArray = new String[arrayList.size()];
        return (String[])arrayList.toArray(objectArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getModuleNames(String string) throws CoreException {
        Object[] objectArray;
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject == null) {
            return null;
        }
        if (iProject.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") == null) {
            return null;
        }
        StructureEdit structureEdit = StructureEdit.getStructureEditForRead((IProject)iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            objectArray = structureEdit.getWorkbenchModules();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.add(objectArray[n].getName());
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            structureEdit.dispose();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        structureEdit.dispose();
        objectArray = new String[arrayList.size()];
        return (String[])arrayList.toArray(objectArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorkbenchComponent[] getModules(IProject iProject) throws CoreException {
        WorkbenchComponent[] workbenchComponentArray;
        if (iProject.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") == null) {
            return null;
        }
        StructureEdit structureEdit = StructureEdit.getStructureEditForRead((IProject)iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            workbenchComponentArray = structureEdit.getWorkbenchModules();
            int n = 0;
            while (n < workbenchComponentArray.length) {
                arrayList.add(workbenchComponentArray[n].getName());
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            structureEdit.dispose();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        structureEdit.dispose();
        workbenchComponentArray = new WorkbenchComponent[arrayList.size()];
        return arrayList.toArray(workbenchComponentArray);
    }

    public static IContainer getWebContentFolder(IProject iProject) {
        try {
            if (iProject.hasNature(PHP_NATURE_ID)) {
                return iProject;
            }
        }
        catch (CoreException coreException) {}
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iProject);
        if (iVirtualComponent != null) {
            IVirtualFolder iVirtualFolder = iVirtualComponent.getRootFolder();
            return iVirtualFolder.getUnderlyingFolder();
        }
        return null;
    }

    public static IPath getWebContentPath(IProject iProject, String string) {
        IVirtualFolder iVirtualFolder;
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iProject);
        if (iVirtualComponent != null && (iVirtualFolder = iVirtualComponent.getRootFolder()).exists()) {
            IPath iPath = iVirtualFolder.getProjectRelativePath().append(string);
            return iPath;
        }
        return iProject.getFolder(string).getProjectRelativePath();
    }

    public static String getWebContentRelativePath(IResource iResource) {
        if (!FlexibleProjectUtils.isResourceInWebContentDir(iResource)) {
            return null;
        }
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iResource.getProject());
        if (iVirtualComponent != null) {
            IVirtualFolder iVirtualFolder = iVirtualComponent.getRootFolder();
            if (iVirtualFolder.exists()) {
                return iResource.getProjectRelativePath().removeFirstSegments(iVirtualFolder.getProjectRelativePath().segmentCount()).makeRelative().toString();
            }
        } else {
            return iResource.getProjectRelativePath().makeRelative().toString();
        }
        return null;
    }

    public static ArrayList getFilePathsForType(IResource iResource, String string, ArrayList arrayList) throws CoreException {
        if (!(iResource instanceof IContainer)) {
            return arrayList;
        }
        IContainer iContainer = (IContainer)iResource;
        IResource[] iResourceArray = iContainer.members();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource2 = iResourceArray[n];
            if (iResource2 instanceof IContainer) {
                FlexibleProjectUtils.getFilePathsForType(iResource2, string, arrayList);
            } else if (iResource2 instanceof IFile && ((IFile)iResource2).getFileExtension().equals(string)) {
                arrayList.add(iResource2.getFullPath());
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean isResourceInWebContentDir(IResource iResource) {
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iResource.getProject());
        if (iVirtualComponent != null) {
            IVirtualFolder iVirtualFolder = iVirtualComponent.getRootFolder();
            if (iResource.getProjectRelativePath().matchingFirstSegments(iVirtualFolder.getProjectRelativePath()) == iVirtualFolder.getProjectRelativePath().segmentCount()) {
                return true;
            }
        } else {
            try {
                if (iResource.getProject().hasNature(PHP_NATURE_ID)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean isPathInSelectedFolderTree(IFolder iFolder, IPath iPath) {
        IPath iPath2 = iPath.removeFirstSegments(2);
        IPath iPath3 = iFolder.getProjectRelativePath().removeFirstSegments(1);
        return iPath3.isPrefixOf(iPath2);
    }

    public static boolean isContainerInsideWebContent(IContainer iContainer) {
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iContainer.getProject());
        IVirtualFolder iVirtualFolder = iVirtualComponent.getRootFolder();
        return iContainer.getProjectRelativePath().matchingFirstSegments(iVirtualFolder.getProjectRelativePath()) == iVirtualFolder.getProjectRelativePath().segmentCount();
    }

    public static String getModuleName(IFile iFile) {
        return iFile.getProject().getName();
    }

    public static String getModuleName(String string, IPath iPath) {
        if (string == null || string.equals("")) {
            return null;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject == null) {
            return null;
        }
        return iProject.getName();
    }

    public static String getWebAppPath(IFile iFile) {
        String string = FlexibleProjectUtils.getModuleName(iFile);
        if (string == null) {
            return null;
        }
        String string2 = FlexibleProjectUtils.getWebContentRelativePath((IResource)iFile);
        if (string2 == null) {
            return null;
        }
        return "/" + string + "/" + string2;
    }

    public static String getWebAppPath(String string, IPath iPath) {
        String string2 = FlexibleProjectUtils.getModuleName(string, iPath);
        if (string2 == null) {
            return null;
        }
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getProject(string).getFile(iPath);
        String string3 = FlexibleProjectUtils.getWebContentRelativePath((IResource)iFile);
        if (string3 == null) {
            return null;
        }
        return "/" + string2 + "/" + string3;
    }

    public static String getProjectRelativePath(String string, String string2, IPath iPath) {
        if (string == null || string2 == null || string2.equals("")) {
            return null;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject == null) {
            return null;
        }
        IContainer iContainer = FlexibleProjectUtils.getWebContentFolder(iProject);
        String string3 = iContainer.getProjectRelativePath().makeRelative().toString();
        if (string3.equals("")) {
            return iPath.makeRelative().toString();
        }
        return String.valueOf(string3) + "/" + iPath.makeRelative().toString();
    }

    public static boolean isJ2EEProject(IProject iProject) throws CoreException {
        int n = 0;
        while (n < J2EE_PROJECT_NATURE_IDS.length) {
            if (!iProject.hasNature(J2EE_PROJECT_NATURE_IDS[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getServerContextRoot(IProject iProject) throws CoreException {
        String string = null;
        string = iProject.hasNature(PHP_NATURE_ID) ? iProject.getName() : ComponentUtilities.getServerContextRoot((IProject)iProject);
        return string;
    }
}

