/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mozilla.interfaces.nsIWebBrowser;

public abstract class MozillaBrowserPlatform
extends Composite {
    nsIWebBrowser webBrowser;
    private int embedHandle;
    private boolean hasFocus;
    private Listener listener;

    public MozillaBrowserPlatform(Composite composite, int n) {
        super(composite, n);
    }

    static MozillaBrowserPlatform findBrowser(long l) {
        int n = OS.gtk_widget_get_parent((int)((int)l));
        Display display = Display.getCurrent();
        return (MozillaBrowserPlatform)display.findWidget(n);
    }

    protected int getHandle() {
        if (this.embedHandle == 0) {
            this.embedHandle = OS.gtk_hbox_new((boolean)false, (int)0);
            OS.gtk_container_add((int)this.handle, (int)this.embedHandle);
            OS.gtk_widget_show((int)this.embedHandle);
        }
        return this.embedHandle;
    }

    abstract void activate();

    abstract void deactivate();

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.activate();
        this.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaBrowserPlatform.this) {
                    return;
                }
                MozillaBrowserPlatform.this.deactivate();
                MozillaBrowserPlatform.this.hasFocus = false;
                MozillaBrowserPlatform.this.getDisplay().removeFilter(15, (Listener)this);
                MozillaBrowserPlatform.this.getShell().removeListener(27, (Listener)this);
                MozillaBrowserPlatform.this.listener = null;
            }
        };
        this.getDisplay().addFilter(15, this.listener);
        this.getShell().addListener(27, this.listener);
    }

    void onShow(Event event) {
        Display display = event.display;
        display.asyncExec(new Runnable(){

            public void run() {
                if (MozillaBrowserPlatform.this.isDisposed()) {
                    return;
                }
                MozillaBrowserPlatform.this.onResize();
            }
        });
    }

    abstract void onResize();

    void setNativeSize(int n, int n2) {
        OS.gtk_widget_set_size_request((int)this.embedHandle, (int)n, (int)n2);
    }

    void onDipose() {
        if (this.listener != null) {
            this.getDisplay().removeFilter(15, this.listener);
            this.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
    }
}

