/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.awt.Frame;
import java.awt.Panel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;

public abstract class MozillaBrowserPlatform
extends Composite {
    nsIWebBrowser webBrowser;
    private int embedHandle;
    private boolean hasFocus;
    private Frame frame;
    private Listener listener;
    private static Map handles = new HashMap();

    public MozillaBrowserPlatform(Composite composite, int n) {
        super(composite, n | 0x1000000);
    }

    static MozillaBrowserPlatform findBrowser(long l) {
        Long l2 = (Long)handles.get(new Long(l));
        if (l2 != null) {
            Display display = Display.getCurrent();
            return (MozillaBrowserPlatform)display.findWidget(l2.intValue());
        }
        return null;
    }

    protected int getHandle() {
        if (this.embedHandle == 0) {
            this.frame = SWT_AWT.new_Frame((Composite)this);
            Panel panel = new Panel();
            this.frame.add(panel);
            this.embedHandle = (int)Mozilla.getInstance().getNativeHandleFromAWT((Object)panel);
            handles.put(new Long(this.embedHandle), new Long(this.handle));
        }
        return this.embedHandle;
    }

    abstract void activate();

    abstract void deactivate();

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.activate();
        this.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaBrowserPlatform.this) {
                    return;
                }
                MozillaBrowserPlatform.this.deactivate();
                MozillaBrowserPlatform.this.hasFocus = false;
                MozillaBrowserPlatform.this.getDisplay().removeFilter(15, (Listener)this);
                MozillaBrowserPlatform.this.getShell().removeListener(27, (Listener)this);
                MozillaBrowserPlatform.this.listener = null;
            }
        };
        this.getDisplay().addFilter(15, this.listener);
        this.getShell().addListener(27, this.listener);
    }

    void onShow(Event event) {
    }

    abstract void onResize();

    void setNativeSize(int n, int n2) {
    }

    void onDipose() {
        handles.remove(new Long(this.embedHandle));
        this.frame.dispose();
        if (this.listener != null) {
            this.getDisplay().removeFilter(15, this.listener);
            this.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
    }
}

