/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.IDOMNodeSelection;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMViewCSS;

public class DOMCompareView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.atf.mozilla.ide.ui.views.compare";
    protected Composite leftComp;
    protected Composite listComp;
    protected Composite listButtonsComp;
    protected Composite rightComp;
    protected ListViewer compareViewer;
    protected org.eclipse.swt.widgets.List compare;
    protected Map nodesToCompare = new HashMap();
    protected Table nodes;
    protected TableViewer nodeTable;
    protected SashForm displayArea;
    protected Composite buttons;
    protected Label compareLabel;
    protected Label compareListLabel;
    private Menu menu;
    private MenuItem rename;
    protected Button attributes;
    protected Button children;
    protected Button css;
    protected Button executeCompare;
    protected Button clear;
    protected Button remove;
    protected nsIDOMNode selectedNode;
    protected Color green = new Color((Device)Display.getCurrent(), new RGB(128, 255, 128));
    protected Color red = new Color((Device)Display.getCurrent(), new RGB(255, 128, 128));

    public void createPartControl(Composite composite) {
        this.displayArea = new SashForm(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.leftComp = new Composite((Composite)this.displayArea, 0);
        this.leftComp.setLayout((Layout)gridLayout);
        this.leftComp.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.listComp = new Composite(this.leftComp, 0);
        this.listComp.setLayout((Layout)gridLayout);
        this.listComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.compareListLabel = new Label(this.listComp, 64);
        this.compareListLabel.setText("Compare List:");
        this.compare = new org.eclipse.swt.widgets.List(this.listComp, 2);
        this.compareViewer = new ListViewer(this.compare);
        this.compare.setLayoutData((Object)new GridData(4, 4, true, true));
        int n = 3;
        this.compareViewer.addDropSupport(n, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent dropTargetEvent) {
                if (DOMCompareView.this.selectedNode != null && DOMCompareView.this.selectedNode.toString().equals(dropTargetEvent.data)) {
                    DOMCompareView.this.addNodeToCompare(DOMCompareView.this.selectedNode);
                }
            }
        });
        this.compare.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)DOMCompareView.this.compareViewer.getSelection();
                DOMCompareView.this.rename.setEnabled(iStructuredSelection.size() == 1);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.listButtonsComp = new Composite(this.listComp, 0);
        this.listButtonsComp.setLayout((Layout)gridLayout);
        this.listButtonsComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.remove = new Button(this.listButtonsComp, 8);
        this.remove.setImage(MozIDEUIPlugin.getDefault().getImage("CLOSE_TB_ID"));
        this.remove.setToolTipText("Remove Node");
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] objectArray = ((IStructuredSelection)DOMCompareView.this.compareViewer.getSelection()).toArray();
                int n = 0;
                while (n < objectArray.length) {
                    DOMCompareView.this.compareViewer.remove(objectArray[n]);
                    DOMCompareView.this.nodesToCompare.remove(objectArray[n]);
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.clear = new Button(this.listButtonsComp, 8);
        this.clear.setImage(MozIDEUIPlugin.getDefault().getImage("CLEAR_IMG_ID"));
        this.clear.setToolTipText("Clear List");
        this.clear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DOMCompareView.this.compare.removeAll();
                DOMCompareView.this.nodesToCompare.clear();
                DOMCompareView.this.clearTable();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.buttons = new Composite(this.leftComp, 2048);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.buttons.setLayout((Layout)gridLayout);
        this.buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        this.compareLabel = new Label(this.buttons, 0);
        this.compareLabel.setText("Compare:");
        this.attributes = new Button(this.buttons, 16);
        this.attributes.setText("DOM Attributes");
        this.attributes.setSelection(true);
        this.children = new Button(this.buttons, 16);
        this.children.setText("Child Nodes");
        this.css = new Button(this.buttons, 16);
        this.css.setText("CSS");
        this.executeCompare = new Button(this.buttons, 8);
        this.executeCompare.setText("Compare");
        this.executeCompare.setToolTipText("Compare nodes");
        this.executeCompare.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DOMCompareView.this.attributes.getSelection()) {
                    DOMCompareView.this.compareAttributes();
                } else if (DOMCompareView.this.css.getSelection()) {
                    DOMCompareView.this.compareCSS();
                } else if (DOMCompareView.this.children.getSelection()) {
                    DOMCompareView.this.compareChildren();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.rightComp = new Composite((Composite)this.displayArea, 0);
        this.rightComp.setLayout((Layout)gridLayout);
        this.rightComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nodes = new Table(this.rightComp, 65536);
        this.nodes.setHeaderVisible(true);
        this.nodes.setLinesVisible(true);
        this.nodeTable = new TableViewer(this.nodes);
        this.nodes.setLayoutData((Object)new GridData(4, 4, true, true));
        this.menu = new Menu((Control)this.compare);
        this.menu.setEnabled(true);
        this.rename = new MenuItem(this.menu, 8);
        this.rename.setText("Rename node");
        this.rename.setEnabled(false);
        this.rename.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = DOMCompareView.this.compare.getSelection()[0];
                int n = DOMCompareView.this.compare.getSelectionIndex();
                InputDialog inputDialog = new InputDialog(DOMCompareView.this.rename.getParent().getShell(), "Rename node", "Node Name:", string, null);
                if (inputDialog.open() == 0) {
                    DOMCompareView.this.compare.setItem(n, inputDialog.getValue());
                    DOMCompareView.this.nodesToCompare.put(inputDialog.getValue(), DOMCompareView.this.nodesToCompare.remove(string));
                    DOMCompareView.this.nodeTable.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.compare.setMenu(this.menu);
        this.displayArea.setWeights(new int[]{15, 85});
    }

    public void addNodeToCompare(nsIDOMNode nsIDOMNode2) {
        String string = this.hashNode(nsIDOMNode2);
        this.compareViewer.add((Object)string);
        this.nodesToCompare.put(string, nsIDOMNode2);
    }

    private void clearTable() {
        this.nodes.removeAll();
        TableColumn[] tableColumnArray = this.nodes.getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            tableColumnArray[n].dispose();
            ++n;
        }
    }

    public void dispose() {
        this.green.dispose();
        this.red.dispose();
        super.dispose();
    }

    private String hashNode(nsIDOMNode nsIDOMNode2) {
        nsIDOMElement nsIDOMElement2;
        String string = String.valueOf(nsIDOMNode2.getNodeName()) + "[" + nsIDOMNode2.hashCode() + "]";
        if (nsIDOMNode2.getNodeType() == 1 && (nsIDOMElement2 = (nsIDOMElement)nsIDOMNode2.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")).getAttribute("id") != null && nsIDOMElement2.getAttribute("id").length() > 0) {
            string = String.valueOf(nsIDOMNode2.getNodeName()) + "[" + nsIDOMElement2.getAttribute("id") + "]";
        }
        return string;
    }

    private void compareAttributes() {
        this.clearTable();
        ArrayList<TableItem> arrayList = new ArrayList<TableItem>();
        Object[] objectArray = this.nodesToCompare.keySet().toArray();
        int n = this.nodes.getBounds().width;
        int n2 = 0;
        while (n2 < objectArray.length) {
            nsIDOMNode nsIDOMNode2 = (nsIDOMNode)this.nodesToCompare.get(objectArray[n2]);
            nsIDOMNamedNodeMap nsIDOMNamedNodeMap2 = nsIDOMNode2.getAttributes();
            TableColumn tableColumn = new TableColumn(this.nodes, 16384);
            tableColumn.setText(objectArray[n2].toString());
            tableColumn.setWidth(n / objectArray.length);
            tableColumn.setResizable(true);
            if (nsIDOMNamedNodeMap2 != null) {
                int n3 = 0;
                while ((long)n3 < nsIDOMNamedNodeMap2.getLength()) {
                    TableItem tableItem;
                    String string = nsIDOMNamedNodeMap2.item((long)n3).getNodeName();
                    String string2 = nsIDOMNamedNodeMap2.item((long)n3).getNodeValue();
                    if (n3 < arrayList.size()) {
                        tableItem = (TableItem)arrayList.get(n3);
                    } else {
                        tableItem = new TableItem(this.nodes, 0);
                        arrayList.add(tableItem);
                    }
                    tableItem.setText(n2, String.valueOf(string) + ":" + string2);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void compareCSS() {
        this.clearTable();
        ArrayList<TableItem> arrayList = new ArrayList<TableItem>();
        Object[] objectArray = this.nodesToCompare.keySet().toArray();
        int n = this.nodes.getBounds().width;
        int n2 = 0;
        while (n2 < objectArray.length) {
            nsIDOMNode nsIDOMNode2 = (nsIDOMNode)this.nodesToCompare.get(objectArray[n2]);
            nsIDOMNamedNodeMap nsIDOMNamedNodeMap2 = nsIDOMNode2.getAttributes();
            TableColumn tableColumn = new TableColumn(this.nodes, 16384);
            tableColumn.setText(objectArray[n2].toString());
            tableColumn.setWidth(n / objectArray.length);
            tableColumn.setResizable(true);
            if (nsIDOMNamedNodeMap2 != null && nsIDOMNode2.getNodeType() == 1) {
                nsIDOMElement nsIDOMElement2 = (nsIDOMElement)nsIDOMNode2.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                nsIDOMDocumentView nsIDOMDocumentView2 = (nsIDOMDocumentView)nsIDOMElement2.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
                nsIDOMViewCSS nsIDOMViewCSS2 = (nsIDOMViewCSS)nsIDOMDocumentView2.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
                nsIDOMCSSStyleDeclaration nsIDOMCSSStyleDeclaration2 = nsIDOMViewCSS2.getComputedStyle(nsIDOMElement2, "");
                int n3 = 0;
                while ((long)n3 < nsIDOMCSSStyleDeclaration2.getLength()) {
                    TableItem tableItem;
                    String string = nsIDOMCSSStyleDeclaration2.item((long)n3);
                    String string2 = nsIDOMCSSStyleDeclaration2.getPropertyCSSValue(nsIDOMCSSStyleDeclaration2.item((long)n3)).getCssText();
                    if (n3 < arrayList.size()) {
                        tableItem = (TableItem)arrayList.get(n3);
                    } else {
                        tableItem = new TableItem(this.nodes, 0);
                        arrayList.add(tableItem);
                    }
                    tableItem.setText(n2, String.valueOf(string) + ":" + string2);
                    ++n3;
                }
            }
            ++n2;
        }
        this.highlightTable(arrayList);
    }

    private void compareChildren() {
        this.clearTable();
        ArrayList<TableItem> arrayList = new ArrayList<TableItem>();
        Object[] objectArray = this.nodesToCompare.keySet().toArray();
        int n = this.nodes.getBounds().width;
        int n2 = 0;
        while (n2 < objectArray.length) {
            nsIDOMNode nsIDOMNode2 = (nsIDOMNode)this.nodesToCompare.get(objectArray[n2]);
            nsIDOMNodeList nsIDOMNodeList2 = nsIDOMNode2.getChildNodes();
            TableColumn tableColumn = new TableColumn(this.nodes, 16384);
            tableColumn.setText(objectArray[n2].toString());
            tableColumn.setWidth(n / objectArray.length);
            tableColumn.setResizable(true);
            if (nsIDOMNodeList2 != null) {
                int n3 = 0;
                while ((long)n3 < nsIDOMNodeList2.getLength()) {
                    TableItem tableItem;
                    String string = nsIDOMNodeList2.item((long)n3).getNodeName();
                    if (n3 < arrayList.size()) {
                        tableItem = (TableItem)arrayList.get(n3);
                    } else {
                        tableItem = new TableItem(this.nodes, 0);
                        arrayList.add(tableItem);
                    }
                    tableItem.setText(n2, string);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void highlightTable(List list) {
        if (this.nodesToCompare.size() > 1) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TableItem tableItem = (TableItem)iterator.next();
                int n = tableItem.getParent().getColumnCount();
                int n2 = 0;
                String string = "";
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n) {
                        if (n3 != n5 && tableItem.getText(n3).equals(tableItem.getText(n5))) {
                            ++n4;
                        }
                        ++n5;
                    }
                    string = n4 > n2 ? tableItem.getText(n3) : string;
                    n2 = n4 > n2 ? n4 : n2;
                    ++n3;
                }
                n3 = 0;
                while (n3 < n) {
                    if (tableItem.getText(n3).equals(string)) {
                        tableItem.setBackground(n3, this.green);
                    } else {
                        tableItem.setBackground(n3, this.red);
                    }
                    ++n3;
                }
            }
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IDOMNodeSelection) {
            this.selectedNode = ((IDOMNodeSelection)iSelection).getSelectedNode();
        }
    }

    public void setFocus() {
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        iViewSite.getPage().addSelectionListener((ISelectionListener)this);
        super.init(iViewSite);
    }
}

