/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.interfaces.nsIWebProgressListener2;
import org.mozilla.xpcom.Mozilla;

public class BrowserStatusFilter
implements nsIWebProgress,
nsIWebProgressListener,
nsIWebProgressListener2 {
    private Display display;
    private nsIWebProgressListener listener;
    private boolean useRealProgressFlag;
    private int totalRequests;
    private int finishedRequests;
    private String statusMsg;
    private boolean delayedStatus;
    private boolean delayedProgress;
    private int curProgress;
    private int maxProgress;

    public BrowserStatusFilter(Display display) {
        this.display = display;
    }

    public void addProgressListener(nsIWebProgressListener nsIWebProgressListener3, long l) {
        this.listener = nsIWebProgressListener3;
    }

    public nsIDOMWindow getDOMWindow() {
        throw new RuntimeException("Not implemented.");
    }

    public boolean getIsLoadingDocument() {
        throw new RuntimeException("Not implemented.");
    }

    public void removeProgressListener(nsIWebProgressListener nsIWebProgressListener3) {
        if (nsIWebProgressListener3 == this.listener) {
            this.listener = null;
        }
    }

    public nsISupports queryInterface(String string) {
        return Mozilla.queryInterface((nsISupports)this, (String)string);
    }

    public void onLocationChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, nsIURI nsIURI2) {
        if (this.listener != null) {
            this.listener.onLocationChange(nsIWebProgress2, nsIRequest2, nsIURI2);
        }
    }

    public void onProgressChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, int n, int n2, int n3, int n4) {
        if (this.listener == null) {
            return;
        }
        if (!this.useRealProgressFlag && nsIRequest2 != null) {
            return;
        }
        this.curProgress = n3;
        this.maxProgress = n4;
        if (this.delayedProgress) {
            return;
        }
        if (!this.delayedStatus) {
            this.listener.onProgressChange(null, null, 0, 0, this.curProgress, this.maxProgress);
            this.startDelayTimer();
        }
        this.delayedProgress = true;
    }

    public void onSecurityChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l) {
        if (this.listener != null) {
            this.listener.onSecurityChange(nsIWebProgress2, nsIRequest2, l);
        }
    }

    public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l, long l2) {
        if (this.listener == null) {
            return;
        }
        if ((l & 1L) != 0L) {
            if ((l & 0x40000L) != 0L) {
                this.totalRequests = 0;
                this.finishedRequests = 0;
                this.useRealProgressFlag = false;
            }
            if ((l & 0x10000L) != 0L) {
                ++this.totalRequests;
                this.useRealProgressFlag = this.totalRequests == 1;
            }
        } else if ((l & 0x10L) != 0L) {
            if ((l & 0x10000L) != 0L) {
                ++this.finishedRequests;
                if (!this.useRealProgressFlag && this.totalRequests != 0) {
                    this.onProgressChange(null, null, 0, 0, this.finishedRequests, this.totalRequests);
                }
            }
        } else if ((l & 4L) != 0L) {
            if ((l & 0x10000L) != 0L && !this.useRealProgressFlag && this.totalRequests != 0) {
                this.onProgressChange(null, null, 0, 0, this.finishedRequests, this.totalRequests);
            }
        } else {
            return;
        }
        this.listener.onStateChange(nsIWebProgress2, nsIRequest2, l, l2);
    }

    public void onStatusChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l, String string) {
        if (this.listener == null) {
            return;
        }
        this.statusMsg = string;
        if (this.delayedStatus) {
            return;
        }
        if (!this.delayedProgress) {
            this.listener.onStatusChange(null, null, 0L, string);
            this.startDelayTimer();
        }
        this.delayedStatus = true;
    }

    public void onProgressChange64(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l, long l2, long l3, long l4) {
        this.onProgressChange(nsIWebProgress2, nsIRequest2, (int)l, (int)l2, (int)l3, (int)l4);
    }

    private void startDelayTimer() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (BrowserStatusFilter.this.listener == null) {
                    return;
                }
                if (BrowserStatusFilter.this.delayedStatus) {
                    BrowserStatusFilter.this.delayedStatus = false;
                    BrowserStatusFilter.this.listener.onStatusChange(null, null, 0L, BrowserStatusFilter.this.statusMsg);
                }
                if (BrowserStatusFilter.this.delayedProgress) {
                    BrowserStatusFilter.this.delayedProgress = false;
                    BrowserStatusFilter.this.listener.onProgressChange(null, null, 0, 0, BrowserStatusFilter.this.curProgress, BrowserStatusFilter.this.maxProgress);
                }
            }
        };
        this.display.timerExec(40, runnable);
    }
}

