/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Vector;
import org.eclipse.atf.mozilla.ide.core.MozillaHelper;
import org.eclipse.atf.mozilla.ide.core.MozillaInitializationException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.BrowserStatusFilter;
import org.eclipse.swt.browser.EmbeddingSiteWindow;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.MozillaBrowserPlatform;
import org.eclipse.swt.browser.MozillaCloseWindowListener;
import org.eclipse.swt.browser.MozillaDownloadFactory;
import org.eclipse.swt.browser.MozillaHelperAppLauncherDialogFactory;
import org.eclipse.swt.browser.MozillaOpenWindowListener;
import org.eclipse.swt.browser.MozillaPromptServiceFactory;
import org.eclipse.swt.browser.MozillaVisibilityWindowListener;
import org.eclipse.swt.browser.MozillaWindowCreator;
import org.eclipse.swt.browser.MozillaWindowEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mozilla.interfaces.nsIAppShell;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIContextMenuListener;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDocShellTreeItem;
import org.mozilla.interfaces.nsIDocShellTreeNode;
import org.mozilla.interfaces.nsIEmbeddingSiteWindow;
import org.mozilla.interfaces.nsIFactory;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIStreamListener;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsITooltipListener;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIURIContentListener;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWebBrowserChromeFocus;
import org.mozilla.interfaces.nsIWebBrowserFocus;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.interfaces.nsIWindowCreator;
import org.mozilla.interfaces.nsIWindowWatcher;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class MozillaBrowser
extends MozillaBrowserPlatform
implements nsIWebProgressListener,
nsIWebBrowserChrome,
nsIWebBrowserChromeFocus,
nsIInterfaceRequestor,
nsIContextMenuListener,
nsIURIContentListener,
nsITooltipListener,
nsIDOMEventListener {
    public static final String NS_APPSHELL_CID = "{2d96b3df-c051-11d1-a827-0040959a28c9}";
    public static final String NS_IOSERVICE_CID = "{9ac9e770-18bc-11d3-9337-00104ba0fd40}";
    public static final String NS_INPUTSTREAMCHANNEL_CID = "{6ddb050c-0d04-11d4-986e-00c04fa0cf4a}";
    public static final String NS_LOADGROUP_CID = "{e1c61582-2a84-11d3-8cce-0060b0fc14a3}";
    public static final String NS_PROMPTSERVICE_CID = "{a2112d6a-0e28-421f-b46a-25c0b308cbd0}";
    public static final String NS_HELPERAPPLAUNCHERDIALOG_CID = "{f68578eb-6ec2-4169-ae19-8c6243f0abe1}";
    public static final String NS_DOWNLOAD_CID = "{e3fa9D0a-1dd1-11b2-bdef-8c720b597445}";
    public static final String NS_CATEGORYMANAGER_CONTRACTID = "@mozilla.org/categorymanager;1";
    public static final String NS_MEMORY_CONTRACTID = "@mozilla.org/xpcom/memory-service;1";
    public static final String NS_PROMPTSERVICE_CONTRACTID = "@mozilla.org/embedcomp/prompt-service;1";
    public static final String NS_WINDOWWATCHER_CONTRACTID = "@mozilla.org/embedcomp/window-watcher;1";
    public static final String NS_HELPERAPPLAUNCHERDIALOG_CONTRACTID = "@mozilla.org/helperapplauncherdialog;1";
    public static final String NS_DOWNLOAD_CONTRACTID = "@mozilla.org/download;1";
    nsIEmbeddingSiteWindow embeddingSiteWin;
    long chromeFlags = 1L;
    nsIRequest request;
    Point location;
    Point size;
    boolean addressBar;
    boolean menuBar;
    boolean statusBar;
    boolean toolBar;
    boolean visible;
    Shell tip = null;
    Vector unhookedDOMWindows = new Vector();
    MozillaCloseWindowListener[] closeWindowListeners = new MozillaCloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    MozillaOpenWindowListener[] openWindowListeners = new MozillaOpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    MozillaVisibilityWindowListener[] visibilityWindowListeners = new MozillaVisibilityWindowListener[0];
    private BrowserStatusFilter filter;
    static nsIAppShell AppShell;
    static MozillaWindowCreator WindowCreator;
    static int BrowserCount;
    static boolean mozilla;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";

    public MozillaBrowser(Composite composite, int n) {
        super(composite, n);
        try {
            Object object;
            Object object2;
            Object object3;
            nsIBaseWindow nsIBaseWindow2;
            String string;
            nsIComponentManager nsIComponentManager2;
            Mozilla mozilla = MozillaHelper.getMozillaInstance();
            if (!MozillaBrowser.mozilla) {
                nsIComponentManager2 = mozilla.getComponentManager();
                AppShell = (nsIAppShell)nsIComponentManager2.createInstance(NS_APPSHELL_CID, null, "{a0757c31-eeac-11d1-9ec1-00aa002fb821}");
                AppShell.create(null, null);
                AppShell.spinup();
                WindowCreator = new MozillaWindowCreator();
                string = mozilla.getServiceManager();
                nsIBaseWindow2 = (nsIWindowWatcher)string.getServiceByContractID(NS_WINDOWWATCHER_CONTRACTID, "{002286a8-494b-43b3-8ddd-49e3fc50622b}");
                nsIBaseWindow2.setWindowCreator((nsIWindowCreator)WindowCreator);
                object3 = new MozillaPromptServiceFactory();
                object2 = mozilla.getComponentRegistrar();
                object2.registerFactory(NS_PROMPTSERVICE_CID, "Prompt Service", NS_PROMPTSERVICE_CONTRACTID, (nsIFactory)object3);
                object = new MozillaHelperAppLauncherDialogFactory();
                object2.registerFactory(NS_HELPERAPPLAUNCHERDIALOG_CID, "Helper App Launcher Dialog", NS_HELPERAPPLAUNCHERDIALOG_CONTRACTID, (nsIFactory)object);
                MozillaDownloadFactory mozillaDownloadFactory = new MozillaDownloadFactory();
                object2.registerFactory(NS_DOWNLOAD_CID, "MozillaDownload", NS_DOWNLOAD_CONTRACTID, (nsIFactory)mozillaDownloadFactory);
                MozillaBrowser.mozilla = true;
            }
            ++BrowserCount;
            nsIComponentManager2 = mozilla.getComponentManager();
            string = "F1EAC761-87E9-11d3-AF80-00A024FFC08C";
            this.webBrowser = (nsIWebBrowser)nsIComponentManager2.createInstance(string, null, "{69e5df00-7b8b-11d3-af61-00a024ffc08c}");
            this.webBrowser.setContainerWindow((nsIWebBrowserChrome)this);
            nsIBaseWindow2 = (nsIBaseWindow)this.webBrowser.queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}");
            object3 = this.getClientArea();
            if (object3.isEmpty()) {
                object3.width = 1;
                object3.height = 1;
            }
            nsIBaseWindow2.initWindow((long)this.getHandle(), 0L, 0, 0, object3.width, object3.height);
            nsIBaseWindow2.create();
            nsIBaseWindow2.setVisibility(true);
            this.filter = new BrowserStatusFilter(this.getDisplay());
            this.filter.addProgressListener(this, 255L);
            this.webBrowser.addWebBrowserListener((nsISupports)this.filter, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
            this.webBrowser.setParentURIContentListener((nsIURIContentListener)this);
            object2 = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            MozillaBrowser.this.onDispose();
                            break;
                        }
                        case 11: {
                            MozillaBrowser.this.onResize();
                            break;
                        }
                        case 15: 
                        case 26: {
                            MozillaBrowser.this.activate();
                            break;
                        }
                        case 27: {
                            Display display = event.display;
                            if (MozillaBrowser.this != display.getFocusControl()) break;
                            MozillaBrowser.this.deactivate();
                            break;
                        }
                        case 22: {
                            MozillaBrowser.this.onShow(event);
                        }
                    }
                }
            };
            object = new int[]{12, 11, 15, 1, 26, 27, 22};
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                this.addListener((int)object[n2], (Listener)object2);
                ++n2;
            }
        }
        catch (MozillaInitializationException mozillaInitializationException) {
            mozillaInitializationException.printStackTrace();
            this.dispose();
            if (mozillaInitializationException.getWrappedException() instanceof XPCOMException) {
                MozillaBrowser.error(((XPCOMException)mozillaInitializationException.getWrappedException()).errorcode);
            }
            SWT.error((int)47, (Throwable)mozillaInitializationException.getWrappedException());
        }
    }

    public void addCloseWindowListener(MozillaCloseWindowListener mozillaCloseWindowListener) {
        this.checkWidget();
        if (mozillaCloseWindowListener == null) {
            SWT.error((int)4);
        }
        MozillaCloseWindowListener[] mozillaCloseWindowListenerArray = new MozillaCloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, mozillaCloseWindowListenerArray, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = mozillaCloseWindowListenerArray;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = mozillaCloseWindowListener;
    }

    public void addLocationListener(LocationListener locationListener) {
        this.checkWidget();
        if (locationListener == null) {
            SWT.error((int)4);
        }
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, this.locationListeners.length);
        this.locationListeners = locationListenerArray;
        this.locationListeners[this.locationListeners.length - 1] = locationListener;
    }

    public void addOpenWindowListener(MozillaOpenWindowListener mozillaOpenWindowListener) {
        this.checkWidget();
        if (mozillaOpenWindowListener == null) {
            SWT.error((int)4);
        }
        MozillaOpenWindowListener[] mozillaOpenWindowListenerArray = new MozillaOpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, mozillaOpenWindowListenerArray, 0, this.openWindowListeners.length);
        this.openWindowListeners = mozillaOpenWindowListenerArray;
        this.openWindowListeners[this.openWindowListeners.length - 1] = mozillaOpenWindowListener;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.checkWidget();
        if (progressListener == null) {
            SWT.error((int)4);
        }
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, this.progressListeners.length);
        this.progressListeners = progressListenerArray;
        this.progressListeners[this.progressListeners.length - 1] = progressListener;
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.checkWidget();
        if (statusTextListener == null) {
            SWT.error((int)4);
        }
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, this.statusTextListeners.length);
        this.statusTextListeners = statusTextListenerArray;
        this.statusTextListeners[this.statusTextListeners.length - 1] = statusTextListener;
    }

    public void addTitleListener(TitleListener titleListener) {
        this.checkWidget();
        if (titleListener == null) {
            SWT.error((int)4);
        }
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, this.titleListeners.length);
        this.titleListeners = titleListenerArray;
        this.titleListeners[this.titleListeners.length - 1] = titleListener;
    }

    public void addVisibilityWindowListener(MozillaVisibilityWindowListener mozillaVisibilityWindowListener) {
        this.checkWidget();
        if (mozillaVisibilityWindowListener == null) {
            SWT.error((int)4);
        }
        MozillaVisibilityWindowListener[] mozillaVisibilityWindowListenerArray = new MozillaVisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, mozillaVisibilityWindowListenerArray, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = mozillaVisibilityWindowListenerArray;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = mozillaVisibilityWindowListener;
    }

    public boolean back() {
        this.checkWidget();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIWebNavigation2.goBack();
        return true;
    }

    protected void checkSubclass() {
        int n;
        String string = ((Object)((Object)this)).getClass().getName();
        if (!string.substring(0, (n = string.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error((int)43);
        }
    }

    public boolean execute(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        String string2 = "javascript:" + string + ";void(0);";
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        if (nsIWebNavigation2 == null) {
            MozillaBrowser.error(2147500034L);
        }
        nsIWebNavigation2.loadURI(string2, 0L, null, null, null);
        return true;
    }

    public boolean forward() {
        this.checkWidget();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIWebNavigation2.goForward();
        return true;
    }

    public String getUrl() {
        this.checkWidget();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIURI nsIURI2 = nsIWebNavigation2.getCurrentURI();
        String string = "";
        if (nsIURI2 != null) {
            string = nsIURI2.getSpec();
        }
        return string;
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        boolean bl = nsIWebNavigation2.getCanGoBack();
        return bl;
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        boolean bl = nsIWebNavigation2.getCanGoForward();
        return bl;
    }

    static String error(long l) {
        throw new SWTError("XPCOM error " + l);
    }

    public nsIBaseWindow getBaseWindow() {
        return (nsIBaseWindow)this.webBrowser.queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}");
    }

    void onDispose() {
        this.webBrowser.removeWebBrowserListener((nsISupports)this.filter, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        this.webBrowser.setParentURIContentListener(null);
        this.unhookDOMListeners();
        this.notifyCloseWindowListeners();
        nsIBaseWindow nsIBaseWindow2 = (nsIBaseWindow)this.webBrowser.queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}");
        nsIBaseWindow2.destroy();
        this.webBrowser = null;
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        super.onDipose();
        --BrowserCount;
    }

    void activate() {
        nsIWebBrowserFocus nsIWebBrowserFocus2 = (nsIWebBrowserFocus)this.webBrowser.queryInterface("{9c5d3c58-1dd1-11b2-a1c9-f3699284657a}");
        nsIWebBrowserFocus2.activate();
    }

    void deactivate() {
        nsIWebBrowserFocus nsIWebBrowserFocus2 = (nsIWebBrowserFocus)this.webBrowser.queryInterface("{9c5d3c58-1dd1-11b2-a1c9-f3699284657a}");
        nsIWebBrowserFocus2.deactivate();
    }

    void onResize() {
        Rectangle rectangle = this.getClientArea();
        nsIBaseWindow nsIBaseWindow2 = (nsIBaseWindow)this.webBrowser.queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}");
        super.setNativeSize(rectangle.width, rectangle.height);
        nsIBaseWindow2.setPositionAndSize(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    void setFocusAtFirstElement() {
        nsIWebBrowserFocus nsIWebBrowserFocus2 = (nsIWebBrowserFocus)this.webBrowser.queryInterface("{9c5d3c58-1dd1-11b2-a1c9-f3699284657a}");
        nsIWebBrowserFocus2.setFocusAtFirstElement();
    }

    public void refresh() {
        block2: {
            this.checkWidget();
            nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
            try {
                nsIWebNavigation2.reload(0L);
            }
            catch (XPCOMException xPCOMException) {
                if (xPCOMException.errorcode == 2147500035L) break block2;
                throw xPCOMException;
            }
        }
    }

    public void removeCloseWindowListener(MozillaCloseWindowListener mozillaCloseWindowListener) {
        this.checkWidget();
        if (mozillaCloseWindowListener == null) {
            SWT.error((int)4);
        }
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.closeWindowListeners.length) {
            if (mozillaCloseWindowListener == this.closeWindowListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new MozillaCloseWindowListener[0];
            return;
        }
        MozillaCloseWindowListener[] mozillaCloseWindowListenerArray = new MozillaCloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, mozillaCloseWindowListenerArray, 0, n);
        System.arraycopy(this.closeWindowListeners, n + 1, mozillaCloseWindowListenerArray, n, this.closeWindowListeners.length - n - 1);
        this.closeWindowListeners = mozillaCloseWindowListenerArray;
    }

    public void removeLocationListener(LocationListener locationListener) {
        this.checkWidget();
        if (locationListener == null) {
            SWT.error((int)4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.locationListeners.length) {
            if (locationListener == this.locationListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] locationListenerArray = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, locationListenerArray, 0, n);
        System.arraycopy(this.locationListeners, n + 1, locationListenerArray, n, this.locationListeners.length - n - 1);
        this.locationListeners = locationListenerArray;
    }

    public void removeOpenWindowListener(MozillaOpenWindowListener mozillaOpenWindowListener) {
        this.checkWidget();
        if (mozillaOpenWindowListener == null) {
            SWT.error((int)4);
        }
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.openWindowListeners.length) {
            if (mozillaOpenWindowListener == this.openWindowListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new MozillaOpenWindowListener[0];
            return;
        }
        MozillaOpenWindowListener[] mozillaOpenWindowListenerArray = new MozillaOpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, mozillaOpenWindowListenerArray, 0, n);
        System.arraycopy(this.openWindowListeners, n + 1, mozillaOpenWindowListenerArray, n, this.openWindowListeners.length - n - 1);
        this.openWindowListeners = mozillaOpenWindowListenerArray;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.checkWidget();
        if (progressListener == null) {
            SWT.error((int)4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.progressListeners.length) {
            if (progressListener == this.progressListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] progressListenerArray = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, progressListenerArray, 0, n);
        System.arraycopy(this.progressListeners, n + 1, progressListenerArray, n, this.progressListeners.length - n - 1);
        this.progressListeners = progressListenerArray;
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.checkWidget();
        if (statusTextListener == null) {
            SWT.error((int)4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.statusTextListeners.length) {
            if (statusTextListener == this.statusTextListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] statusTextListenerArray = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, statusTextListenerArray, 0, n);
        System.arraycopy(this.statusTextListeners, n + 1, statusTextListenerArray, n, this.statusTextListeners.length - n - 1);
        this.statusTextListeners = statusTextListenerArray;
    }

    public void removeTitleListener(TitleListener titleListener) {
        this.checkWidget();
        if (titleListener == null) {
            SWT.error((int)4);
        }
        if (this.titleListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.titleListeners.length) {
            if (titleListener == this.titleListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] titleListenerArray = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, titleListenerArray, 0, n);
        System.arraycopy(this.titleListeners, n + 1, titleListenerArray, n, this.titleListeners.length - n - 1);
        this.titleListeners = titleListenerArray;
    }

    public void removeVisibilityWindowListener(MozillaVisibilityWindowListener mozillaVisibilityWindowListener) {
        this.checkWidget();
        if (mozillaVisibilityWindowListener == null) {
            SWT.error((int)4);
        }
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.visibilityWindowListeners.length) {
            if (mozillaVisibilityWindowListener == this.visibilityWindowListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new MozillaVisibilityWindowListener[0];
            return;
        }
        MozillaVisibilityWindowListener[] mozillaVisibilityWindowListenerArray = new MozillaVisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, mozillaVisibilityWindowListenerArray, 0, n);
        System.arraycopy(this.visibilityWindowListeners, n + 1, mozillaVisibilityWindowListenerArray, n, this.visibilityWindowListeners.length - n - 1);
        this.visibilityWindowListeners = mozillaVisibilityWindowListenerArray;
    }

    public boolean setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if (this != this.getDisplay().getFocusControl()) {
            this.deactivate();
        }
        this.unhookDOMListeners();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIWebNavigation2.stop(3L);
        nsIWebNavigation2.loadURI("data:text/html," + string, 0L, null, null, null);
        this.hookDOMListeners();
        return true;
    }

    public boolean setUrl(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIWebNavigation2.loadURI(string, 0L, null, null, null);
        return true;
    }

    public void stop() {
        this.checkWidget();
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)this.webBrowser.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIWebNavigation2.stop(3L);
    }

    void hookDOMListenersFromVector(nsIDOMWindow nsIDOMWindow2) {
        int n = this.unhookedDOMWindows.indexOf(nsIDOMWindow2);
        if (n != -1) {
            boolean bl = nsIDOMWindow2 == this.webBrowser.getContentDOMWindow();
            nsIDOMEventTarget nsIDOMEventTarget2 = (nsIDOMEventTarget)nsIDOMWindow2.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            this.hookDOMListeners(nsIDOMEventTarget2, bl);
            this.unhookedDOMWindows.remove(nsIDOMWindow2);
        }
    }

    void hookDOMListeners() {
        nsIDOMWindow nsIDOMWindow2 = this.webBrowser.getContentDOMWindow();
        nsIDOMEventTarget nsIDOMEventTarget2 = (nsIDOMEventTarget)nsIDOMWindow2.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        this.hookDOMListeners(nsIDOMEventTarget2, true);
        nsIInterfaceRequestor nsIInterfaceRequestor2 = (nsIInterfaceRequestor)nsIDOMWindow2.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)nsIInterfaceRequestor2.getInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIDocShellTreeNode nsIDocShellTreeNode2 = (nsIDocShellTreeNode)nsIWebNavigation2.queryInterface("{37f1ab73-f224-44b1-82f0-d2834ab1cec0}");
        int n = nsIDocShellTreeNode2.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            nsIDocShellTreeItem nsIDocShellTreeItem2 = nsIDocShellTreeNode2.getChildAt(n2);
            nsIInterfaceRequestor2 = (nsIInterfaceRequestor)nsIDocShellTreeItem2.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
            nsIDOMWindow nsIDOMWindow3 = (nsIDOMWindow)nsIInterfaceRequestor2.getInterface("{a6cf906b-15b3-11d2-932e-00805f8add32}");
            nsIDOMEventTarget2 = (nsIDOMEventTarget)nsIDOMWindow3.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            this.hookDOMListeners(nsIDOMEventTarget2, false);
            ++n2;
        }
    }

    void hookDOMListeners(nsIDOMEventTarget nsIDOMEventTarget2, boolean bl) {
        nsIDOMEventTarget2.addEventListener("focus", (nsIDOMEventListener)this, false);
        nsIDOMEventTarget2.addEventListener("unload", (nsIDOMEventListener)this, false);
        nsIDOMEventTarget2.addEventListener("mousedown", (nsIDOMEventListener)this, false);
        nsIDOMEventTarget2.addEventListener("mouseup", (nsIDOMEventListener)this, false);
        nsIDOMEventTarget2.addEventListener("mousemove", (nsIDOMEventListener)this, false);
        if (bl) {
            nsIDOMEventTarget2.addEventListener("mouseover", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.addEventListener("mouseout", (nsIDOMEventListener)this, false);
        }
    }

    void unhookDOMListeners() {
        nsIDOMWindow nsIDOMWindow2 = this.webBrowser.getContentDOMWindow();
        nsIDOMEventTarget nsIDOMEventTarget2 = (nsIDOMEventTarget)nsIDOMWindow2.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        this.unhookDOMListeners(nsIDOMEventTarget2);
        nsIInterfaceRequestor nsIInterfaceRequestor2 = (nsIInterfaceRequestor)nsIDOMWindow2.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
        nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)nsIInterfaceRequestor2.getInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
        nsIDocShellTreeNode nsIDocShellTreeNode2 = (nsIDocShellTreeNode)nsIWebNavigation2.queryInterface("{37f1ab73-f224-44b1-82f0-d2834ab1cec0}");
        int n = nsIDocShellTreeNode2.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            nsIDocShellTreeItem nsIDocShellTreeItem2 = nsIDocShellTreeNode2.getChildAt(n2);
            nsIInterfaceRequestor2 = (nsIInterfaceRequestor)nsIDocShellTreeItem2.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
            nsIDOMWindow nsIDOMWindow3 = (nsIDOMWindow)nsIInterfaceRequestor2.getInterface("{a6cf906b-15b3-11d2-932e-00805f8add32}");
            nsIDOMEventTarget2 = (nsIDOMEventTarget)nsIDOMWindow3.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            this.unhookDOMListeners(nsIDOMEventTarget2);
            ++n2;
        }
    }

    void unhookDOMListeners(nsIDOMEventTarget nsIDOMEventTarget2) {
        try {
            nsIDOMEventTarget2.removeEventListener("focus", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.removeEventListener("unload", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.removeEventListener("mousedown", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.removeEventListener("mouseup", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.removeEventListener("mousemove", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.removeEventListener("mouseover", (nsIDOMEventListener)this, false);
            nsIDOMEventTarget2.removeEventListener("mouseout", (nsIDOMEventListener)this, false);
        }
        catch (XPCOMException xPCOMException) {}
    }

    public nsISupports queryInterface(String string) {
        if (string.equals("{3e5432cd-9568-4bd1-8cbe-d50aba110743}")) {
            if (this.embeddingSiteWin == null) {
                this.embeddingSiteWin = new EmbeddingSiteWindow(this);
            }
            return this.embeddingSiteWin;
        }
        return Mozilla.queryInterface((nsISupports)this, (String)string);
    }

    public nsISupports queryReferent(String string) {
        return this.queryInterface(string);
    }

    public nsISupports getInterface(String string) {
        if (string.equals("{a6cf906b-15b3-11d2-932e-00805f8add32}")) {
            nsIDOMWindow nsIDOMWindow2 = this.webBrowser.getContentDOMWindow();
            return nsIDOMWindow2;
        }
        return this.queryInterface(string);
    }

    public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l, long l2) {
        if ((l & 0x20000L) == 0L) {
            return;
        }
        if ((l & 1L) != 0L) {
            if (this.request == null) {
                this.request = nsIRequest2;
            }
            this.unhookedDOMWindows.addElement(nsIWebProgress2.getDOMWindow());
        } else if ((l & 2L) != 0L) {
            if (this.request != null && this.request.equals(nsIRequest2)) {
                this.request = null;
            }
        } else if ((l & 0x10L) != 0L) {
            nsIDOMWindow nsIDOMWindow2 = nsIWebProgress2.getDOMWindow();
            this.hookDOMListenersFromVector(nsIDOMWindow2);
            if (this.request == null || this.request.equals(nsIRequest2)) {
                this.request = null;
                StatusTextEvent statusTextEvent = new StatusTextEvent((Widget)this);
                statusTextEvent.display = this.getDisplay();
                statusTextEvent.widget = this;
                statusTextEvent.text = "";
                int n = 0;
                while (n < this.statusTextListeners.length) {
                    this.statusTextListeners[n].changed(statusTextEvent);
                    ++n;
                }
                ProgressEvent progressEvent = new ProgressEvent((Widget)this);
                progressEvent.display = this.getDisplay();
                progressEvent.widget = this;
                progressEvent.data = nsIDOMWindow2 == this.webBrowser.getContentDOMWindow();
                int n2 = 0;
                while (n2 < this.progressListeners.length) {
                    this.progressListeners[n2].completed(progressEvent);
                    ++n2;
                }
            }
        } else if ((l & 4L) != 0L) {
            nsIDOMWindow nsIDOMWindow3 = nsIWebProgress2.getDOMWindow();
            this.hookDOMListenersFromVector(nsIDOMWindow3);
        }
    }

    public void onProgressChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, int n, int n2, int n3, int n4) {
        if (this.progressListeners.length == 0) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent((Widget)this);
        progressEvent.display = this.getDisplay();
        progressEvent.widget = this;
        progressEvent.current = n3;
        progressEvent.total = n4;
        int n5 = 0;
        while (n5 < this.progressListeners.length) {
            this.progressListeners[n5].changed(progressEvent);
            ++n5;
        }
    }

    public void onLocationChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, nsIURI nsIURI2) {
        if (this.request != null && this.request != nsIRequest2) {
            this.request = nsIRequest2;
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        String string = nsIURI2.getSpec();
        LocationEvent locationEvent = new LocationEvent((Widget)this);
        locationEvent.display = this.getDisplay();
        locationEvent.widget = this;
        locationEvent.location = string;
        locationEvent.top = nsIWebProgress2.getDOMWindow() == this.webBrowser.getContentDOMWindow();
        int n = 0;
        while (n < this.locationListeners.length) {
            this.locationListeners[n].changed(locationEvent);
            ++n;
        }
    }

    public void onStatusChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l, String string) {
        if (this.statusTextListeners.length == 0) {
            return;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent((Widget)this);
        statusTextEvent.display = this.getDisplay();
        statusTextEvent.widget = this;
        statusTextEvent.text = string;
        int n = 0;
        while (n < this.statusTextListeners.length) {
            this.statusTextListeners[n].changed(statusTextEvent);
            ++n;
        }
    }

    public void onSecurityChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l) {
    }

    public void setStatus(long l, String string) {
        StatusTextEvent statusTextEvent = new StatusTextEvent((Widget)this);
        statusTextEvent.display = this.getDisplay();
        statusTextEvent.widget = this;
        statusTextEvent.text = string;
        int n = 0;
        while (n < this.statusTextListeners.length) {
            this.statusTextListeners[n].changed(statusTextEvent);
            ++n;
        }
    }

    public nsIWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void setWebBrowser(nsIWebBrowser nsIWebBrowser2) {
        this.webBrowser = nsIWebBrowser2;
    }

    public long getChromeFlags() {
        return this.chromeFlags;
    }

    public void setChromeFlags(long l) {
        this.chromeFlags = l;
    }

    public void destroyBrowserWindow() {
        this.notifyCloseWindowListeners();
        this.dispose();
    }

    private void notifyCloseWindowListeners() {
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        MozillaWindowEvent mozillaWindowEvent = new MozillaWindowEvent((Widget)this);
        mozillaWindowEvent.display = this.getDisplay();
        mozillaWindowEvent.widget = this;
        int n = 0;
        while (n < this.closeWindowListeners.length) {
            this.closeWindowListeners[n].close(mozillaWindowEvent);
            ++n;
        }
    }

    public void sizeBrowserTo(int n, int n2) {
        this.size = new Point(n, n2);
    }

    public void showAsModal() {
        throw new RuntimeException("Not implemented.");
    }

    public boolean isWindowModal() {
        return false;
    }

    public void exitModalEventLoop(long l) {
    }

    public void focusNextElement() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MozillaBrowser.this.traverse(16);
            }
        });
    }

    public void focusPrevElement() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MozillaBrowser.this.traverse(8);
            }
        });
    }

    public void onShowContextMenu(long l, nsIDOMEvent nsIDOMEvent2, nsIDOMNode nsIDOMNode2) {
        nsIDOMMouseEvent nsIDOMMouseEvent2 = (nsIDOMMouseEvent)nsIDOMEvent2.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        int n = nsIDOMMouseEvent2.getScreenX();
        int n2 = nsIDOMMouseEvent2.getScreenY();
        Event event = new Event();
        event.x = n;
        event.y = n2;
        this.notifyListeners(35, event);
        if (!event.doit) {
            return;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (n != event.x || n2 != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
        }
    }

    public boolean onStartURIOpen(nsIURI nsIURI2) {
        String string = nsIURI2.getSpec();
        if (this.locationListeners.length == 0) {
            return false;
        }
        boolean bl = true;
        if (this.request == null) {
            LocationEvent locationEvent = new LocationEvent((Widget)this);
            locationEvent.display = this.getDisplay();
            locationEvent.widget = this;
            locationEvent.location = string;
            locationEvent.doit = true;
            int n = 0;
            while (n < this.locationListeners.length) {
                this.locationListeners[n].changing(locationEvent);
                ++n;
            }
            bl = locationEvent.doit;
        }
        return !bl;
    }

    public boolean doContent(String string, boolean bl, nsIRequest nsIRequest2, nsIStreamListener[] nsIStreamListenerArray) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean isPreferred(String string, String[] stringArray) {
        if (string.length() > 0) {
            if (string.equals("application/x-vnd.mozilla.maybe-text")) {
                return false;
            }
            if (string.equals("multipart/x-mixed-replace")) {
                return false;
            }
        }
        return true;
    }

    public boolean canHandleContent(String string, boolean bl, String[] stringArray) {
        throw new RuntimeException("Not implemented.");
    }

    public nsISupports getLoadCookie() {
        throw new RuntimeException("Not implemented.");
    }

    public void setLoadCookie(nsISupports nsISupports2) {
        throw new RuntimeException("Not implemented.");
    }

    public nsIURIContentListener getParentContentListener() {
        throw new RuntimeException("Not implemented.");
    }

    public void setParentContentListener(nsIURIContentListener nsIURIContentListener2) {
        throw new RuntimeException("Not implemented.");
    }

    public void onShowTooltip(int n, int n2, String string) {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        Display display = this.getDisplay();
        Shell shell = this.getShell();
        this.tip = new Shell(shell, 16384);
        this.tip.setLayout((Layout)new FillLayout());
        Label label = new Label((Composite)this.tip, 0x1000000);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setText(string);
        Point point = display.getCursorLocation();
        point.y += 21;
        this.tip.setLocation(point);
        this.tip.pack();
        this.tip.setVisible(true);
    }

    public void onHideTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
    }

    public nsIDOMDocument getDocument() {
        nsIDOMWindow nsIDOMWindow2 = this.webBrowser.getContentDOMWindow();
        nsIDOMDocument nsIDOMDocument2 = nsIDOMWindow2.getDocument();
        return nsIDOMDocument2;
    }

    public void handleEvent(nsIDOMEvent nsIDOMEvent2) {
        nsIDOMEventTarget nsIDOMEventTarget2;
        String string = nsIDOMEvent2.getType();
        nsIDOMEventTarget nsIDOMEventTarget3 = nsIDOMEvent2.getCurrentTarget();
        if (string.equals("unload")) {
            this.unhookDOMListeners(nsIDOMEventTarget3);
            return;
        }
        if (string.equals("focus")) {
            this.handleFocus();
            return;
        }
        nsIDOMMouseEvent nsIDOMMouseEvent2 = (nsIDOMMouseEvent)nsIDOMEvent2.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        if ((string.equals("mouseover") || string.equals("mouseout")) && (nsIDOMEventTarget2 = nsIDOMMouseEvent2.getRelatedTarget()) != null) {
            return;
        }
        int n = nsIDOMMouseEvent2.getClientX();
        int n2 = nsIDOMMouseEvent2.getClientY();
        int n3 = nsIDOMMouseEvent2.getDetail();
        int n4 = nsIDOMMouseEvent2.getButton();
        boolean bl = nsIDOMMouseEvent2.getAltKey();
        boolean bl2 = nsIDOMMouseEvent2.getCtrlKey();
        boolean bl3 = nsIDOMMouseEvent2.getShiftKey();
        boolean bl4 = nsIDOMMouseEvent2.getMetaKey();
        Event event = new Event();
        event.widget = this;
        event.data = nsIDOMEventTarget3;
        event.x = n;
        event.y = n2;
        event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? SWT.MOD1 : 0);
        if (string.equals("mousedown")) {
            event.type = 3;
            event.button = n4 + 1;
            event.count = n3;
        } else if (string.equals("mouseup")) {
            event.type = 4;
            event.button = n4 + 1;
            event.count = n3;
        } else if (string.equals("mousemove")) {
            event.type = 5;
        } else if (string.equals("mouseover")) {
            event.type = 6;
        } else if (string.equals("mouseout")) {
            event.type = 7;
        }
        this.notifyListeners(event.type, event);
        if (n3 == 2 && string.equals("mousedown")) {
            event = new Event();
            event.widget = this;
            event.data = nsIDOMEventTarget3;
            event.x = n;
            event.y = n2;
            event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? SWT.MOD1 : 0);
            event.type = 8;
            event.button = n4 + 1;
            event.count = n3;
            this.notifyListeners(event.type, event);
        }
    }
}

