/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class RenameResourceDescriptor
extends JavaRefactoringDescriptor {
    private String fName = null;
    private IResource fResource = null;

    public RenameResourceDescriptor() {
        super("org.eclipse.wst.jsdt.ui.rename.resource");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("input", RenameResourceDescriptor.resourceToHandle(this.getProject(), this.fResource));
        this.fArguments.put("name", this.fName);
    }

    public void setNewName(String string) {
        Assert.isNotNull((Object)string);
        Assert.isLegal((!"".equals(string) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = string;
    }

    public void setProject(String string) {
        super.setProject(string);
    }

    public void setResource(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.fResource = iResource;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (this.fResource == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_resource));
        }
        if (this.fName == null || "".equals(this.fName)) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fResource instanceof IProject && this.getProject() != null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_project_constraint));
        }
        return refactoringStatus;
    }
}

