/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.DefaultCommentMapper;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Message;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class CompilationUnit
extends ASTNode {
    private static final Message[] EMPTY_MESSAGES;
    private static final IProblem[] EMPTY_PROBLEMS;
    public static final ChildListPropertyDescriptor IMPORTS_PROPERTY;
    public static final ChildPropertyDescriptor PACKAGE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;
    public static final ChildListPropertyDescriptor TYPES_PROPERTY;
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY;
    private DefaultCommentMapper commentMapper = null;
    private ITypeRoot typeRoot = null;
    private ASTNode.NodeList imports = new ASTNode.NodeList(IMPORTS_PROPERTY);
    private int[] lineEndTable = Util.EMPTY_INT_ARRAY;
    private Message[] messages;
    private List optionalCommentList = null;
    Comment[] optionalCommentTable = null;
    private PackageDeclaration optionalPackageDeclaration = null;
    private IProblem[] problems = EMPTY_PROBLEMS;
    private ASTNode.NodeList types = new ASTNode.NodeList(TYPES_PROPERTY);
    private ASTNode.NodeList statements = new ASTNode.NodeList(STATEMENTS_PROPERTY);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        EMPTY_MESSAGES = new Message[0];
        EMPTY_PROBLEMS = new IProblem[0];
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$1) == null) {
            try {
                clazz4 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMPORTS_PROPERTY = new ChildListPropertyDescriptor(clazz5, "imports", clazz4, false);
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$2) == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.PackageDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PACKAGE_PROPERTY = new ChildPropertyDescriptor(clazz6, "package", clazz3, false, false);
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$3) == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TYPES_PROPERTY = new ChildListPropertyDescriptor(clazz7, "types", clazz2, true);
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.wst.jsdt.core.dom.ProgramElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(clazz8, "statements", clazz, true);
        ArrayList arrayList = new ArrayList(4);
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CompilationUnit.createPropertyList(clazz9, arrayList);
        CompilationUnit.addProperty(PACKAGE_PROPERTY, arrayList);
        CompilationUnit.addProperty(IMPORTS_PROPERTY, arrayList);
        CompilationUnit.addProperty(TYPES_PROPERTY, arrayList);
        CompilationUnit.addProperty(STATEMENTS_PROPERTY, arrayList);
        PROPERTY_DESCRIPTORS = CompilationUnit.reapPropertyList(arrayList);
    }

    public static List propertyDescriptors(int n) {
        return PROPERTY_DESCRIPTORS;
    }

    CompilationUnit(AST aST) {
        super(aST);
    }

    void accept0(ASTVisitor aSTVisitor) {
        boolean bl = aSTVisitor.visit(this);
        if (bl) {
            this.acceptChild(aSTVisitor, this.getPackage());
            this.acceptChildren(aSTVisitor, this.imports);
            this.acceptChildren(aSTVisitor, this.types);
            this.acceptChildren(aSTVisitor, this.statements);
        }
        aSTVisitor.endVisit(this);
    }

    ASTNode clone0(AST aST) {
        CompilationUnit compilationUnit = new CompilationUnit(aST);
        compilationUnit.setSourceRange(this.getStartPosition(), this.getLength());
        compilationUnit.setPackage((PackageDeclaration)ASTNode.copySubtree(aST, this.getPackage()));
        compilationUnit.imports().addAll(ASTNode.copySubtrees(aST, this.imports()));
        compilationUnit.types().addAll(ASTNode.copySubtrees(aST, this.types()));
        compilationUnit.statements().addAll(ASTNode.copySubtrees(aST, this.statements()));
        return compilationUnit;
    }

    public int getColumnNumber(int n) {
        int n2;
        if (this.lineEndTable == null) {
            return -2;
        }
        int n3 = this.getLineNumber(n);
        if (n3 == -1) {
            return -1;
        }
        if (n3 == 1) {
            if (n >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return n;
        }
        int n4 = this.lineEndTable.length;
        int n5 = this.lineEndTable[n3 - 2];
        int n6 = n5 + 1;
        int n7 = n2 = n3 == n4 + 1 ? this.getStartPosition() + this.getLength() - 1 : this.lineEndTable[n3 - 1];
        if (n6 > n2) {
            return -1;
        }
        return n - n6;
    }

    public ASTNode findDeclaringNode(IBinding iBinding) {
        return this.ast.getBindingResolver().findDeclaringNode(iBinding);
    }

    public ASTNode findDeclaringNode(String string) {
        return this.ast.getBindingResolver().findDeclaringNode(string);
    }

    public List getCommentList() {
        return this.optionalCommentList;
    }

    DefaultCommentMapper getCommentMapper() {
        return this.commentMapper;
    }

    public int getExtendedLength(ASTNode aSTNode) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || aSTNode.getAST() != this.getAST()) {
            return aSTNode.getLength();
        }
        return this.commentMapper.getExtendedLength(aSTNode);
    }

    public int getExtendedStartPosition(ASTNode aSTNode) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || aSTNode.getAST() != this.getAST()) {
            return aSTNode.getStartPosition();
        }
        return this.commentMapper.getExtendedStartPosition(aSTNode);
    }

    public IJavaElement getJavaElement() {
        return this.typeRoot;
    }

    public Message[] getMessages() {
        if (this.messages == null) {
            int n = this.problems.length;
            if (n == 0) {
                this.messages = EMPTY_MESSAGES;
            } else {
                this.messages = new Message[n];
                int n2 = 0;
                while (n2 < n) {
                    IProblem iProblem = this.problems[n2];
                    int n3 = iProblem.getSourceStart();
                    int n4 = iProblem.getSourceEnd();
                    this.messages[n2] = new Message(iProblem.getMessage(), n3, n4 - n3 + 1);
                    ++n2;
                }
            }
        }
        return this.messages;
    }

    final int getNodeType0() {
        return 15;
    }

    public PackageDeclaration getPackage() {
        return this.optionalPackageDeclaration;
    }

    public int getPosition(int n, int n2) {
        int n3;
        if (this.lineEndTable == null) {
            return -2;
        }
        if (n < 1 || n2 < 0) {
            return -1;
        }
        int n4 = this.lineEndTable.length;
        if (n4 == 0) {
            if (n != 1) {
                return -1;
            }
            return n2 >= this.getStartPosition() + this.getLength() ? -1 : n2;
        }
        if (n == 1) {
            int n5 = this.lineEndTable[0];
            return n2 > n5 ? -1 : n2;
        }
        if (n > n4 + 1) {
            return -1;
        }
        int n6 = this.lineEndTable[n - 2];
        int n7 = n6 + 1;
        int n8 = n3 = n == n4 + 1 ? this.getStartPosition() + this.getLength() - 1 : this.lineEndTable[n - 1];
        if (n7 + n2 > n3) {
            return -1;
        }
        return n7 + n2;
    }

    public IProblem[] getProblems() {
        return this.problems;
    }

    public ITypeRoot getTypeRoot() {
        return this.typeRoot;
    }

    public List imports() {
        return this.imports;
    }

    public int firstLeadingCommentIndex(ASTNode aSTNode) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || aSTNode.getAST() != this.getAST()) {
            return -1;
        }
        return this.commentMapper.firstLeadingCommentIndex(aSTNode);
    }

    public int lastTrailingCommentIndex(ASTNode aSTNode) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || aSTNode.getAST() != this.getAST()) {
            return -1;
        }
        return this.commentMapper.lastTrailingCommentIndex(aSTNode);
    }

    void initCommentMapper(Scanner scanner) {
        this.commentMapper = new DefaultCommentMapper(this.optionalCommentTable);
        this.commentMapper.initialize(this, scanner);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor childListPropertyDescriptor) {
        if (childListPropertyDescriptor == IMPORTS_PROPERTY) {
            return this.imports();
        }
        if (childListPropertyDescriptor == TYPES_PROPERTY) {
            return this.types();
        }
        if (childListPropertyDescriptor == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        return super.internalGetChildListProperty(childListPropertyDescriptor);
    }

    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor childPropertyDescriptor, boolean bl, ASTNode aSTNode) {
        if (childPropertyDescriptor == PACKAGE_PROPERTY) {
            if (bl) {
                return this.getPackage();
            }
            this.setPackage((PackageDeclaration)aSTNode);
            return null;
        }
        return super.internalGetSetChildProperty(childPropertyDescriptor, bl, aSTNode);
    }

    final List internalStructuralPropertiesForType(int n) {
        return CompilationUnit.propertyDescriptors(n);
    }

    public int lineNumber(int n) {
        int n2 = this.getLineNumber(n);
        return n2 < 1 ? 1 : n2;
    }

    public int getLineNumber(int n) {
        if (this.lineEndTable == null) {
            return -2;
        }
        int n2 = this.lineEndTable.length;
        if (n2 == 0) {
            if (n >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return 1;
        }
        int n3 = 0;
        if (n < 0) {
            return -1;
        }
        if (n <= this.lineEndTable[n3]) {
            return 1;
        }
        int n4 = n2 - 1;
        if (n > this.lineEndTable[n4]) {
            if (n >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return n2 + 1;
        }
        while (n3 + 1 != n4) {
            int n5 = n3 + (n4 - n3) / 2;
            if (n <= this.lineEndTable[n5]) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        return n3 + 2;
    }

    int memSize() {
        int n = 72;
        if (this.lineEndTable != null) {
            n += 12 + 4 * this.lineEndTable.length;
        }
        if (this.optionalCommentTable != null) {
            n += 12 + 4 * this.optionalCommentTable.length;
        }
        return n;
    }

    public void recordModifications() {
        this.getAST().recordModifications(this);
    }

    public TextEdit rewrite(IDocument iDocument, Map map) {
        return this.getAST().rewrite(iDocument, map);
    }

    void setCommentTable(Comment[] commentArray) {
        if (commentArray == null) {
            this.optionalCommentList = null;
            this.optionalCommentTable = null;
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < commentArray.length) {
                Comment comment = commentArray[n2];
                if (comment == null) {
                    throw new IllegalArgumentException();
                }
                int n3 = comment.getStartPosition();
                int n4 = comment.getLength();
                if (n3 < 0 || n4 < 0 || n3 < n) {
                    throw new IllegalArgumentException();
                }
                n = comment.getStartPosition() + comment.getLength();
                ++n2;
            }
            this.optionalCommentTable = commentArray;
            List<Comment> list = Arrays.asList(commentArray);
            this.optionalCommentList = Collections.unmodifiableList(list);
        }
    }

    void setTypeRoot(ITypeRoot iTypeRoot) {
        this.typeRoot = iTypeRoot;
    }

    void setLineEndTable(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        this.checkModifiable();
        this.lineEndTable = nArray;
    }

    public void setPackage(PackageDeclaration packageDeclaration) {
        PackageDeclaration packageDeclaration2 = this.optionalPackageDeclaration;
        this.preReplaceChild(packageDeclaration2, packageDeclaration, PACKAGE_PROPERTY);
        this.optionalPackageDeclaration = packageDeclaration;
        this.postReplaceChild(packageDeclaration2, packageDeclaration, PACKAGE_PROPERTY);
    }

    void setProblems(IProblem[] iProblemArray) {
        if (iProblemArray == null) {
            throw new IllegalArgumentException();
        }
        this.problems = iProblemArray;
    }

    final boolean subtreeMatch0(ASTMatcher aSTMatcher, Object object) {
        return aSTMatcher.match(this, object);
    }

    int treeSize() {
        int n = this.memSize();
        if (this.optionalPackageDeclaration != null) {
            n += this.getPackage().treeSize();
        }
        n += this.imports.listSize();
        n += this.types.listSize();
        n += this.statements.listSize();
        if (this.optionalCommentList != null) {
            int n2 = 0;
            while (n2 < this.optionalCommentList.size()) {
                Comment comment = (Comment)this.optionalCommentList.get(n2);
                if (comment != null && comment.getParent() == null) {
                    n += comment.treeSize();
                }
                ++n2;
            }
        }
        return n;
    }

    public List types() {
        return this.types;
    }

    public List statements() {
        return this.statements;
    }

    public ITypeBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveType(this);
    }
}

