/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.rewrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ImportRewriteAnalyzer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public final class ImportRewrite {
    private static final char STATIC_PREFIX = 's';
    private static final char NORMAL_PREFIX = 'n';
    private final ImportRewriteContext defaultContext;
    private final ICompilationUnit compilationUnit;
    private final CompilationUnit astRoot;
    private final boolean restoreExistingImports;
    private final List existingImports;
    private String[] importOrder;
    private int importOnDemandThreshold;
    private int staticImportOnDemandThreshold;
    private List addedImports;
    private List removedImports;
    private String[] createdImports;
    private String[] createdStaticImports;
    private boolean filterImplicitImports;
    private boolean writeImports = false;

    public static ImportRewrite create(ICompilationUnit iCompilationUnit, boolean bl) throws JavaModelException {
        if (iCompilationUnit == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        ArrayList<String> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<String>();
            IImportDeclaration[] iImportDeclarationArray = iCompilationUnit.getImports();
            int n = 0;
            while (n < iImportDeclarationArray.length) {
                IImportDeclaration iImportDeclaration = iImportDeclarationArray[n];
                char c = Flags.isStatic(iImportDeclaration.getFlags()) ? (char)'s' : 'n';
                arrayList.add(String.valueOf(c) + iImportDeclaration.getElementName());
                ++n;
            }
        }
        return new ImportRewrite(iCompilationUnit, null, arrayList);
    }

    public static ImportRewrite create(CompilationUnit compilationUnit, boolean bl) {
        if (compilationUnit == null) {
            throw new IllegalArgumentException("AST must not be null");
        }
        ITypeRoot iTypeRoot = compilationUnit.getTypeRoot();
        if (!(iTypeRoot instanceof ICompilationUnit)) {
            throw new IllegalArgumentException("AST must have been constructed from a Java element");
        }
        ArrayList<String> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<String>();
            List list = compilationUnit.imports();
            int n = 0;
            while (n < list.size()) {
                ImportDeclaration importDeclaration = (ImportDeclaration)list.get(n);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(importDeclaration.isStatic() ? (char)'s' : 'n').append(importDeclaration.getName().getFullyQualifiedName());
                if (importDeclaration.isOnDemand()) {
                    if (stringBuffer.length() > 1) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append('*');
                }
                arrayList.add(stringBuffer.toString());
                ++n;
            }
        }
        return new ImportRewrite((ICompilationUnit)iTypeRoot, compilationUnit, arrayList);
    }

    private ImportRewrite(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, List list) {
        this.compilationUnit = iCompilationUnit;
        this.astRoot = compilationUnit;
        if (list != null) {
            this.existingImports = list;
            this.restoreExistingImports = !list.isEmpty();
        } else {
            this.existingImports = new ArrayList();
            this.restoreExistingImports = false;
        }
        this.filterImplicitImports = true;
        this.defaultContext = new ImportRewriteContext(){

            public int findInContext(String string, String string2, int n) {
                return ImportRewrite.this.findInImports(string, string2, n);
            }
        };
        this.addedImports = null;
        this.removedImports = null;
        this.createdImports = null;
        this.createdStaticImports = null;
        this.importOrder = CharOperation.NO_STRINGS;
        this.importOnDemandThreshold = 99;
        this.staticImportOnDemandThreshold = 99;
    }

    public void setImportOrder(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Order must not be null");
        }
        this.importOrder = stringArray;
    }

    public void setOnDemandImportThreshold(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Threshold must be positive.");
        }
        this.importOnDemandThreshold = n;
    }

    public void setStaticOnDemandImportThreshold(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Threshold must be positive.");
        }
        this.staticImportOnDemandThreshold = n;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public ImportRewriteContext getDefaultImportRewriteContext() {
        return this.defaultContext;
    }

    public void setFilterImplicitImports(boolean bl) {
        this.filterImplicitImports = bl;
    }

    private static int compareImport(char c, String string, String string2, String string3) {
        if (string3.charAt(0) != c || !string3.endsWith(string2)) {
            return 2;
        }
        if ((string3 = string3.substring(1)).length() == string2.length()) {
            if (string.length() == 0) {
                return 1;
            }
            return 3;
        }
        int n = string3.length() - string2.length() - 1;
        if (string3.charAt(n) != '.') {
            return 2;
        }
        if (string.length() != n || !string3.startsWith(string)) {
            return 3;
        }
        return 1;
    }

    final int findInImports(String string, String string2, int n) {
        boolean bl = n == 3 || string2.length() == 1 && string2.charAt(0) == '*';
        List list = this.existingImports;
        char c = n == 1 ? (char)'n' : 's';
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            String string3 = (String)list.get(n2);
            int n3 = ImportRewrite.compareImport(c, string, string2, string3);
            if (!(n3 == 2 || bl && n3 != 1)) {
                return n3;
            }
            --n2;
        }
        return 2;
    }

    public Type addImportFromSignature(String string, AST aST) {
        return this.addImportFromSignature(string, aST, this.defaultContext);
    }

    public Type addImportFromSignature(String string, AST aST, ImportRewriteContext importRewriteContext) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid type signature: empty or null");
        }
        int n = Signature.getTypeSignatureKind(string);
        switch (n) {
            case 2: {
                return aST.newPrimitiveType(PrimitiveType.toCode(Signature.toString(string)));
            }
            case 4: {
                Type type = this.addImportFromSignature(Signature.getElementType(string), aST, importRewriteContext);
                return aST.newArrayType(type, Signature.getArrayCount(string));
            }
            case 1: {
                String string2 = Signature.getTypeErasure(string);
                String string3 = Signature.toString(string2);
                if (string2.charAt(0) == 'L') {
                    string3 = this.internalAddImport(string3, importRewriteContext);
                }
                SimpleType simpleType = aST.newSimpleType(aST.newName(string3));
                String[] stringArray = Signature.getTypeArguments(string);
                if (stringArray.length > 0) {
                    ParameterizedType parameterizedType = aST.newParameterizedType(simpleType);
                    List list = parameterizedType.typeArguments();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string4 = stringArray[n2];
                        if (this.containsNestedCapture(string4)) {
                            list.add(aST.newWildcardType());
                        } else {
                            list.add(this.addImportFromSignature(string4, aST, importRewriteContext));
                        }
                        ++n2;
                    }
                    return parameterizedType;
                }
                return simpleType;
            }
            case 3: {
                return aST.newSimpleType(aST.newSimpleName(Signature.toString(string)));
            }
            case 5: {
                WildcardType wildcardType = aST.newWildcardType();
                char c = string.charAt(0);
                if (c != '*') {
                    Type type = this.addImportFromSignature(string.substring(1), aST, importRewriteContext);
                    wildcardType.setBound(type, c == '+');
                }
                return wildcardType;
            }
            case 6: {
                return this.addImportFromSignature(string.substring(1), aST, importRewriteContext);
            }
        }
        throw new IllegalArgumentException("Unknown type signature kind: " + string);
    }

    public String addImport(ITypeBinding iTypeBinding) {
        return this.addImport(iTypeBinding, this.defaultContext);
    }

    public String addImport(ITypeBinding iTypeBinding, ImportRewriteContext importRewriteContext) {
        if (iTypeBinding.isPrimitive() || iTypeBinding.isTypeVariable()) {
            return iTypeBinding.getName();
        }
        ITypeBinding iTypeBinding2 = ImportRewrite.normalizeTypeBinding(iTypeBinding);
        if (iTypeBinding2 == null) {
            return "invalid";
        }
        if (iTypeBinding2.isWildcardType()) {
            StringBuffer stringBuffer = new StringBuffer("?");
            ITypeBinding iTypeBinding3 = iTypeBinding2.getBound();
            if (iTypeBinding3 != null && !iTypeBinding3.isWildcardType() && !iTypeBinding3.isCapture()) {
                if (iTypeBinding2.isUpperbound()) {
                    stringBuffer.append(" extends ");
                } else {
                    stringBuffer.append(" super ");
                }
                stringBuffer.append(this.addImport(iTypeBinding3, importRewriteContext));
            }
            return stringBuffer.toString();
        }
        if (iTypeBinding2.isArray()) {
            StringBuffer stringBuffer = new StringBuffer(this.addImport(iTypeBinding2.getElementType(), importRewriteContext));
            int n = iTypeBinding2.getDimensions();
            while (n > 0) {
                stringBuffer.append("[]");
                --n;
            }
            return stringBuffer.toString();
        }
        String string = ImportRewrite.getRawQualifiedName(iTypeBinding2);
        if (string.length() > 0) {
            String string2 = this.internalAddImport(string, importRewriteContext);
            ITypeBinding[] iTypeBindingArray = iTypeBinding2.getTypeArguments();
            if (iTypeBindingArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append('<');
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    ITypeBinding iTypeBinding4;
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    if (this.containsNestedCapture(iTypeBinding4 = iTypeBindingArray[n], false)) {
                        stringBuffer.append('?');
                    } else {
                        stringBuffer.append(this.addImport(iTypeBinding4, importRewriteContext));
                    }
                    ++n;
                }
                stringBuffer.append('>');
                return stringBuffer.toString();
            }
            return string2;
        }
        return ImportRewrite.getRawName(iTypeBinding2);
    }

    private boolean containsNestedCapture(ITypeBinding iTypeBinding, boolean bl) {
        if (iTypeBinding == null || iTypeBinding.isPrimitive() || iTypeBinding.isTypeVariable()) {
            return false;
        }
        if (iTypeBinding.isCapture()) {
            if (bl) {
                return true;
            }
            return this.containsNestedCapture(iTypeBinding.getWildcard(), true);
        }
        if (iTypeBinding.isWildcardType()) {
            return this.containsNestedCapture(iTypeBinding.getBound(), true);
        }
        if (iTypeBinding.isArray()) {
            return this.containsNestedCapture(iTypeBinding.getElementType(), true);
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (this.containsNestedCapture(iTypeBindingArray[n], true)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean containsNestedCapture(String string) {
        return string.length() > 1 && string.indexOf(33, 1) != -1;
    }

    private static ITypeBinding normalizeTypeBinding(ITypeBinding iTypeBinding) {
        if (iTypeBinding != null && !iTypeBinding.isNullType() && !"void".equals(iTypeBinding.getName())) {
            if (iTypeBinding.isAnonymous()) {
                ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
                if (iTypeBindingArray.length > 0) {
                    return iTypeBindingArray[0];
                }
                return iTypeBinding.getSuperclass();
            }
            if (iTypeBinding.isCapture()) {
                return iTypeBinding.getWildcard();
            }
            return iTypeBinding;
        }
        return null;
    }

    public Type addImport(ITypeBinding iTypeBinding, AST aST) {
        return this.addImport(iTypeBinding, aST, this.defaultContext);
    }

    public Type addImport(ITypeBinding iTypeBinding, AST aST, ImportRewriteContext importRewriteContext) {
        if (iTypeBinding.isPrimitive() || iTypeBinding.isRecovered()) {
            return aST.newPrimitiveType(PrimitiveType.toCode(iTypeBinding.getName()));
        }
        ITypeBinding iTypeBinding2 = ImportRewrite.normalizeTypeBinding(iTypeBinding);
        if (iTypeBinding2 == null) {
            return aST.newSimpleType(aST.newSimpleName("invalid"));
        }
        if (iTypeBinding2.isTypeVariable()) {
            return aST.newSimpleType(aST.newSimpleName(iTypeBinding.getName()));
        }
        if (iTypeBinding2.isWildcardType()) {
            WildcardType wildcardType = aST.newWildcardType();
            ITypeBinding iTypeBinding3 = iTypeBinding2.getBound();
            if (iTypeBinding3 != null && !iTypeBinding3.isWildcardType() && !iTypeBinding3.isCapture()) {
                Type type = this.addImport(iTypeBinding3, aST, importRewriteContext);
                wildcardType.setBound(type, iTypeBinding2.isUpperbound());
            }
            return wildcardType;
        }
        if (iTypeBinding2.isArray()) {
            Type type = this.addImport(iTypeBinding2.getElementType(), aST, importRewriteContext);
            return aST.newArrayType(type, iTypeBinding2.getDimensions());
        }
        String string = ImportRewrite.getRawQualifiedName(iTypeBinding2);
        if (string.length() > 0) {
            String string2 = this.internalAddImport(string, importRewriteContext);
            ITypeBinding[] iTypeBindingArray = iTypeBinding2.getTypeArguments();
            if (iTypeBindingArray.length > 0) {
                SimpleType simpleType = aST.newSimpleType(aST.newName(string2));
                ParameterizedType parameterizedType = aST.newParameterizedType(simpleType);
                List list = parameterizedType.typeArguments();
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    ITypeBinding iTypeBinding4 = iTypeBindingArray[n];
                    if (this.containsNestedCapture(iTypeBinding4, false)) {
                        list.add(aST.newWildcardType());
                    } else {
                        list.add(this.addImport(iTypeBinding4, aST, importRewriteContext));
                    }
                    ++n;
                }
                return parameterizedType;
            }
            return aST.newSimpleType(aST.newName(string2));
        }
        return aST.newSimpleType(aST.newName(ImportRewrite.getRawName(iTypeBinding2)));
    }

    public String addImport(String string, ImportRewriteContext importRewriteContext) {
        int n = string.indexOf(60);
        if (n != -1) {
            return String.valueOf(this.internalAddImport(string.substring(0, n), importRewriteContext)) + string.substring(n);
        }
        int n2 = string.indexOf(91);
        if (n2 != -1) {
            return String.valueOf(this.internalAddImport(string.substring(0, n2), importRewriteContext)) + string.substring(n2);
        }
        return this.internalAddImport(string, importRewriteContext);
    }

    public String addImport(String string) {
        return this.addImport(string, this.defaultContext);
    }

    public String addStaticImport(IBinding iBinding) {
        return this.addStaticImport(iBinding, this.defaultContext);
    }

    public String addStaticImport(IBinding iBinding, ImportRewriteContext importRewriteContext) {
        if (Modifier.isStatic(iBinding.getModifiers())) {
            if (iBinding instanceof IVariableBinding) {
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                if (iVariableBinding.isField()) {
                    ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
                    return this.addStaticImport(ImportRewrite.getRawQualifiedName(iTypeBinding), iBinding.getName(), true, importRewriteContext);
                }
            } else if (iBinding instanceof IMethodBinding) {
                ITypeBinding iTypeBinding = ((IMethodBinding)iBinding).getDeclaringClass();
                return this.addStaticImport(ImportRewrite.getRawQualifiedName(iTypeBinding), iBinding.getName(), false, importRewriteContext);
            }
        }
        throw new IllegalArgumentException("Binding must be a static field or method.");
    }

    public String addStaticImport(String string, String string2, boolean bl) {
        return this.addStaticImport(string, string2, bl, this.defaultContext);
    }

    public String addStaticImport(String string, String string2, boolean bl, ImportRewriteContext importRewriteContext) {
        int n;
        int n2;
        if (string.indexOf(46) == -1) {
            return String.valueOf(string) + '.' + string2;
        }
        if (importRewriteContext == null) {
            importRewriteContext = this.defaultContext;
        }
        if ((n2 = importRewriteContext.findInContext(string, string2, n = bl ? 2 : 3)) == 3) {
            return String.valueOf(string) + '.' + string2;
        }
        if (n2 == 2) {
            this.addEntry(String.valueOf('s') + string + '.' + string2);
        }
        return string2;
    }

    private String internalAddImport(String string, ImportRewriteContext importRewriteContext) {
        int n;
        String string2;
        String string3;
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        if (string3.length() == 0 && PrimitiveType.toCode(string2) != null) {
            return string;
        }
        if (importRewriteContext == null) {
            importRewriteContext = this.defaultContext;
        }
        if ((n = importRewriteContext.findInContext(string3, string2, 1)) == 3) {
            return string;
        }
        if (n == 2) {
            this.addEntry(String.valueOf('n') + string);
        }
        return string2;
    }

    private void addEntry(String string) {
        this.existingImports.add(string);
        if (this.removedImports != null && this.removedImports.remove(string)) {
            return;
        }
        if (this.addedImports == null) {
            this.addedImports = new ArrayList();
        }
        this.addedImports.add(string);
    }

    private boolean removeEntry(String string) {
        if (this.existingImports.remove(string)) {
            if (this.addedImports != null && this.addedImports.remove(string)) {
                return true;
            }
            if (this.removedImports == null) {
                this.removedImports = new ArrayList();
            }
            this.removedImports.add(string);
            return true;
        }
        return false;
    }

    public boolean removeImport(String string) {
        return this.removeEntry(String.valueOf('n') + string);
    }

    public boolean removeStaticImport(String string) {
        return this.removeEntry(String.valueOf('s') + string);
    }

    private static String getRawName(ITypeBinding iTypeBinding) {
        return iTypeBinding.getTypeDeclaration().getName();
    }

    private static String getRawQualifiedName(ITypeBinding iTypeBinding) {
        return iTypeBinding.getTypeDeclaration().getQualifiedName();
    }

    public final TextEdit rewriteImports(IProgressMonitor iProgressMonitor) throws CoreException {
        MultiTextEdit multiTextEdit;
        block9: {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(Messages.bind(Messages.importRewrite_processDescription), 2);
            if (this.hasRecordedChanges()) break block9;
            this.createdImports = CharOperation.NO_STRINGS;
            this.createdStaticImports = CharOperation.NO_STRINGS;
            MultiTextEdit multiTextEdit2 = new MultiTextEdit();
            Object var6_4 = null;
            iProgressMonitor.done();
            return multiTextEdit2;
        }
        try {
            String string;
            int n;
            Object object;
            CompilationUnit compilationUnit = this.astRoot;
            if (compilationUnit == null) {
                object = ASTParser.newParser(3);
                ((ASTParser)object).setSource(this.compilationUnit);
                ((ASTParser)object).setFocalPosition(0);
                ((ASTParser)object).setResolveBindings(false);
                compilationUnit = (CompilationUnit)((ASTParser)object).createAST((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            object = new ImportRewriteAnalyzer(this.compilationUnit, compilationUnit, this.importOrder, this.importOnDemandThreshold, this.staticImportOnDemandThreshold, this.restoreExistingImports);
            ((ImportRewriteAnalyzer)object).setFilterImplicitImports(this.filterImplicitImports);
            if (this.addedImports != null) {
                n = 0;
                while (n < this.addedImports.size()) {
                    string = (String)this.addedImports.get(n);
                    ((ImportRewriteAnalyzer)object).addImport(string.substring(1), 's' == string.charAt(0));
                    ++n;
                }
            }
            if (this.removedImports != null) {
                n = 0;
                while (n < this.removedImports.size()) {
                    string = (String)this.removedImports.get(n);
                    ((ImportRewriteAnalyzer)object).removeImport(string.substring(1), 's' == string.charAt(0));
                    ++n;
                }
            }
            MultiTextEdit multiTextEdit3 = ((ImportRewriteAnalyzer)object).getResultingEdits((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.createdImports = ((ImportRewriteAnalyzer)object).getCreatedImports();
            this.createdStaticImports = ((ImportRewriteAnalyzer)object).getCreatedStaticImports();
            multiTextEdit = multiTextEdit3;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return multiTextEdit;
    }

    public String[] getCreatedImports() {
        return this.createdImports;
    }

    public String[] getCreatedStaticImports() {
        return this.createdStaticImports;
    }

    public String[] getAddedImports() {
        return ImportRewrite.filterFromList(this.addedImports, 'n');
    }

    public String[] getAddedStaticImports() {
        return ImportRewrite.filterFromList(this.addedImports, 's');
    }

    public String[] getRemovedImports() {
        return ImportRewrite.filterFromList(this.removedImports, 'n');
    }

    public String[] getRemovedStaticImports() {
        return ImportRewrite.filterFromList(this.removedImports, 's');
    }

    public boolean hasRecordedChanges() {
        if (!this.writeImports) {
            return false;
        }
        return !this.restoreExistingImports || this.addedImports != null && !this.addedImports.isEmpty() || this.removedImports != null && !this.removedImports.isEmpty();
    }

    private static String[] filterFromList(List list, char c) {
        if (list == null) {
            return CharOperation.NO_STRINGS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list.size()) {
            String string = (String)list.get(n);
            if (c == string.charAt(0)) {
                arrayList.add(string.substring(1));
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static abstract class ImportRewriteContext {
        public static final int RES_NAME_FOUND = 1;
        public static final int RES_NAME_UNKNOWN = 2;
        public static final int RES_NAME_CONFLICT = 3;
        public static final int KIND_TYPE = 1;
        public static final int KIND_STATIC_FIELD = 2;
        public static final int KIND_STATIC_METHOD = 3;

        public abstract int findInContext(String var1, String var2, int var3);
    }
}

