/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public final class IndentManipulation {
    private IndentManipulation() {
    }

    public static boolean isIndentChar(char c) {
        return ScannerHelper.isWhitespace(c) && !IndentManipulation.isLineDelimiterChar(c);
    }

    public static boolean isLineDelimiterChar(char c) {
        return c == '\n' || c == '\r';
    }

    public static int measureIndentUnits(CharSequence charSequence, int n, int n2) {
        if (n2 <= 0 || n < 0 || charSequence == null) {
            throw new IllegalArgumentException();
        }
        int n3 = IndentManipulation.measureIndentInSpaces(charSequence, n);
        return n3 / n2;
    }

    public static int measureIndentInSpaces(CharSequence charSequence, int n) {
        if (n < 0 || charSequence == null) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        int n3 = charSequence.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = charSequence.charAt(n4);
            if (c == '\t') {
                int n5 = n2 % n;
                n2 += n - n5;
            } else if (IndentManipulation.isIndentChar(c)) {
                ++n2;
            } else {
                return n2;
            }
            ++n4;
        }
        return n2;
    }

    public static String extractIndentString(String string, int n, int n2) {
        if (n < 0 || n2 <= 0 || string == null) {
            throw new IllegalArgumentException();
        }
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            char c = string.charAt(n7);
            if (c == '\t') {
                int n8 = n5 % n;
                n5 += n - n8;
                ++n6;
            } else {
                if (!IndentManipulation.isIndentChar(c)) break;
                ++n5;
                ++n6;
            }
            if (n5 >= n2) {
                n4 += n6;
                n6 = 0;
                n5 %= n2;
            }
            ++n7;
        }
        if (n4 == 0) {
            return Util.EMPTY_STRING;
        }
        if (n4 == n3) {
            return string;
        }
        return string.substring(0, n4);
    }

    public static String trimIndent(String string, int n, int n2, int n3) {
        if (n2 < 0 || n3 <= 0 || string == null) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return string;
        }
        int n4 = n * n3;
        int n5 = 0;
        int n6 = 0;
        int n7 = string.length();
        String string2 = null;
        int n8 = 0;
        while (n8 < n7) {
            char c = string.charAt(n8);
            if (c == '\t') {
                int n9 = n6 % n2;
                n6 += n2 - n9;
            } else if (IndentManipulation.isIndentChar(c)) {
                ++n6;
            } else {
                n5 = n8;
                break;
            }
            if (n6 == n4) {
                n5 = n8 + 1;
                break;
            }
            if (n6 > n4) {
                n5 = n8 + 1;
                char[] cArray = new char[n6 - n4];
                Arrays.fill(cArray, ' ');
                string2 = new String(cArray);
                break;
            }
            ++n8;
        }
        String string3 = n5 == n7 ? Util.EMPTY_STRING : string.substring(n5);
        if (string2 == null) {
            return string3;
        }
        return String.valueOf(string2) + string3;
    }

    public static String changeIndent(String string, int n, int n2, int n3, String string2, String string3) {
        if (n2 < 0 || n3 <= 0 || string == null || n < 0 || string2 == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n4 = defaultLineTracker.getNumberOfLines();
            if (n4 == 1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < n4) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n5);
                int n6 = iRegion.getOffset();
                int n7 = n6 + iRegion.getLength();
                String string4 = string.substring(n6, n7);
                if (n5 == 0) {
                    stringBuffer.append(string4);
                } else {
                    stringBuffer.append(string3);
                    stringBuffer.append(string2);
                    stringBuffer.append(IndentManipulation.trimIndent(string4, n, n2, n3));
                }
                ++n5;
            }
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            return string;
        }
    }

    public static ReplaceEdit[] getChangeIndentEdits(String string, int n, int n2, int n3, String string2) {
        if (n2 < 0 || n3 <= 0 || string == null || n < 0 || string2 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ReplaceEdit> arrayList = new ArrayList<ReplaceEdit>();
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n4 = defaultLineTracker.getNumberOfLines();
            if (n4 == 1) {
                return arrayList.toArray(new ReplaceEdit[arrayList.size()]);
            }
            int n5 = 1;
            while (n5 < n4) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n5);
                int n6 = iRegion.getOffset();
                String string3 = string.substring(n6, n6 + iRegion.getLength());
                int n7 = IndentManipulation.indexOfIndent(string3, n, n2, n3);
                if (n7 >= 0) {
                    arrayList.add(new ReplaceEdit(n6, n7, string2));
                } else {
                    n7 = IndentManipulation.measureIndentUnits(string3, n2, n3);
                    arrayList.add(new ReplaceEdit(n6, n7, ""));
                }
                ++n5;
            }
        }
        catch (BadLocationException badLocationException) {}
        return arrayList.toArray(new ReplaceEdit[arrayList.size()]);
    }

    private static int indexOfIndent(CharSequence charSequence, int n, int n2, int n3) {
        int n4 = n * n3;
        int n5 = charSequence.length();
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5 && n7 < n4) {
            char c = charSequence.charAt(n8);
            if (c == '\t') {
                int n9 = n7 % n2;
                n7 += n2 - n9;
            } else {
                if (!IndentManipulation.isIndentChar(c)) break;
                ++n7;
            }
            n6 = n8++;
        }
        if (n7 < n4) {
            return -1;
        }
        return n6 + 1;
    }

    public static int getTabWidth(Map map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        return IndentManipulation.getIntValue(map, "org.eclipse.wst.jsdt.core.formatter.tabulation.size", 4);
    }

    public static int getIndentWidth(Map map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        int n = IndentManipulation.getTabWidth(map);
        boolean bl = "mixed".equals(map.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char"));
        if (bl) {
            return IndentManipulation.getIntValue(map, "org.eclipse.wst.jsdt.core.formatter.indentation.size", n);
        }
        return n;
    }

    private static int getIntValue(Map map, String string, int n) {
        try {
            return Integer.parseInt((String)map.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }
}

