/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler;

import java.util.Arrays;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;

public class ClassFilePool {
    public static final int POOL_SIZE = 7;
    ClassFile[] classFiles = new ClassFile[7];

    private ClassFilePool() {
    }

    public static ClassFilePool newInstance() {
        return new ClassFilePool();
    }

    public void release(ClassFile classFile) {
        int n = 0;
        while (n < 7) {
            ClassFile classFile2 = this.classFiles[n];
            if (classFile2 == classFile) {
                classFile.isShared = false;
                return;
            }
            ++n;
        }
    }

    public ClassFile acquire(SourceTypeBinding sourceTypeBinding) {
        int n = 0;
        while (n < 7) {
            ClassFile classFile = this.classFiles[n];
            if (classFile == null) {
                ClassFile classFile2;
                this.classFiles[n] = classFile2 = new ClassFile(sourceTypeBinding);
                classFile2.isShared = true;
                return classFile2;
            }
            if (!classFile.isShared) {
                classFile.reset(sourceTypeBinding);
                classFile.isShared = true;
                return classFile;
            }
            ++n;
        }
        return new ClassFile(sourceTypeBinding);
    }

    public void reset() {
        Arrays.fill(this.classFiles, null);
    }
}

