/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.impl.IntConstant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public Expression constantExpression;
    public CaseLabel targetLabel;
    public boolean isEnumConstant;

    public CaseStatement(Expression expression, int n, int n2) {
        this.constantExpression = expression;
        this.sourceEnd = n;
        this.sourceStart = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression != null) {
            if (!this.isEnumConstant && this.constantExpression.constant == Constant.NotAConstant) {
                blockScope.problemReporter().caseExpressionMustBeConstant(this.constantExpression);
            }
            this.constantExpression.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        CaseStatement.printIndent(n, stringBuffer);
        if (this.constantExpression == null) {
            stringBuffer.append("default : ");
        } else {
            stringBuffer.append("case ");
            this.constantExpression.printExpression(0, stringBuffer).append(" : ");
        }
        return stringBuffer.append(';');
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        this.targetLabel.place();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void resolve(BlockScope blockScope) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        TypeBinding typeBinding2;
        blockScope.enclosingCase = this;
        if (this.constantExpression == null) {
            if (switchStatement.defaultCase != null) {
                blockScope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return Constant.NotAConstant;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (typeBinding != null && typeBinding.isEnum() && this.constantExpression instanceof SingleNameReference) {
            ((SingleNameReference)this.constantExpression).setActualReceiverType((ReferenceBinding)typeBinding);
        }
        if ((typeBinding2 = this.constantExpression.resolveType(blockScope)) == null || typeBinding == null) {
            return Constant.NotAConstant;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding)) {
            if (!typeBinding2.isEnum()) return this.constantExpression.constant;
            this.isEnumConstant = true;
            if ((this.constantExpression.bits & 0x1FE00000) >> 21 != 0) {
                blockScope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(this.constantExpression);
            }
            if (this.constantExpression instanceof NameReference && (this.constantExpression.bits & 0xF) == 1) {
                NameReference nameReference = (NameReference)this.constantExpression;
                FieldBinding fieldBinding = nameReference.fieldBinding();
                if ((fieldBinding.modifiers & 0x4000) == 0) {
                    blockScope.problemReporter().enumSwitchCannotTargetField(nameReference, fieldBinding);
                    return IntConstant.fromValue(fieldBinding.original().id + 1);
                } else {
                    if (!(nameReference instanceof QualifiedNameReference)) return IntConstant.fromValue(fieldBinding.original().id + 1);
                    blockScope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(nameReference, fieldBinding);
                }
                return IntConstant.fromValue(fieldBinding.original().id + 1);
            }
        } else if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding) || typeBinding2.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding.isBaseType() && this.constantExpression.isConstantValueOfTypeAssignableToType(typeBinding2, blockScope.environment().computeBoxingType(typeBinding))) {
            return this.constantExpression.constant;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.constantExpression);
        return Constant.NotAConstant;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.constantExpression != null) {
            this.constantExpression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

