/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorIds;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class CompoundAssignment
extends Assignment
implements OperatorIds {
    public int operator;
    public int preAssignImplicitConversion;

    public CompoundAssignment(Expression expression, Expression expression2, int n, int n2) {
        super(expression, expression2, n2);
        expression.bits &= 0xFFFFDFFF;
        expression.bits |= 0x10000;
        this.operator = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.resolvedType.id != 11) {
            this.lhs.checkNPE(blockScope, flowContext, flowInfo);
        }
        return ((Reference)this.lhs).analyseAssignment(blockScope, flowContext, flowInfo, this, true).unconditionalInits();
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ((Reference)this.lhs).generateCompoundAssignment(blockScope, codeStream, this.expression, this.operator, this.preAssignImplicitConversion, bl);
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    public String operatorToString() {
        switch (this.operator) {
            case 14: {
                return "+=";
            }
            case 13: {
                return "-=";
            }
            case 15: {
                return "*=";
            }
            case 9: {
                return "/=";
            }
            case 2: {
                return "&=";
            }
            case 3: {
                return "|=";
            }
            case 8: {
                return "^=";
            }
            case 16: {
                return "%=";
            }
            case 10: {
                return "<<=";
            }
            case 17: {
                return ">>=";
            }
            case 19: {
                return ">>>=";
            }
        }
        return "unknown operator";
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.lhs.printExpression(n, stringBuffer).append(' ').append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        this.constant = Constant.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            blockScope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding typeBinding = this.lhs.resolveType(blockScope);
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            this.resolvedType = TypeBinding.ANY;
            return null;
        }
        LookupEnvironment lookupEnvironment = blockScope.environment();
        TypeBinding typeBinding3 = typeBinding;
        TypeBinding typeBinding4 = typeBinding2;
        boolean bl = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        boolean bl2 = false;
        if (bl) {
            TypeBinding typeBinding5;
            if (!typeBinding3.isBaseType() && typeBinding4.id != 11 && typeBinding4.id != 12 && (typeBinding5 = lookupEnvironment.computeBoxingType(typeBinding3)) != typeBinding3) {
                typeBinding3 = typeBinding5;
                bl2 = true;
            }
            if (!typeBinding4.isBaseType() && typeBinding3.id != 11 && typeBinding3.id != 12) {
                typeBinding4 = lookupEnvironment.computeBoxingType(typeBinding4);
            }
        }
        if (this.restrainUsageToNumericTypes() && !typeBinding3.isNumericType() && !typeBinding3.isAnyType()) {
            blockScope.problemReporter().operatorOnlyValidOnNumericType(this, typeBinding3, typeBinding4);
            return null;
        }
        int n2 = typeBinding3.id;
        int n3 = typeBinding4.id;
        if (n2 > 15 || n3 > 15) {
            if (n2 != 11) {
                blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
                return null;
            }
            n3 = 1;
        }
        if ((n = OperatorExpression.OperatorSignatures[this.operator][(n2 << 4) + n3]) == 0) {
            blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
            return null;
        }
        if (this.operator == 14) {
            if (n2 == 1) {
                blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
                return null;
            }
            if ((typeBinding3.isNumericType() || n2 == 5) && !typeBinding4.isNumericType()) {
                blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
                return null;
            }
        }
        this.lhs.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n >>> 16 & 0xF), typeBinding);
        this.expression.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n >>> 8 & 0xF), typeBinding2);
        this.preAssignImplicitConversion = (bl2 ? 512 : 0) | n2 << 4 | n & 0xF;
        if (bl2) {
            blockScope.problemReporter().autoboxing(this, typeBinding3, typeBinding);
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public boolean restrainUsageToNumericTypes() {
        return false;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

