/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.IntLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class FieldReference
extends Reference
implements InvocationSite {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    protected FieldBinding codegenBinding;
    public MethodBinding[] syntheticAccessors;
    public long nameSourcePosition;
    public TypeBinding receiverType;
    public TypeBinding genericCast;

    public FieldReference(char[] cArray, long l) {
        this.token = cArray;
        this.nameSourcePosition = l;
        this.sourceStart = (int)(l >>> 32);
        this.sourceEnd = (int)(l & 0xFFFFFFFFL);
        this.bits |= 1;
    }

    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl) {
        if (bl) {
            if (this.binding.isBlankFinal() && this.receiver.isThis() && blockScope.allowBlankFinalFieldAssignment(this.binding) && !flowInfo.isDefinitelyAssigned(this.binding)) {
                blockScope.problemReporter().uninitializedBlankFinalField(this.binding, this);
            }
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, true);
        }
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, this.binding == null || !this.binding.isStatic()).unconditionalInits();
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, false);
        if (this.binding.isFinal()) {
            if (this.binding.isBlankFinal() && !bl && this.receiver.isThis() && !(this.receiver instanceof QualifiedThisReference) && (this.receiver.bits & 0x1FE00000) == 0 && blockScope.allowBlankFinalFieldAssignment(this.binding)) {
                if (flowInfo.isPotentiallyAssigned(this.binding)) {
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField(this.binding, this);
                } else {
                    flowContext.recordSettingFinal(this.binding, this, flowInfo);
                }
                flowInfo.markAsDefinitelyAssigned(this.binding);
            } else {
                blockScope.problemReporter().cannotAssignToFinalField(this.binding, this);
            }
        }
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(blockScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, boolean bl) {
        boolean bl2 = this.binding == null || !this.binding.isStatic();
        this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl2);
        if (bl2) {
            this.receiver.checkNPE(blockScope, flowContext, flowInfo);
        }
        if (bl || blockScope.compilerOptions().complianceLevel >= 0x300000L) {
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, true);
        }
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            FieldBinding fieldBinding = this.binding.original();
            TypeBinding typeBinding3 = fieldBinding.type;
            if (fieldBinding != this.binding && typeBinding3 != this.binding.type && typeBinding.id != 1 && (typeBinding3.tagBits & 0x20000000L) != 0L) {
                TypeBinding typeBinding4 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                this.genericCast = fieldBinding.type.genericCast(typeBinding4);
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public void generateAssignment(BlockScope blockScope, CodeStream codeStream, Assignment assignment, boolean bl) {
        int n = codeStream.position;
        this.receiver.generateCode(blockScope, codeStream, !this.codegenBinding.isStatic());
        codeStream.recordPositionsFrom(n, this.sourceStart);
        assignment.expression.generateCode(blockScope, codeStream, true);
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], bl);
        if (bl) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        boolean bl2 = this.codegenBinding.isStatic();
        boolean bl3 = this.receiver instanceof ThisReference;
        Constant constant = this.codegenBinding.constant();
        if (constant != Constant.NotAConstant) {
            if (!bl3) {
                this.receiver.generateCode(blockScope, codeStream, !bl2);
                if (!bl2) {
                    codeStream.invokeObjectGetClass();
                    codeStream.pop();
                }
            }
            if (bl) {
                codeStream.generateConstant(constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        if (bl || !bl3 && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
            this.receiver.generateCode(blockScope, codeStream, !bl2);
            if (this.codegenBinding.declaringClass == null) {
                codeStream.arraylength();
                if (bl) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    codeStream.pop();
                }
            } else {
                if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                    if (bl2) {
                        codeStream.getstatic(this.codegenBinding);
                    } else {
                        codeStream.getfield(this.codegenBinding);
                    }
                } else {
                    codeStream.invokestatic(this.syntheticAccessors[0]);
                }
                if (bl) {
                    if (this.genericCast != null) {
                        codeStream.checkcast(this.genericCast);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    switch (this.codegenBinding.type.id) {
                        case 7: 
                        case 8: {
                            codeStream.pop2();
                            break;
                        }
                        default: {
                            codeStream.pop();
                            break;
                        }
                    }
                }
            }
        } else if (bl3) {
            if (bl2 && this.binding.original().declaringClass != this.receiverType.erasure()) {
                MethodBinding methodBinding;
                MethodBinding methodBinding2 = methodBinding = this.syntheticAccessors == null ? null : this.syntheticAccessors[0];
                if (methodBinding == null) {
                    codeStream.getstatic(this.codegenBinding);
                } else {
                    codeStream.invokestatic(methodBinding);
                }
                switch (this.codegenBinding.type.id) {
                    case 7: 
                    case 8: {
                        codeStream.pop2();
                        break;
                    }
                    default: {
                        codeStream.pop();
                        break;
                    }
                }
            }
        } else {
            this.receiver.generateCode(blockScope, codeStream, !bl2);
            if (!bl2) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope blockScope, CodeStream codeStream, Expression expression, int n, int n2, boolean bl) {
        boolean bl2 = this.codegenBinding.isStatic();
        this.receiver.generateCode(blockScope, codeStream, !bl2);
        if (bl2) {
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        } else {
            codeStream.dup();
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getfield(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        }
        int n3 = (this.implicitConversion & 0xFF) >> 4;
        switch (n3) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(blockScope, null, expression);
                break;
            }
            default: {
                if (this.genericCast != null) {
                    codeStream.checkcast(this.genericCast);
                }
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(blockScope, codeStream, true);
                }
                codeStream.sendOperator(n, n3);
                codeStream.generateImplicitConversion(n2);
            }
        }
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], bl);
    }

    public void generatePostIncrement(BlockScope blockScope, CodeStream codeStream, CompoundAssignment compoundAssignment, boolean bl) {
        boolean bl2 = this.codegenBinding.isStatic();
        this.receiver.generateCode(blockScope, codeStream, !bl2);
        if (bl2) {
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        } else {
            codeStream.dup();
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getfield(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        }
        if (bl) {
            if (bl2) {
                if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                    codeStream.dup2();
                } else {
                    codeStream.dup();
                }
            } else if (this.codegenBinding.type == TypeBinding.LONG || this.codegenBinding.type == TypeBinding.DOUBLE) {
                codeStream.dup2_x1();
            } else {
                codeStream.dup_x1();
            }
        }
        if (this.genericCast != null) {
            codeStream.checkcast(this.genericCast);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.generateConstant(compoundAssignment.expression.constant, this.implicitConversion);
        codeStream.sendOperator(compoundAssignment.operator, this.implicitConversion & 0xF);
        codeStream.generateImplicitConversion(compoundAssignment.preAssignImplicitConversion);
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], false);
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo, boolean bl) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public Constant optimizedBooleanConstant() {
        switch (this.resolvedType.id) {
            case 5: 
            case 33: {
                return this.constant != Constant.NotAConstant ? this.constant : this.binding.constant();
            }
        }
        return Constant.NotAConstant;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        if (this.genericCast != null) {
            typeBinding = this.genericCast;
        }
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.receiver.printExpression(0, stringBuffer).append('.').append(this.token);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, false, null);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl, TypeBinding typeBinding) {
        if (this.isPrototype()) {
            char[] cArray = Util.getTypeName(this.receiver);
            TypeBinding typeBinding2 = blockScope.getJavaLangObject();
            if (cArray != null) {
                Binding binding = blockScope.getBinding(cArray, 4, (InvocationSite)this, true);
                if (binding.isValidBinding()) {
                    typeBinding2 = (TypeBinding)binding;
                }
                char[] cArray2 = new char[]{'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e'};
                this.binding = blockScope.getJavaLangObject().getField(cArray2, true);
            }
            this.resolvedType = typeBinding2;
            return this.resolvedType;
        }
        this.receiverType = this.receiver.resolveType(blockScope);
        if (this.receiverType == null) {
            this.binding = new ProblemFieldBinding(null, this.token, 1);
            this.constant = Constant.NotAConstant;
            this.resolvedType = TypeBinding.ANY;
            return null;
        }
        Binding binding = blockScope.getFieldOrMethod(this.receiverType, this.token, this);
        if (binding instanceof FieldBinding) {
            boolean bl2;
            this.codegenBinding = this.binding = (FieldBinding)binding;
            FieldBinding fieldBinding = this.binding;
            if (!fieldBinding.isValidBinding()) {
                this.binding = fieldBinding;
                this.resolvedType = TypeBinding.ANY;
                if (!bl) {
                    this.constant = Constant.NotAConstant;
                    blockScope.problemReporter().invalidField(this, this.receiverType);
                    return null;
                }
            }
            this.receiver.computeConversion(blockScope, this.receiverType, this.receiverType);
            if (this.isFieldUseDeprecated(fieldBinding, blockScope, (this.bits & 0x2000) != 0)) {
                blockScope.problemReporter().deprecatedField(fieldBinding, this);
            }
            Constant constant = this.constant = (bl2 = this.receiver.isImplicitThis()) ? fieldBinding.constant() : Constant.NotAConstant;
            if (fieldBinding.isStatic()) {
                if (!(bl2 || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
                    blockScope.problemReporter().nonStaticAccessToStaticField(this, fieldBinding);
                }
                if (!bl2 && fieldBinding.declaringClass != this.receiverType && fieldBinding.declaringClass.canBeSeenBy(blockScope)) {
                    blockScope.problemReporter().indirectAccessToStaticField(this, fieldBinding);
                }
            }
            this.resolvedType = (this.bits & 0x2000) == 0 ? fieldBinding.type.capture(blockScope, this.sourceEnd) : fieldBinding.type;
            return this.resolvedType;
        }
        if (binding instanceof MethodBinding) {
            this.resolvedType = blockScope.getJavaLangFunction();
            this.binding = new ProblemFieldBinding(null, this.token, 1);
            if (binding.isValidBinding()) {
                return this.resolvedType;
            }
            return null;
        }
        return null;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.receiver.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public boolean isPrototype() {
        return CharOperation.equals(TypeConstants.PROTOTYPE, this.token);
    }
}

