/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.declarationEnd = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        int n = this.initialization.nullStatus(flowInfo);
        this.bits = !(flowInfo = this.initialization.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).isDefinitelyAssigned(this.binding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
        flowInfo.markAsDefinitelyAssigned(this.binding);
        switch (n) {
            case 1: {
                flowInfo.markAsDefinitelyNull(this.binding);
                break;
            }
            case -1: {
                flowInfo.markAsDefinitelyNonNull(this.binding);
                break;
            }
            default: {
                flowInfo.markAsDefinitelyUnknown(this.binding);
            }
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.binding.resolvedPosition != -1) {
            codeStream.addVisibleLocalVariable(this.binding);
        }
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.initialization != null) {
            if (this.binding.resolvedPosition < 0) {
                if (this.initialization.constant == Constant.NotAConstant) {
                    this.initialization.generateCode(blockScope, codeStream, false);
                }
            } else {
                this.initialization.generateCode(blockScope, codeStream, true);
                if (this.binding.type.isArrayType() && (this.initialization.resolvedType == TypeBinding.NULL || this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == TypeBinding.NULL)) {
                    codeStream.checkcast(this.binding.type);
                }
                codeStream.store(this.binding, false);
                if ((this.bits & 8) != 0) {
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public int getKind() {
        return 4;
    }

    public TypeBinding resolveVarType(BlockScope blockScope) {
        TypeBinding typeBinding = null;
        typeBinding = this.type != null ? this.type.resolveType(blockScope, true) : (this.inferredType != null ? this.inferredType.resolveType(blockScope, this) : TypeBinding.UNKNOWN);
        this.checkModifiers();
        return typeBinding;
    }

    public void resolve(BlockScope blockScope) {
        Object object;
        TypeBinding typeBinding = this.resolveVarType(blockScope);
        if (typeBinding != null) {
            if (typeBinding == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        typeBinding = this.type != null ? this.type.resolveType(blockScope, true) : (this.inferredType != null ? this.inferredType.resolveType(blockScope, this) : TypeBinding.UNKNOWN);
        this.checkModifiers();
        if (typeBinding != null) {
            if (typeBinding == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
                blockScope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        Binding binding = null;
        binding = blockScope.enclosingMethodScope() == null ? blockScope.getBinding(this.name, 3, (InvocationSite)this, false) : blockScope.getLocalBinding(this.name, 3, this, false);
        boolean bl = false;
        if (binding != null && binding.isValidBinding()) {
            object = (VariableBinding)binding;
            if (((VariableBinding)object).isFor(this)) {
                ((VariableBinding)object).type = typeBinding;
                bl = true;
            } else if (object instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)object;
                if (localVariableBinding.declaringScope instanceof CompilationUnitScope && blockScope.enclosingMethodScope() != null) {
                    blockScope.problemReporter().localVariableHiding(this, (Binding)object, false);
                } else {
                    blockScope.problemReporter().redefineLocal(this);
                }
            } else {
                blockScope.problemReporter().localVariableHiding(this, (Binding)object, false);
            }
        }
        if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
            this.modifiers |= 0x4000000;
        }
        if (this.binding == null || !bl) {
            this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, false);
            object = blockScope.enclosingMethodScope();
            if (object != null) {
                ((BlockScope)object).addLocalVariable(this.binding);
            } else {
                blockScope.compilationUnitScope().addLocalVariable(this.binding);
            }
        }
        this.binding.setConstant(Constant.NotAConstant);
        if (typeBinding == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(blockScope);
            }
            return;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                object = this.initialization.resolveTypeExpecting(blockScope, typeBinding);
                if (object != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)object;
                    this.initialization.computeConversion(blockScope, typeBinding, (TypeBinding)object);
                }
            } else {
                this.initialization.setExpectedType(typeBinding);
                object = this.initialization.resolveType(blockScope);
                if (object != null) {
                    if (typeBinding == TypeBinding.UNKNOWN) {
                        this.binding.type = object;
                    } else if (!(this.initialization.isConstantValueOfTypeAssignableToType((TypeBinding)object, typeBinding) || typeBinding.isBaseType() || ((TypeBinding)object).isCompatibleWith(typeBinding))) {
                        blockScope.problemReporter().typeMismatchError((TypeBinding)object, typeBinding, this.initialization);
                    }
                }
            }
            if (this.binding == Assignment.getDirectBinding(this.initialization)) {
                blockScope.problemReporter().assignmentHasNoEffect(this, this.name);
            }
            this.binding.setConstant(this.binding.isFinal() ? this.initialization.constant.castTo((typeBinding.id << 4) + this.initialization.constant.typeID()) : Constant.NotAConstant);
        }
        if (this.javadoc != null) {
            if (blockScope.enclosingMethodScope() != null) {
                this.javadoc.resolve(blockScope.enclosingMethodScope());
            } else {
                this.javadoc.resolve(blockScope.compilationUnitScope());
            }
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        return super.printStatement(n, stringBuffer);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public String getTypeName() {
        if (this.type != null) {
            return this.type.toString();
        }
        if (this.inferredType != null) {
            return new String(this.inferredType.getName());
        }
        return null;
    }
}

