/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ObjectLiteral
extends Expression {
    public ObjectLiteralField[] fields;

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.fields == null || this.fields.length == 0) {
            stringBuffer.append("{}");
        } else {
            stringBuffer.append("{\n");
            ObjectLiteral.printIndent(n + 1, stringBuffer);
            int n2 = 0;
            while (n2 < this.fields.length) {
                if (n2 > 0) {
                    stringBuffer.append(",\n");
                    ObjectLiteral.printIndent(n + 1, stringBuffer);
                }
                this.fields[n2].printExpression(n, stringBuffer);
                ++n2;
            }
            stringBuffer.append("\n");
            ObjectLiteral.printIndent(n, stringBuffer);
            stringBuffer.append("}");
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.fields != null) {
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n].traverse(aSTVisitor, blockScope);
                ++n;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.fields != null) {
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n].resolveType(blockScope);
                ++n;
            }
        }
        return null;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.fields != null) {
            int n = 0;
            while (n < this.fields.length) {
                flowInfo = this.fields[n].analyseCode(blockScope, flowContext, flowInfo);
                ++n;
            }
        }
        return flowInfo;
    }
}

