/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.codegen;

public class FloatCache {
    private float[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public FloatCache() {
        this(13);
    }

    public FloatCache(int n) {
        this.keyTable = new float[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = 0.0f;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(float f) {
        if (f == 0.0f) {
            int n = 0;
            int n2 = this.elementSize;
            while (n < n2) {
                if (this.keyTable[n] == 0.0f) {
                    int n3 = Float.floatToIntBits(f);
                    int n4 = Float.floatToIntBits(this.keyTable[n]);
                    if (n3 == Integer.MIN_VALUE && n4 == Integer.MIN_VALUE) {
                        return true;
                    }
                    if (n3 == 0 && n4 == 0) {
                        return true;
                    }
                }
                ++n;
            }
        } else {
            int n = 0;
            int n5 = this.elementSize;
            while (n < n5) {
                if (this.keyTable[n] == f) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public int put(float f, int n) {
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new float[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = f;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return n;
    }

    public int putIfAbsent(float f, int n) {
        if (f == 0.0f) {
            int n2 = 0;
            int n3 = this.elementSize;
            while (n2 < n3) {
                if (this.keyTable[n2] == 0.0f) {
                    int n4 = Float.floatToIntBits(f);
                    int n5 = Float.floatToIntBits(this.keyTable[n2]);
                    if (n4 == Integer.MIN_VALUE && n5 == Integer.MIN_VALUE) {
                        return this.valueTable[n2];
                    }
                    if (n4 == 0 && n5 == 0) {
                        return this.valueTable[n2];
                    }
                }
                ++n2;
            }
        } else {
            int n6 = 0;
            int n7 = this.elementSize;
            while (n6 < n7) {
                if (this.keyTable[n6] == f) {
                    return this.valueTable[n6];
                }
                ++n6;
            }
        }
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new float[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = f;
        this.valueTable[this.elementSize] = n;
        ++this.elementSize;
        return -n;
    }

    public String toString() {
        int n = this.elementSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 < n) {
            if (this.keyTable[n2] != 0.0f || this.keyTable[n2] == 0.0f && this.valueTable[n2] != 0) {
                stringBuffer.append(this.keyTable[n2]).append("->").append(this.valueTable[n2]);
            }
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

