/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.HashMap;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeIds;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;
    public InferredType inferredType;

    public ClassScope(Scope scope, TypeDeclaration typeDeclaration) {
        super(3, scope);
        this.referenceContext = typeDeclaration;
    }

    public ClassScope(Scope scope, InferredType inferredType) {
        super(3, scope);
        this.inferredType = inferredType;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        SourceTypeBinding sourceTypeBinding2 = this.getReferenceBinding();
        if (referenceBinding.isInterface()) {
            sourceTypeBinding2.superclass = this.getJavaLangObject();
            sourceTypeBinding2.superInterfaces = new ReferenceBinding[]{referenceBinding};
        } else {
            sourceTypeBinding2.superclass = referenceBinding;
            sourceTypeBinding2.superInterfaces = Binding.NO_SUPERINTERFACES;
        }
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        sourceTypeBinding2.verifyMethods(this.environment().methodVerifier());
    }

    private void buildFields() {
        FieldBinding fieldBinding;
        if (this.referenceContext.fields == null) {
            this.getReferenceBinding().setFields(Binding.NO_FIELDS);
            return;
        }
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            switch (fieldDeclarationArray[n3].getKind()) {
                case 1: 
                case 3: {
                    ++n2;
                }
            }
            ++n3;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[n2];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n2);
        boolean bl = false;
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n4];
            if (fieldDeclaration.getKind() == 2) {
                if (this.getReferenceBinding().isInterface()) {
                    this.problemReporter().interfaceCannotHaveInitializers(this.getReferenceBinding(), fieldDeclaration);
                }
            } else {
                fieldBinding = new FieldBinding(fieldDeclaration.binding, this.getReferenceBinding());
                fieldBinding.id = n2;
                this.checkAndSetModifiersForField(fieldBinding, fieldDeclaration);
                if (hashtableOfObject.containsKey(fieldDeclaration.name)) {
                    bl = true;
                    FieldBinding fieldBinding2 = (FieldBinding)hashtableOfObject.get(fieldDeclaration.name);
                    if (fieldBinding2 != null) {
                        int n5 = 0;
                        while (n5 < n4) {
                            FieldDeclaration fieldDeclaration2 = fieldDeclarationArray[n5];
                            if (fieldDeclaration2.binding == fieldBinding2) {
                                this.problemReporter().duplicateFieldInType(this.getReferenceBinding(), fieldDeclaration2);
                                fieldDeclaration2.binding = null;
                                break;
                            }
                            ++n5;
                        }
                    }
                    hashtableOfObject.put(fieldDeclaration.name, null);
                    this.problemReporter().duplicateFieldInType(this.getReferenceBinding(), fieldDeclaration);
                    fieldDeclaration.binding = null;
                } else {
                    hashtableOfObject.put(fieldDeclaration.name, fieldBinding);
                    fieldBindingArray[n2++] = fieldBinding;
                }
            }
            ++n4;
        }
        if (bl) {
            FieldBinding[] fieldBindingArray2 = new FieldBinding[fieldBindingArray.length];
            n = n2;
            n2 = 0;
            int n6 = 0;
            while (n6 < n) {
                fieldBinding = fieldBindingArray[n6];
                if (hashtableOfObject.get(fieldBinding.name) != null) {
                    fieldBinding.id = n2;
                    fieldBindingArray2[n2++] = fieldBinding;
                }
                ++n6;
            }
            fieldBindingArray = fieldBindingArray2;
        }
        if (n2 != fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray3 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n2];
            System.arraycopy(fieldBindingArray3, 0, fieldBindingArray, 0, n2);
        }
        this.getReferenceBinding().setFields(fieldBindingArray);
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        if (sourceTypeBinding.isMemberType() && !sourceTypeBinding.isLocalType()) {
            ((MemberTypeBinding)sourceTypeBinding).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        int n = 0;
        int n2 = referenceBindingArray.length;
        while (n < n2) {
            ((SourceTypeBinding)referenceBindingArray[n]).classScope.buildFieldsAndMethods();
            ++n;
        }
    }

    public SourceTypeBinding getReferenceBinding() {
        if (this.referenceContext != null) {
            return this.referenceContext.binding;
        }
        return this.inferredType.binding;
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localTypeBinding = new LocalTypeBinding(this, sourceTypeBinding, this.innermostSwitchCase());
        this.referenceContext.binding = localTypeBinding;
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[n3];
                block0 : switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                        break;
                    }
                    default: {
                        ReferenceBinding referenceBinding = localTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().typeCollidesWithEnclosingType(typeDeclaration);
                            break block0;
                        } while ((referenceBinding = ((TypeBinding)referenceBinding).enclosingType()) != null);
                        int n4 = 0;
                        while (n4 < n3) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[n4].name, typeDeclaration.name)) {
                                this.problemReporter().duplicateNestedType(typeDeclaration);
                                break block0;
                            }
                            ++n4;
                        }
                        ClassScope classScope = new ClassScope((Scope)this, this.referenceContext.memberTypes[n3]);
                        LocalTypeBinding localTypeBinding2 = classScope.buildLocalType(localTypeBinding, packageBinding);
                        localTypeBinding2.setAsMemberType();
                        referenceBindingArray[n2++] = localTypeBinding2;
                    }
                }
                ++n3;
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        localTypeBinding.memberTypes = referenceBindingArray;
        return localTypeBinding;
    }

    void buildLocalTypeBinding(SourceTypeBinding sourceTypeBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        this.connectTypeHierarchy();
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        this.getReferenceBinding().verifyMethods(this.environment().methodVerifier());
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[n3];
                block0 : switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        if (sourceTypeBinding.isNestedType() && sourceTypeBinding.isClass() && !sourceTypeBinding.isStatic()) {
                            this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                            break;
                        }
                    }
                    default: {
                        ReferenceBinding referenceBinding = sourceTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().typeCollidesWithEnclosingType(typeDeclaration);
                            break block0;
                        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
                        int n4 = 0;
                        while (n4 < n3) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[n4].name, typeDeclaration.name)) {
                                this.problemReporter().duplicateNestedType(typeDeclaration);
                                break block0;
                            }
                            ++n4;
                        }
                        ClassScope classScope = new ClassScope((Scope)this, typeDeclaration);
                        referenceBindingArray[n2++] = classScope.buildType(sourceTypeBinding, sourceTypeBinding.fPackage, accessRestriction);
                    }
                }
                ++n3;
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        sourceTypeBinding.memberTypes = referenceBindingArray;
    }

    private void buildMethods() {
        boolean bl;
        boolean bl2 = bl = TypeDeclaration.kind(this.referenceContext.modifiers) == 3;
        if (this.referenceContext.methods == null && !bl) {
            this.getReferenceBinding().setMethods(Binding.NO_METHODS);
            return;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.referenceContext.methods;
        int n = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if (abstractMethodDeclarationArray[n3].isClinit()) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        n3 = bl ? 2 : 0;
        MethodBinding[] methodBindingArray = new MethodBinding[(n2 == -1 ? n : n - 1) + n3];
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        if (bl) {
            methodBindingArray[0] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUES);
            methodBindingArray[1] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUEOF);
        }
        int n4 = 0;
        while (n4 < n) {
            MethodScope methodScope;
            MethodBinding methodBinding;
            if (n4 != n2 && (methodBinding = (methodScope = new MethodScope(this, abstractMethodDeclarationArray[n4], false)).createMethod(abstractMethodDeclarationArray[n4], abstractMethodDeclarationArray[n4].selector, sourceTypeBinding, false, false)) != null) {
                methodBindingArray[n3++] = methodBinding;
            }
            ++n4;
        }
        if (n3 != methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n3];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n3);
        }
        sourceTypeBinding.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        sourceTypeBinding.setMethods(methodBindingArray);
    }

    SourceTypeBinding buildType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (sourceTypeBinding == null) {
            object = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            if (this.referenceContext != null) {
                this.referenceContext.binding = new SourceTypeBinding((char[][])object, packageBinding, this);
            }
        } else {
            object = CharOperation.deepCopy(sourceTypeBinding.compoundName);
            object[((char[][])object).length - 1] = CharOperation.concat(object[((char[][])object).length - 1], this.referenceContext.name, '$');
            ReferenceBinding referenceBinding = packageBinding.getType0(object[((char[][])object).length - 1]);
            if (referenceBinding != null) {
                this.parent.problemReporter().duplicateNestedType(this.referenceContext);
            }
            this.referenceContext.binding = new MemberTypeBinding((char[][])object, this, sourceTypeBinding);
        }
        object = this.getReferenceBinding();
        this.environment().setAccessRestriction((ReferenceBinding)object, accessRestriction);
        object.fPackage.addType((ReferenceBinding)object);
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        this.buildMemberTypes(accessRestriction);
        return object;
    }

    private void buildTypeVariables() {
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        if (typeParameterArray == null || this.compilerOptions().sourceLevel < 0x310000L) {
            sourceTypeBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
            return;
        }
        sourceTypeBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
        if (sourceTypeBinding.id == 1) {
            this.problemReporter().objectCannotBeGeneric(this.referenceContext);
            return;
        }
        sourceTypeBinding.typeVariables = this.createTypeVariables(typeParameterArray, sourceTypeBinding);
        sourceTypeBinding.modifiers |= 0x40000000;
    }

    private void checkAndSetModifiers() {
        int n;
        Binding binding;
        TypeIds typeIds;
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        int n2 = sourceTypeBinding.modifiers;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceTypeBinding);
        }
        ReferenceBinding referenceBinding = sourceTypeBinding.enclosingType();
        boolean bl = sourceTypeBinding.isMemberType();
        if (bl) {
            n2 |= referenceBinding.modifiers & 0x40000800;
            if (referenceBinding.isInterface()) {
                n2 |= 1;
            }
            if (sourceTypeBinding.isEnum()) {
                if (!referenceBinding.isStatic()) {
                    this.problemReporter().nonStaticContextForEnumMemberType(sourceTypeBinding);
                } else {
                    n2 |= 8;
                }
            }
            if (referenceBinding.isViewedAsDeprecated() && !sourceTypeBinding.isDeprecated()) {
                n2 |= 0x200000;
            }
        } else if (sourceTypeBinding.isLocalType()) {
            if (sourceTypeBinding.isEnum()) {
                this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                sourceTypeBinding.modifiers = 0;
                return;
            }
            if (sourceTypeBinding.isAnonymousType()) {
                n2 |= 0x10;
                if (this.referenceContext.allocation.type == null) {
                    n2 |= 0x4000;
                }
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        typeIds = (MethodScope)scope;
                        if (typeIds.isInsideInitializer()) {
                            binding = ((TypeDeclaration)typeIds.referenceContext).binding;
                            if (typeIds.initializedField != null) {
                                if (!typeIds.initializedField.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                                n2 |= 0x200000;
                                break;
                            }
                            if (((ReferenceBinding)binding).isStrictfp()) {
                                n2 |= 0x800;
                            }
                            if (!((ReferenceBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                            n2 |= 0x200000;
                            break;
                        }
                        binding = ((AbstractMethodDeclaration)typeIds.referenceContext).binding;
                        if (binding == null) break;
                        if (((MethodBinding)binding).isStrictfp()) {
                            n2 |= 0x800;
                        }
                        if (!((MethodBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n2 |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (referenceBinding.isStrictfp()) {
                            n2 |= 0x800;
                        }
                        if (!referenceBinding.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n2 |= 0x200000;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        if (((n = n2 & 0xFFFF) & 0x200) != 0) {
            if (bl) {
                if ((n & 0xFFFFD1F0) != 0) {
                    if ((n & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationMemberType(sourceTypeBinding);
                    } else {
                        this.problemReporter().illegalModifierForMemberInterface(sourceTypeBinding);
                    }
                }
            } else if ((n & 0xFFFFD1FE) != 0) {
                if ((n & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationType(sourceTypeBinding);
                } else {
                    this.problemReporter().illegalModifierForInterface(sourceTypeBinding);
                }
            }
            n2 |= 0x400;
        } else if ((n & 0x4000) != 0) {
            if (bl) {
                if ((n & 0xFFFFB7F0) != 0) {
                    this.problemReporter().illegalModifierForMemberEnum(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n & 0xFFFFB7EF) != 0) {
                    this.problemReporter().illegalModifierForLocalEnum(sourceTypeBinding);
                }
            } else if ((n & 0xFFFFB7FE) != 0) {
                this.problemReporter().illegalModifierForEnum(sourceTypeBinding);
            }
            if (!sourceTypeBinding.isAnonymousType()) {
                int n3;
                block80: {
                    if ((this.referenceContext.bits & 0x800) != 0) {
                        n2 |= 0x400;
                    } else {
                        typeIds = this.referenceContext;
                        binding = ((TypeDeclaration)typeIds).fields;
                        int n4 = n3 = binding == null ? 0 : ((Binding)binding).length;
                        if (n3 != 0) {
                            AbstractMethodDeclaration[] abstractMethodDeclarationArray = ((TypeDeclaration)typeIds).methods;
                            int n5 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
                            boolean bl2 = ((TypeDeclaration)typeIds).superInterfaces != null;
                            int n6 = 0;
                            while (n6 < n5 && !bl2) {
                                bl2 = abstractMethodDeclarationArray[n6].isAbstract();
                                ++n6;
                            }
                            if (bl2) {
                                n6 = 0;
                                int n7 = 0;
                                while (n7 < n3) {
                                    Binding binding2 = binding[n7];
                                    if (((FieldDeclaration)((Object)binding2)).getKind() == 3) {
                                        if (!(((FieldDeclaration)((Object)binding2)).initialization instanceof QualifiedAllocationExpression)) break block80;
                                        n6 = 1;
                                    }
                                    ++n7;
                                }
                                if (n6 != 0) {
                                    n2 |= 0x400;
                                }
                            }
                        }
                    }
                }
                typeIds = this.referenceContext;
                binding = ((TypeDeclaration)typeIds).fields;
                if (binding != null) {
                    n3 = 0;
                    int n8 = ((Binding)binding).length;
                    while (n3 < n8) {
                        Binding binding3 = binding[n3];
                        if (((FieldDeclaration)((Object)binding3)).getKind() != 3 || !(((FieldDeclaration)((Object)binding3)).initialization instanceof QualifiedAllocationExpression)) {
                            ++n3;
                            continue;
                        }
                        break;
                    }
                } else {
                    n2 |= 0x10;
                }
            }
        } else {
            if (bl) {
                if ((n & 0xFFFFF3E0) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n & 0xFFFFF3EF) != 0) {
                    this.problemReporter().illegalModifierForLocalClass(sourceTypeBinding);
                }
            } else if ((n & 0xFFFFF3EE) != 0) {
                this.problemReporter().illegalModifierForClass(sourceTypeBinding);
            }
            if ((n & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceTypeBinding);
            }
        }
        if (bl) {
            if (referenceBinding.isInterface()) {
                if ((n & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceTypeBinding);
                    if ((n & 4) != 0) {
                        n2 &= 0xFFFFFFFB;
                    }
                    if ((n & 2) != 0) {
                        n2 &= 0xFFFFFFFD;
                    }
                }
            } else {
                int n9 = n & 7;
                if ((n9 & n9 - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceTypeBinding);
                    if ((n9 & 1) != 0) {
                        if ((n9 & 4) != 0) {
                            n2 &= 0xFFFFFFFB;
                        }
                        if ((n9 & 2) != 0) {
                            n2 &= 0xFFFFFFFD;
                        }
                    } else if ((n9 & 4) != 0 && (n9 & 2) != 0) {
                        n2 &= 0xFFFFFFFD;
                    }
                }
            }
            if ((n & 8) == 0) {
                if (referenceBinding.isInterface()) {
                    n2 |= 8;
                }
            } else if (!referenceBinding.isStatic()) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceTypeBinding);
            }
        }
        sourceTypeBinding.modifiers = n2;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDeclaration) {
        int n;
        int n2 = fieldBinding.modifiers;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(referenceBinding, fieldDeclaration);
        }
        if (referenceBinding.isInterface()) {
            if (((n2 |= 0x19) & 0xFFFF) != 25) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationField(fieldDeclaration);
                } else {
                    this.problemReporter().illegalModifierForInterfaceField(fieldDeclaration);
                }
            }
            fieldBinding.modifiers = n2;
            return;
        }
        if (fieldDeclaration.getKind() == 3) {
            if ((n2 & 0xFFFF) != 0) {
                this.problemReporter().illegalModifierForEnumConstant(referenceBinding, fieldDeclaration);
            }
            fieldBinding.modifiers |= 0x4019;
            return;
        }
        int n3 = n2 & 0xFFFF;
        if ((n3 & 0xFFFFFF20) != 0) {
            this.problemReporter().illegalModifierForField(referenceBinding, fieldDeclaration);
            n2 &= 0xFFFF00DF;
        }
        if (((n = n3 & 7) & n - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(referenceBinding, fieldDeclaration);
            if ((n & 1) != 0) {
                if ((n & 4) != 0) {
                    n2 &= 0xFFFFFFFB;
                }
                if ((n & 2) != 0) {
                    n2 &= 0xFFFFFFFD;
                }
            } else if ((n & 4) != 0 && (n & 2) != 0) {
                n2 &= 0xFFFFFFFD;
            }
        }
        if ((n3 & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(referenceBinding, fieldDeclaration);
        }
        if (fieldDeclaration.initialization == null && (n2 & 0x10) != 0) {
            n2 |= 0x4000000;
        }
        fieldBinding.modifiers = n2;
    }

    public void checkParameterizedSuperTypeCollisions() {
        ReferenceBinding referenceBinding;
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces;
        HashMap hashMap = new HashMap(2);
        ReferenceBinding referenceBinding2 = sourceTypeBinding.isInterface() ? null : sourceTypeBinding.superclass;
        int n = 0;
        int n2 = referenceBindingArray.length;
        while (n < n2) {
            ReferenceBinding referenceBinding3 = referenceBindingArray[n];
            if (!(referenceBinding3 == null || referenceBinding2 != null && this.hasErasedCandidatesCollisions(referenceBinding2, referenceBinding3, hashMap, sourceTypeBinding, this.referenceContext))) {
                int n3 = 0;
                while (n3 < n) {
                    referenceBinding = referenceBindingArray[n3];
                    if (referenceBinding != null && this.hasErasedCandidatesCollisions(referenceBinding3, referenceBinding, hashMap, sourceTypeBinding, this.referenceContext)) break;
                    ++n3;
                }
            }
            ++n;
        }
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        n2 = 0;
        int n4 = typeParameterArray == null ? 0 : typeParameterArray.length;
        while (n2 < n4) {
            TypeReference[] typeReferenceArray;
            TypeParameter typeParameter = typeParameterArray[n2];
            referenceBinding = typeParameter.binding;
            if (referenceBinding != null && referenceBinding.isValidBinding() && (typeReferenceArray = typeParameter.bounds) != null) {
                boolean bl = ((TypeVariableBinding)referenceBinding).firstBound == ((TypeVariableBinding)referenceBinding).superclass;
                int n5 = 0;
                int n6 = typeReferenceArray.length;
                block3: while (n5 < n6) {
                    TypeReference typeReference = typeReferenceArray[n5];
                    TypeBinding typeBinding = typeReference.resolvedType;
                    if (typeBinding != null && typeBinding.isValidBinding()) {
                        if (bl && this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superclass, hashMap, referenceBinding, typeReference)) break;
                        int n7 = ((TypeVariableBinding)referenceBinding).superInterfaces.length;
                        while (--n7 >= 0) {
                            if (this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superInterfaces[n7], hashMap, referenceBinding, typeReference)) break block3;
                        }
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        ReferenceBinding[] referenceBindingArray2 = this.getReferenceBinding().memberTypes;
        if (referenceBindingArray2 != null && referenceBindingArray2 != Binding.NO_MEMBER_TYPES) {
            n4 = 0;
            int n8 = referenceBindingArray2.length;
            while (n4 < n8) {
                ((SourceTypeBinding)referenceBindingArray2[n4]).classScope.checkParameterizedSuperTypeCollisions();
                ++n4;
            }
        }
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceTypeBinding) {
        int n;
        ReferenceBinding[] referenceBindingArray;
        int n2;
        ReferenceBinding referenceBinding = sourceTypeBinding;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n3 = 0;
        do {
            if (referenceBinding.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] referenceBindingArray3 = referenceBinding.superInterfaces();
            if (referenceBindingArray3 == null || referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n3 = referenceBindingArray2.length;
                continue;
            }
            n2 = referenceBindingArray3.length;
            if (n3 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n3 + n2 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n3);
            }
            int n4 = 0;
            while (n4 < n2) {
                block19: {
                    referenceBindingArray = referenceBindingArray3[n4];
                    n = 0;
                    while (n < n3) {
                        if (referenceBindingArray != referenceBindingArray2[n]) {
                            ++n;
                            continue;
                        }
                        break block19;
                    }
                    referenceBindingArray2[n3++] = referenceBindingArray;
                }
                ++n4;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
        if (referenceBindingArray2 != null) {
            boolean bl = false;
            n2 = 0;
            while (n2 < n3) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n2];
                if ((referenceBinding2.tagBits & 0x10000L) == 0L) {
                    if (referenceBinding2.hasMemberTypes()) {
                        return;
                    }
                    bl = true;
                    referenceBindingArray = referenceBinding2.superInterfaces();
                    if (referenceBindingArray != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                        n = referenceBindingArray.length;
                        if (n3 + n >= referenceBindingArray2.length) {
                            ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                            referenceBindingArray2 = new ReferenceBinding[n3 + n + 5];
                            System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n3);
                        }
                        int n5 = 0;
                        while (n5 < n) {
                            block20: {
                                ReferenceBinding referenceBinding3 = referenceBindingArray[n5];
                                int n6 = 0;
                                while (n6 < n3) {
                                    if (referenceBinding3 != referenceBindingArray2[n6]) {
                                        ++n6;
                                        continue;
                                    }
                                    break block20;
                                }
                                referenceBindingArray2[n3++] = referenceBinding3;
                            }
                            ++n5;
                        }
                    }
                }
                ++n2;
            }
            if (bl) {
                n2 = 0;
                while (n2 < n3) {
                    referenceBindingArray2[n2].tagBits |= 0x10000L;
                    ++n2;
                }
            }
        }
        referenceBinding = sourceTypeBinding;
        do {
            referenceBinding.tagBits |= 0x10000L;
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
    }

    public void checkParameterizedTypeBounds() {
        ReferenceBinding[] referenceBindingArray;
        int n;
        TypeParameter[] typeParameterArray;
        int n2;
        TypeReference[] typeReferenceArray;
        TypeReference typeReference = this.referenceContext.superclass;
        if (typeReference != null) {
            typeReference.checkBounds(this);
        }
        if ((typeReferenceArray = this.referenceContext.superInterfaces) != null) {
            int n3 = 0;
            n2 = typeReferenceArray.length;
            while (n3 < n2) {
                typeReferenceArray[n3].checkBounds(this);
                ++n3;
            }
        }
        if ((typeParameterArray = this.referenceContext.typeParameters) != null) {
            n2 = 0;
            n = typeParameterArray.length;
            while (n2 < n) {
                typeParameterArray[n2].checkBounds(this);
                ++n2;
            }
        }
        if ((referenceBindingArray = this.getReferenceBinding().memberTypes) != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            n = 0;
            int n4 = referenceBindingArray.length;
            while (n < n4) {
                ((SourceTypeBinding)referenceBindingArray[n]).classScope.checkParameterizedTypeBounds();
                ++n;
            }
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n = 0;
            int n2 = referenceBindingArray.length;
            while (n < n2) {
                ((SourceTypeBinding)referenceBindingArray[n]).classScope.connectTypeHierarchy();
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean connectSuperclass() {
        SourceTypeBinding sourceTypeBinding;
        block10: {
            block11: {
                ReferenceBinding referenceBinding;
                TypeReference typeReference;
                block12: {
                    sourceTypeBinding = this.getReferenceBinding();
                    if (sourceTypeBinding.id == 1) {
                        sourceTypeBinding.superclass = null;
                        sourceTypeBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
                        if (sourceTypeBinding.isClass()) return true;
                        this.problemReporter().objectMustBeClass(sourceTypeBinding);
                        return true;
                    }
                    if (this.referenceContext != null && this.referenceContext.superclass == null || this.inferredType != null && this.inferredType.superClass == null) {
                        if (sourceTypeBinding.isEnum() && this.compilerOptions().sourceLevel >= 0x310000L) {
                            return this.connectEnumSuperclass();
                        }
                        sourceTypeBinding.superclass = this.getJavaLangObject();
                        if (!this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null)) return true;
                        return false;
                    }
                    if (this.referenceContext == null) break block11;
                    typeReference = this.referenceContext.superclass;
                    referenceBinding = this.findSupertype(typeReference);
                    if (referenceBinding == null) break block10;
                    if (referenceBinding.isClass()) break block12;
                    this.problemReporter().superclassMustBeAClass(sourceTypeBinding, typeReference, referenceBinding);
                    break block10;
                }
                if (referenceBinding.isFinal()) {
                    this.problemReporter().classExtendFinalClass(sourceTypeBinding, typeReference, referenceBinding);
                    break block10;
                } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
                    break block10;
                } else {
                    if (referenceBinding.erasure().id != 41) {
                        sourceTypeBinding.superclass = referenceBinding;
                        return true;
                    }
                    this.problemReporter().cannotExtendEnum(sourceTypeBinding, typeReference, referenceBinding);
                }
                break block10;
            }
            ReferenceBinding referenceBinding = this.findInferredSupertype(this.inferredType.superClass);
            if (referenceBinding != null) {
                if (referenceBinding.isClass()) {
                    sourceTypeBinding.superclass = referenceBinding;
                    return true;
                }
                this.problemReporter().superclassMustBeAClass(sourceTypeBinding, this.inferredType, referenceBinding);
            }
        }
        sourceTypeBinding.tagBits |= 0x20000L;
        sourceTypeBinding.superclass = this.getJavaLangObject();
        if ((sourceTypeBinding.superclass.tagBits & 0x100L) != 0L) return false;
        this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        return false;
    }

    private boolean connectEnumSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        ReferenceBinding referenceBinding = this.getJavaLangEnum();
        boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            this.problemReporter().nonGenericTypeCannotBeParameterized(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        if (1 != typeVariableBindingArray.length) {
            this.problemReporter().incorrectArityForParameterizedType(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment().createParameterizedType(referenceBinding, new TypeBinding[]{this.environment().convertToRawType(sourceTypeBinding)}, null);
        sourceTypeBinding.superclass = parameterizedTypeBinding;
        if (typeVariableBindingArray[0].boundCheck(parameterizedTypeBinding, sourceTypeBinding) != 0) {
            this.problemReporter().typeMismatchError(referenceBinding, typeVariableBindingArray[0], sourceTypeBinding, null);
        }
        return !bl;
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        sourceTypeBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
        if (this.referenceContext != null && this.referenceContext.superInterfaces == null) {
            if (sourceTypeBinding.isAnnotationType() && this.compilerOptions().sourceLevel >= 0x310000L) {
                ReferenceBinding referenceBinding = this.getJavaLangAnnotationAnnotation();
                boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
                sourceTypeBinding.superInterfaces = new ReferenceBinding[]{referenceBinding};
                return !bl;
            }
            return true;
        }
        if (sourceTypeBinding.id == 1) {
            return true;
        }
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void connectTypeHierarchy() {
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        if ((sourceTypeBinding.tagBits & 0x100L) == 0L) {
            sourceTypeBinding.tagBits |= 0x100L;
            boolean bl = this.connectSuperclass();
            sourceTypeBinding.tagBits |= 0x200L;
            sourceTypeBinding.tagBits |= 0x40000L;
            if (bl && sourceTypeBinding.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
            }
        }
        this.connectMemberTypes();
        LookupEnvironment lookupEnvironment = this.environment();
        try {
            try {
                lookupEnvironment.missingClassFileLocation = this.referenceContext;
                this.checkForInheritedMemberTypes(sourceTypeBinding);
            }
            catch (AbortCompilation abortCompilation) {
                abortCompilation.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
                throw abortCompilation;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            lookupEnvironment.missingClassFileLocation = null;
            throw throwable;
        }
        {
            Object var4_7 = null;
            lookupEnvironment.missingClassFileLocation = null;
            return;
        }
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
        if ((sourceTypeBinding.tagBits & 0x100L) != 0L) {
            return;
        }
        sourceTypeBinding.tagBits |= 0x100L;
        boolean bl = this.connectSuperclass();
        sourceTypeBinding.tagBits |= 0x200L;
        sourceTypeBinding.tagBits |= 0x40000L;
        if ((bl &= this.connectSuperInterfaces()) && sourceTypeBinding.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
        }
    }

    public boolean detectHierarchyCycle(TypeBinding typeBinding, TypeReference typeReference) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        if (typeReference == this.superTypeReference) {
            if (typeBinding.isTypeVariable()) {
                return false;
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = ((ParameterizedTypeBinding)typeBinding).genericType();
            }
            this.compilationUnitScope().recordSuperTypeReference(typeBinding);
            return this.detectHierarchyCycle(this.getReferenceBinding(), (ReferenceBinding)typeBinding, typeReference);
        }
        if ((typeBinding.tagBits & 0x100L) == 0L && typeBinding instanceof SourceTypeBinding) {
            ((SourceTypeBinding)typeBinding).classScope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding, TypeReference typeReference) {
        Object object;
        if (referenceBinding.isRawType()) {
            referenceBinding = ((RawTypeBinding)referenceBinding).genericType();
        }
        if (sourceTypeBinding == referenceBinding) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x20000L;
            return true;
        }
        if (referenceBinding.isMemberType()) {
            object = referenceBinding.enclosingType();
            do {
                if (!((ReferenceBinding)object).isHierarchyBeingConnected() || object != sourceTypeBinding) continue;
                this.problemReporter().hierarchyCircularity(sourceTypeBinding, (ReferenceBinding)object, typeReference);
                sourceTypeBinding.tagBits |= 0x20000L;
                ((ReferenceBinding)object).tagBits |= 0x20000L;
                return true;
            } while ((object = ((TypeBinding)object).enclosingType()) != null);
        }
        if (referenceBinding.isBinaryBinding()) {
            ReferenceBinding[] referenceBindingArray;
            boolean bl = false;
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                if (sourceTypeBinding == referenceBinding2) {
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                }
                if (referenceBinding2.isParameterizedType()) {
                    referenceBinding2 = ((ParameterizedTypeBinding)referenceBinding2).genericType();
                }
                bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding2, typeReference);
                if ((referenceBinding2.tagBits & 0x20000L) != 0L) {
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding2.tagBits |= 0x20000L;
                }
            }
            if ((referenceBindingArray = referenceBinding.superInterfaces()) != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                int n = 0;
                int n2 = referenceBindingArray.length;
                while (n < n2) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray[n];
                    if (sourceTypeBinding == referenceBinding3) {
                        this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                        sourceTypeBinding.tagBits |= 0x20000L;
                        referenceBinding.tagBits |= 0x20000L;
                        return true;
                    }
                    if (referenceBinding3.isParameterizedType()) {
                        referenceBinding3 = ((ParameterizedTypeBinding)referenceBinding3).genericType();
                    }
                    bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding3, typeReference);
                    if ((referenceBinding3.tagBits & 0x20000L) != 0L) {
                        sourceTypeBinding.tagBits |= 0x20000L;
                        referenceBinding.tagBits |= 0x20000L;
                    }
                    ++n;
                }
            }
            return bl;
        }
        if (referenceBinding.isHierarchyBeingConnected() && (object = ((SourceTypeBinding)referenceBinding).classScope.superTypeReference) != null && (((TypeReference)object).resolvedType == null || ((ReferenceBinding)((TypeReference)object).resolvedType).isHierarchyBeingConnected())) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x20000L;
            referenceBinding.tagBits |= 0x20000L;
            return true;
        }
        if ((referenceBinding.tagBits & 0x100L) == 0L) {
            ((SourceTypeBinding)referenceBinding).classScope.connectTypeHierarchyWithoutMembers();
        }
        if ((referenceBinding.tagBits & 0x20000L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
        }
        return false;
    }

    private ReferenceBinding findInferredSupertype(InferredType inferredType) {
        try {
            this.compilationUnitScope().recordQualifiedReference(new char[][]{inferredType.getName()});
            ReferenceBinding referenceBinding = inferredType.resolveSuperType(this);
            this.superTypeReference = null;
            return referenceBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(inferredType, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        ReferenceBinding referenceBinding;
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            ReferenceBinding referenceBinding2;
            lookupEnvironment.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            compilationUnitScope.recordQualifiedReference(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            referenceBinding = referenceBinding2 = (ReferenceBinding)typeReference.resolveSuperType(this);
            Object var6_7 = null;
        }
        catch (AbortCompilation abortCompilation) {
            try {
                SourceTypeBinding sourceTypeBinding = this.getReferenceBinding();
                if (sourceTypeBinding.superInterfaces == null) {
                    sourceTypeBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
                }
                abortCompilation.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
                throw abortCompilation;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                lookupEnvironment.missingClassFileLocation = null;
                this.superTypeReference = null;
                throw throwable;
            }
        }
        lookupEnvironment.missingClassFileLocation = null;
        this.superTypeReference = null;
        return referenceBinding;
    }

    public ProblemReporter problemReporter() {
        MethodScope methodScope = this.outerMostMethodScope();
        if (methodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return methodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.getReferenceBinding().toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }

    SourceTypeBinding buildInferredType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object;
        this.inferredType.scope = this;
        if (sourceTypeBinding == null) {
            object = CharOperation.arrayConcat(packageBinding.compoundName, this.inferredType.getName());
            this.inferredType.binding = new SourceTypeBinding((char[][])object, packageBinding, this);
            if (this.inferredType.isAnonymous) {
                this.inferredType.binding.tagBits |= 0x34L;
            }
        }
        object = this.inferredType.binding;
        this.environment().setAccessRestriction((ReferenceBinding)object, accessRestriction);
        ((SourceTypeBinding)object).fPackage.addType((ReferenceBinding)object);
        return object;
    }
}

