/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;

    public LocalVariableBinding(char[] cArray, TypeBinding typeBinding, int n, boolean bl) {
        super(cArray, typeBinding, n, bl ? Constant.NotAConstant : null);
        if (bl) {
            this.tagBits |= 0x400L;
        }
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n, boolean bl) {
        this(localDeclaration.name, typeBinding != null ? typeBinding : BaseTypeBinding.UNKNOWN, n, bl);
        this.declaration = localDeclaration;
    }

    public final int kind() {
        return 2;
    }

    public char[] computeUniqueKey(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        BlockScope blockScope = this.declaringScope;
        if (blockScope != null) {
            Object object2;
            if (blockScope instanceof CompilationUnitScope) {
                object2 = (CompilationUnitScope)blockScope;
                stringBuffer.append(((CompilationUnitScope)object2).referenceContext.compilationUnitBinding.computeUniqueKey(false));
            } else {
                CompilationUnitBinding compilationUnitBinding;
                object2 = null;
                object = blockScope instanceof MethodScope ? (MethodScope)blockScope : blockScope.enclosingMethodScope();
                object2 = object != null ? ((MethodScope)object).referenceContext : blockScope.enclosingCompilationUnit().scope.referenceCompilationUnit();
                if (object2 instanceof AbstractMethodDeclaration) {
                    MethodBinding methodBinding = ((AbstractMethodDeclaration)object2).binding;
                    if (methodBinding != null) {
                        stringBuffer.append(methodBinding.computeUniqueKey(false));
                    }
                } else if (object2 instanceof TypeDeclaration) {
                    SourceTypeBinding sourceTypeBinding = ((TypeDeclaration)object2).binding;
                    if (sourceTypeBinding != null) {
                        stringBuffer.append(((Binding)sourceTypeBinding).computeUniqueKey(false));
                    }
                } else if (object2 instanceof CompilationUnitDeclaration && (compilationUnitBinding = ((CompilationUnitDeclaration)object2).compilationUnitBinding) != null) {
                    stringBuffer.append(compilationUnitBinding.computeUniqueKey(false));
                }
            }
        }
        this.getScopeKey(blockScope, stringBuffer);
        stringBuffer.append('#');
        stringBuffer.append(this.name);
        int n = stringBuffer.length();
        object = new char[n];
        stringBuffer.getChars(0, n, (char[])object, 0);
        return object;
    }

    public AnnotationBinding[] getAnnotations() {
        Annotation[] annotationArray;
        if (this.declaringScope == null) {
            if ((this.tagBits & 0x200000000L) != 0L) {
                if (this.declaringScope == null && this.declaration == null) {
                    return Binding.NO_ANNOTATIONS;
                }
                Annotation[] annotationArray2 = this.declaration.annotations;
                if (annotationArray2 != null) {
                    int n = annotationArray2.length;
                    AnnotationBinding[] annotationBindingArray = new AnnotationBinding[n];
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotationBinding = annotationArray2[n2].getCompilerAnnotation();
                        if (annotationBinding == null) {
                            return Binding.NO_ANNOTATIONS;
                        }
                        annotationBindingArray[n2] = annotationBinding;
                        ++n2;
                    }
                    return annotationBindingArray;
                }
            }
            return Binding.NO_ANNOTATIONS;
        }
        SourceTypeBinding sourceTypeBinding = this.declaringScope.enclosingSourceType();
        if (sourceTypeBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        AnnotationBinding[] annotationBindingArray = sourceTypeBinding.retrieveAnnotations(this);
        if ((this.tagBits & 0x200000000L) == 0L && (this.tagBits & 0x400L) != 0L && this.declaration != null && (annotationArray = this.declaration.annotations) != null) {
            int n = annotationArray.length;
            ASTNode.resolveAnnotations(this.declaringScope, annotationArray, this);
            annotationBindingArray = new AnnotationBinding[n];
            int n3 = 0;
            while (n3 < n) {
                annotationBindingArray[n3] = new AnnotationBinding(annotationArray[n3]);
                ++n3;
            }
            this.setAnnotations(annotationBindingArray);
        }
        return annotationBindingArray;
    }

    private void getScopeKey(BlockScope blockScope, StringBuffer stringBuffer) {
        int n = blockScope.scopeIndex();
        if (n != -1) {
            this.getScopeKey((BlockScope)blockScope.parent, stringBuffer);
            stringBuffer.append('#');
            stringBuffer.append(n);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && (this.tagBits & 0x400L) == 0L;
    }

    public void recordInitializationEndPC(int n) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = n;
        }
    }

    public void recordInitializationStartPC(int n) {
        int n2;
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0) {
            n2 = this.initializationPCs[(this.initializationCount - 1 << 1) + 1];
            if (n2 == -1) {
                return;
            }
            if (n2 == n) {
                this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
                return;
            }
        }
        if ((n2 = this.initializationCount << 1) == this.initializationPCs.length) {
            this.initializationPCs = new int[this.initializationCount << 2];
            System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, n2);
        }
        this.initializationPCs[n2] = n;
        this.initializationPCs[n2 + 1] = -1;
        ++this.initializationCount;
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        if (this.declaringScope == null) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = this.declaringScope.enclosingSourceType();
        if (sourceTypeBinding != null) {
            sourceTypeBinding.storeAnnotations(this, annotationBindingArray);
        }
    }

    public boolean isFor(AbstractVariableDeclaration abstractVariableDeclaration) {
        return abstractVariableDeclaration.equals(this.declaration);
    }

    public String toString() {
        String string = super.toString();
        switch (this.useFlag) {
            case 1: {
                string = String.valueOf(string) + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                string = String.valueOf(string) + "[pos: unused]";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "[pos: fake_used]";
            }
        }
        string = String.valueOf(string) + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            string = String.valueOf(string) + "[pc: ";
            int n = 0;
            while (n < this.initializationCount) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + String.valueOf(this.initializationPCs[n << 1]) + "-" + (this.initializationPCs[(n << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(n << 1) + 1]));
                ++n;
            }
            string = String.valueOf(string) + "]";
        }
        return string;
    }
}

