/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ClassFilePool;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier15;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MissingBinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;

public class LookupEnvironment
implements ProblemReasons,
TypeConstants {
    static final int BUILD_FIELDS_AND_METHODS = 4;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final ProblemPackageBinding TheNotFoundPackage = new ProblemPackageBinding(CharOperation.NO_CHAR, 1);
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR, null, 1);
    private Map accessRestrictions;
    ImportBinding[] defaultImports;
    public PackageBinding defaultPackage;
    private int lastCompletedUnitIndex = -1;
    private int lastUnitIndex = -1;
    public INameEnvironment nameEnvironment;
    public CompilerOptions globalOptions;
    public ProblemReporter problemReporter;
    public ClassFilePool classFilePool;
    private int stepCompleted;
    public ITypeRequestor typeRequestor;
    private ArrayBinding[][] uniqueArrayBindings;
    private SimpleLookupTable uniqueParameterizedTypeBindings;
    private SimpleLookupTable uniqueRawTypeBindings;
    private SimpleLookupTable uniqueWildcardBindings;
    private SimpleLookupTable uniqueParameterizedGenericMethodBindings;
    private SimpleLookupTable uniqueAnnotationBindings;
    public CompilationUnitDeclaration unitBeingCompleted = null;
    public Object missingClassFileLocation = null;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    private MethodVerifier verifier;
    HashSet acceptedCompilationUnits = new HashSet();

    public LookupEnvironment(ITypeRequestor iTypeRequestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, INameEnvironment iNameEnvironment) {
        this.typeRequestor = iTypeRequestor;
        this.globalOptions = compilerOptions;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = iNameEnvironment;
        this.uniqueArrayBindings = new ArrayBinding[5][];
        this.uniqueArrayBindings[0] = new ArrayBinding[50];
        this.uniqueParameterizedTypeBindings = new SimpleLookupTable(3);
        this.uniqueRawTypeBindings = new SimpleLookupTable(3);
        this.uniqueWildcardBindings = new SimpleLookupTable(3);
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniqueAnnotationBindings = new SimpleLookupTable(3);
        this.accessRestrictions = new HashMap(3);
        this.classFilePool = ClassFilePool.newInstance();
    }

    public ReferenceBinding askForType(char[][] cArray) {
        NameEnvironmentAnswer nameEnvironmentAnswer = this.nameEnvironment.findType(cArray, this.typeRequestor);
        if (nameEnvironmentAnswer == null) {
            return null;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), this.computePackageFrom(cArray), nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            ICompilationUnit iCompilationUnit = nameEnvironmentAnswer.getCompilationUnit();
            if (!this.acceptedCompilationUnits.contains(iCompilationUnit)) {
                this.acceptedCompilationUnits.add(iCompilationUnit);
                this.typeRequestor.accept(iCompilationUnit, nameEnvironmentAnswer.getAccessRestriction());
            }
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), this.computePackageFrom(cArray), nameEnvironmentAnswer.getAccessRestriction());
        }
        return this.getCachedType(cArray);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] cArray) {
        return (ReferenceBinding)this.askForBinding(packageBinding, cArray, 20);
    }

    void addUnitsContainingBinding(PackageBinding packageBinding, char[] cArray, int n, String string) {
        NameEnvironmentAnswer nameEnvironmentAnswer;
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return;
            }
            packageBinding = this.defaultPackage;
        }
        if ((nameEnvironmentAnswer = this.nameEnvironment.findBinding(cArray, packageBinding.compoundName, n, this.typeRequestor, true, string)) == null) {
            return;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            ICompilationUnit iCompilationUnit = nameEnvironmentAnswer.getCompilationUnit();
            if (!this.acceptedCompilationUnits.contains(iCompilationUnit)) {
                this.acceptedCompilationUnits.add(iCompilationUnit);
                this.typeRequestor.accept(iCompilationUnit, nameEnvironmentAnswer.getAccessRestriction());
            }
        } else if (nameEnvironmentAnswer.isCompilationUnits()) {
            ICompilationUnit[] iCompilationUnitArray = nameEnvironmentAnswer.getCompilationUnits();
            int n2 = 0;
            while (n2 < iCompilationUnitArray.length) {
                if (!this.acceptedCompilationUnits.contains(iCompilationUnitArray[n2])) {
                    this.acceptedCompilationUnits.add(iCompilationUnitArray[n2]);
                    this.typeRequestor.accept(iCompilationUnitArray[n2], nameEnvironmentAnswer.getAccessRestriction());
                }
                ++n2;
            }
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        }
    }

    Binding askForBinding(PackageBinding packageBinding, char[] cArray, int n) {
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return null;
            }
            packageBinding = this.defaultPackage;
        }
        if (n == 16 && (cArray == null || cArray.length == 0) && this.defaultPackage.compoundName.length == 0) {
            return this.defaultPackage;
        }
        NameEnvironmentAnswer nameEnvironmentAnswer = this.nameEnvironment.findBinding(cArray, packageBinding.compoundName, n, this.typeRequestor, false, null);
        if (nameEnvironmentAnswer == null) {
            return null;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            ICompilationUnit iCompilationUnit = nameEnvironmentAnswer.getCompilationUnit();
            if (!this.acceptedCompilationUnits.contains(iCompilationUnit)) {
                this.acceptedCompilationUnits.add(iCompilationUnit);
                this.typeRequestor.accept(iCompilationUnit, nameEnvironmentAnswer.getAccessRestriction());
            }
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        }
        return packageBinding.getBinding0(cArray, n);
    }

    public void buildTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration, AccessRestriction accessRestriction) {
        CompilationUnitScope compilationUnitScope = new CompilationUnitScope(compilationUnitDeclaration, this);
        compilationUnitScope.buildTypeBindings(accessRestriction);
        int n = this.units.length;
        if (++this.lastUnitIndex >= n) {
            this.units = new CompilationUnitDeclaration[2 * n];
            System.arraycopy(this.units, 0, this.units, 0, n);
        }
        this.units[this.lastUnitIndex] = compilationUnitDeclaration;
    }

    public BinaryTypeBinding cacheBinaryType(ISourceType iSourceType, AccessRestriction accessRestriction) {
        return this.cacheBinaryType(iSourceType, true, accessRestriction);
    }

    public BinaryTypeBinding cacheBinaryType(ISourceType iSourceType, boolean bl, AccessRestriction accessRestriction) {
        char[][] cArray = CharOperation.splitOn('/', iSourceType.getName());
        ReferenceBinding referenceBinding = this.getCachedType(cArray);
        if (referenceBinding == null || referenceBinding instanceof UnresolvedReferenceBinding) {
            return this.createBinaryTypeFrom(iSourceType, this.computePackageFrom(cArray), bl, accessRestriction);
        }
        return null;
    }

    public BinaryTypeBinding cacheMissingBinaryType(char[][] cArray, CompilationUnitDeclaration compilationUnitDeclaration) {
        this.problemReporter.isClassPathCorrect(cArray, compilationUnitDeclaration == null ? this.unitBeingCompleted : compilationUnitDeclaration, this.missingClassFileLocation);
        PackageBinding packageBinding = this.computePackageFrom(cArray);
        MissingBinaryTypeBinding missingBinaryTypeBinding = new MissingBinaryTypeBinding(packageBinding, cArray, this);
        if (missingBinaryTypeBinding.id != 1) {
            ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_OBJECT);
            if (referenceBinding == null) {
                referenceBinding = this.cacheMissingBinaryType(TypeConstants.JAVA_LANG_OBJECT, compilationUnitDeclaration);
            }
            missingBinaryTypeBinding.setMissingSuperclass(referenceBinding);
        }
        packageBinding.addType(missingBinaryTypeBinding);
        return missingBinaryTypeBinding;
    }

    public void completeTypeBindings() {
        this.stepCompleted = 1;
        int n = this.lastCompletedUnitIndex + 1;
        while (n <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[n];
            this.unitBeingCompleted.scope.checkAndSetImports();
            ++n;
        }
        this.stepCompleted = 2;
        n = this.lastCompletedUnitIndex + 1;
        while (n <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[n];
            this.unitBeingCompleted.scope.connectTypeHierarchy();
            ++n;
        }
        this.stepCompleted = 3;
        n = this.lastCompletedUnitIndex + 1;
        while (n <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[n];
            CompilationUnitScope compilationUnitScope = this.unitBeingCompleted.scope;
            compilationUnitScope.checkParameterizedTypes();
            compilationUnitScope.buildFieldsAndMethods();
            this.units[n] = null;
            ++n;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.stepCompleted == 4) {
            this.completeTypeBindings();
        } else {
            if (compilationUnitDeclaration.scope == null) {
                return;
            }
            if (this.stepCompleted >= 2) {
                this.unitBeingCompleted = compilationUnitDeclaration;
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            if (this.stepCompleted >= 3) {
                this.unitBeingCompleted = compilationUnitDeclaration;
                this.unitBeingCompleted.scope.connectTypeHierarchy();
            }
            this.unitBeingCompleted = null;
        }
    }

    public void completeTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration, boolean bl) {
        if (compilationUnitDeclaration.scope == null) {
            return;
        }
        this.unitBeingCompleted = compilationUnitDeclaration;
        this.unitBeingCompleted.scope.checkAndSetImports();
        compilationUnitDeclaration.scope.connectTypeHierarchy();
        compilationUnitDeclaration.scope.checkParameterizedTypes();
        if (bl) {
            compilationUnitDeclaration.scope.buildFieldsAndMethods();
        }
        this.unitBeingCompleted = null;
    }

    public TypeBinding computeBoxingType(TypeBinding typeBinding) {
        switch (typeBinding.id) {
            case 33: {
                return TypeBinding.BOOLEAN;
            }
            case 26: {
                return TypeBinding.BYTE;
            }
            case 28: {
                return TypeBinding.CHAR;
            }
            case 27: {
                return TypeBinding.SHORT;
            }
            case 32: {
                return TypeBinding.DOUBLE;
            }
            case 31: {
                return TypeBinding.FLOAT;
            }
            case 29: {
                return TypeBinding.INT;
            }
            case 30: {
                return TypeBinding.LONG;
            }
            case 10: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_INTEGER);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_INTEGER, null, 1);
            }
            case 3: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_BYTE);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BYTE, null, 1);
            }
            case 4: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_SHORT);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_SHORT, null, 1);
            }
            case 2: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_CHARACTER);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_CHARACTER, null, 1);
            }
            case 7: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_LONG);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_LONG, null, 1);
            }
            case 9: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_FLOAT);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_FLOAT, null, 1);
            }
            case 8: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_DOUBLE);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_DOUBLE, null, 1);
            }
            case 5: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_BOOLEAN);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BOOLEAN, null, 1);
            }
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 4100: {
                switch (typeBinding.erasure().id) {
                    case 33: {
                        return TypeBinding.BOOLEAN;
                    }
                    case 26: {
                        return TypeBinding.BYTE;
                    }
                    case 28: {
                        return TypeBinding.CHAR;
                    }
                    case 27: {
                        return TypeBinding.SHORT;
                    }
                    case 32: {
                        return TypeBinding.DOUBLE;
                    }
                    case 31: {
                        return TypeBinding.FLOAT;
                    }
                    case 29: {
                        return TypeBinding.INT;
                    }
                    case 30: {
                        return TypeBinding.LONG;
                    }
                }
            }
        }
        return typeBinding;
    }

    private PackageBinding computePackageFrom(char[][] cArray) {
        return this.defaultPackage;
    }

    public ReferenceBinding convertToParameterizedType(ReferenceBinding referenceBinding) {
        if (referenceBinding != null) {
            ReferenceBinding referenceBinding2;
            boolean bl = referenceBinding.isGenericType();
            ReferenceBinding referenceBinding3 = referenceBinding2 = referenceBinding.enclosingType();
            boolean bl2 = bl;
            if (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding.isStatic() ? (ReferenceBinding)this.convertToRawType(referenceBinding2) : this.convertToParameterizedType(referenceBinding2);
                bl2 |= referenceBinding2 != referenceBinding3;
            }
            if (bl2) {
                return this.createParameterizedType(referenceBinding, bl ? referenceBinding.typeVariables() : null, referenceBinding3);
            }
        }
        return referenceBinding;
    }

    public TypeBinding convertToRawType(TypeBinding typeBinding) {
        return typeBinding;
    }

    public TypeBinding convertUnresolvedBinaryToRawType(TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        boolean bl;
        TypeBinding typeBinding3;
        int n;
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: {
                return typeBinding;
            }
            case 68: {
                n = typeBinding.dimensions();
                typeBinding3 = typeBinding.leafComponentType();
                break;
            }
            default: {
                if (typeBinding.id == 1) {
                    return typeBinding;
                }
                n = 0;
                typeBinding3 = typeBinding;
            }
        }
        switch (typeBinding3.kind()) {
            case 132: {
                return typeBinding;
            }
            case 2052: {
                bl = true;
                break;
            }
            case 260: {
                referenceBinding = (ParameterizedTypeBinding)typeBinding3;
                bl = referenceBinding.genericType().isGenericType();
                break;
            }
            default: {
                bl = false;
            }
        }
        referenceBinding = typeBinding3.enclosingType();
        if (referenceBinding == null) {
            typeBinding2 = bl ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), null) : typeBinding3;
        } else {
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(referenceBinding);
            if (referenceBinding2 != referenceBinding) {
                bl |= !((ReferenceBinding)typeBinding3).isStatic();
            }
            typeBinding2 = bl ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), referenceBinding2) : (referenceBinding != referenceBinding2 ? this.createParameterizedType((ReferenceBinding)typeBinding3.erasure(), null, referenceBinding2) : typeBinding3);
        }
        if (typeBinding3 != typeBinding2) {
            return n > 0 ? this.createArrayType(typeBinding2, n) : typeBinding2;
        }
        return typeBinding;
    }

    public AnnotationBinding createAnnotation(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        AnnotationBinding annotationBinding;
        int n;
        AnnotationBinding[] annotationBindingArray = (AnnotationBinding[])this.uniqueAnnotationBindings.get(referenceBinding);
        boolean bl = false;
        int n2 = 0;
        if (elementValuePairArray.length != 0) {
            AnnotationBinding.setMethodBindings(referenceBinding, elementValuePairArray);
        }
        if (annotationBindingArray != null) {
            n = annotationBindingArray.length;
            while (n2 < n) {
                block13: {
                    annotationBinding = annotationBindingArray[n2];
                    if (annotationBinding == null) break;
                    int n3 = elementValuePairArray.length;
                    ElementValuePair[] elementValuePairArray2 = annotationBinding.pairs;
                    if (n3 == elementValuePairArray2.length) {
                        int n4 = 0;
                        block1: while (n4 < n3) {
                            ElementValuePair elementValuePair = elementValuePairArray2[n4];
                            int n5 = 0;
                            while (n5 < n3) {
                                ElementValuePair elementValuePair2 = elementValuePairArray[n5];
                                if (elementValuePair.binding == elementValuePair2.binding) {
                                    if (elementValuePair.value == null) {
                                        if (elementValuePair2.value != null) break block13;
                                    } else if (elementValuePair2.value == null || !elementValuePair2.value.equals(elementValuePair.value)) {
                                        break block13;
                                    }
                                } else {
                                    ++n5;
                                    continue;
                                }
                                ++n4;
                                continue block1;
                            }
                            break block13;
                        }
                        return annotationBinding;
                    }
                }
                ++n2;
            }
            bl = true;
        } else {
            annotationBindingArray = new AnnotationBinding[1];
            this.uniqueAnnotationBindings.put(referenceBinding, annotationBindingArray);
        }
        n = annotationBindingArray.length;
        if (bl && n2 == n) {
            AnnotationBinding[] annotationBindingArray2 = annotationBindingArray;
            annotationBindingArray = new AnnotationBinding[n * 2];
            System.arraycopy(annotationBindingArray2, 0, annotationBindingArray, 0, n);
            this.uniqueAnnotationBindings.put(referenceBinding, annotationBindingArray);
        }
        annotationBindingArray[n2] = annotationBinding = new AnnotationBinding(referenceBinding, elementValuePairArray);
        return annotationBinding;
    }

    public ArrayBinding createArrayType(TypeBinding typeBinding, int n) {
        ArrayBinding[] arrayBindingArray;
        if (typeBinding instanceof LocalTypeBinding) {
            return ((LocalTypeBinding)typeBinding).createArrayType(n, this);
        }
        int n2 = n - 1;
        int n3 = this.uniqueArrayBindings.length;
        if (n2 < n3) {
            arrayBindingArray = this.uniqueArrayBindings[n2];
            if (arrayBindingArray == null) {
                arrayBindingArray = new ArrayBinding[10];
                this.uniqueArrayBindings[n2] = arrayBindingArray;
            }
        } else {
            this.uniqueArrayBindings = new ArrayBinding[n][];
            System.arraycopy(this.uniqueArrayBindings, 0, this.uniqueArrayBindings, 0, n3);
            arrayBindingArray = new ArrayBinding[10];
            this.uniqueArrayBindings[n2] = arrayBindingArray;
        }
        int n4 = -1;
        n3 = arrayBindingArray.length;
        while (++n4 < n3) {
            ArrayBinding arrayBinding = arrayBindingArray[n4];
            if (arrayBinding == null) {
                arrayBindingArray[n4] = new ArrayBinding(typeBinding, n, this);
                return arrayBindingArray[n4];
            }
            if (arrayBinding.leafComponentType != typeBinding) continue;
            return arrayBinding;
        }
        ArrayBinding[] arrayBindingArray2 = arrayBindingArray;
        arrayBindingArray = new ArrayBinding[n3 * 2];
        System.arraycopy(arrayBindingArray2, 0, arrayBindingArray, 0, n3);
        this.uniqueArrayBindings[n2] = arrayBindingArray;
        arrayBindingArray[n3] = new ArrayBinding(typeBinding, n, this);
        return arrayBindingArray[n3];
    }

    public BinaryTypeBinding createBinaryTypeFrom(ISourceType iSourceType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        return this.createBinaryTypeFrom(iSourceType, packageBinding, true, accessRestriction);
    }

    public BinaryTypeBinding createBinaryTypeFrom(ISourceType iSourceType, PackageBinding packageBinding, boolean bl, AccessRestriction accessRestriction) {
        BinaryTypeBinding binaryTypeBinding = new BinaryTypeBinding(packageBinding, iSourceType, this);
        ReferenceBinding referenceBinding = packageBinding.getType0(binaryTypeBinding.compoundName[binaryTypeBinding.compoundName.length - 1]);
        if (referenceBinding != null) {
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                ((UnresolvedReferenceBinding)referenceBinding).setResolvedType(binaryTypeBinding, this);
            } else {
                if (referenceBinding.isBinaryBinding()) {
                    return (BinaryTypeBinding)referenceBinding;
                }
                return null;
            }
        }
        packageBinding.addType(binaryTypeBinding);
        this.setAccessRestriction(binaryTypeBinding, accessRestriction);
        binaryTypeBinding.cachePartsFrom(iSourceType, bl);
        return binaryTypeBinding;
    }

    public PackageBinding createPackage(char[][] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(cArray[0], this);
        }
        int n = 1;
        int n2 = cArray.length;
        while (n < n2) {
            ReferenceBinding referenceBinding = packageBinding.getType0(cArray[n]);
            if (referenceBinding != null && referenceBinding != TheNotFoundType && !(referenceBinding instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding packageBinding2 = packageBinding;
            if ((packageBinding = packageBinding2.getPackage0(cArray[n])) == null || packageBinding == TheNotFoundPackage) {
                if (this.nameEnvironment.findType(cArray[n], packageBinding2.compoundName, this.typeRequestor) != null) {
                    return null;
                }
                packageBinding = new PackageBinding(CharOperation.subarray(cArray, 0, n + 1), packageBinding2, this);
                packageBinding2.addPackage(packageBinding);
            }
            ++n;
        }
        return packageBinding;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, RawTypeBinding rawTypeBinding) {
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        int n;
        ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(methodBinding);
        boolean bl = false;
        int n2 = 0;
        if (parameterizedGenericMethodBindingArray != null) {
            n = parameterizedGenericMethodBindingArray.length;
            while (n2 < n) {
                parameterizedGenericMethodBinding = parameterizedGenericMethodBindingArray[n2];
                if (parameterizedGenericMethodBinding == null) break;
                if (parameterizedGenericMethodBinding.isRaw && parameterizedGenericMethodBinding.declaringClass == (rawTypeBinding == null ? methodBinding.declaringClass : rawTypeBinding)) {
                    return parameterizedGenericMethodBinding;
                }
                ++n2;
            }
            bl = true;
        } else {
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        n = parameterizedGenericMethodBindingArray.length;
        if (bl && n2 == n) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray2 = parameterizedGenericMethodBindingArray;
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[n * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray2, 0, parameterizedGenericMethodBindingArray, 0, n);
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        parameterizedGenericMethodBindingArray[n2] = parameterizedGenericMethodBinding = new ParameterizedGenericMethodBinding(methodBinding, rawTypeBinding, this);
        return parameterizedGenericMethodBinding;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        int n;
        ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(methodBinding);
        int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
        boolean bl = false;
        int n3 = 0;
        if (parameterizedGenericMethodBindingArray != null) {
            n = parameterizedGenericMethodBindingArray.length;
            while (n3 < n) {
                block8: {
                    parameterizedGenericMethodBinding = parameterizedGenericMethodBindingArray[n3];
                    if (parameterizedGenericMethodBinding == null) break;
                    if (!parameterizedGenericMethodBinding.isRaw) {
                        int n4;
                        TypeBinding[] typeBindingArray2 = parameterizedGenericMethodBinding.typeArguments;
                        int n5 = n4 = typeBindingArray2 == null ? 0 : typeBindingArray2.length;
                        if (n2 == n4) {
                            int n6 = 0;
                            while (n6 < n4) {
                                if (typeBindingArray[n6] == typeBindingArray2[n6]) {
                                    ++n6;
                                    continue;
                                }
                                break block8;
                            }
                            return parameterizedGenericMethodBinding;
                        }
                    }
                }
                ++n3;
            }
            bl = true;
        } else {
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        n = parameterizedGenericMethodBindingArray.length;
        if (bl && n3 == n) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray2 = parameterizedGenericMethodBindingArray;
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[n * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray2, 0, parameterizedGenericMethodBindingArray, 0, n);
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        parameterizedGenericMethodBindingArray[n3] = parameterizedGenericMethodBinding = new ParameterizedGenericMethodBinding(methodBinding, typeBindingArray, this);
        return parameterizedGenericMethodBinding;
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        ParameterizedTypeBinding parameterizedTypeBinding;
        int n;
        ParameterizedTypeBinding[] parameterizedTypeBindingArray = (ParameterizedTypeBinding[])this.uniqueParameterizedTypeBindings.get(referenceBinding);
        int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
        boolean bl = false;
        int n3 = 0;
        if (parameterizedTypeBindingArray != null) {
            n = parameterizedTypeBindingArray.length;
            while (n3 < n) {
                block8: {
                    parameterizedTypeBinding = parameterizedTypeBindingArray[n3];
                    if (parameterizedTypeBinding == null) break;
                    if (parameterizedTypeBinding.actualType() == referenceBinding && parameterizedTypeBinding.enclosingType() == referenceBinding2) {
                        int n4;
                        TypeBinding[] typeBindingArray2 = parameterizedTypeBinding.arguments;
                        int n5 = n4 = typeBindingArray2 == null ? 0 : typeBindingArray2.length;
                        if (n2 == n4) {
                            int n6 = 0;
                            while (n6 < n4) {
                                if (typeBindingArray[n6] == typeBindingArray2[n6]) {
                                    ++n6;
                                    continue;
                                }
                                break block8;
                            }
                            return parameterizedTypeBinding;
                        }
                    }
                }
                ++n3;
            }
            bl = true;
        } else {
            parameterizedTypeBindingArray = new ParameterizedTypeBinding[5];
            this.uniqueParameterizedTypeBindings.put(referenceBinding, parameterizedTypeBindingArray);
        }
        n = parameterizedTypeBindingArray.length;
        if (bl && n3 == n) {
            ParameterizedTypeBinding[] parameterizedTypeBindingArray2 = parameterizedTypeBindingArray;
            parameterizedTypeBindingArray = new ParameterizedTypeBinding[n * 2];
            System.arraycopy(parameterizedTypeBindingArray2, 0, parameterizedTypeBindingArray, 0, n);
            this.uniqueParameterizedTypeBindings.put(referenceBinding, parameterizedTypeBindingArray);
        }
        parameterizedTypeBindingArray[n3] = parameterizedTypeBinding = new ParameterizedTypeBinding(referenceBinding, typeBindingArray, referenceBinding2, this);
        return parameterizedTypeBinding;
    }

    public RawTypeBinding createRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        RawTypeBinding rawTypeBinding;
        int n;
        RawTypeBinding[] rawTypeBindingArray = (RawTypeBinding[])this.uniqueRawTypeBindings.get(referenceBinding);
        boolean bl = false;
        int n2 = 0;
        if (rawTypeBindingArray != null) {
            n = rawTypeBindingArray.length;
            while (n2 < n) {
                rawTypeBinding = rawTypeBindingArray[n2];
                if (rawTypeBinding == null) break;
                if (rawTypeBinding.actualType() == referenceBinding && rawTypeBinding.enclosingType() == referenceBinding2) {
                    return rawTypeBinding;
                }
                ++n2;
            }
            bl = true;
        } else {
            rawTypeBindingArray = new RawTypeBinding[1];
            this.uniqueRawTypeBindings.put(referenceBinding, rawTypeBindingArray);
        }
        n = rawTypeBindingArray.length;
        if (bl && n2 == n) {
            RawTypeBinding[] rawTypeBindingArray2 = rawTypeBindingArray;
            rawTypeBindingArray = new RawTypeBinding[n * 2];
            System.arraycopy(rawTypeBindingArray2, 0, rawTypeBindingArray, 0, n);
            this.uniqueRawTypeBindings.put(referenceBinding, rawTypeBindingArray);
        }
        rawTypeBindingArray[n2] = rawTypeBinding = new RawTypeBinding(referenceBinding, referenceBinding2, this);
        return rawTypeBinding;
    }

    public WildcardBinding createWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        WildcardBinding wildcardBinding;
        int n3;
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        WildcardBinding[] wildcardBindingArray = (WildcardBinding[])this.uniqueWildcardBindings.get(referenceBinding);
        boolean bl = false;
        int n4 = 0;
        if (wildcardBindingArray != null) {
            n3 = wildcardBindingArray.length;
            while (n4 < n3) {
                wildcardBinding = wildcardBindingArray[n4];
                if (wildcardBinding == null) break;
                if (wildcardBinding.genericType == referenceBinding && wildcardBinding.rank == n && wildcardBinding.boundKind == n2 && wildcardBinding.bound == typeBinding) {
                    if (wildcardBinding.otherBounds != typeBindingArray) {
                        int n5;
                        int n6 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                        int n7 = n5 = typeBindingArray == null ? 0 : typeBindingArray.length;
                        if (n6 == n5) {
                            int n8 = 0;
                            while (n8 < n5) {
                                if (wildcardBinding.otherBounds[n8] == typeBindingArray[n8]) {
                                    ++n8;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        return wildcardBinding;
                    }
                }
                ++n4;
            }
            bl = true;
        } else {
            wildcardBindingArray = new WildcardBinding[10];
            this.uniqueWildcardBindings.put(referenceBinding, wildcardBindingArray);
        }
        n3 = wildcardBindingArray.length;
        if (bl && n4 == n3) {
            WildcardBinding[] wildcardBindingArray2 = wildcardBindingArray;
            wildcardBindingArray = new WildcardBinding[n3 * 2];
            System.arraycopy(wildcardBindingArray2, 0, wildcardBindingArray, 0, n3);
            this.uniqueWildcardBindings.put(referenceBinding, wildcardBindingArray);
        }
        wildcardBindingArray[n4] = wildcardBinding = new WildcardBinding(referenceBinding, n, typeBinding, typeBindingArray, n2, this);
        return wildcardBinding;
    }

    public AccessRestriction getAccessRestriction(TypeBinding typeBinding) {
        return (AccessRestriction)this.accessRestrictions.get(typeBinding);
    }

    public ReferenceBinding getCachedType(char[][] cArray) {
        if (cArray.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            return this.defaultPackage.getType0(cArray[0]);
        }
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            return null;
        }
        int n = 1;
        int n2 = cArray.length - 1;
        while (n < n2) {
            if ((packageBinding = packageBinding.getPackage0(cArray[n])) == null || packageBinding == TheNotFoundPackage) {
                return null;
            }
            ++n;
        }
        return packageBinding.getType0(cArray[cArray.length - 1]);
    }

    PackageBinding getPackage0(char[] cArray) {
        return this.defaultPackage;
    }

    public ReferenceBinding getResolvedType(char[][] cArray, Scope scope) {
        ReferenceBinding referenceBinding = this.getType(cArray);
        if (referenceBinding != null) {
            return referenceBinding;
        }
        return this.cacheMissingBinaryType(cArray, scope == null ? this.unitBeingCompleted : scope.referenceCompilationUnit());
    }

    PackageBinding getTopLevelPackage(char[] cArray) {
        if (CharOperation.equals(cArray, this.defaultPackage.readableName())) {
            return this.defaultPackage;
        }
        return null;
    }

    public ReferenceBinding getType(char[][] cArray) {
        ReferenceBinding referenceBinding;
        if (cArray.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            referenceBinding = this.defaultPackage.getType0(cArray[0]);
            if (referenceBinding == null) {
                PackageBinding packageBinding = this.getPackage0(cArray[0]);
                if (packageBinding != null && packageBinding != TheNotFoundPackage) {
                    return null;
                }
                referenceBinding = this.askForType(this.defaultPackage, cArray[0]);
            }
        } else {
            PackageBinding packageBinding = this.getPackage0(cArray[0]);
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            if (packageBinding != null) {
                int n = 1;
                int n2 = cArray.length - 1;
                while (n < n2) {
                    if ((packageBinding = packageBinding.getPackage0(cArray[n])) == null) break;
                    if (packageBinding == TheNotFoundPackage) {
                        return null;
                    }
                    ++n;
                }
            }
            if (packageBinding == null) {
                referenceBinding = this.askForType(cArray);
            } else {
                referenceBinding = packageBinding.getType0(cArray[cArray.length - 1]);
                if (referenceBinding == null) {
                    referenceBinding = this.askForType(packageBinding, cArray[cArray.length - 1]);
                }
            }
        }
        if (referenceBinding == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = BinaryTypeBinding.resolveType(referenceBinding, this, false)).isNestedType()) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 4);
        }
        return referenceBinding;
    }

    private TypeBinding[] getTypeArgumentsFromSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
        int n = 0;
        do {
            arrayList.add(this.getTypeFromVariantTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding2, n++));
        } while (signatureWrapper.signature[signatureWrapper.start] != '>');
        ++signatureWrapper.start;
        TypeBinding[] typeBindingArray = new TypeBinding[arrayList.size()];
        arrayList.toArray(typeBindingArray);
        return typeBindingArray;
    }

    ReferenceBinding getTypeFromCompoundName(char[][] cArray, boolean bl) {
        ReferenceBinding referenceBinding = this.getCachedType(cArray);
        if (referenceBinding == null) {
            PackageBinding packageBinding = this.computePackageFrom(cArray);
            referenceBinding = new UnresolvedReferenceBinding(cArray, packageBinding);
            packageBinding.addType(referenceBinding);
        } else if (referenceBinding == TheNotFoundType) {
            referenceBinding = this.cacheMissingBinaryType(cArray, this.unitBeingCompleted);
        } else if (!bl) {
            referenceBinding = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    ReferenceBinding getTypeFromConstantPoolName(char[] cArray, int n, int n2, boolean bl) {
        if (n2 == -1) {
            n2 = cArray.length;
        }
        char[][] cArray2 = CharOperation.splitOn('/', cArray, n, n2);
        return this.getTypeFromCompoundName(cArray2, bl);
    }

    TypeBinding getTypeFromSignature(char[] cArray, int n, int n2, boolean bl, TypeBinding typeBinding) {
        int n3 = 0;
        while (cArray[n] == '[') {
            ++n;
            ++n3;
        }
        if (n2 == -1) {
            n2 = cArray.length - 1;
        }
        TypeBinding typeBinding2 = null;
        if (n == n2) {
            switch (cArray[n]) {
                case 'I': {
                    typeBinding2 = TypeBinding.INT;
                    break;
                }
                case 'Z': {
                    typeBinding2 = TypeBinding.BOOLEAN;
                    break;
                }
                case 'V': {
                    typeBinding2 = TypeBinding.VOID;
                    break;
                }
                case 'C': {
                    typeBinding2 = TypeBinding.CHAR;
                    break;
                }
                case 'D': {
                    typeBinding2 = TypeBinding.DOUBLE;
                    break;
                }
                case 'B': {
                    typeBinding2 = TypeBinding.BYTE;
                    break;
                }
                case 'F': {
                    typeBinding2 = TypeBinding.FLOAT;
                    break;
                }
                case 'J': {
                    typeBinding2 = TypeBinding.LONG;
                    break;
                }
                case 'S': {
                    typeBinding2 = TypeBinding.SHORT;
                    break;
                }
                default: {
                    this.problemReporter.corruptedSignature(typeBinding, cArray, n);
                    break;
                }
            }
        } else {
            typeBinding2 = this.getTypeFromConstantPoolName(cArray, n + 1, n2, bl);
        }
        if (n3 == 0) {
            return typeBinding2;
        }
        return this.createArrayType(typeBinding2, n3);
    }

    TypeBinding getTypeFromTypeSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding) {
        int n = 0;
        while (signatureWrapper.signature[signatureWrapper.start] == '[') {
            ++signatureWrapper.start;
            ++n;
        }
        if (signatureWrapper.signature[signatureWrapper.start] == 'T') {
            int n2 = signatureWrapper.start + 1;
            int n3 = signatureWrapper.computeEnd();
            int n4 = typeVariableBindingArray.length;
            while (--n4 >= 0) {
                if (!CharOperation.equals(typeVariableBindingArray[n4].sourceName, signatureWrapper.signature, n2, n3)) continue;
                return n == 0 ? typeVariableBindingArray[n4] : this.createArrayType(typeVariableBindingArray[n4], n);
            }
            ReferenceBinding referenceBinding2 = referenceBinding;
            do {
                if (!(referenceBinding instanceof BinaryTypeBinding)) continue;
                TypeVariableBinding[] typeVariableBindingArray2 = ((BinaryTypeBinding)referenceBinding).typeVariables;
                int n5 = typeVariableBindingArray2.length;
                while (--n5 >= 0) {
                    if (!CharOperation.equals(typeVariableBindingArray2[n5].sourceName, signatureWrapper.signature, n2, n3)) continue;
                    return n == 0 ? typeVariableBindingArray2[n5] : this.createArrayType(typeVariableBindingArray2[n5], n);
                }
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            this.problemReporter.undefinedTypeVariableSignature(CharOperation.subarray(signatureWrapper.signature, n2, n3), referenceBinding2);
            return null;
        }
        boolean bl = signatureWrapper.end == signatureWrapper.bracket;
        TypeBinding typeBinding = this.getTypeFromSignature(signatureWrapper.signature, signatureWrapper.start, signatureWrapper.computeEnd(), bl, referenceBinding);
        if (!bl) {
            return n == 0 ? typeBinding : this.createArrayType(typeBinding, n);
        }
        ReferenceBinding referenceBinding3 = (ReferenceBinding)typeBinding;
        TypeBinding[] typeBindingArray = this.getTypeArgumentsFromSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding3);
        ReferenceBinding referenceBinding4 = referenceBinding3.enclosingType();
        if (referenceBinding4 != null) {
            referenceBinding4 = (ReferenceBinding)this.convertToRawType(referenceBinding4);
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.createParameterizedType(referenceBinding3, typeBindingArray, referenceBinding4);
        while (signatureWrapper.signature[signatureWrapper.start] == '.') {
            ++signatureWrapper.start;
            char[] cArray = signatureWrapper.nextWord();
            BinaryTypeBinding.resolveType(parameterizedTypeBinding, this, false);
            ReferenceBinding referenceBinding5 = parameterizedTypeBinding.genericType().getMemberType(cArray);
            if (signatureWrapper.signature[signatureWrapper.start] == '<') {
                ++signatureWrapper.start;
                typeBindingArray = this.getTypeArgumentsFromSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding5);
            } else {
                typeBindingArray = null;
            }
            parameterizedTypeBinding = this.createParameterizedType(referenceBinding5, typeBindingArray, parameterizedTypeBinding);
        }
        ++signatureWrapper.start;
        return n == 0 ? parameterizedTypeBinding : this.createArrayType(parameterizedTypeBinding, n);
    }

    TypeBinding getTypeFromVariantTypeSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, int n) {
        switch (signatureWrapper.signature[signatureWrapper.start]) {
            case '-': {
                ++signatureWrapper.start;
                TypeBinding typeBinding = this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding);
                return this.createWildcard(referenceBinding2, n, typeBinding, null, 2);
            }
            case '+': {
                ++signatureWrapper.start;
                TypeBinding typeBinding = this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding);
                return this.createWildcard(referenceBinding2, n, typeBinding, null, 1);
            }
            case '*': {
                ++signatureWrapper.start;
                return this.createWildcard(referenceBinding2, n, null, null, 0);
            }
        }
        return this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding);
    }

    boolean isPackage(char[][] cArray, char[] cArray2) {
        if (cArray == null || cArray.length == 0) {
            return this.nameEnvironment.isPackage(null, cArray2);
        }
        return this.nameEnvironment.isPackage(cArray, cArray2);
    }

    public MethodVerifier methodVerifier() {
        if (this.verifier == null) {
            this.verifier = this.globalOptions.sourceLevel < 0x310000L ? new MethodVerifier(this) : new MethodVerifier15(this);
        }
        return this.verifier;
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.accessRestrictions = new HashMap(3);
        this.verifier = null;
        int n = this.uniqueArrayBindings.length;
        while (--n >= 0) {
            ArrayBinding[] arrayBindingArray = this.uniqueArrayBindings[n];
            if (arrayBindingArray == null) continue;
            int n2 = arrayBindingArray.length;
            while (--n2 >= 0) {
                arrayBindingArray[n2] = null;
            }
        }
        this.uniqueParameterizedTypeBindings = new SimpleLookupTable(3);
        this.uniqueRawTypeBindings = new SimpleLookupTable(3);
        this.uniqueWildcardBindings = new SimpleLookupTable(3);
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniqueAnnotationBindings = new SimpleLookupTable(3);
        n = this.units.length;
        while (--n >= 0) {
            this.units[n] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
        this.unitBeingCompleted = null;
        this.classFilePool.reset();
    }

    public void setAccessRestriction(ReferenceBinding referenceBinding, AccessRestriction accessRestriction) {
        if (accessRestriction == null) {
            return;
        }
        referenceBinding.modifiers |= 0x40000;
        this.accessRestrictions.put(referenceBinding, accessRestriction);
    }

    void updateCaches(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding) {
        int n;
        int n2;
        Object[] objectArray;
        if (this.uniqueParameterizedTypeBindings.get(unresolvedReferenceBinding) != null) {
            objectArray = this.uniqueParameterizedTypeBindings.keyTable;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                if (objectArray[n2] == unresolvedReferenceBinding) {
                    objectArray[n2] = referenceBinding;
                    break;
                }
                ++n2;
            }
        }
        if (this.uniqueWildcardBindings.get(unresolvedReferenceBinding) != null) {
            objectArray = this.uniqueWildcardBindings.keyTable;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                if (objectArray[n2] == unresolvedReferenceBinding) {
                    objectArray[n2] = referenceBinding;
                    break;
                }
                ++n2;
            }
        }
    }
}

