/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IDependent;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public abstract class ReferenceBinding
extends TypeBinding
implements IDependent {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;
    private SimpleLookupTable compatibleCache;
    public static ReferenceBinding LUB_GENERIC = new ReferenceBinding(){};
    private static final Comparator FIELD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            char[] cArray = ((FieldBinding)object).name;
            char[] cArray2 = ((FieldBinding)object2).name;
            return ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
        }
    };
    private static final Comparator METHOD_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            MethodBinding methodBinding = (MethodBinding)object;
            MethodBinding methodBinding2 = (MethodBinding)object2;
            char[] cArray = methodBinding.selector;
            char[] cArray2 = methodBinding2.selector;
            int n = ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
            return n == 0 ? methodBinding.parameters.length - methodBinding2.parameters.length : n;
        }
    };

    public static FieldBinding binarySearch(char[] cArray, FieldBinding[] fieldBindingArray) {
        if (fieldBindingArray == null) {
            return null;
        }
        int n = fieldBindingArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = fieldBindingArray[n5].name;
            int n6 = ReferenceBinding.compare(cArray, fieldBindingArray[n5].name, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            return fieldBindingArray[n5];
        }
        return null;
    }

    public static long binarySearch(char[] cArray, MethodBinding[] methodBindingArray) {
        if (methodBindingArray == null) {
            return -1L;
        }
        int n = methodBindingArray.length;
        if (n == 0) {
            return -1L;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = methodBindingArray[n5].selector;
            int n6 = ReferenceBinding.compare(cArray, methodBindingArray[n5].selector, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            int n7 = n5;
            int n8 = n5;
            while (n7 > n2 && CharOperation.equals(methodBindingArray[n7 - 1].selector, cArray)) {
                --n7;
            }
            while (n8 < n3 && CharOperation.equals(methodBindingArray[n8 + 1].selector, cArray)) {
                ++n8;
            }
            return (long)n7 + ((long)n8 << 32);
        }
        return -1L;
    }

    static int compare(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = cArray[n4];
            if (c2 == (c = cArray2[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static void sortFields(FieldBinding[] fieldBindingArray, int n, int n2) {
        Arrays.sort(fieldBindingArray, n, n2, FIELD_COMPARATOR);
    }

    public static void sortMethods(MethodBinding[] methodBindingArray, int n, int n2) {
        Arrays.sort(methodBindingArray, n, n2, METHOD_COMPARATOR);
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.fPackage;
    }

    public final boolean canBeSeenBy(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        ReferenceBinding referenceBinding3;
        if (this.isPublic()) {
            return true;
        }
        if (referenceBinding2 == this && referenceBinding2 == referenceBinding) {
            return true;
        }
        if (this.isProtected()) {
            if (referenceBinding2 == this) {
                return true;
            }
            if (referenceBinding2.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding4 = referenceBinding2;
            ReferenceBinding referenceBinding5 = this.enclosingType();
            if (referenceBinding5 == referenceBinding2) {
                return true;
            }
            if (referenceBinding5 == null) {
                return false;
            }
            do {
                if (referenceBinding4.findSuperTypeWithSameErasure(referenceBinding5) == null) continue;
                return true;
            } while ((referenceBinding4 = referenceBinding4.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding6;
            if (!(referenceBinding == this || referenceBinding == this.enclosingType() || referenceBinding.isTypeVariable() && (((TypeVariableBinding)(referenceBinding6 = (TypeVariableBinding)referenceBinding)).isErasureBoundTo(this.erasure()) || ((TypeVariableBinding)referenceBinding6).isErasureBoundTo(this.enclosingType().erasure())))) {
                return false;
            }
            if (referenceBinding2 != this) {
                referenceBinding6 = referenceBinding2;
                ReferenceBinding referenceBinding7 = referenceBinding6.enclosingType();
                while (referenceBinding7 != null) {
                    referenceBinding6 = referenceBinding7;
                    referenceBinding7 = referenceBinding7.enclosingType();
                }
                ReferenceBinding referenceBinding8 = (ReferenceBinding)this.erasure();
                referenceBinding7 = referenceBinding8.enclosingType();
                while (referenceBinding7 != null) {
                    referenceBinding8 = referenceBinding7;
                    referenceBinding7 = referenceBinding7.enclosingType();
                }
                if (referenceBinding6 != referenceBinding8) {
                    return false;
                }
            }
            return true;
        }
        if (referenceBinding2.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding referenceBinding9 = referenceBinding;
        ReferenceBinding referenceBinding10 = referenceBinding3 = this.enclosingType() == null ? this : this.enclosingType();
        do {
            if (referenceBinding3 == referenceBinding9) {
                return true;
            }
            PackageBinding packageBinding = referenceBinding9.fPackage;
            if (packageBinding == null || packageBinding == this.fPackage) continue;
            return false;
        } while ((referenceBinding9 = referenceBinding9.superclass()) != null);
        return false;
    }

    public final boolean canBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = this.enclosingType();
            if (referenceBinding2 == null) {
                return false;
            }
            do {
                if (referenceBinding2 == sourceTypeBinding) {
                    return true;
                }
                if (!referenceBinding2.isSuperclassOf(referenceBinding)) continue;
                return true;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding3 = referenceBinding.enclosingType();
            while (referenceBinding3 != null) {
                referenceBinding = referenceBinding3;
                referenceBinding3 = referenceBinding3.enclosingType();
            }
            ReferenceBinding referenceBinding4 = (ReferenceBinding)this.erasure();
            referenceBinding3 = referenceBinding4.enclosingType();
            while (referenceBinding3 != null) {
                referenceBinding4 = referenceBinding3;
                referenceBinding3 = referenceBinding3.enclosingType();
            }
            return referenceBinding == referenceBinding4;
        }
        return sourceTypeBinding.fPackage == this.fPackage;
    }

    public ReferenceBinding closestMatch() {
        return this;
    }

    public char[] computeGenericTypeSignature(TypeVariableBinding[] typeVariableBindingArray) {
        int n;
        char[] cArray;
        boolean bl;
        boolean bl2 = bl = this.isMemberType() && (this.enclosingType().modifiers & 0x40000000) != 0;
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES && !bl) {
            return this.signature();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (bl) {
            cArray = this.enclosingType().genericTypeSignature();
            n = 0;
            while (n < cArray.length - 1) {
                stringBuffer.append(cArray[n]);
                ++n;
            }
            stringBuffer.append('.');
            stringBuffer.append(this.sourceName);
        } else {
            cArray = this.signature();
            n = 0;
            while (n < cArray.length - 1) {
                stringBuffer.append(cArray[n]);
                ++n;
            }
        }
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('<');
            int n2 = 0;
            n = typeVariableBindingArray.length;
            while (n2 < n) {
                stringBuffer.append(typeVariableBindingArray[n2].genericTypeSignature());
                ++n2;
            }
            stringBuffer.append(">;");
        }
        int n3 = stringBuffer.length();
        char[] cArray2 = new char[n3];
        stringBuffer.getChars(0, n3, cArray2, 0);
        return cArray2;
    }

    public void computeId() {
        switch (this.compoundName.length) {
            case 1: 
            case 2: {
                char[] cArray;
                char[] cArray2 = cArray = this.compoundName.length > 1 && CharOperation.equals(this.compoundName[0], TypeConstants.SYSTEMJS) ? this.compoundName[1] : this.compoundName[0];
                if (cArray.length == 0) {
                    return;
                }
                switch (cArray[0]) {
                    case 'B': {
                        if (CharOperation.equals(cArray, TypeConstants.BOOLEAN_OBJECT[1])) {
                            this.id = 5;
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(cArray, TypeConstants.FUNCTION[1])) {
                            this.id = 14;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(cArray, TypeConstants.NUMBER[1])) {
                            this.id = 10;
                        }
                        return;
                    }
                    case 'O': {
                        if (CharOperation.equals(cArray, TypeConstants.JAVA_LANG_OBJECT[1])) {
                            this.id = 1;
                        }
                        return;
                    }
                    case 'S': {
                        if (CharOperation.equals(cArray, TypeConstants.JAVA_LANG_STRING[1])) {
                            this.id = 11;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(cArray, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    return;
                }
                char[] cArray = this.compoundName[2];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray3 = this.compoundName[3];
                if (cArray3.length == 0) {
                    return;
                }
                if (CharOperation.equals(cArray, TypeConstants.REFLECT)) {
                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR[3])) {
                        this.id = 20;
                    } else if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_FIELD[3])) {
                        this.id = 54;
                    } else if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_METHOD[3])) {
                        this.id = 55;
                    }
                    return;
                }
                if (!CharOperation.equals(cArray, TypeConstants.ANNOTATION)) break;
                switch (cArray3[0]) {
                    case 'A': {
                        if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                            this.id = 43;
                        }
                        return;
                    }
                    case 'D': {
                        if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                            this.id = 45;
                        }
                        return;
                    }
                    case 'E': {
                        if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                            this.id = 52;
                        }
                        return;
                    }
                    case 'I': {
                        if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED[3])) {
                            this.id = 46;
                        }
                        return;
                    }
                    case 'R': {
                        if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION[3])) {
                            this.id = 48;
                        } else if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                            this.id = 51;
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_TARGET[3])) {
                            this.id = 50;
                        }
                        return;
                    }
                }
            }
        }
    }

    public char[] computeUniqueKey(boolean bl) {
        if (!bl) {
            return this.signature();
        }
        return this.genericTypeSignature();
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    public String debugName() {
        return this.compoundName != null ? new String(this.readableName()) : "UNNAMED TYPE";
    }

    public final int depth() {
        int n = 0;
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.enclosingType()) != null) {
            ++n;
        }
        return n;
    }

    public boolean detectAnnotationCycle() {
        if ((this.tagBits & 0x100000000L) != 0L) {
            return false;
        }
        if ((this.tagBits & 0x80000000L) != 0L) {
            return true;
        }
        this.tagBits |= 0x80000000L;
        MethodBinding[] methodBindingArray = this.methods();
        boolean bl = false;
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodDeclaration methodDeclaration;
            TypeBinding typeBinding = methodBindingArray[n].returnType.leafComponentType();
            if (this == typeBinding) {
                if (this instanceof SourceTypeBinding) {
                    methodDeclaration = (MethodDeclaration)methodBindingArray[n].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, this, methodDeclaration != null ? methodDeclaration.returnType : null);
                }
            } else if (typeBinding.isAnnotationType() && ((ReferenceBinding)typeBinding).detectAnnotationCycle()) {
                if (this instanceof SourceTypeBinding) {
                    methodDeclaration = (MethodDeclaration)methodBindingArray[n].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, typeBinding, methodDeclaration != null ? methodDeclaration.returnType : null);
                }
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        this.tagBits |= 0x100000000L;
        return false;
    }

    public final ReferenceBinding enclosingTypeAt(int n) {
        ReferenceBinding referenceBinding = this;
        while (n-- > 0 && referenceBinding != null) {
            referenceBinding = referenceBinding.enclosingType();
        }
        return referenceBinding;
    }

    public int enumConstantCount() {
        int n = 0;
        FieldBinding[] fieldBindingArray = this.fields();
        int n2 = 0;
        int n3 = fieldBindingArray.length;
        while (n2 < n3) {
            if ((fieldBindingArray[n2].modifiers & 0x4000) != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return Binding.NO_FIELDS;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        ReferenceBinding[] referenceBindingArray = this.memberTypes();
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(referenceBindingArray[n].sourceName, cArray)) continue;
            return referenceBindingArray[n];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        return Binding.NO_METHODS;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        int n = typeVariableBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(typeVariableBindingArray[n].sourceName, cArray)) continue;
            return typeVariableBindingArray[n];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding referenceBinding) {
        int n;
        TypeBinding typeBinding;
        if (this == referenceBinding) {
            return false;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            if ((typeBinding = referenceBinding.findSuperTypeWithSameErasure(referenceBinding2)) != null && !typeBinding.isIntersectingWith(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray2 = referenceBinding2.superInterfaces();
            if (referenceBindingArray2 == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            n = 0;
            while (n < n3) {
                block16: {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    int n4 = 0;
                    while (n4 < n2) {
                        if (referenceBinding3 != referenceBindingArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block16;
                    }
                    referenceBindingArray[n2++] = referenceBinding3;
                }
                ++n;
            }
        } while ((referenceBinding2 = referenceBinding2.superclass()) != null);
        int n5 = 0;
        while (n5 < n2) {
            referenceBinding2 = referenceBindingArray[n5];
            if (referenceBinding2 == referenceBinding) {
                return false;
            }
            typeBinding = referenceBinding.findSuperTypeWithSameErasure(referenceBinding2);
            if (typeBinding != null && !typeBinding.isIntersectingWith(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 != null && referenceBindingArray4 != Binding.NO_SUPERINTERFACES) {
                n = referenceBindingArray4.length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                }
                int n6 = 0;
                while (n6 < n) {
                    block17: {
                        ReferenceBinding referenceBinding4 = referenceBindingArray4[n6];
                        int n7 = 0;
                        while (n7 < n2) {
                            if (referenceBinding4 != referenceBindingArray[n7]) {
                                ++n7;
                                continue;
                            }
                            break block17;
                        }
                        referenceBindingArray[n2++] = referenceBinding4;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return false;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean implementsInterface(ReferenceBinding referenceBinding, boolean bl) {
        int n;
        if (this == referenceBinding) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            ReferenceBinding[] referenceBindingArray2;
            if ((referenceBindingArray2 = referenceBinding2.superInterfaces()) == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            n = 0;
            while (n < n3) {
                block14: {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    int n4 = 0;
                    while (n4 < n2) {
                        if (referenceBinding3 != referenceBindingArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block14;
                    }
                    referenceBindingArray[n2++] = referenceBinding3;
                }
                ++n;
            }
        } while (bl && (referenceBinding2 = referenceBinding2.superclass()) != null);
        int n5 = 0;
        while (n5 < n2) {
            referenceBinding2 = referenceBindingArray[n5];
            if (referenceBinding2.isEquivalentTo(referenceBinding)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 != null && referenceBindingArray4 != Binding.NO_SUPERINTERFACES) {
                n = referenceBindingArray4.length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                }
                int n6 = 0;
                while (n6 < n) {
                    block15: {
                        ReferenceBinding referenceBinding4 = referenceBindingArray4[n6];
                        int n7 = 0;
                        while (n7 < n2) {
                            if (referenceBinding4 != referenceBindingArray[n7]) {
                                ++n7;
                                continue;
                            }
                            break block15;
                        }
                        referenceBindingArray[n2++] = referenceBinding4;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding methodBinding) {
        char[] cArray = methodBinding.selector;
        ReferenceBinding referenceBinding = this;
        while (referenceBinding != null) {
            MethodBinding[] methodBindingArray = referenceBinding.methods();
            long l = ReferenceBinding.binarySearch(cArray, methodBindingArray);
            if (l >= 0L) {
                int n = (int)l;
                int n2 = (int)(l >> 32);
                int n3 = n;
                while (n3 <= n2) {
                    if (methodBindingArray[n3].areParametersEqual(methodBinding)) {
                        return true;
                    }
                    ++n3;
                }
            }
            referenceBinding = referenceBinding.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    public boolean isCompatibleWith(TypeBinding typeBinding) {
        if (typeBinding == this) {
            return true;
        }
        if (typeBinding.id == 1 || typeBinding.id == 13) {
            return true;
        }
        if (this.compatibleCache == null) {
            this.compatibleCache = new SimpleLookupTable(3);
            Object var2_2 = null;
        } else {
            Object object = this.compatibleCache.get(typeBinding);
            if (object != null) {
                return object == Boolean.TRUE;
            }
        }
        this.compatibleCache.put(typeBinding, Boolean.FALSE);
        if (this.isCompatibleWith0(typeBinding)) {
            this.compatibleCache.put(typeBinding, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private boolean isCompatibleWith0(TypeBinding typeBinding) {
        if (typeBinding == this) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: {
                return false;
            }
            case 4100: {
                ReferenceBinding referenceBinding;
                if (typeBinding.isCapture()) {
                    referenceBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = ((CaptureBinding)referenceBinding).lowerBound;
                    if (typeBinding2 != null) {
                        if (typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2);
                    }
                }
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: {
                switch (this.kind()) {
                    case 260: 
                    case 1028: 
                    case 2052: {
                        if (this.erasure() != typeBinding.erasure()) break;
                        return false;
                    }
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                if (referenceBinding.isInterface()) {
                    return this.implementsInterface(referenceBinding, true);
                }
                if (this.isInterface()) {
                    return false;
                }
                if (Arrays.equals((Object[])this.compoundName, (Object[])referenceBinding.compoundName) && Arrays.equals(this.fileName, referenceBinding.fileName)) {
                    return true;
                }
                return referenceBinding.isSuperclassOf(this);
            }
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            if (!referenceBinding.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowable() {
        ReferenceBinding referenceBinding = this;
        do {
            switch (referenceBinding.id) {
                case 19: 
                case 21: 
                case 24: 
                case 25: {
                    return true;
                }
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public boolean isUncheckedException(boolean bl) {
        switch (this.id) {
            case 19: 
            case 24: {
                return true;
            }
            case 21: 
            case 25: {
                return bl;
            }
        }
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            switch (referenceBinding.id) {
                case 19: 
                case 24: {
                    return true;
                }
                case 21: 
                case 25: {
                    return false;
                }
            }
        }
        return false;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0 || (this.getPackage().tagBits & 0x400000000000L) != 0L;
    }

    public ReferenceBinding[] memberTypes() {
        return Binding.NO_MEMBER_TYPES;
    }

    public MethodBinding[] methods() {
        return Binding.NO_METHODS;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding referenceBinding;
        ReferenceBinding referenceBinding2 = this;
        do {
            referenceBinding = referenceBinding2;
        } while ((referenceBinding2 = referenceBinding2.enclosingType()) != null);
        return referenceBinding;
    }

    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    public char[] readableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].readableName());
                ++n;
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
        return simpleLookupTable == null ? null : (AnnotationHolder)simpleLookupTable.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder annotationHolder = this.retrieveAnnotationHolder(binding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getAnnotations();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.storeAnnotations(this, annotationBindingArray);
    }

    public char[] shortReadableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName;
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].shortReadableName());
                ++n;
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder annotationHolder) {
        if (annotationHolder == null) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
            if (simpleLookupTable != null) {
                simpleLookupTable.removeKey(binding);
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true);
            if (simpleLookupTable != null) {
                simpleLookupTable.put(binding, annotationHolder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotationBindingArray) {
        AnnotationHolder annotationHolder = null;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
            if (simpleLookupTable != null) {
                annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            }
            if (annotationHolder == null) {
                return;
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true);
            if (simpleLookupTable == null) {
                return;
            }
            annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            if (annotationHolder == null) {
                annotationHolder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, annotationHolder.setAnnotations(annotationBindingArray));
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        return null;
    }

    public ReferenceBinding superclass() {
        return null;
    }

    public ReferenceBinding[] superInterfaces() {
        return Binding.NO_SUPERINTERFACES;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding == null) {
            return null;
        }
        return new ReferenceBinding[]{referenceBinding};
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return null;
    }

    public InferredType getInferredType() {
        return null;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }
}

