/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.text.NumberFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferFactory;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.internal.core.Buffer;
import org.eclipse.wst.jsdt.internal.core.BufferCache;
import org.eclipse.wst.jsdt.internal.core.NullBuffer;
import org.eclipse.wst.jsdt.internal.core.Openable;

public class BufferManager {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected static boolean VERBOSE;
    private BufferCache openBuffers = new BufferCache(60);
    protected IBufferFactory defaultBufferFactory = new IBufferFactory(){

        public IBuffer createBuffer(IOpenable iOpenable) {
            return BufferManager.createBuffer(iOpenable);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBuffer(IBuffer iBuffer) {
        Object object;
        if (VERBOSE) {
            object = ((Openable)iBuffer.getOwner()).toStringWithAncestors();
            System.out.println("Adding buffer for " + (String)object);
        }
        object = this.openBuffers;
        synchronized (object) {
            this.openBuffers.put(iBuffer.getOwner(), iBuffer);
        }
        this.openBuffers.closeBuffers();
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }

    public static IBuffer createBuffer(IOpenable iOpenable) {
        IJavaElement iJavaElement = (IJavaElement)((Object)iOpenable);
        IResource iResource = iJavaElement.getResource();
        return new Buffer(iResource instanceof IFile ? (IFile)iResource : null, iOpenable, iJavaElement.isReadOnly());
    }

    public static IBuffer createNullBuffer(IOpenable iOpenable) {
        IJavaElement iJavaElement = (IJavaElement)((Object)iOpenable);
        IResource iResource = iJavaElement.getResource();
        return new NullBuffer(iResource instanceof IFile ? (IFile)iResource : null, iOpenable, iJavaElement.isReadOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBuffer getBuffer(IOpenable iOpenable) {
        BufferCache bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            return (IBuffer)this.openBuffers.get(iOpenable);
        }
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this.defaultBufferFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        Enumeration enumeration;
        BufferCache bufferCache = this.openBuffers;
        synchronized (bufferCache) {
            this.openBuffers.shrink();
            enumeration = this.openBuffers.elements();
        }
        this.openBuffers.closeBuffers();
        return enumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBuffer(IBuffer iBuffer) {
        Object object;
        if (VERBOSE) {
            object = ((Openable)iBuffer.getOwner()).toStringWithAncestors();
            System.out.println("Removing buffer for " + (String)object);
        }
        object = this.openBuffers;
        synchronized (object) {
            this.openBuffers.remove(iBuffer.getOwner());
        }
        this.openBuffers.closeBuffers();
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }
}

