/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragment;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IJavaElement[] iJavaElementArray, boolean bl) {
        super(iJavaElementArray, bl);
    }

    private void deletePackageFragment(IPackageFragment iPackageFragment) throws JavaModelException {
        IResource iResource = iPackageFragment.getResource();
        if (iResource != null) {
            IResource iResource2;
            IResource[] iResourceArray;
            int n;
            Object[] objectArray;
            IJavaElement[] iJavaElementArray = iPackageFragment.getChildren();
            if (iJavaElementArray.length > 0) {
                objectArray = new IResource[iJavaElementArray.length];
                n = 0;
                while (n < iJavaElementArray.length) {
                    objectArray[n] = iJavaElementArray[n].getCorrespondingResource();
                    ++n;
                }
                this.deleteResources((IResource[])objectArray, this.force);
            }
            objectArray = iPackageFragment.getNonJavaResources();
            n = 0;
            int n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3) {
                if (objectArray[n2] instanceof IResource) {
                    ++n;
                }
                ++n2;
            }
            IResource[] iResourceArray2 = new IResource[n];
            n3 = 0;
            int n4 = objectArray.length;
            int n5 = 0;
            while (n3 < n4) {
                if (objectArray[n3] instanceof IResource) {
                    iResourceArray2[n5++] = (IResource)objectArray[n3];
                }
                ++n3;
            }
            this.deleteResources(iResourceArray2, this.force);
            try {
                iResourceArray = ((IContainer)iResource).members();
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
            n4 = 1;
            n5 = 0;
            int n6 = iResourceArray.length;
            while (n5 < n6) {
                IResource iResource3 = iResourceArray[n5];
                if (iResource3 instanceof IFile && Util.isClassFileName(iResource3.getName())) {
                    this.deleteResource(iResource3, 3);
                } else {
                    n4 = 0;
                }
                ++n5;
            }
            if (n4 != 0 && !iPackageFragment.isDefaultPackage() && (iResource2 = iPackageFragment.getResource()) != null) {
                this.deleteEmptyPackageFragment(iPackageFragment, false, (IResource)iResource2.getParent());
            }
        }
    }

    protected String getMainTaskName() {
        return Messages.operation_deleteResourceProgress;
    }

    protected void processElement(IJavaElement iJavaElement) throws JavaModelException {
        switch (iJavaElement.getElementType()) {
            case 5: 
            case 6: {
                this.deleteResource(iJavaElement.getResource(), this.force ? 3 : 2);
                break;
            }
            case 4: {
                this.deletePackageFragment((IPackageFragment)iJavaElement);
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, iJavaElement));
            }
        }
        if (iJavaElement instanceof IOpenable) {
            ((IOpenable)((Object)iJavaElement)).close();
        }
    }

    protected void verify(IJavaElement iJavaElement) throws JavaModelException {
        int n;
        if (iJavaElement == null || !iJavaElement.exists()) {
            this.error(969, iJavaElement);
        }
        if ((n = iJavaElement.getElementType()) <= 3 || n > 5) {
            this.error(967, iJavaElement);
        } else if (n == 4 && iJavaElement instanceof JarPackageFragment) {
            this.error(967, iJavaElement);
        }
        IResource iResource = iJavaElement.getResource();
        if (iResource instanceof IFolder && iResource.isLinked()) {
            this.error(995, iJavaElement);
        }
    }
}

