/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.core.ClasspathChange;
import org.eclipse.wst.jsdt.internal.core.ClasspathValidation;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessingState;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessor;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.JavaProjectElementInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.ModelUpdater;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.ProjectReferenceChange;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.search.AbstractSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class DeltaProcessor {
    private static final int IGNORE = 0;
    private static final int SOURCE = 1;
    private static final int BINARY = 2;
    private static final String EXTERNAL_JAR_ADDED = "external jar added";
    private static final String EXTERNAL_JAR_CHANGED = "external jar changed";
    private static final String EXTERNAL_JAR_REMOVED = "external jar removed";
    private static final String EXTERNAL_JAR_UNCHANGED = "external jar unchanged";
    private static final String INTERNAL_JAR_IGNORE = "internal jar ignore";
    private static final int NON_JAVA_RESOURCE = -1;
    public static boolean DEBUG = false;
    public static boolean VERBOSE = false;
    public static boolean PERF = false;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private DeltaProcessingState state;
    JavaModelManager manager;
    private JavaElementDelta currentDelta;
    private Openable currentElement;
    public ArrayList javaModelDeltas = new ArrayList();
    public HashMap reconcileDeltas = new HashMap();
    private boolean isFiring = true;
    private final ModelUpdater modelUpdater = new ModelUpdater();
    public HashSet projectCachesToReset = new HashSet();
    private HashSet refreshedElements;
    public Map oldRoots;
    private HashSet rootsToRefresh = new HashSet();
    public int overridenEventType = -1;
    private SourceElementParser sourceElementParserCache;
    public HashMap classpathChanges = new HashMap();

    public static long getTimeStamp(File file) {
        return file.lastModified() + file.length();
    }

    public DeltaProcessor(DeltaProcessingState deltaProcessingState, JavaModelManager javaModelManager) {
        this.state = deltaProcessingState;
        this.manager = javaModelManager;
    }

    public ClasspathChange addClasspathChange(IProject iProject, IClasspathEntry[] iClasspathEntryArray, IPath iPath, IClasspathEntry[] iClasspathEntryArray2) {
        ClasspathChange classpathChange = (ClasspathChange)this.classpathChanges.get(iProject);
        if (classpathChange == null) {
            classpathChange = new ClasspathChange((JavaProject)this.manager.getJavaModel().getJavaProject((IResource)iProject), iClasspathEntryArray, iPath, iClasspathEntryArray2);
            this.classpathChanges.put(iProject, classpathChange);
        } else {
            if (classpathChange.oldRawClasspath == null) {
                classpathChange.oldRawClasspath = iClasspathEntryArray;
            }
            if (classpathChange.oldOutputLocation == null) {
                classpathChange.oldOutputLocation = iPath;
            }
            if (classpathChange.oldResolvedClasspath == null) {
                classpathChange.oldResolvedClasspath = iClasspathEntryArray2;
            }
        }
        return classpathChange;
    }

    private void addDependentProjects(IJavaProject iJavaProject, HashMap hashMap, HashSet hashSet) {
        IJavaProject[] iJavaProjectArray = (IJavaProject[])hashMap.get(iJavaProject);
        if (iJavaProjectArray == null) {
            return;
        }
        int n = 0;
        int n2 = iJavaProjectArray.length;
        while (n < n2) {
            IJavaProject iJavaProject2 = iJavaProjectArray[n];
            if (!hashSet.contains(iJavaProject2)) {
                hashSet.add(iJavaProject2);
                this.addDependentProjects(iJavaProject2, hashMap, hashSet);
            }
            ++n;
        }
    }

    public void addForRefresh(IJavaElement iJavaElement) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(iJavaElement);
    }

    private void addToParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                JavaElementInfo javaElementInfo = (JavaElementInfo)openable2.getElementInfo();
                javaElementInfo.addChild(openable);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void addToRootsToRefreshWithDependents(IJavaProject iJavaProject) {
        this.rootsToRefresh.add(iJavaProject);
        this.addDependentProjects(iJavaProject, this.state.projectDependencies, this.rootsToRefresh);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkExternalArchiveChanges(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("", 1);
            }
            int n = 0;
            int n2 = iJavaElementArray.length;
            while (n < n2) {
                this.addForRefresh(iJavaElementArray[n]);
                ++n;
            }
            n = this.createExternalArchiveDelta(iProgressMonitor) ? 1 : 0;
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                Object var10_6 = null;
                this.currentDelta = null;
                if (iProgressMonitor == null) return;
                iProgressMonitor.done();
                return;
            }
            if (n != 0) {
                JavaModel.flushExternalFileCache();
                JavaModelManager.getJavaModelManager().resetJarTypeCache();
                IJavaElementDelta[] iJavaElementDeltaArray = this.currentDelta.getAffectedChildren();
                final int n3 = iJavaElementDeltaArray.length;
                final IProject[] iProjectArray = new IProject[n3];
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElementDelta iJavaElementDelta = iJavaElementDeltaArray[n4];
                    JavaProject javaProject = (JavaProject)iJavaElementDelta.getElement();
                    iProjectArray[n4] = javaProject.getProject();
                    ++n4;
                }
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        int n = 0;
                        while (n < n3) {
                            IProject iProject = iProjectArray[n];
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Touching project " + iProject.getName() + " due to external jar file change");
                            }
                            iProject.touch(iProgressMonitor);
                            ++n;
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new JavaModelException(coreException);
                }
                if (this.currentDelta != null) {
                    this.fire(this.currentDelta, 0);
                }
            }
            Object var10_8 = null;
            this.currentDelta = null;
            if (iProgressMonitor == null) return;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.currentDelta = null;
            if (iProgressMonitor == null) throw throwable;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    private void checkProjectsBeingAddedOrRemoved(IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        IResourceDelta[] iResourceDeltaArray = null;
        switch (iResource.getType()) {
            case 8: {
                this.state.getOldJavaProjecNames();
                iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                break;
            }
            case 4: {
                int n;
                IProject iProject = (IProject)iResource;
                JavaProject javaProject = (JavaProject)JavaCore.create(iProject);
                switch (iResourceDelta.getKind()) {
                    case 1: {
                        this.manager.batchContainerInitializations = true;
                        this.addToRootsToRefreshWithDependents(javaProject);
                        if (JavaProject.hasJavaNature(iProject)) {
                            this.addToParentInfo(javaProject);
                            this.readRawClasspath(javaProject);
                            this.checkProjectReferenceChange(iProject, javaProject);
                        }
                        this.state.rootsAreStale = true;
                        break;
                    }
                    case 4: {
                        if ((iResourceDelta.getFlags() & 0x4000) != 0) {
                            this.manager.batchContainerInitializations = true;
                            this.addToRootsToRefreshWithDependents(javaProject);
                            if (iProject.isOpen()) {
                                if (JavaProject.hasJavaNature(iProject)) {
                                    this.addToParentInfo(javaProject);
                                    this.readRawClasspath(javaProject);
                                    this.checkProjectReferenceChange(iProject, javaProject);
                                }
                            } else {
                                try {
                                    javaProject.close();
                                }
                                catch (JavaModelException javaModelException) {}
                                this.removeFromParentInfo(javaProject);
                                this.manager.removePerProjectInfo(javaProject);
                                this.manager.containerRemove(javaProject);
                            }
                            this.state.rootsAreStale = true;
                            break;
                        }
                        if ((iResourceDelta.getFlags() & 0x80000) != 0) {
                            int n2 = this.state.findJavaProject(iProject.getName()) != null ? 1 : 0;
                            if (n2 != (n = (int)(JavaProject.hasJavaNature(iProject) ? 1 : 0))) {
                                this.manager.batchContainerInitializations = true;
                                this.addToRootsToRefreshWithDependents(javaProject);
                                if (n != 0) {
                                    this.addToParentInfo(javaProject);
                                    this.readRawClasspath(javaProject);
                                    this.checkProjectReferenceChange(iProject, javaProject);
                                } else {
                                    this.manager.removePerProjectInfo(javaProject);
                                    this.manager.containerRemove(javaProject);
                                    try {
                                        javaProject.close();
                                    }
                                    catch (JavaModelException javaModelException) {}
                                    this.removeFromParentInfo(javaProject);
                                }
                                this.state.rootsAreStale = true;
                                break;
                            }
                            if (n == 0) break;
                            this.addToParentInfo(javaProject);
                            iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                            break;
                        }
                        if (!JavaProject.hasJavaNature(iProject)) break;
                        this.addToParentInfo(javaProject);
                        iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                        break;
                    }
                    case 2: {
                        this.manager.batchContainerInitializations = true;
                        this.manager.removePerProjectInfo(javaProject);
                        this.manager.containerRemove(javaProject);
                        this.state.rootsAreStale = true;
                    }
                }
                this.addForRefresh(javaProject);
                break;
            }
            case 1: {
                int n;
                JavaProject javaProject;
                IFile iFile = (IFile)iResource;
                if (!iFile.getName().equals(".jsdtscope")) break;
                this.manager.batchContainerInitializations = true;
                switch (iResourceDelta.getKind()) {
                    case 4: {
                        n = iResourceDelta.getFlags();
                        if ((n & 0x100) == 0 && (n & 0x100000) == 0 && (n & 0x1000) == 0) break;
                    }
                    case 1: {
                        javaProject = (JavaProject)JavaCore.create(iFile.getProject());
                        try {
                            javaProject.getPerProjectInfo().readAndCacheClasspath(javaProject);
                            break;
                        }
                        catch (JavaModelException javaModelException) {
                            return;
                        }
                    }
                }
                this.state.rootsAreStale = true;
            }
        }
        if (iResourceDeltaArray != null) {
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                this.checkProjectsBeingAddedOrRemoved(iResourceDeltaArray[n]);
                ++n;
            }
        }
    }

    private void checkProjectReferenceChange(IProject iProject, JavaProject javaProject) {
        ClasspathChange classpathChange = (ClasspathChange)this.classpathChanges.get(iProject);
        this.state.addProjectReferenceChange(javaProject, classpathChange == null ? null : classpathChange.oldResolvedClasspath);
    }

    private void readRawClasspath(JavaProject javaProject) {
        block2: {
            try {
                javaProject.getPerProjectInfo().readAndCacheClasspath(javaProject);
            }
            catch (JavaModelException javaModelException) {
                if (!VERBOSE) break block2;
                javaModelException.printStackTrace();
            }
        }
    }

    private void checkSourceAttachmentChange(IResourceDelta iResourceDelta, IResource iResource) {
        RootInfo rootInfo;
        IPath iPath = (IPath)this.state.sourceAttachments.get(iResource.getFullPath());
        if (iPath != null && (rootInfo = this.rootInfo(iPath, iResourceDelta.getKind())) != null) {
            JavaProject javaProject = rootInfo.project;
            IPackageFragmentRoot iPackageFragmentRoot = null;
            try {
                iPackageFragmentRoot = javaProject.findPackageFragmentRoot(iPath);
                if (iPackageFragmentRoot != null) {
                    iPackageFragmentRoot.close();
                }
            }
            catch (JavaModelException javaModelException) {}
            if (iPackageFragmentRoot == null) {
                return;
            }
            switch (iResourceDelta.getKind()) {
                case 1: {
                    this.currentDelta().sourceAttached(iPackageFragmentRoot);
                    break;
                }
                case 4: {
                    this.currentDelta().sourceDetached(iPackageFragmentRoot);
                    this.currentDelta().sourceAttached(iPackageFragmentRoot);
                    break;
                }
                case 2: {
                    this.currentDelta().sourceDetached(iPackageFragmentRoot);
                }
            }
        }
    }

    private void close(Openable openable) {
        try {
            openable.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    private void contentChanged(Openable openable) {
        boolean bl = false;
        boolean bl2 = false;
        if (openable.getElementType() == 5) {
            CompilationUnit compilationUnit = (CompilationUnit)openable;
            bl = compilationUnit.isPrimary();
            boolean bl3 = bl2 = bl && compilationUnit.isWorkingCopy();
        }
        if (bl2) {
            this.currentDelta().changed(openable, 262144);
        } else {
            this.close(openable);
            int n = 1;
            if (openable instanceof JarPackageFragmentRoot) {
                n |= 0x8000;
                this.projectCachesToReset.add(openable.getJavaProject());
            }
            if (bl) {
                n |= 0x40000;
            }
            this.currentDelta().changed(openable, n);
        }
    }

    private Openable createElement(IResource iResource, int n, RootInfo rootInfo) {
        if (iResource == null) {
            return null;
        }
        IPath iPath = iResource.getFullPath();
        IJavaElement iJavaElement = null;
        switch (n) {
            case 2: {
                if (!(iResource instanceof IProject)) break;
                this.popUntilPrefixOf(iPath);
                if (this.currentElement != null && this.currentElement.getElementType() == 2 && ((IJavaProject)((Object)this.currentElement)).getProject().equals((Object)iResource)) {
                    return this.currentElement;
                }
                if (rootInfo != null && rootInfo.project.getProject().equals((Object)iResource)) {
                    iJavaElement = rootInfo.project;
                    break;
                }
                IProject iProject = (IProject)iResource;
                if (JavaProject.hasJavaNature(iProject)) {
                    iJavaElement = JavaCore.create(iProject);
                    break;
                }
                iJavaElement = this.state.findJavaProject(iProject.getName());
                break;
            }
            case 3: {
                iJavaElement = rootInfo == null ? JavaCore.create(iResource) : rootInfo.getPackageFragmentRoot(iResource);
                break;
            }
            case 4: {
                if (rootInfo != null) {
                    if (!rootInfo.project.contains(iResource)) break;
                    PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)rootInfo.getPackageFragmentRoot(null);
                    IPath iPath2 = iPath.removeFirstSegments(rootInfo.rootPath.segmentCount());
                    String[] stringArray = iPath2.segments();
                    iJavaElement = packageFragmentRoot.getPackageFragment(stringArray);
                    break;
                }
                this.popUntilPrefixOf(iPath);
                if (this.currentElement == null) {
                    iJavaElement = JavaCore.create(iResource);
                    break;
                }
                PackageFragmentRoot packageFragmentRoot = this.currentElement.getPackageFragmentRoot();
                if (packageFragmentRoot == null) {
                    iJavaElement = JavaCore.create(iResource);
                    break;
                }
                if (!((JavaProject)packageFragmentRoot.getJavaProject()).contains(iResource)) break;
                IPath iPath3 = iPath.removeFirstSegments(packageFragmentRoot.getPath().segmentCount());
                String[] stringArray = iPath3.segments();
                iJavaElement = packageFragmentRoot.getPackageFragment(stringArray);
                break;
            }
            case 5: 
            case 6: {
                Object object;
                this.popUntilPrefixOf(iPath);
                if (this.currentElement == null) {
                    iJavaElement = rootInfo == null ? JavaCore.create(iResource) : JavaModelManager.create(iResource, (IJavaProject)rootInfo.project);
                    break;
                }
                IPackageFragment iPackageFragment = null;
                switch (this.currentElement.getElementType()) {
                    case 3: {
                        object = (PackageFragmentRoot)this.currentElement;
                        IPath iPath4 = ((PackageFragmentRoot)object).getPath();
                        IPath iPath5 = iPath.removeLastSegments(1);
                        String[] stringArray = iPath5.removeFirstSegments(iPath4.segmentCount()).segments();
                        iPackageFragment = ((PackageFragmentRoot)object).getPackageFragment(stringArray);
                        break;
                    }
                    case 4: {
                        Openable openable = this.currentElement;
                        if (!openable.getPath().equals((Object)iPath.removeLastSegments(1))) break;
                        iPackageFragment = (IPackageFragment)((Object)openable);
                        break;
                    }
                    case 5: 
                    case 6: {
                        iPackageFragment = (IPackageFragment)this.currentElement.getParent();
                    }
                }
                if (iPackageFragment == null) {
                    iJavaElement = rootInfo == null ? JavaCore.create(iResource) : JavaModelManager.create(iResource, (IJavaProject)rootInfo.project);
                    break;
                }
                if (n == 5) {
                    object = iPath.lastSegment();
                    iJavaElement = iPackageFragment.getCompilationUnit((String)object);
                    break;
                }
                object = iPath.lastSegment();
                iJavaElement = iPackageFragment.getClassFile((String)object);
            }
        }
        if (iJavaElement == null) {
            return null;
        }
        this.currentElement = (Openable)iJavaElement;
        return this.currentElement;
    }

    private boolean createExternalArchiveDelta(IProgressMonitor iProgressMonitor) {
        int n;
        IClasspathEntry[] iClasspathEntryArray;
        IClasspathEntry[] iClasspathEntryArray2;
        Object object;
        Object object2;
        if (this.refreshedElements == null) {
            return false;
        }
        HashMap<IPath, String> hashMap = new HashMap<IPath, String>();
        boolean bl = false;
        HashSet<IPath> hashSet = new HashSet<IPath>();
        Iterator iterator = this.refreshedElements.iterator();
        this.refreshedElements = null;
        block11: while (iterator.hasNext()) {
            object2 = (IJavaElement)iterator.next();
            switch (object2.getElementType()) {
                case 3: {
                    hashSet.add(object2.getPath());
                    break;
                }
                case 2: {
                    object = (JavaProject)object2;
                    if (!JavaProject.hasJavaNature(((JavaProject)object).getProject())) continue block11;
                    try {
                        iClasspathEntryArray2 = ((JavaProject)object).getResolvedClasspath();
                        int n2 = 0;
                        int n3 = iClasspathEntryArray2.length;
                        while (n2 < n3) {
                            if (iClasspathEntryArray2[n2].getEntryKind() == 1) {
                                hashSet.add(iClasspathEntryArray2[n2].getPath());
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    continue block11;
                }
                case 1: {
                    Iterator iterator2 = this.state.getOldJavaProjecNames().iterator();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        iClasspathEntryArray = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
                        if (!JavaProject.hasJavaNature((IProject)iClasspathEntryArray)) continue;
                        object = (JavaProject)JavaCore.create((IProject)iClasspathEntryArray);
                        try {
                            iClasspathEntryArray2 = ((JavaProject)object).getResolvedClasspath();
                        }
                        catch (JavaModelException javaModelException) {
                            continue;
                        }
                        n = 0;
                        int n4 = iClasspathEntryArray2.length;
                        while (n < n4) {
                            if (iClasspathEntryArray2[n].getEntryKind() == 1) {
                                hashSet.add(iClasspathEntryArray2[n].getPath());
                            }
                            ++n;
                        }
                    }
                    continue block11;
                }
            }
        }
        object2 = this.state.getOldJavaProjecNames().iterator();
        object = ResourcesPlugin.getWorkspace().getRoot();
        while (object2.hasNext()) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) break;
            iClasspathEntryArray2 = (IClasspathEntry[])object2.next();
            IProject iProject = object.getProject((String)iClasspathEntryArray2);
            if (!JavaProject.hasJavaNature(iProject)) continue;
            JavaProject javaProject = (JavaProject)JavaCore.create(iProject);
            try {
                iClasspathEntryArray = javaProject.getResolvedClasspath();
            }
            catch (JavaModelException javaModelException) {
                continue;
            }
            n = 0;
            while (n < iClasspathEntryArray.length) {
                IPath iPath;
                if (iClasspathEntryArray[n].getEntryKind() == 1 && hashSet.contains(iPath = iClasspathEntryArray[n].getPath())) {
                    Object object3;
                    String string = (String)hashMap.get(iPath);
                    if (string == null) {
                        object3 = JavaModel.getTarget((IContainer)object, iPath, true);
                        if (object3 == null) {
                            if (this.state.getExternalLibTimeStamps().remove(iPath) != null) {
                                hashMap.put(iPath, EXTERNAL_JAR_REMOVED);
                                this.manager.indexManager.removeIndex(iPath);
                            }
                        } else if (object3 instanceof File) {
                            File file = (File)object3;
                            Long l = (Long)this.state.getExternalLibTimeStamps().get(iPath);
                            long l2 = DeltaProcessor.getTimeStamp(file);
                            if (l != null) {
                                if (l2 == 0L) {
                                    hashMap.put(iPath, EXTERNAL_JAR_REMOVED);
                                    this.state.getExternalLibTimeStamps().remove(iPath);
                                    this.manager.indexManager.removeIndex(iPath);
                                } else if (l != l2) {
                                    hashMap.put(iPath, EXTERNAL_JAR_CHANGED);
                                    this.state.getExternalLibTimeStamps().put(iPath, new Long(l2));
                                    this.manager.indexManager.removeIndex(iPath);
                                    this.manager.indexManager.indexLibrary(iClasspathEntryArray[n], iProject.getProject());
                                } else {
                                    hashMap.put(iPath, EXTERNAL_JAR_UNCHANGED);
                                }
                            } else if (l2 == 0L) {
                                hashMap.put(iPath, EXTERNAL_JAR_UNCHANGED);
                            } else {
                                hashMap.put(iPath, EXTERNAL_JAR_ADDED);
                                this.state.getExternalLibTimeStamps().put(iPath, new Long(l2));
                                this.manager.indexManager.indexLibrary(iClasspathEntryArray[n], iProject.getProject());
                            }
                        } else {
                            hashMap.put(iPath, INTERNAL_JAR_IGNORE);
                        }
                    }
                    if ((string = (String)hashMap.get(iPath)) != null) {
                        if (string == EXTERNAL_JAR_ADDED) {
                            object3 = (PackageFragmentRoot)javaProject.getPackageFragmentRoot(iPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR ADDED, affecting root: " + ((PackageFragmentRoot)object3).getElementName());
                            }
                            this.elementAdded((Openable)object3, null, null);
                            this.state.addClasspathValidation(javaProject);
                            bl = true;
                        } else if (string == EXTERNAL_JAR_CHANGED) {
                            object3 = (PackageFragmentRoot)javaProject.getPackageFragmentRoot(iPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR CHANGED, affecting root: " + ((PackageFragmentRoot)object3).getElementName());
                            }
                            this.contentChanged((Openable)object3);
                            bl = true;
                        } else if (string == EXTERNAL_JAR_REMOVED) {
                            object3 = (PackageFragmentRoot)javaProject.getPackageFragmentRoot(iPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR REMOVED, affecting root: " + ((PackageFragmentRoot)object3).getElementName());
                            }
                            this.elementRemoved((Openable)object3, null, null);
                            this.state.addClasspathValidation(javaProject);
                            bl = true;
                        }
                    }
                }
                ++n;
            }
        }
        return bl;
    }

    private JavaElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new JavaElementDelta(this.manager.getJavaModel());
        }
        return this.currentDelta;
    }

    private void deleting(IProject iProject) {
        try {
            this.manager.indexManager.discardJobs(iProject.getName());
            JavaProject javaProject = (JavaProject)JavaCore.create(iProject);
            if (this.oldRoots == null) {
                this.oldRoots = new HashMap();
            }
            if (javaProject.isOpen()) {
                this.oldRoots.put(javaProject, javaProject.getPackageFragmentRoots());
            } else {
                this.oldRoots.put(javaProject, javaProject.computePackageFragmentRoots(javaProject.getResolvedClasspath(), false, null));
            }
            javaProject.close();
            this.state.getOldJavaProjecNames();
            this.removeFromParentInfo(javaProject);
            this.manager.resetProjectPreferences(javaProject);
        }
        catch (JavaModelException javaModelException) {}
    }

    private void elementAdded(Openable openable, IResourceDelta iResourceDelta, RootInfo rootInfo) {
        int n = openable.getElementType();
        if (n == 2) {
            if (iResourceDelta != null && JavaProject.hasJavaNature((IProject)iResourceDelta.getResource())) {
                this.addToParentInfo(openable);
                if ((iResourceDelta.getFlags() & 0x1000) != 0) {
                    Openable openable2 = (Openable)((Object)openable.getJavaModel().getJavaProject(iResourceDelta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(openable, openable2);
                } else {
                    this.close(openable);
                    this.currentDelta().added(openable);
                }
                this.state.updateRoots(openable.getPath(), iResourceDelta, this);
                this.rootsToRefresh.add(openable);
                this.projectCachesToReset.add(openable);
            }
        } else {
            Object object;
            if (iResourceDelta == null || (iResourceDelta.getFlags() & 0x1000) == 0) {
                if (this.isPrimaryWorkingCopy(openable, n)) {
                    this.currentDelta().changed(openable, 262144);
                } else {
                    this.addToParentInfo(openable);
                    this.close(openable);
                    this.currentDelta().added(openable);
                }
            } else {
                Openable openable3;
                this.addToParentInfo(openable);
                this.close(openable);
                object = iResourceDelta.getMovedFromPath();
                IResource iResource = iResourceDelta.getResource();
                Object object2 = iResource instanceof IFile ? iResource.getWorkspace().getRoot().getFile(object) : iResource.getWorkspace().getRoot().getFolder(object);
                RootInfo rootInfo2 = this.enclosingRootInfo((IPath)object, 2);
                int n2 = this.elementType((IResource)object2, 2, openable.getParent().getElementType(), rootInfo2);
                this.currentElement = null;
                Openable openable4 = openable3 = n != 2 && n2 == 2 ? null : this.createElement((IResource)object2, n2, rootInfo2);
                if (openable3 == null) {
                    this.currentDelta().added(openable);
                } else {
                    this.currentDelta().movedTo(openable, openable3);
                }
            }
            switch (n) {
                case 3: {
                    object = (JavaProject)openable.getJavaProject();
                    this.rootsToRefresh.add(object);
                    this.projectCachesToReset.add(object);
                    break;
                }
                case 4: {
                    object = (JavaProject)openable.getJavaProject();
                    this.projectCachesToReset.add(object);
                }
            }
        }
    }

    private void elementRemoved(Openable openable, IResourceDelta iResourceDelta, RootInfo rootInfo) {
        Object object;
        int n = openable.getElementType();
        if (iResourceDelta == null || (iResourceDelta.getFlags() & 0x2000) == 0) {
            if (this.isPrimaryWorkingCopy(openable, n)) {
                this.currentDelta().changed(openable, 262144);
            } else {
                this.close(openable);
                this.removeFromParentInfo(openable);
                this.currentDelta().removed(openable);
            }
        } else {
            Openable openable2;
            IFolder iFolder;
            this.close(openable);
            this.removeFromParentInfo(openable);
            object = iResourceDelta.getMovedToPath();
            IResource iResource = iResourceDelta.getResource();
            switch (iResource.getType()) {
                case 4: {
                    iFolder = iResource.getWorkspace().getRoot().getProject(object.lastSegment());
                    break;
                }
                case 2: {
                    iFolder = iResource.getWorkspace().getRoot().getFolder(object);
                    break;
                }
                case 1: {
                    iFolder = iResource.getWorkspace().getRoot().getFile(object);
                    break;
                }
                default: {
                    return;
                }
            }
            RootInfo rootInfo2 = this.enclosingRootInfo((IPath)object, 1);
            int n2 = this.elementType((IResource)iFolder, 1, openable.getParent().getElementType(), rootInfo2);
            this.currentElement = null;
            Openable openable3 = openable2 = n != 2 && n2 == 2 ? null : this.createElement((IResource)iFolder, n2, rootInfo2);
            if (openable2 == null) {
                this.currentDelta().removed(openable);
            } else {
                this.currentDelta().movedFrom(openable, openable2);
            }
        }
        switch (n) {
            case 1: {
                this.manager.indexManager.reset();
                break;
            }
            case 2: {
                this.state.updateRoots(openable.getPath(), iResourceDelta, this);
                this.rootsToRefresh.add(openable);
                this.projectCachesToReset.add(openable);
                break;
            }
            case 3: {
                object = (JavaProject)openable.getJavaProject();
                this.rootsToRefresh.add(object);
                this.projectCachesToReset.add(object);
                break;
            }
            case 4: {
                object = (JavaProject)openable.getJavaProject();
                this.projectCachesToReset.add(object);
            }
        }
    }

    private int elementType(IResource iResource, int n, int n2, RootInfo rootInfo) {
        switch (n2) {
            case 1: {
                return 2;
            }
            case -1: 
            case 2: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(iResource.getFullPath(), n);
                }
                if (rootInfo != null && rootInfo.isRootOfProject(iResource.getFullPath())) {
                    return 3;
                }
            }
            case 3: 
            case 4: {
                String string;
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(iResource.getFullPath(), n);
                }
                if (rootInfo == null) {
                    return -1;
                }
                if (Util.isExcluded(iResource, rootInfo.inclusionPatterns, rootInfo.exclusionPatterns)) {
                    return -1;
                }
                if (iResource.getType() == 2) {
                    String string2;
                    if (n2 == -1 && !Util.isExcluded((IResource)iResource.getParent(), rootInfo.inclusionPatterns, rootInfo.exclusionPatterns)) {
                        return -1;
                    }
                    String string3 = rootInfo.project == null ? null : rootInfo.project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
                    String string4 = string2 = rootInfo.project == null ? null : rootInfo.project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                    if (Util.isValidFolderNameForPackage(iResource.getName(), string3, string2)) {
                        return 4;
                    }
                    return -1;
                }
                String string5 = iResource.getName();
                String string6 = rootInfo.project == null ? null : rootInfo.project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
                String string7 = string = rootInfo.project == null ? null : rootInfo.project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                if (Util.isValidCompilationUnitName(string5, string6, string)) {
                    return 5;
                }
                if (Util.isValidClassFileName(string5, string6, string)) {
                    return 6;
                }
                rootInfo = this.rootInfo(iResource.getFullPath(), n);
                if (rootInfo != null && rootInfo.project.getProject().getFullPath().isPrefixOf(iResource.getFullPath())) {
                    return 3;
                }
                return -1;
            }
        }
        return -1;
    }

    public void flush() {
        this.javaModelDeltas = new ArrayList();
    }

    private SourceElementParser getSourceElementParser(Openable openable) {
        if (this.sourceElementParserCache == null) {
            this.sourceElementParserCache = this.manager.indexManager.getSourceElementParser(openable.getJavaProject(), null);
        }
        return this.sourceElementParserCache;
    }

    private RootInfo enclosingRootInfo(IPath iPath, int n) {
        while (iPath != null && iPath.segmentCount() > 0) {
            RootInfo rootInfo = this.rootInfo(iPath, n);
            if (rootInfo != null) {
                return rootInfo;
            }
            iPath = iPath.removeLastSegments(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(IJavaElementDelta iJavaElementDelta, int n) {
        int n2;
        Object object;
        IElementChangedListener[] iElementChangedListenerArray;
        IJavaElementDelta iJavaElementDelta2;
        if (!this.isFiring) {
            return;
        }
        if (DEBUG) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        if ((iJavaElementDelta2 = iJavaElementDelta == null ? this.mergeDeltas(this.javaModelDeltas) : iJavaElementDelta) != null) {
            iElementChangedListenerArray = this.manager.searchScopes.keySet().iterator();
            while (iElementChangedListenerArray.hasNext()) {
                object = (AbstractSearchScope)iElementChangedListenerArray.next();
                ((AbstractSearchScope)object).processDelta(iJavaElementDelta2);
            }
            object = this.manager.workspaceScope;
            if (object != null) {
                ((JavaWorkspaceScope)object).processDelta(iJavaElementDelta2);
            }
        }
        DeltaProcessingState deltaProcessingState = this.state;
        synchronized (deltaProcessingState) {
            iElementChangedListenerArray = this.state.elementChangedListeners;
            object = this.state.elementChangedListenerMasks;
            n2 = this.state.elementChangedListenerCount;
        }
        switch (n) {
            case 0: {
                this.firePostChangeDelta(iJavaElementDelta2, iElementChangedListenerArray, (int[])object, n2);
                this.fireReconcileDelta(iElementChangedListenerArray, (int[])object, n2);
                break;
            }
            case 1: {
                this.firePostChangeDelta(iJavaElementDelta2, iElementChangedListenerArray, (int[])object, n2);
                this.fireReconcileDelta(iElementChangedListenerArray, (int[])object, n2);
            }
        }
    }

    private void firePostChangeDelta(IJavaElementDelta iJavaElementDelta, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        if (DEBUG) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(iJavaElementDelta == null ? "<NONE>" : iJavaElementDelta.toString());
        }
        if (iJavaElementDelta != null) {
            this.flush();
            JavaModelOperation.setAttribute("hasModifiedResource", null);
            this.notifyListeners(iJavaElementDelta, 1, iElementChangedListenerArray, nArray, n);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        IJavaElementDelta iJavaElementDelta = this.mergeDeltas(this.reconcileDeltas.values());
        if (DEBUG) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(iJavaElementDelta == null ? "<NONE>" : iJavaElementDelta.toString());
        }
        if (iJavaElementDelta != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(iJavaElementDelta, 4, iElementChangedListenerArray, nArray, n);
        }
    }

    private boolean isAffectedBy(IResourceDelta iResourceDelta) {
        if (iResourceDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                private static final long serialVersionUID = 7137113252936111022L;
                final /* synthetic */ DeltaProcessor this$0;

                FoundRelevantDeltaException(DeltaProcessor deltaProcessor) {
                    this.this$0 = deltaProcessor;
                }
            }
            try {
                iResourceDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta iResourceDelta) {
                        switch (iResourceDelta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException(DeltaProcessor.this);
                            }
                            case 4: {
                                if (iResourceDelta.getAffectedChildren().length != 0 || (iResourceDelta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException(DeltaProcessor.this);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private boolean isPrimaryWorkingCopy(IJavaElement iJavaElement, int n) {
        if (n == 5) {
            CompilationUnit compilationUnit = (CompilationUnit)iJavaElement;
            return compilationUnit.isPrimary() && compilationUnit.isWorkingCopy();
        }
        return false;
    }

    private boolean isResFilteredFromOutput(RootInfo rootInfo, OutputsInfo outputsInfo, IResource iResource, int n) {
        if (outputsInfo != null) {
            JavaProject javaProject = null;
            String string = null;
            String string2 = null;
            IPath iPath = iResource.getFullPath();
            int n2 = 0;
            while (n2 < outputsInfo.outputCount) {
                if (outputsInfo.paths[n2].isPrefixOf(iPath)) {
                    if (outputsInfo.traverseModes[n2] != 0) {
                        if (outputsInfo.traverseModes[n2] == 1 && n == 6) {
                            return true;
                        }
                        if (n == 2 && iResource instanceof IFile) {
                            if (string == null) {
                                JavaProject javaProject2 = javaProject = rootInfo == null ? (JavaProject)this.createElement((IResource)iResource.getProject(), 2, null) : rootInfo.project;
                                if (javaProject != null) {
                                    string = javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
                                    string2 = javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                                }
                            }
                            if (Util.isValidClassFileName(iResource.getName(), string, string2)) {
                                return true;
                            }
                        }
                    } else {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private IJavaElementDelta mergeDeltas(Collection collection) {
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() == 1) {
            return (IJavaElementDelta)collection.iterator().next();
        }
        if (VERBOSE) {
            System.out.println("MERGING " + collection.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = collection.iterator();
        JavaElementDelta javaElementDelta = new JavaElementDelta(this.manager.javaModel);
        boolean bl = false;
        while (iterator.hasNext()) {
            IJavaElement iJavaElement;
            JavaElementDelta javaElementDelta2 = (JavaElementDelta)iterator.next();
            if (VERBOSE) {
                System.out.println(javaElementDelta2.toString());
            }
            if (this.manager.javaModel.equals(iJavaElement = javaElementDelta2.getElement())) {
                IJavaElementDelta[] iJavaElementDeltaArray = javaElementDelta2.getAffectedChildren();
                int n = 0;
                while (n < iJavaElementDeltaArray.length) {
                    JavaElementDelta javaElementDelta3 = (JavaElementDelta)iJavaElementDeltaArray[n];
                    javaElementDelta.insertDeltaTree(javaElementDelta3.getElement(), javaElementDelta3);
                    bl = true;
                    ++n;
                }
                IResourceDelta[] iResourceDeltaArray = javaElementDelta2.getResourceDeltas();
                if (iResourceDeltaArray == null) continue;
                int n2 = 0;
                int n3 = iResourceDeltaArray.length;
                while (n2 < n3) {
                    javaElementDelta.addResourceDelta(iResourceDeltaArray[n2]);
                    bl = true;
                    ++n2;
                }
                continue;
            }
            javaElementDelta.insertDeltaTree(iJavaElement, javaElementDelta2);
            bl = true;
        }
        if (bl) {
            return javaElementDelta;
        }
        return null;
    }

    private void notifyListeners(IJavaElementDelta iJavaElementDelta, int n, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n2) {
        final ElementChangedEvent elementChangedEvent = new ElementChangedEvent(iJavaElementDelta, n);
        int n3 = 0;
        while (n3 < n2) {
            if ((nArray[n3] & n) != 0) {
                final IElementChangedListener iElementChangedListener = iElementChangedListenerArray[n3];
                long l = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (n3 + 1) + "=" + iElementChangedListener.toString());
                    l = System.currentTimeMillis();
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        Util.log(throwable, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        PerformanceStats performanceStats = null;
                        if (PERF) {
                            performanceStats = PerformanceStats.getStats((String)"org.eclipse.wst.jsdt.core/perf/javadeltalistener", (Object)iElementChangedListener);
                            performanceStats.startRun();
                        }
                        iElementChangedListener.elementChanged(elementChangedEvent);
                        if (PERF) {
                            performanceStats.endRun();
                        }
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - l) + "ms");
                }
            }
            ++n3;
        }
    }

    private void notifyTypeHierarchies(IElementChangedListener[] iElementChangedListenerArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            final IElementChangedListener iElementChangedListener = iElementChangedListenerArray[n2];
            if (iElementChangedListener instanceof TypeHierarchy) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        Util.log(throwable, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        TypeHierarchy typeHierarchy = (TypeHierarchy)iElementChangedListener;
                        if (typeHierarchy.hasFineGrainChanges()) {
                            typeHierarchy.needsRefresh = true;
                            typeHierarchy.fireChange();
                        }
                    }
                });
            }
            ++n2;
        }
    }

    private void nonJavaResourcesChanged(Openable openable, IResourceDelta iResourceDelta) throws JavaModelException {
        Object object;
        Object object2;
        if (openable.isOpen()) {
            object2 = (JavaElementInfo)openable.getElementInfo();
            switch (openable.getElementType()) {
                case 1: {
                    ((JavaModelInfo)object2).nonJavaResources = null;
                    this.currentDelta().addResourceDelta(iResourceDelta);
                    return;
                }
                case 2: {
                    ((JavaProjectElementInfo)object2).setNonJavaResources(null);
                    object = (JavaProject)openable;
                    PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)((JavaProject)object).getPackageFragmentRoot((IResource)((JavaProject)object).getProject());
                    if (!packageFragmentRoot.isOpen()) break;
                    ((PackageFragmentRootInfo)packageFragmentRoot.getElementInfo()).setNonJavaResources(null);
                    break;
                }
                case 4: {
                    ((PackageFragmentInfo)object2).setNonJavaResources(null);
                    break;
                }
                case 3: {
                    ((PackageFragmentRootInfo)object2).setNonJavaResources(null);
                }
            }
        }
        if ((object = ((JavaElementDelta)(object2 = this.currentDelta())).find(openable)) == null) {
            object = ((JavaElementDelta)object2).changed(openable, 1);
        }
        ((JavaElementDelta)object).addResourceDelta(iResourceDelta);
    }

    private ArrayList otherRootsInfo(IPath iPath, int n) {
        if (n == 2) {
            return (ArrayList)this.state.oldOtherRoots.get(iPath);
        }
        return (ArrayList)this.state.otherRoots.get(iPath);
    }

    private OutputsInfo outputsInfo(RootInfo rootInfo, IResource iResource) {
        try {
            JavaProject javaProject;
            JavaProject javaProject2 = javaProject = rootInfo == null ? (JavaProject)this.createElement((IResource)iResource.getProject(), 2, null) : rootInfo.project;
            if (javaProject != null) {
                IPath iPath = javaProject.getOutputLocation();
                int n = 0;
                if (javaProject.getProject().getFullPath().equals((Object)iPath)) {
                    return new OutputsInfo(new IPath[]{iPath}, new int[]{1}, 1);
                }
                IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath();
                IPath[] iPathArray = new IPath[iClasspathEntryArray.length + 1];
                int[] nArray = new int[iClasspathEntryArray.length + 1];
                int n2 = 1;
                iPathArray[0] = iPath;
                nArray[0] = n;
                int n3 = 0;
                int n4 = iClasspathEntryArray.length;
                while (n3 < n4) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
                    IPath iPath2 = iClasspathEntry.getPath();
                    IPath iPath3 = iClasspathEntry.getOutputLocation();
                    if (iPath3 != null) {
                        iPathArray[n2] = iPath3;
                        if (iPath2.equals((Object)iPath3)) {
                            nArray[n2++] = iClasspathEntry.getEntryKind() == 3 ? 1 : 2;
                        } else {
                            nArray[n2++] = 0;
                        }
                    }
                    if (iPath2.equals((Object)iPath)) {
                        nArray[0] = iClasspathEntry.getEntryKind() == 3 ? 1 : 2;
                    }
                    ++n3;
                }
                return new OutputsInfo(iPathArray, nArray, n2);
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private void popUntilPrefixOf(IPath iPath) {
        while (this.currentElement != null) {
            IPath iPath2 = null;
            if (this.currentElement instanceof IPackageFragmentRoot) {
                iPath2 = ((IPackageFragmentRoot)((Object)this.currentElement)).getPath();
            } else {
                IResource iResource = this.currentElement.getResource();
                if (iResource != null) {
                    iPath2 = iResource.getFullPath();
                }
            }
            if (iPath2 != null) {
                if (this.currentElement instanceof IPackageFragment && ((IPackageFragment)((Object)this.currentElement)).isDefaultPackage() && iPath2.segmentCount() != iPath.segmentCount() - 1) {
                    this.currentElement = (Openable)this.currentElement.getParent();
                }
                if (iPath2.isPrefixOf(iPath)) {
                    return;
                }
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    private IJavaElementDelta processResourceDelta(IResourceDelta iResourceDelta) {
        JavaModel javaModel;
        block10: {
            javaModel = this.manager.getJavaModel();
            if (javaModel.isOpen()) break block10;
            try {
                javaModel.open(null);
            }
            catch (JavaModelException javaModelException) {
                if (VERBOSE) {
                    javaModelException.printStackTrace();
                }
                Object var12_5 = null;
                this.currentDelta = null;
                this.rootsToRefresh.clear();
                this.projectCachesToReset.clear();
                return null;
            }
        }
        try {
            this.state.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                IResource iResource = iResourceDelta2.getResource();
                RootInfo rootInfo = null;
                IProject iProject = (IProject)iResource;
                boolean bl = this.state.findJavaProject(iProject.getName()) != null;
                boolean bl2 = JavaProject.hasJavaNature(iProject);
                int n2 = !bl && !bl2 ? -1 : ((rootInfo = this.enclosingRootInfo(iResource.getFullPath(), iResourceDelta2.getKind())) != null && rootInfo.isRootOfProject(iResource.getFullPath()) ? 3 : 2);
                this.traverseDelta(iResourceDelta2, n2, rootInfo, null);
                if (n2 == -1 || bl != bl2 && iResourceDelta2.getKind() == 4) {
                    try {
                        this.nonJavaResourcesChanged(javaModel, iResourceDelta2);
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++n;
            }
            this.refreshPackageFragmentRoots();
            this.resetProjectCaches();
            JavaElementDelta javaElementDelta = this.currentDelta;
            Object var12_6 = null;
            this.currentDelta = null;
            this.rootsToRefresh.clear();
            this.projectCachesToReset.clear();
            return javaElementDelta;
        }
        catch (Throwable throwable) {
            Object var12_7 = null;
            this.currentDelta = null;
            this.rootsToRefresh.clear();
            this.projectCachesToReset.clear();
            throw throwable;
        }
    }

    public void resetProjectCaches() {
        JavaProject javaProject;
        if (this.projectCachesToReset.size() == 0) {
            return;
        }
        JavaModelManager.getJavaModelManager().resetJarTypeCache();
        Iterator iterator = this.projectCachesToReset.iterator();
        HashMap hashMap = this.state.projectDependencies;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            javaProject = (JavaProject)iterator.next();
            javaProject.resetCaches();
            this.addDependentProjects(javaProject, hashMap, hashSet);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            javaProject = (JavaProject)iterator.next();
            javaProject.resetCaches();
        }
    }

    private void refreshPackageFragmentRoots() {
        Iterator iterator = this.rootsToRefresh.iterator();
        while (iterator.hasNext()) {
            JavaProject javaProject = (JavaProject)iterator.next();
            javaProject.updatePackageFragmentRoots();
        }
    }

    public void registerJavaModelDelta(IJavaElementDelta iJavaElementDelta) {
        this.javaModelDeltas.add(iJavaElementDelta);
    }

    private void removeFromParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                JavaElementInfo javaElementInfo = (JavaElementInfo)openable2.getElementInfo();
                javaElementInfo.removeChild(openable);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        int n = this.overridenEventType == -1 ? iResourceChangeEvent.getType() : this.overridenEventType;
        IResource iResource = iResourceChangeEvent.getResource();
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        switch (n) {
            case 4: {
                try {
                    if (iResource.getType() != 4) return;
                    if (!((IProject)iResource).hasNature("org.eclipse.wst.jsdt.core.jsNature")) return;
                    this.deleting((IProject)iResource);
                    return;
                }
                catch (CoreException coreException) {}
                return;
            }
            case 1: {
                if (!this.isAffectedBy(iResourceDelta)) return;
                try {
                    int n2;
                    IElementChangedListener[] iElementChangedListenerArray;
                    Object object;
                    try {
                        this.stopDeltas();
                        this.checkProjectsBeingAddedOrRemoved(iResourceDelta);
                        if (this.classpathChanges.size() > 0) {
                            boolean bl = this.currentDelta != null;
                            JavaElementDelta javaElementDelta = this.currentDelta();
                            object = this.classpathChanges.values().iterator();
                            while (true) {
                                if (!object.hasNext()) {
                                    this.classpathChanges.clear();
                                    if (bl) break;
                                    this.currentDelta = null;
                                    break;
                                }
                                ClasspathChange classpathChange = (ClasspathChange)object.next();
                                int n3 = classpathChange.generateDelta(javaElementDelta);
                                if ((n3 & ClasspathChange.HAS_DELTA) != 0) {
                                    bl = true;
                                    classpathChange.requestIndexing();
                                    this.state.addClasspathValidation(classpathChange.project);
                                }
                                if ((n3 & ClasspathChange.HAS_PROJECT_CHANGE) == 0) continue;
                                this.state.addProjectReferenceChange(classpathChange.project, classpathChange.oldResolvedClasspath);
                            }
                        }
                        if (this.refreshedElements != null) {
                            this.createExternalArchiveDelta(null);
                        }
                        if ((iElementChangedListenerArray = this.processResourceDelta(iResourceDelta)) != null) {
                            this.registerJavaModelDelta((IJavaElementDelta)iElementChangedListenerArray);
                        }
                        Object var10_21 = null;
                        this.sourceElementParserCache = null;
                        this.startDeltas();
                        object = this.state;
                    }
                    catch (Throwable throwable) {
                        Object var10_20 = null;
                        this.sourceElementParserCache = null;
                        this.startDeltas();
                        throw throwable;
                    }
                    synchronized (object) {
                        iElementChangedListenerArray = this.state.elementChangedListeners;
                        n2 = this.state.elementChangedListenerCount;
                    }
                    this.notifyTypeHierarchies(iElementChangedListenerArray, n2);
                    this.fire(null, 1);
                    Object var12_24 = null;
                    this.state.resetOldJavaProjectNames();
                    this.oldRoots = null;
                    return;
                }
                catch (Throwable throwable) {
                    Object var12_23 = null;
                    this.state.resetOldJavaProjectNames();
                    this.oldRoots = null;
                    throw throwable;
                }
            }
            case 8: {
                ProjectReferenceChange[] projectReferenceChangeArray;
                int n4;
                if (!this.isAffectedBy(iResourceDelta)) {
                    return;
                }
                boolean bl = this.validateClasspaths(iResourceDelta);
                ClasspathValidation[] classpathValidationArray = this.state.removeClasspathValidations();
                if (classpathValidationArray != null) {
                    int n5 = 0;
                    n4 = classpathValidationArray.length;
                    while (n5 < n4) {
                        ClasspathValidation classpathValidation = classpathValidationArray[n5];
                        classpathValidation.validate();
                        ++n5;
                    }
                }
                if ((projectReferenceChangeArray = this.state.removeProjectReferenceChanges()) != null) {
                    n4 = 0;
                    int n6 = projectReferenceChangeArray.length;
                    while (n4 < n6) {
                        try {
                            projectReferenceChangeArray[n4].updateProjectReferencesIfNecessary();
                        }
                        catch (JavaModelException javaModelException) {}
                        ++n4;
                    }
                }
                if (bl || projectReferenceChangeArray != null) {
                    try {
                        JavaProject.validateCycles(null);
                    }
                    catch (JavaModelException javaModelException) {}
                }
                JavaModel.flushExternalFileCache();
                JavaBuilder.buildStarting();
                return;
            }
            case 16: {
                JavaBuilder.buildFinished();
                return;
            }
        }
    }

    private RootInfo rootInfo(IPath iPath, int n) {
        if (n == 2) {
            return (RootInfo)this.state.oldRoots.get(iPath);
        }
        return (RootInfo)this.state.roots.get(iPath);
    }

    private void startDeltas() {
        this.isFiring = true;
    }

    private void stopDeltas() {
        this.isFiring = false;
    }

    private void traverseDelta(IResourceDelta iResourceDelta, int n, RootInfo rootInfo, OutputsInfo outputsInfo) {
        block18: {
            IProject iProject;
            Object object;
            IResource iResource = iResourceDelta.getResource();
            if (this.currentElement == null && rootInfo != null) {
                this.currentElement = rootInfo.project;
            }
            boolean bl = true;
            if (iResource instanceof IProject) {
                this.sourceElementParserCache = null;
                bl = this.updateCurrentDeltaAndIndex(iResourceDelta, n == 3 ? 2 : n, rootInfo);
            } else {
                bl = rootInfo != null ? this.updateCurrentDeltaAndIndex(iResourceDelta, n, rootInfo) : true;
            }
            if (outputsInfo == null) {
                outputsInfo = this.outputsInfo(rootInfo, iResource);
            }
            if (!bl) break block18;
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            boolean bl2 = false;
            int n2 = iResourceDeltaArray.length;
            IResourceDelta[] iResourceDeltaArray2 = null;
            Openable openable = null;
            boolean bl3 = true;
            int n3 = 0;
            while (n3 < n2) {
                block22: {
                    ArrayList arrayList;
                    boolean bl4;
                    RootInfo rootInfo2;
                    int n4;
                    IPath iPath;
                    block24: {
                        block19: {
                            block20: {
                                block21: {
                                    block23: {
                                        object = iResourceDeltaArray[n3];
                                        IResource iResource2 = object.getResource();
                                        this.checkSourceAttachmentChange((IResourceDelta)object, iResource2);
                                        iPath = iResource2.getFullPath();
                                        n4 = object.getKind();
                                        rootInfo2 = this.rootInfo(iPath, n4);
                                        if (rootInfo2 != null && !rootInfo2.isRootOfProject(iPath)) {
                                            rootInfo2 = null;
                                        }
                                        int n5 = this.elementType(iResource2, n4, n, rootInfo == null ? rootInfo2 : rootInfo);
                                        boolean bl5 = this.isResFilteredFromOutput(rootInfo, outputsInfo, iResource2, n5);
                                        boolean bl6 = bl4 = rootInfo != null && rootInfo2 != null;
                                        if (bl5 || bl4) break block19;
                                        this.traverseDelta((IResourceDelta)object, n5, rootInfo == null ? rootInfo2 : rootInfo, outputsInfo);
                                        if (n5 != -1) break block20;
                                        if (rootInfo == null) break block21;
                                        if (!bl3) break block22;
                                        if (openable != null) break block23;
                                        if (this.currentElement == null || !rootInfo.project.equals(this.currentElement.getJavaProject())) {
                                            this.currentElement = rootInfo.project;
                                        }
                                        if ((openable = n == 2 || n == 3 && iResource instanceof IProject ? rootInfo.project : this.createElement(iResource, n, rootInfo)) != null) break block23;
                                        bl3 = false;
                                        break block22;
                                    }
                                    try {
                                        this.nonJavaResourcesChanged(openable, (IResourceDelta)object);
                                    }
                                    catch (JavaModelException javaModelException) {}
                                    break block24;
                                }
                                if (iResourceDeltaArray2 == null) {
                                    iResourceDeltaArray2 = new IResourceDelta[n2];
                                }
                                iResourceDeltaArray2[n3] = object;
                                break block24;
                            }
                            bl2 = true;
                            break block24;
                        }
                        bl2 = true;
                    }
                    if (bl4 || rootInfo2 == null && (rootInfo2 = this.rootInfo(iPath, n4)) != null) {
                        this.traverseDelta((IResourceDelta)object, 3, rootInfo2, null);
                    }
                    if ((arrayList = this.otherRootsInfo(iPath, n4)) != null) {
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            rootInfo2 = (RootInfo)iterator.next();
                            this.traverseDelta((IResourceDelta)object, 3, rootInfo2, null);
                        }
                    }
                }
                ++n3;
            }
            if (iResourceDeltaArray2 != null && (bl2 || iResource instanceof IProject) && (object = (JavaProject)JavaCore.create(iProject = iResource.getProject())) != null && JavaProject.hasJavaNature(iProject)) {
                int n6 = 0;
                while (n6 < n2) {
                    if (iResourceDeltaArray2[n6] != null) {
                        try {
                            this.nonJavaResourcesChanged((Openable)object, iResourceDeltaArray2[n6]);
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    ++n6;
                }
            }
        }
    }

    private void validateClasspaths(IResourceDelta iResourceDelta, HashSet hashSet) {
        int n;
        IResourceDelta[] iResourceDeltaArray;
        IResource iResource = iResourceDelta.getResource();
        boolean bl = false;
        switch (iResource.getType()) {
            case 8: {
                if (iResourceDelta.getKind() != 4) break;
                bl = true;
                break;
            }
            case 4: {
                Object object;
                Object object2;
                iResourceDeltaArray = (IResourceDelta[])iResource;
                n = iResourceDelta.getKind();
                boolean bl2 = JavaProject.hasJavaNature((IProject)iResourceDeltaArray);
                switch (n) {
                    case 1: {
                        bl = bl2;
                        hashSet.add(iResourceDeltaArray.getFullPath());
                        break;
                    }
                    case 4: {
                        boolean bl3;
                        bl = bl2;
                        if ((iResourceDelta.getFlags() & 0x4000) != 0) {
                            if (bl2) {
                                object2 = (JavaProject)JavaCore.create((IProject)iResourceDeltaArray);
                                this.state.addClasspathValidation((JavaProject)object2);
                            }
                            hashSet.add(iResourceDeltaArray.getFullPath());
                            break;
                        }
                        if ((iResourceDelta.getFlags() & 0x80000) == 0) break;
                        boolean bl4 = bl3 = this.state.findJavaProject(iResourceDeltaArray.getName()) != null;
                        if (bl3 == bl2) break;
                        object = (JavaProject)JavaCore.create((IProject)iResourceDeltaArray);
                        this.state.addClasspathValidation((JavaProject)object);
                        hashSet.add(iResourceDeltaArray.getFullPath());
                        break;
                    }
                    case 2: {
                        hashSet.add(iResourceDeltaArray.getFullPath());
                    }
                }
                break;
            }
            case 1: {
                Object object2 = (IFile)iResource;
                Object object = object2.getName();
                if (!((String)object).equals(".jsdtscope")) break;
                JavaProject javaProject = (JavaProject)JavaCore.create(object2.getProject());
                this.state.addClasspathValidation(javaProject);
                hashSet.add(object2.getProject().getFullPath());
            }
        }
        if (bl) {
            iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            n = 0;
            while (n < iResourceDeltaArray.length) {
                this.validateClasspaths(iResourceDeltaArray[n], hashSet);
                ++n;
            }
        }
    }

    private boolean validateClasspaths(IResourceDelta iResourceDelta) {
        HashSet hashSet = new HashSet(5);
        this.validateClasspaths(iResourceDelta, hashSet);
        boolean bl = false;
        if (!hashSet.isEmpty()) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = iWorkspaceRoot.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                JavaProject javaProject = (JavaProject)JavaCore.create(iProject);
                try {
                    IPath iPath = iProject.getFullPath();
                    IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath();
                    int n3 = 0;
                    int n4 = iClasspathEntryArray.length;
                    while (n3 < n4) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
                        switch (iClasspathEntry.getEntryKind()) {
                            case 2: {
                                if (!hashSet.contains(iClasspathEntry.getPath())) break;
                                this.state.addClasspathValidation(javaProject);
                                bl = true;
                                break;
                            }
                            case 1: {
                                IPath iPath2 = iClasspathEntry.getPath();
                                IPath iPath3 = iPath2.removeLastSegments(iPath2.segmentCount() - 1);
                                if (iPath3.equals((Object)iPath) || !hashSet.contains(iPath3)) break;
                                this.state.addClasspathValidation(javaProject);
                            }
                        }
                        ++n3;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++n2;
            }
        }
        return bl;
    }

    public boolean updateCurrentDeltaAndIndex(IResourceDelta iResourceDelta, int n, RootInfo rootInfo) {
        switch (iResourceDelta.getKind()) {
            case 1: {
                IResource iResource = iResourceDelta.getResource();
                Openable openable = this.createElement(iResource, n, rootInfo);
                if (openable == null) {
                    this.state.updateRoots(iResource.getFullPath(), iResourceDelta, this);
                    return rootInfo != null && rootInfo.inclusionPatterns != null;
                }
                this.updateIndex(openable, iResourceDelta);
                this.elementAdded(openable, iResourceDelta, rootInfo);
                if (n == 3) {
                    this.state.addClasspathValidation(rootInfo.project);
                }
                return n == 4;
            }
            case 2: {
                IResource iResource = iResourceDelta.getResource();
                Openable openable = this.createElement(iResource, n, rootInfo);
                if (openable == null) {
                    this.state.updateRoots(iResource.getFullPath(), iResourceDelta, this);
                    return rootInfo != null && rootInfo.inclusionPatterns != null;
                }
                this.updateIndex(openable, iResourceDelta);
                this.elementRemoved(openable, iResourceDelta, rootInfo);
                if (n == 3) {
                    this.state.addClasspathValidation(rootInfo.project);
                }
                if (iResource.getType() == 4) {
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Clearing last state for removed project : " + iResource);
                    }
                    this.manager.setLastBuiltState((IProject)iResource, null);
                    this.manager.previousSessionContainers.remove(openable);
                }
                return n == 4;
            }
            case 4: {
                int n2 = iResourceDelta.getFlags();
                if ((n2 & 0x100) != 0 || (n2 & 0x100000) != 0) {
                    Openable openable = this.createElement(iResourceDelta.getResource(), n, rootInfo);
                    if (openable == null) {
                        return false;
                    }
                    this.updateIndex(openable, iResourceDelta);
                    this.contentChanged(openable);
                } else if (n == 2) {
                    boolean bl;
                    IProject iProject;
                    boolean bl2;
                    if ((n2 & 0x4000) != 0) {
                        IProject iProject2 = (IProject)iResourceDelta.getResource();
                        Openable openable = this.createElement((IResource)iProject2, n, rootInfo);
                        if (openable == null) {
                            this.state.updateRoots(iProject2.getFullPath(), iResourceDelta, this);
                            return false;
                        }
                        if (iProject2.isOpen()) {
                            if (JavaProject.hasJavaNature(iProject2)) {
                                this.addToParentInfo(openable);
                                this.currentDelta().opened(openable);
                                this.state.updateRoots(openable.getPath(), iResourceDelta, this);
                                this.rootsToRefresh.add(openable);
                                this.projectCachesToReset.add(openable);
                                this.manager.indexManager.indexAll(iProject2);
                            }
                        } else {
                            boolean bl3;
                            boolean bl4 = bl3 = this.state.findJavaProject(iProject2.getName()) != null;
                            if (bl3) {
                                this.close(openable);
                                this.removeFromParentInfo(openable);
                                this.currentDelta().closed(openable);
                                this.manager.indexManager.discardJobs(openable.getElementName());
                                this.manager.indexManager.removeIndexFamily(iProject2.getFullPath());
                            }
                        }
                        return false;
                    }
                    if ((n2 & 0x80000) != 0 && (bl2 = this.state.findJavaProject((iProject = (IProject)iResourceDelta.getResource()).getName()) != null) != (bl = JavaProject.hasJavaNature(iProject))) {
                        Openable openable = this.createElement((IResource)iProject, n, rootInfo);
                        if (openable == null) {
                            return false;
                        }
                        if (bl) {
                            this.elementAdded(openable, iResourceDelta, rootInfo);
                            this.manager.indexManager.indexAll(iProject);
                        } else {
                            this.elementRemoved(openable, iResourceDelta, rootInfo);
                            this.manager.indexManager.discardJobs(openable.getElementName());
                            this.manager.indexManager.removeIndexFamily(iProject.getFullPath());
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Clearing last state for project loosing Java nature: " + iProject);
                            }
                            this.manager.setLastBuiltState(iProject, null);
                        }
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    private void updateIndex(Openable openable, IResourceDelta iResourceDelta) {
        block46: {
            IndexManager indexManager = this.manager.indexManager;
            if (indexManager == null) {
                return;
            }
            block1 : switch (openable.getElementType()) {
                case 2: {
                    switch (iResourceDelta.getKind()) {
                        case 1: {
                            indexManager.indexAll(openable.getJavaProject().getProject());
                            break;
                        }
                        case 2: {
                            indexManager.removeIndexFamily(openable.getJavaProject().getProject().getFullPath());
                        }
                    }
                    break;
                }
                case 3: {
                    if (openable instanceof LibraryFragmentRoot) {
                        JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)openable;
                        IPath iPath = jarPackageFragmentRoot.getPath();
                        switch (iResourceDelta.getKind()) {
                            case 1: {
                                indexManager.indexLibrary((LibraryFragmentRoot)openable, jarPackageFragmentRoot.getJavaProject().getProject());
                                break;
                            }
                            case 4: {
                                indexManager.removeIndex(iPath);
                                indexManager.indexLibrary((LibraryFragmentRoot)openable, jarPackageFragmentRoot.getJavaProject().getProject());
                                break;
                            }
                            case 2: {
                                indexManager.discardJobs(iPath.toString());
                                indexManager.removeIndex(iPath);
                            }
                        }
                        break;
                    }
                    int n = iResourceDelta.getKind();
                    if (n == 1 || n == 2) {
                        PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)openable;
                        this.updateRootIndex(packageFragmentRoot, CharOperation.NO_STRINGS, iResourceDelta);
                        break;
                    }
                }
                case 4: {
                    switch (iResourceDelta.getKind()) {
                        case 1: 
                        case 2: {
                            Object object;
                            IPackageFragment iPackageFragment = null;
                            if (openable instanceof IPackageFragmentRoot) {
                                object = (PackageFragmentRoot)openable;
                                iPackageFragment = ((PackageFragmentRoot)object).getPackageFragment(CharOperation.NO_STRINGS);
                            } else {
                                iPackageFragment = (IPackageFragment)((Object)openable);
                            }
                            object = this.rootInfo(iPackageFragment.getParent().getPath(), iResourceDelta.getKind());
                            boolean bl = object == null || ((RootInfo)object).entryKind == 3;
                            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                            int n = 0;
                            int n2 = iResourceDeltaArray.length;
                            while (n < n2) {
                                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                                IResource iResource = iResourceDelta2.getResource();
                                if (iResource instanceof IFile) {
                                    Openable openable2;
                                    String string = iResource.getName();
                                    if (bl) {
                                        if (Util.isJavaLikeFileName(string)) {
                                            openable2 = (Openable)((Object)iPackageFragment.getCompilationUnit(string));
                                            this.updateIndex(openable2, iResourceDelta2);
                                        }
                                    } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string)) {
                                        openable2 = (Openable)((Object)iPackageFragment.getClassFile(string));
                                        this.updateIndex(openable2, iResourceDelta2);
                                    }
                                }
                                ++n;
                            }
                            break block1;
                        }
                    }
                    break;
                }
                case 6: {
                    IFile iFile = (IFile)iResourceDelta.getResource();
                    IJavaProject iJavaProject = openable.getJavaProject();
                    IPath iPath = openable.getPackageFragmentRoot().getPath();
                    try {
                        if (iPath.equals((Object)iJavaProject.getOutputLocation())) {
                            break;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    switch (iResourceDelta.getKind()) {
                        case 4: {
                            int n = iResourceDelta.getFlags();
                            if ((n & 0x100) == 0 && (n & 0x100000) == 0) break block1;
                        }
                        case 1: {
                            indexManager.addBinary(iFile, iPath);
                            break;
                        }
                        case 2: {
                            String string = Util.relativePath(iFile.getFullPath(), iPath.segmentCount());
                            indexManager.remove(string, iPath);
                        }
                    }
                    break;
                }
                case 5: {
                    IFile iFile = (IFile)iResourceDelta.getResource();
                    switch (iResourceDelta.getKind()) {
                        case 4: {
                            int n = iResourceDelta.getFlags();
                            if ((n & 0x100) == 0 && (n & 0x100000) == 0) break block46;
                        }
                        case 1: {
                            indexManager.addSource(iFile, iFile.getProject().getFullPath(), this.getSourceElementParser(openable));
                            this.manager.secondaryTypesRemoving(iFile, false);
                            break block1;
                        }
                        {
                        }
                        case 2: {
                            indexManager.remove(Util.relativePath(iFile.getFullPath(), 1), iFile.getProject().getFullPath());
                            this.manager.secondaryTypesRemoving(iFile, true);
                        }
                    }
                }
            }
        }
    }

    public void updateJavaModel(IJavaElementDelta iJavaElementDelta) {
        if (iJavaElementDelta == null) {
            int n = 0;
            int n2 = this.javaModelDeltas.size();
            while (n < n2) {
                IJavaElementDelta iJavaElementDelta2 = (IJavaElementDelta)this.javaModelDeltas.get(n);
                this.modelUpdater.processJavaDelta(iJavaElementDelta2);
                ++n;
            }
        } else {
            this.modelUpdater.processJavaDelta(iJavaElementDelta);
        }
    }

    private void updateRootIndex(PackageFragmentRoot packageFragmentRoot, String[] stringArray, IResourceDelta iResourceDelta) {
        PackageFragment packageFragment = packageFragmentRoot.getPackageFragment(stringArray);
        this.updateIndex(packageFragment, iResourceDelta);
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n = 0;
        int n2 = iResourceDeltaArray.length;
        while (n < n2) {
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
            IResource iResource = iResourceDelta2.getResource();
            if (iResource instanceof IFolder) {
                String[] stringArray2 = Util.arrayConcat(stringArray, iResource.getName());
                this.updateRootIndex(packageFragmentRoot, stringArray2, iResourceDelta2);
            }
            ++n;
        }
    }

    static class OutputsInfo {
        int outputCount;
        IPath[] paths;
        int[] traverseModes;

        OutputsInfo(IPath[] iPathArray, int[] nArray, int n) {
            this.paths = iPathArray;
            this.traverseModes = nArray;
            this.outputCount = n;
        }

        public String toString() {
            if (this.paths == null) {
                return "<none>";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.outputCount) {
                stringBuffer.append("path=");
                stringBuffer.append(this.paths[n].toString());
                stringBuffer.append("\n->traverse=");
                switch (this.traverseModes[n]) {
                    case 2: {
                        stringBuffer.append("BINARY");
                        break;
                    }
                    case 0: {
                        stringBuffer.append("IGNORE");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("SOURCE");
                        break;
                    }
                    default: {
                        stringBuffer.append("<unknown>");
                    }
                }
                if (n + 1 < this.outputCount) {
                    stringBuffer.append('\n');
                }
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    static class RootInfo {
        char[][] inclusionPatterns;
        char[][] exclusionPatterns;
        JavaProject project;
        IPath rootPath;
        int entryKind;
        IPackageFragmentRoot root;

        RootInfo(JavaProject javaProject, IPath iPath, char[][] cArray, char[][] cArray2, int n) {
            this.project = javaProject;
            this.rootPath = iPath;
            this.inclusionPatterns = cArray;
            this.exclusionPatterns = cArray2;
            this.entryKind = n;
        }

        IPackageFragmentRoot getPackageFragmentRoot(IResource iResource) {
            if (this.root == null) {
                Object object;
                this.root = iResource != null ? this.project.getPackageFragmentRoot(iResource) : ((object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.rootPath, false)) instanceof IResource ? this.project.getPackageFragmentRoot((IResource)object) : this.project.getPackageFragmentRoot(this.rootPath.toOSString()));
            }
            return this.root;
        }

        boolean isRootOfProject(IPath iPath) {
            return this.rootPath.equals((Object)iPath) && this.project.getProject().getFullPath().isPrefixOf(iPath);
        }

        public String toString() {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer("project=");
            if (this.project == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.project.getElementName());
            }
            stringBuffer.append("\npath=");
            if (this.rootPath == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.rootPath.toString());
            }
            stringBuffer.append("\nincluding=");
            if (this.inclusionPatterns == null) {
                stringBuffer.append("null");
            } else {
                n2 = 0;
                n = this.inclusionPatterns.length;
                while (n2 < n) {
                    stringBuffer.append(new String(this.inclusionPatterns[n2]));
                    if (n2 < n - 1) {
                        stringBuffer.append("|");
                    }
                    ++n2;
                }
            }
            stringBuffer.append("\nexcluding=");
            if (this.exclusionPatterns == null) {
                stringBuffer.append("null");
            } else {
                n2 = 0;
                n = this.exclusionPatterns.length;
                while (n2 < n) {
                    stringBuffer.append(new String(this.exclusionPatterns[n2]));
                    if (n2 < n - 1) {
                        stringBuffer.append("|");
                    }
                    ++n2;
                }
            }
            return stringBuffer.toString();
        }
    }
}

