/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ImportContainer;
import org.eclipse.wst.jsdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;

public class ImportDeclaration
extends SourceRefElement
implements IImportDeclaration {
    protected String name;
    protected boolean isOnDemand;

    protected ImportDeclaration(ImportContainer importContainer, String string, boolean bl) {
        super(importContainer);
        this.name = string;
        this.isOnDemand = bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImportDeclaration)) {
            return false;
        }
        return super.equals(object);
    }

    public String getElementName() {
        if (this.isOnDemand) {
            return String.valueOf(this.name) + ".*";
        }
        return this.name;
    }

    public String getNameWithoutStar() {
        return this.name;
    }

    public int getElementType() {
        return 13;
    }

    public int getFlags() throws JavaModelException {
        ImportDeclarationElementInfo importDeclarationElementInfo = (ImportDeclarationElementInfo)this.getElementInfo();
        return importDeclarationElementInfo.getModifiers();
    }

    protected void getHandleMemento(StringBuffer stringBuffer) {
        ((JavaElement)this.getParent()).getHandleMemento(stringBuffer);
        this.escapeMementoName(stringBuffer, this.getElementName());
        if (this.occurrenceCount > 1) {
            stringBuffer.append('!');
            stringBuffer.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    public IJavaElement getPrimaryElement(boolean bl) {
        CompilationUnit compilationUnit = (CompilationUnit)this.parent.getParent();
        if (bl && compilationUnit.isPrimary()) {
            return this;
        }
        return compilationUnit.getImport(this.getElementName());
    }

    public boolean isOnDemand() {
        return this.isOnDemand;
    }

    public String readableName() {
        return null;
    }

    protected void toStringInfo(int n, StringBuffer stringBuffer, Object object, boolean bl) {
        stringBuffer.append(this.tabString(n));
        stringBuffer.append("import ");
        this.toStringName(stringBuffer);
        if (object == null) {
            stringBuffer.append(" (not open)");
        }
    }
}

