/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.MemberElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaElementDeltaBuilder {
    IJavaElement javaElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    public JavaElementDelta delta = null;
    ArrayList added;
    ArrayList removed;

    public JavaElementDeltaBuilder(IJavaElement iJavaElement) {
        this.javaElement = iJavaElement;
        this.initialize();
        this.recordElementInfo(iJavaElement, (JavaModel)this.javaElement.getJavaModel(), 0);
    }

    public JavaElementDeltaBuilder(IJavaElement iJavaElement, int n) {
        this.javaElement = iJavaElement;
        this.maxDepth = n;
        this.initialize();
        this.recordElementInfo(iJavaElement, (JavaModel)this.javaElement.getJavaModel(), 0);
    }

    private void added(IJavaElement iJavaElement) {
        this.added.add(iJavaElement);
        ListItem listItem = this.getNewPosition(iJavaElement);
        ListItem listItem2 = null;
        ListItem listItem3 = null;
        if (listItem.previous != null) {
            listItem2 = this.getNewPosition(listItem.previous);
        }
        if (listItem.next != null) {
            listItem3 = this.getNewPosition(listItem.next);
        }
        if (listItem2 != null) {
            listItem2.next = listItem.next;
        }
        if (listItem3 != null) {
            listItem3.previous = listItem.previous;
        }
    }

    public void buildDeltas() {
        this.delta = new JavaElementDelta(this.javaElement);
        if (this.javaElement.getElementType() >= 5) {
            this.delta.fineGrained();
        }
        this.recordNewPositions(this.javaElement, 0);
        this.findAdditions(this.javaElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.javaElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private boolean equals(char[][][] cArray, char[][][] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        int n = cArray.length;
        while (--n >= 0) {
            if (CharOperation.equals(cArray[n], cArray2[n])) continue;
            return false;
        }
        return true;
    }

    private void findAdditions(IJavaElement iJavaElement, int n) {
        IJavaElement[] iJavaElementArray;
        JavaElementInfo javaElementInfo = this.getElementInfo(iJavaElement);
        if (javaElementInfo == null && n < this.maxDepth) {
            this.delta.added(iJavaElement);
            this.added(iJavaElement);
        } else {
            this.removeElementInfo(iJavaElement);
        }
        if (n >= this.maxDepth) {
            this.delta.changed(iJavaElement, 1);
            return;
        }
        JavaElementInfo javaElementInfo2 = null;
        try {
            javaElementInfo2 = (JavaElementInfo)((JavaElement)iJavaElement).getElementInfo();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        this.findContentChange(javaElementInfo, javaElementInfo2, iJavaElement);
        if (javaElementInfo != null && iJavaElement instanceof IParent && (iJavaElementArray = javaElementInfo2.getChildren()) != null) {
            int n2 = iJavaElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.findAdditions(iJavaElementArray[n3], n + 1);
                ++n3;
            }
        }
    }

    private void findChangesInPositioning(IJavaElement iJavaElement, int n) {
        if (n >= this.maxDepth || this.added.contains(iJavaElement) || this.removed.contains(iJavaElement)) {
            return;
        }
        if (!this.isPositionedCorrectly(iJavaElement)) {
            this.delta.changed(iJavaElement, 256);
        }
        if (iJavaElement instanceof IParent) {
            JavaElementInfo javaElementInfo = null;
            try {
                javaElementInfo = (JavaElementInfo)((JavaElement)iJavaElement).getElementInfo();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            IJavaElement[] iJavaElementArray = javaElementInfo.getChildren();
            if (iJavaElementArray != null) {
                int n2 = iJavaElementArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.findChangesInPositioning(iJavaElementArray[n3], n + 1);
                    ++n3;
                }
            }
        }
    }

    private void findContentChange(JavaElementInfo javaElementInfo, JavaElementInfo javaElementInfo2, IJavaElement iJavaElement) {
        block13: {
            HashMap hashMap;
            block14: {
                Set set;
                MemberElementInfo memberElementInfo;
                MemberElementInfo memberElementInfo2;
                if (javaElementInfo instanceof MemberElementInfo && javaElementInfo2 instanceof MemberElementInfo) {
                    if (((MemberElementInfo)javaElementInfo).getModifiers() != ((MemberElementInfo)javaElementInfo2).getModifiers()) {
                        this.delta.changed(iJavaElement, 2);
                    } else if (javaElementInfo instanceof SourceMethodElementInfo && javaElementInfo2 instanceof SourceMethodElementInfo) {
                        memberElementInfo2 = (SourceMethodElementInfo)javaElementInfo;
                        memberElementInfo = (SourceMethodElementInfo)javaElementInfo2;
                        if (!(CharOperation.equals(((SourceMethodElementInfo)memberElementInfo2).getReturnTypeName(), ((SourceMethodElementInfo)memberElementInfo).getReturnTypeName()) && CharOperation.equals(((SourceMethodElementInfo)memberElementInfo2).getTypeParameterNames(), ((SourceMethodElementInfo)memberElementInfo).getTypeParameterNames()) && this.equals(((SourceMethodElementInfo)memberElementInfo2).getTypeParameterBounds(), ((SourceMethodElementInfo)memberElementInfo).getTypeParameterBounds()))) {
                            this.delta.changed(iJavaElement, 1);
                        }
                    } else if (javaElementInfo instanceof SourceFieldElementInfo && javaElementInfo2 instanceof SourceFieldElementInfo && !CharOperation.equals(((SourceFieldElementInfo)javaElementInfo).getTypeName(), ((SourceFieldElementInfo)javaElementInfo2).getTypeName())) {
                        this.delta.changed(iJavaElement, 1);
                    }
                }
                if (!(javaElementInfo instanceof SourceTypeElementInfo) || !(javaElementInfo2 instanceof SourceTypeElementInfo)) break block13;
                memberElementInfo2 = (SourceTypeElementInfo)javaElementInfo;
                memberElementInfo = (SourceTypeElementInfo)javaElementInfo2;
                if (!CharOperation.equals(((SourceTypeElementInfo)memberElementInfo2).getSuperclassName(), ((SourceTypeElementInfo)memberElementInfo).getSuperclassName()) || !CharOperation.equals(((SourceTypeElementInfo)memberElementInfo2).getInterfaceNames(), ((SourceTypeElementInfo)memberElementInfo).getInterfaceNames())) {
                    this.delta.changed(iJavaElement, 2048);
                }
                if (!CharOperation.equals(((SourceTypeElementInfo)memberElementInfo2).getTypeParameterNames(), ((SourceTypeElementInfo)memberElementInfo).getTypeParameterNames()) || !this.equals(((SourceTypeElementInfo)memberElementInfo2).getTypeParameterBounds(), ((SourceTypeElementInfo)memberElementInfo).getTypeParameterBounds())) {
                    this.delta.changed(iJavaElement, 1);
                }
                HashMap hashMap2 = ((SourceTypeElementInfo)memberElementInfo2).categories;
                hashMap = ((SourceTypeElementInfo)memberElementInfo).categories;
                if (hashMap2 == null) break block14;
                if (hashMap != null) {
                    set = new HashSet(hashMap2.keySet());
                    set.addAll(hashMap.keySet());
                } else {
                    set = hashMap2.keySet();
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray;
                    IJavaElement iJavaElement2 = (IJavaElement)iterator.next();
                    Object[] objectArray2 = (String[])hashMap2.get(iJavaElement2);
                    Object[] objectArray3 = objectArray = hashMap == null ? null : (String[])hashMap.get(iJavaElement2);
                    if (Util.equalArraysOrNull(objectArray2, objectArray)) continue;
                    this.delta.changed(iJavaElement2, 0x100000);
                }
                break block13;
            }
            if (hashMap == null) break block13;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                IJavaElement iJavaElement3 = (IJavaElement)iterator.next();
                this.delta.changed(iJavaElement3, 0x100000);
            }
        }
    }

    private void findDeletions() {
        Iterator iterator = this.infos.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement iJavaElement = (IJavaElement)iterator.next();
            this.delta.removed(iJavaElement);
            this.removed(iJavaElement);
        }
    }

    private JavaElementInfo getElementInfo(IJavaElement iJavaElement) {
        return (JavaElementInfo)this.infos.get(iJavaElement);
    }

    private ListItem getNewPosition(IJavaElement iJavaElement) {
        return (ListItem)this.newPositions.get(iJavaElement);
    }

    private ListItem getOldPosition(IJavaElement iJavaElement) {
        return (ListItem)this.oldPositions.get(iJavaElement);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.javaElement, new ListItem(null, null));
        this.putNewPosition(this.javaElement, new ListItem(null, null));
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IJavaElement[] iJavaElementArray, boolean bl) {
        int n = iJavaElementArray.length;
        IJavaElement iJavaElement = null;
        IJavaElement iJavaElement2 = null;
        IJavaElement iJavaElement3 = n > 0 ? iJavaElementArray[0] : null;
        int n2 = 0;
        while (n2 < n) {
            iJavaElement = iJavaElement2;
            iJavaElement2 = iJavaElement3;
            IJavaElement iJavaElement4 = iJavaElement3 = n2 + 1 < n ? iJavaElementArray[n2 + 1] : null;
            if (bl) {
                this.putNewPosition(iJavaElement2, new ListItem(iJavaElement, iJavaElement3));
            } else {
                this.putOldPosition(iJavaElement2, new ListItem(iJavaElement, iJavaElement3));
            }
            ++n2;
        }
    }

    private boolean isPositionedCorrectly(IJavaElement iJavaElement) {
        ListItem listItem = this.getOldPosition(iJavaElement);
        if (listItem == null) {
            return false;
        }
        ListItem listItem2 = this.getNewPosition(iJavaElement);
        if (listItem2 == null) {
            return false;
        }
        IJavaElement iJavaElement2 = listItem.previous;
        IJavaElement iJavaElement3 = listItem2.previous;
        if (iJavaElement2 == null) {
            return iJavaElement3 == null;
        }
        return iJavaElement2.equals(iJavaElement3);
    }

    private void putElementInfo(IJavaElement iJavaElement, JavaElementInfo javaElementInfo) {
        this.infos.put(iJavaElement, javaElementInfo);
    }

    private void putNewPosition(IJavaElement iJavaElement, ListItem listItem) {
        this.newPositions.put(iJavaElement, listItem);
    }

    private void putOldPosition(IJavaElement iJavaElement, ListItem listItem) {
        this.oldPositions.put(iJavaElement, listItem);
    }

    private void recordElementInfo(IJavaElement iJavaElement, JavaModel javaModel, int n) {
        IJavaElement[] iJavaElementArray;
        if (n >= this.maxDepth) {
            return;
        }
        JavaElementInfo javaElementInfo = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(iJavaElement);
        if (javaElementInfo == null) {
            return;
        }
        this.putElementInfo(iJavaElement, javaElementInfo);
        if (iJavaElement instanceof IParent && (iJavaElementArray = javaElementInfo.getChildren()) != null) {
            this.insertPositions(iJavaElementArray, false);
            int n2 = 0;
            int n3 = iJavaElementArray.length;
            while (n2 < n3) {
                this.recordElementInfo(iJavaElementArray[n2], javaModel, n + 1);
                ++n2;
            }
        }
    }

    private void recordNewPositions(IJavaElement iJavaElement, int n) {
        if (n < this.maxDepth && iJavaElement instanceof IParent) {
            JavaElementInfo javaElementInfo = null;
            try {
                javaElementInfo = (JavaElementInfo)((JavaElement)iJavaElement).getElementInfo();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            IJavaElement[] iJavaElementArray = javaElementInfo.getChildren();
            if (iJavaElementArray != null) {
                this.insertPositions(iJavaElementArray, true);
                int n2 = 0;
                int n3 = iJavaElementArray.length;
                while (n2 < n3) {
                    this.recordNewPositions(iJavaElementArray[n2], n + 1);
                    ++n2;
                }
            }
        }
    }

    private void removed(IJavaElement iJavaElement) {
        this.removed.add(iJavaElement);
        ListItem listItem = this.getOldPosition(iJavaElement);
        ListItem listItem2 = null;
        ListItem listItem3 = null;
        if (listItem.previous != null) {
            listItem2 = this.getOldPosition(listItem.previous);
        }
        if (listItem.next != null) {
            listItem3 = this.getOldPosition(listItem.next);
        }
        if (listItem2 != null) {
            listItem2.next = listItem.next;
        }
        if (listItem3 != null) {
            listItem3.previous = listItem.previous;
        }
    }

    private void removeElementInfo(IJavaElement iJavaElement) {
        this.infos.remove(iJavaElement);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Built delta:\n");
        stringBuffer.append(this.delta == null ? "<null>" : this.delta.toString());
        return stringBuffer.toString();
    }

    private void trimDelta(JavaElementDelta javaElementDelta) {
        if (javaElementDelta.getKind() == 2) {
            IJavaElementDelta[] iJavaElementDeltaArray = javaElementDelta.getAffectedChildren();
            int n = 0;
            int n2 = iJavaElementDeltaArray.length;
            while (n < n2) {
                javaElementDelta.removeAffectedChild((JavaElementDelta)iJavaElementDeltaArray[n]);
                ++n;
            }
        } else {
            IJavaElementDelta[] iJavaElementDeltaArray = javaElementDelta.getAffectedChildren();
            int n = 0;
            int n3 = iJavaElementDeltaArray.length;
            while (n < n3) {
                this.trimDelta((JavaElementDelta)iJavaElementDeltaArray[n]);
                ++n;
            }
        }
    }

    static class ListItem {
        public IJavaElement previous;
        public IJavaElement next;

        public ListItem(IJavaElement iJavaElement, IJavaElement iJavaElement2) {
            this.previous = iJavaElement;
            this.next = iJavaElement2;
        }
    }
}

