/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.IJavaElementRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaElementRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.JavaProjectElementInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SingleTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class NameLookup
implements SuffixConstants {
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    public static final int ACCEPT_ENUMS = 8;
    public static final int ACCEPT_ANNOTATIONS = 16;
    public static final int ACCEPT_ALL = 30;
    public static boolean VERBOSE = false;
    private static final IType[] NO_TYPES = new IType[0];
    private static final IJavaElement[] NO_BINDINGS = new IJavaElement[0];
    protected IPackageFragmentRoot[] packageFragmentRoots;
    protected HashtableOfArrayToObject packageFragments;
    protected Map rootToResolvedEntries;
    protected HashMap typesInWorkingCopies;
    protected HashMap bindingsInWorkingCopies;
    public long timeSpentInSeekTypesInSourcePackage = 0L;
    public long timeSpentInSeekTypesInBinaryPackage = 0L;
    protected HashSet acceptedCUs = new HashSet();
    private ICompilationUnit[] workingCopies;
    IRestrictedAccessBindingRequestor restrictedRequestor;
    public static final boolean USE_BINDING_SEARCH = true;
    private HandleFactory handleFactory;
    protected IJavaSearchScope searchScope;

    public NameLookup(IPackageFragmentRoot[] iPackageFragmentRootArray, HashtableOfArrayToObject hashtableOfArrayToObject, ICompilationUnit[] iCompilationUnitArray, Map map) {
        long l = -1L;
        if (VERBOSE) {
            Util.verbose(" BUILDING NameLoopkup");
            Util.verbose(" -> pkg roots size: " + (iPackageFragmentRootArray == null ? 0 : iPackageFragmentRootArray.length));
            Util.verbose(" -> pkgs size: " + (hashtableOfArrayToObject == null ? 0 : hashtableOfArrayToObject.size()));
            Util.verbose(" -> working copy size: " + (iCompilationUnitArray == null ? 0 : iCompilationUnitArray.length));
            l = System.currentTimeMillis();
        }
        this.restrictedRequestor = this.restrictedRequestor;
        this.packageFragmentRoots = iPackageFragmentRootArray;
        if (iCompilationUnitArray == null) {
            this.packageFragments = hashtableOfArrayToObject;
        } else {
            try {
                this.packageFragments = (HashtableOfArrayToObject)hashtableOfArrayToObject.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            this.typesInWorkingCopies = new HashMap();
            this.bindingsInWorkingCopies = new HashMap();
            this.workingCopies = iCompilationUnitArray;
            int n = 0;
            int n2 = iCompilationUnitArray.length;
            while (n < n2) {
                IPackageFragmentRoot[] iPackageFragmentRootArray2;
                Object object;
                ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                PackageFragment packageFragment = (PackageFragment)iCompilationUnit.getParent();
                HashMap<String, IJavaElement[]> hashMap = (HashMap<String, IJavaElement[]>)this.typesInWorkingCopies.get(packageFragment);
                HashMap[] hashMapArray = (HashMap[])this.bindingsInWorkingCopies.get(packageFragment);
                if (hashMap == null) {
                    hashMap = new HashMap<String, IJavaElement[]>();
                    this.typesInWorkingCopies.put(packageFragment, hashMap);
                    hashMapArray = new HashMap[16];
                    int n3 = 0;
                    while (n3 < 16) {
                        hashMapArray[n3] = new HashMap();
                        ++n3;
                    }
                    this.bindingsInWorkingCopies.put(packageFragment, hashMapArray);
                }
                try {
                    IJavaElement[] iJavaElementArray = iCompilationUnit.getTypes();
                    int n4 = iJavaElementArray.length;
                    if (n4 == 0) {
                        object = Util.getNameWithoutJavaLikeExtension(iCompilationUnit.getElementName());
                        hashMap.put((String)object, NO_TYPES);
                    } else {
                        int n5 = 0;
                        while (n5 < n4) {
                            iPackageFragmentRootArray2 = iJavaElementArray[n5];
                            String string = iPackageFragmentRootArray2.getElementName();
                            Object v = hashMap.get(string);
                            if (v == null) {
                                hashMap.put(string, iPackageFragmentRootArray2);
                            } else if (v instanceof IType) {
                                hashMap.put(string, new IType[]{(IType)v, iPackageFragmentRootArray2});
                            } else {
                                IType[] iTypeArray = (IType[])v;
                                int n6 = iTypeArray.length;
                                IType[] iTypeArray2 = iTypeArray;
                                iTypeArray = new IType[n6 + 1];
                                System.arraycopy(iTypeArray2, 0, iTypeArray, 0, n6);
                                iTypeArray[n6] = iPackageFragmentRootArray2;
                                hashMap.put(string, iTypeArray);
                            }
                            ++n5;
                        }
                    }
                    this.addWorkingCopyBindings(iJavaElementArray, hashMapArray[4]);
                    this.addWorkingCopyBindings(iCompilationUnit.getFields(), hashMapArray[3]);
                    this.addWorkingCopyBindings(iCompilationUnit.getFields(), hashMapArray[2]);
                    this.addWorkingCopyBindings(iCompilationUnit.getMethods(), hashMapArray[8]);
                }
                catch (JavaModelException javaModelException) {}
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)packageFragment.getParent();
                Object[] objectArray = packageFragment.names;
                object = this.packageFragments.get(objectArray);
                if (object == null || object == JavaProjectElementInfo.NO_ROOTS) {
                    this.packageFragments.put(objectArray, iPackageFragmentRoot);
                    JavaProjectElementInfo.addSuperPackageNames((String[])objectArray, this.packageFragments);
                } else if (object instanceof PackageFragmentRoot) {
                    if (!object.equals(iPackageFragmentRoot)) {
                        this.packageFragments.put(objectArray, new IPackageFragmentRoot[]{(PackageFragmentRoot)object, iPackageFragmentRoot});
                    }
                } else {
                    iPackageFragmentRootArray2 = (IPackageFragmentRoot[])object;
                    int n7 = iPackageFragmentRootArray2.length;
                    boolean bl = false;
                    int n8 = 0;
                    while (n8 < n7) {
                        if (iPackageFragmentRootArray2[n8].equals(iPackageFragmentRoot)) {
                            bl = true;
                            break;
                        }
                        ++n8;
                    }
                    if (bl) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray3 = iPackageFragmentRootArray2;
                        iPackageFragmentRootArray2 = new IPackageFragmentRoot[n7 + 1];
                        System.arraycopy(iPackageFragmentRootArray3, 0, iPackageFragmentRootArray2, 0, n7);
                        iPackageFragmentRootArray2[n7] = iPackageFragmentRoot;
                        this.packageFragments.put(objectArray, iPackageFragmentRootArray2);
                    }
                }
                ++n;
            }
        }
        this.rootToResolvedEntries = map;
        if (VERBOSE) {
            Util.verbose(" -> spent: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    public void setRestrictedAccessRequestor(IRestrictedAccessBindingRequestor iRestrictedAccessBindingRequestor) {
        this.restrictedRequestor = iRestrictedAccessBindingRequestor;
    }

    protected IRestrictedAccessBindingRequestor getRestrictedAccessRequestor() {
        if (this.restrictedRequestor == null) {
            this.restrictedRequestor = new IRestrictedAccessBindingRequestor(){
                ArrayList foundPaths = new ArrayList();
                String excludePath;

                public void setExcludePath(String string) {
                    this.excludePath = string;
                }

                public boolean acceptBinding(int n, int n2, char[] cArray, char[] cArray2, String string, AccessRestriction accessRestriction) {
                    if (this.excludePath != null && string.equals(this.excludePath)) {
                        return false;
                    }
                    int n3 = 0;
                    while (NameLookup.this.workingCopies != null && n3 < NameLookup.this.workingCopies.length) {
                        if (NameLookup.this.workingCopies[n3].getPath().toString().equals(string)) {
                            return false;
                        }
                        ++n3;
                    }
                    this.foundPaths.add(string);
                    return true;
                }

                public String getFoundPath() {
                    return this.foundPaths.size() > 0 ? (String)this.foundPaths.get(0) : null;
                }

                public void reset() {
                    this.foundPaths.clear();
                }

                public ArrayList getFoundPaths() {
                    return this.foundPaths;
                }
            };
        }
        return this.restrictedRequestor;
    }

    private void addWorkingCopyBindings(IJavaElement[] iJavaElementArray, HashMap hashMap) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            String string = iJavaElement.getElementName();
            Object v = hashMap.get(string);
            if (v == null) {
                hashMap.put(string, iJavaElement);
            } else if (v instanceof IJavaElement) {
                hashMap.put(string, new IJavaElement[]{(IJavaElement)v, iJavaElement});
            } else {
                IJavaElement[] iJavaElementArray2 = (IJavaElement[])v;
                int n2 = iJavaElementArray2.length;
                IJavaElement[] iJavaElementArray3 = iJavaElementArray2;
                iJavaElementArray2 = new IJavaElement[n2 + 1];
                System.arraycopy(iJavaElementArray3, 0, iJavaElementArray2, 0, n2);
                iJavaElementArray2[n2] = iJavaElement;
                hashMap.put(string, iJavaElementArray2);
            }
            ++n;
        }
    }

    protected boolean acceptType(IType iType, int n, boolean bl) {
        if (!iType.exists()) {
            return false;
        }
        if (n == 0 || n == 30) {
            return true;
        }
        try {
            int n2 = TypeDeclaration.kind(((SourceTypeElementInfo)((SourceType)iType).getElementInfo()).getModifiers());
            switch (n2) {
                case 1: {
                    return (n & 2) != 0;
                }
                case 2: {
                    return (n & 4) != 0;
                }
                case 3: {
                    return (n & 8) != 0;
                }
            }
            return (n & 0x10) != 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected boolean doAcceptBinding(IJavaElement iJavaElement, int n, boolean bl, IJavaElementRequestor iJavaElementRequestor) {
        switch (n) {
            case 9: {
                if (iJavaElement instanceof IMethod) {
                    iJavaElementRequestor.acceptMethod((IMethod)iJavaElement);
                    return true;
                }
                if (iJavaElement instanceof IField) {
                    iJavaElementRequestor.acceptField((IField)iJavaElement);
                    return true;
                }
                return false;
            }
            case 1: 
            case 3: {
                if (iJavaElement instanceof IField) {
                    iJavaElementRequestor.acceptField((IField)iJavaElement);
                    return true;
                }
                return false;
            }
            case 8: {
                if (iJavaElement instanceof IMethod) {
                    iJavaElementRequestor.acceptMethod((IMethod)iJavaElement);
                    return true;
                }
            }
            case 4: {
                if (!(iJavaElement instanceof IType)) break;
                iJavaElementRequestor.acceptType((IType)iJavaElement);
                return true;
            }
        }
        return false;
    }

    private void findAllTypes(String string, boolean bl, int n, IJavaElementRequestor iJavaElementRequestor) {
        int n2 = this.packageFragmentRoots.length;
        int n3 = 0;
        while (n3 < n2) {
            block7: {
                if (iJavaElementRequestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot iPackageFragmentRoot = this.packageFragmentRoots[n3];
                IJavaElement[] iJavaElementArray = null;
                try {
                    iJavaElementArray = iPackageFragmentRoot.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                if (iJavaElementArray != null) {
                    int n4 = 0;
                    int n5 = iJavaElementArray.length;
                    while (n4 < n5) {
                        if (iJavaElementRequestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(string, (IPackageFragment)iJavaElementArray[n4], bl, n, iJavaElementRequestor);
                        ++n4;
                    }
                }
            }
            ++n3;
        }
    }

    private void findAllBindings(String string, int n, boolean bl, int n2, IJavaElementRequestor iJavaElementRequestor) {
        int n3 = this.packageFragmentRoots.length;
        int n4 = 0;
        while (n4 < n3) {
            block7: {
                if (iJavaElementRequestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot iPackageFragmentRoot = this.packageFragmentRoots[n4];
                IJavaElement[] iJavaElementArray = null;
                try {
                    iJavaElementArray = iPackageFragmentRoot.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                if (iJavaElementArray != null) {
                    int n5 = 0;
                    int n6 = iJavaElementArray.length;
                    while (n5 < n6) {
                        if (iJavaElementRequestor.isCanceled()) {
                            return;
                        }
                        this.seekBindings(string, n, (IPackageFragment)iJavaElementArray[n5], bl, n2, iJavaElementRequestor);
                        ++n5;
                    }
                }
            }
            ++n4;
        }
    }

    public ICompilationUnit findCompilationUnit(String string) {
        Object object;
        Object[] objectArray = CharOperation.NO_STRINGS;
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            objectArray = Util.splitOn('.', string, 0, n);
            string2 = string.substring(n + 1);
        }
        if ((n = string2.indexOf(36)) != -1) {
            string2 = string2.substring(0, n);
        }
        if ((object = this.packageFragments.get(objectArray)) != null) {
            if (object instanceof PackageFragmentRoot) {
                return this.findCompilationUnit((String[])objectArray, string2, (PackageFragmentRoot)object);
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = (IPackageFragmentRoot[])object;
            int n2 = 0;
            while (n2 < iPackageFragmentRootArray.length) {
                PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)iPackageFragmentRootArray[n2];
                ICompilationUnit iCompilationUnit = this.findCompilationUnit((String[])objectArray, string2, packageFragmentRoot);
                if (iCompilationUnit != null) {
                    return iCompilationUnit;
                }
                ++n2;
            }
        }
        return null;
    }

    private ICompilationUnit findCompilationUnit(String[] stringArray, String string, PackageFragmentRoot packageFragmentRoot) {
        if (!packageFragmentRoot.isArchive()) {
            PackageFragment packageFragment = packageFragmentRoot.getPackageFragment(stringArray);
            try {
                ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                int n = 0;
                int n2 = iCompilationUnitArray.length;
                while (n < n2) {
                    ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                    if (Util.equalsIgnoreJavaLikeExtension(iCompilationUnit.getElementName(), string)) {
                        return iCompilationUnit;
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IPackageFragment findPackageFragment(IPath iPath) {
        if (!iPath.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (iResource == null) {
            int n = 0;
            while (n < this.packageFragmentRoots.length) {
                block22: {
                    IPath iPath2;
                    int n2;
                    IPackageFragmentRoot iPackageFragmentRoot = this.packageFragmentRoots[n];
                    if (iPackageFragmentRoot.isExternal() && (n2 = (iPath2 = iPackageFragmentRoot.getPath()).matchingFirstSegments(iPath)) != 0) {
                        String string = iPath.toOSString();
                        string = string.substring(iPath2.toOSString().length() + 1, string.length());
                        string = string.replace(File.separatorChar, '.');
                        IJavaElement[] iJavaElementArray = null;
                        try {
                            iJavaElementArray = iPackageFragmentRoot.getChildren();
                        }
                        catch (JavaModelException javaModelException) {
                            break block22;
                        }
                        int n3 = iJavaElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElementArray[n4];
                            if (this.nameMatches(string, iPackageFragment, false)) {
                                return iPackageFragment;
                            }
                            ++n4;
                        }
                    }
                }
                ++n;
            }
        } else {
            IJavaElement iJavaElement = JavaCore.create(iResource);
            if (iJavaElement == null) {
                return null;
            }
            switch (iJavaElement.getElementType()) {
                case 4: {
                    return (IPackageFragment)iJavaElement;
                }
                case 2: {
                    JavaProject javaProject = (JavaProject)iJavaElement;
                    try {
                        IClasspathEntry iClasspathEntry = javaProject.getClasspathEntryFor(iPath);
                        if (iClasspathEntry != null) {
                            IPackageFragmentRoot iPackageFragmentRoot = javaProject.getPackageFragmentRoot(javaProject.getResource());
                            Object object = this.packageFragments.get(CharOperation.NO_STRINGS);
                            if (object == null) {
                                return null;
                            }
                            if (object instanceof PackageFragmentRoot && object.equals(iPackageFragmentRoot)) {
                                return ((PackageFragmentRoot)iPackageFragmentRoot).getPackageFragment(CharOperation.NO_STRINGS);
                            }
                            IPackageFragmentRoot[] iPackageFragmentRootArray = (IPackageFragmentRoot[])object;
                            int n = 0;
                            while (n < iPackageFragmentRootArray.length) {
                                if (iPackageFragmentRootArray[n].equals(iPackageFragmentRoot)) {
                                    return ((PackageFragmentRoot)iPackageFragmentRoot).getPackageFragment(CharOperation.NO_STRINGS);
                                }
                                ++n;
                            }
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                    return null;
                }
                case 3: {
                    return ((PackageFragmentRoot)iJavaElement).getPackageFragment(CharOperation.NO_STRINGS);
                }
            }
        }
        return null;
    }

    public IPackageFragment[] findPackageFragments(String string, boolean bl) {
        return this.findPackageFragments(string, bl, false);
    }

    public IPackageFragment[] findPackageFragments(String string, boolean bl, boolean bl2) {
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        int n = 0;
        while (n < this.packageFragmentRoots.length) {
            try {
                IJavaElement[] iJavaElementArray = this.packageFragmentRoots[n].getChildren();
                int n2 = 0;
                while (n2 < iJavaElementArray.length) {
                    IPackageFragment iPackageFragment = (IPackageFragment)iJavaElementArray[n2];
                    if (iPackageFragment != null && iPackageFragment.getElementName().equals(string)) {
                        arrayList.add(iPackageFragment);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    private IType findSecondaryType(String string, String string2, IJavaProject iJavaProject, boolean bl, IProgressMonitor iProgressMonitor) {
        if (JavaModelManager.VERBOSE) {
            Util.verbose("NameLookup FIND SECONDARY TYPES:");
            Util.verbose(" -> pkg name: " + string);
            Util.verbose(" -> type name: " + string2);
            Util.verbose(" -> project: " + iJavaProject.getElementName());
        }
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        try {
            IType iType;
            Map map;
            IJavaProject iJavaProject2 = iJavaProject;
            Map map2 = javaModelManager.secondaryTypes(iJavaProject2, bl, iProgressMonitor);
            if (map2.size() > 0 && (map = (Map)map2.get(string == null ? "" : string)) != null && map.size() > 0 && (iType = (IType)map.get(string2)) != null) {
                if (JavaModelManager.VERBOSE) {
                    Util.verbose(" -> type: " + iType.getElementName());
                }
                return iType;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public Answer findType(String string, String string2, boolean bl, int n, boolean bl2) {
        Answer answer = this.findBindingSearch(string, string2, 4, bl, n, true, true, bl2, null, false, null);
        if (answer != null && answer.type == null && answer.element instanceof ITypeRoot) {
            ITypeRoot iTypeRoot = (ITypeRoot)answer.element;
            answer.type = iTypeRoot.getType(string);
        }
        return answer;
    }

    public Answer findBinding(String string, String string2, int n, boolean bl, int n2, boolean bl2, boolean bl3, String string3) {
        return this.findBindingSearch(string, string2, n, bl, n2, true, false, bl2, null, bl3, string3);
    }

    public ICompilationUnit[] findTypeSources(String string, boolean bl) {
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        this.seekPackageFragments("", false, javaElementRequestor);
        IPackageFragment[] iPackageFragmentArray = javaElementRequestor.getPackageFragments();
        IType iType = null;
        int n = iPackageFragmentArray.length;
        HashSet<IJavaProject> hashSet = null;
        IJavaProject iJavaProject = null;
        ArrayList<IType> arrayList = new ArrayList<IType>();
        int n2 = 0;
        while (n2 < n) {
            iType = this.findType(string, iPackageFragmentArray[n2], false, 30);
            if (iType != null && iType.exists()) {
                arrayList.add(iType);
            }
            if (iJavaProject == null) {
                iJavaProject = iPackageFragmentArray[n2].getJavaProject();
            } else if (hashSet == null) {
                if (!iJavaProject.equals(iPackageFragmentArray[n2].getJavaProject())) {
                    hashSet = new HashSet<IJavaProject>(3);
                    hashSet.add(iJavaProject);
                    hashSet.add(iPackageFragmentArray[n2].getJavaProject());
                }
            } else {
                hashSet.add(iPackageFragmentArray[n2].getJavaProject());
            }
            ++n2;
        }
        if (iJavaProject != null) {
            if (hashSet == null) {
                iType = this.findSecondaryType("", string, iJavaProject, bl, (IProgressMonitor)new NullProgressMonitor());
            } else {
                Iterator iterator = hashSet.iterator();
                while (iType == null && iterator.hasNext()) {
                    iType = this.findSecondaryType("", string, (IJavaProject)iterator.next(), bl, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        return null;
    }

    public Answer findType(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, IProgressMonitor iProgressMonitor) {
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (string.length() > 0 && ScannerHelper.isLowerCase(string.charAt(0)) && this.findPackageFragments(String.valueOf(string2) + "." + string, false) != null) {
            return null;
        }
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(string2, false, javaElementRequestor);
        IPackageFragment[] iPackageFragmentArray = javaElementRequestor.getPackageFragments();
        IType iType = null;
        int n2 = iPackageFragmentArray.length;
        HashSet<IJavaProject> hashSet = null;
        IJavaProject iJavaProject = null;
        Answer answer = null;
        int n3 = 0;
        while (n3 < n2) {
            iType = this.findType(string, iPackageFragmentArray[n3], bl, n);
            if (iType != null) {
                Answer answer2;
                AccessRestriction accessRestriction = null;
                if (bl4) {
                    accessRestriction = this.getViolatedRestriction(string, string2, iType, accessRestriction);
                }
                if (!(answer2 = new Answer(iType, accessRestriction)).ignoreIfBetter()) {
                    if (answer2.isBetter(answer)) {
                        return answer2;
                    }
                } else if (answer2.isBetter(answer)) {
                    answer = answer2;
                }
            } else if (answer == null && bl2) {
                if (iJavaProject == null) {
                    iJavaProject = iPackageFragmentArray[n3].getJavaProject();
                } else if (hashSet == null) {
                    if (!iJavaProject.equals(iPackageFragmentArray[n3].getJavaProject())) {
                        hashSet = new HashSet<IJavaProject>(3);
                        hashSet.add(iJavaProject);
                        hashSet.add(iPackageFragmentArray[n3].getJavaProject());
                    }
                } else {
                    hashSet.add(iPackageFragmentArray[n3].getJavaProject());
                }
            }
            ++n3;
        }
        if (answer != null) {
            return answer;
        }
        if (bl2 && iJavaProject != null) {
            if (hashSet == null) {
                iType = this.findSecondaryType(string2, string, iJavaProject, bl3, iProgressMonitor);
            } else {
                Iterator iterator = hashSet.iterator();
                while (iType == null && iterator.hasNext()) {
                    iType = this.findSecondaryType(string2, string, (IJavaProject)iterator.next(), bl3, iProgressMonitor);
                }
            }
        }
        return iType == null ? null : new Answer(iType, null);
    }

    public Answer findBinding(String string, String string2, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, IProgressMonitor iProgressMonitor) {
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (string.length() > 0 && ScannerHelper.isLowerCase(string.charAt(0)) && this.findPackageFragments(String.valueOf(string2) + "." + string, false) != null) {
            return null;
        }
        if (VERBOSE) {
            System.out.println("find binding: " + string);
        }
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(string2, false, javaElementRequestor);
        IPackageFragment[] iPackageFragmentArray = javaElementRequestor.getPackageFragments();
        IJavaElement iJavaElement = null;
        int n3 = iPackageFragmentArray.length;
        HashSet<IJavaProject> hashSet = null;
        IJavaProject iJavaProject = null;
        Answer answer = null;
        int n4 = 0;
        while (n4 < n3) {
            iJavaElement = this.findBinding(string, n, iPackageFragmentArray[n4], bl, n2);
            if (iJavaElement != null) {
                Answer answer2;
                AccessRestriction accessRestriction = null;
                if (bl4) {
                    accessRestriction = this.getViolatedRestriction(string, string2, iJavaElement, accessRestriction);
                }
                if (!(answer2 = new Answer(iJavaElement, accessRestriction)).ignoreIfBetter()) {
                    if (answer2.isBetter(answer)) {
                        return answer2;
                    }
                } else if (answer2.isBetter(answer)) {
                    answer = answer2;
                }
            } else if (answer == null && bl2) {
                if (iJavaProject == null) {
                    iJavaProject = iPackageFragmentArray[n4].getJavaProject();
                } else if (hashSet == null) {
                    if (!iJavaProject.equals(iPackageFragmentArray[n4].getJavaProject())) {
                        hashSet = new HashSet<IJavaProject>(3);
                        hashSet.add(iJavaProject);
                        hashSet.add(iPackageFragmentArray[n4].getJavaProject());
                    }
                } else {
                    hashSet.add(iPackageFragmentArray[n4].getJavaProject());
                }
            }
            ++n4;
        }
        if (answer != null) {
            return answer;
        }
        return iJavaElement == null ? null : new Answer(iJavaElement, null);
    }

    private AccessRestriction getViolatedRestriction(String string, String string2, IType iType, AccessRestriction accessRestriction) {
        AccessRuleSet accessRuleSet;
        PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)iType.getAncestor(3);
        ClasspathEntry classpathEntry = (ClasspathEntry)this.rootToResolvedEntries.get(packageFragmentRoot);
        if (classpathEntry != null && (accessRuleSet = classpathEntry.getAccessRuleSet()) != null) {
            char[][] cArray = CharOperation.splitOn('.', string2.toCharArray());
            char[] cArray2 = string.toCharArray();
            accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(cArray, cArray2, '/'));
        }
        return accessRestriction;
    }

    private AccessRestriction getViolatedRestriction(String string, String string2, Object object, AccessRestriction accessRestriction) {
        return accessRestriction;
    }

    public IType findType(String string, IPackageFragment iPackageFragment, boolean bl, int n, boolean bl2) {
        IType iType = this.findType(string, iPackageFragment, bl, n);
        if (iType == null && bl2) {
            iType = this.findSecondaryType(iPackageFragment.getElementName(), string, iPackageFragment.getJavaProject(), false, null);
        }
        return iType;
    }

    public IType findType(String string, IPackageFragment iPackageFragment, boolean bl, int n) {
        if (iPackageFragment == null) {
            return null;
        }
        SingleTypeRequestor singleTypeRequestor = new SingleTypeRequestor();
        this.seekTypes(string, iPackageFragment, bl, n, singleTypeRequestor);
        return singleTypeRequestor.getType();
    }

    public IJavaElement findBinding(String string, int n, IPackageFragment iPackageFragment, boolean bl, int n2) {
        if (iPackageFragment == null) {
            return null;
        }
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        this.seekBindings(string, n, iPackageFragment, bl, n2, javaElementRequestor);
        IField[] iFieldArray = javaElementRequestor.getFields();
        IMethod[] iMethodArray = javaElementRequestor.getMethods();
        IType[] iTypeArray = javaElementRequestor.getTypes();
        switch (n) {
            case 9: {
                if (iMethodArray.length > 0) {
                    return iMethodArray[0];
                }
            }
            case 1: {
                return iFieldArray.length > 0 ? iFieldArray[0] : null;
            }
            case 8: {
                return iMethodArray.length > 0 ? iMethodArray[0] : null;
            }
            case 4: 
            case 20: {
                return iTypeArray.length > 0 ? iTypeArray[0] : null;
            }
        }
        if ((4 & n) != 0 && iTypeArray.length > 0) {
            return iTypeArray[0];
        }
        if ((8 & n) != 0 && iMethodArray.length > 0) {
            return iMethodArray[0];
        }
        if ((3 & n) != 0 && iFieldArray.length > 0) {
            return iFieldArray[0];
        }
        return null;
    }

    public IType findType(String string, boolean bl, int n) {
        Answer answer = this.findType(string, bl, n, false);
        return answer == null ? null : answer.type;
    }

    public Answer findType(String string, boolean bl, int n, boolean bl2) {
        return this.findType(string, bl, n, true, true, bl2, null);
    }

    public Answer findType(String string, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, IProgressMonitor iProgressMonitor) {
        String string2 = null;
        String string3 = null;
        string3 = "";
        string2 = string;
        return this.findBindingSearch(string2, string3, 4, bl, n, bl2, bl3, bl4, iProgressMonitor, false, null);
    }

    private IType getMemberType(IType iType, String string, int n) {
        return iType;
    }

    public boolean isPackage(String[] stringArray) {
        return this.packageFragments.get(stringArray) != null;
    }

    protected boolean nameMatches(String string, IJavaElement iJavaElement, boolean bl) {
        if (bl) {
            return iJavaElement.getElementName().toLowerCase().startsWith(string);
        }
        return iJavaElement.getElementName().equals(string);
    }

    protected boolean nameMatches(String string, ICompilationUnit iCompilationUnit, boolean bl) {
        if (bl) {
            return iCompilationUnit.getElementName().toLowerCase().startsWith(string);
        }
        return Util.equalsIgnoreJavaLikeExtension(iCompilationUnit.getElementName(), string);
    }

    public void seekPackageFragments(String string, boolean bl, IJavaElementRequestor iJavaElementRequestor) {
        int n = 0;
        while (n < this.packageFragmentRoots.length) {
            try {
                IJavaElement[] iJavaElementArray = this.packageFragmentRoots[n].getChildren();
                int n2 = 0;
                while (n2 < iJavaElementArray.length) {
                    iJavaElementRequestor.acceptPackageFragment((IPackageFragment)iJavaElementArray[n2]);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
    }

    private String[] splitPackageName(String string) {
        String[] stringArray;
        if (string.endsWith(".js")) {
            stringArray = Util.splitOn('.', string, 0, string.length() - 3);
            stringArray[stringArray.length - 1] = String.valueOf(stringArray[stringArray.length - 1]) + ".js";
        } else {
            stringArray = Util.splitOn('.', string, 0, string.length());
        }
        return stringArray;
    }

    public void seekTypes(String string, IPackageFragment iPackageFragment, boolean bl, int n, IJavaElementRequestor iJavaElementRequestor) {
        String string2;
        String string3 = string2 = bl ? string.toLowerCase() : string;
        if (iPackageFragment == null) {
            this.findAllTypes(string2, bl, n, iJavaElementRequestor);
            return;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
        try {
            int n2 = -1;
            String string4 = string2;
            int n3 = iPackageFragmentRoot.getKind();
            if (this.typesInWorkingCopies != null && this.seekTypesInWorkingCopies(string2, iPackageFragment, n2, bl, string4, n, iJavaElementRequestor)) {
                return;
            }
            switch (n3) {
                case 2: {
                    string2 = string2.replace('.', '$');
                    this.seekBindingsInBinaryPackage(string2, 4, iPackageFragment, bl, n, iJavaElementRequestor);
                    break;
                }
                case 1: {
                    this.seekTypesInSourcePackage(string2, iPackageFragment, n2, bl, string4, n, iJavaElementRequestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    public void seekBindings(String string, int n, IPackageFragment iPackageFragment, boolean bl, int n2, IJavaElementRequestor iJavaElementRequestor) {
        String string2;
        String string3 = string2 = bl ? string.toLowerCase() : string;
        if (iPackageFragment == null) {
            this.findAllBindings(string2, n, bl, n2, iJavaElementRequestor);
            return;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
        try {
            int n3 = -1;
            String string4 = null;
            int n4 = iPackageFragmentRoot.getKind();
            if (this.typesInWorkingCopies != null || n4 == 1) {
                n3 = string2.indexOf(46);
                if (!bl) {
                    String string5 = string4 = n3 == -1 ? string2 : string2.substring(0, n3);
                }
            }
            if (this.bindingsInWorkingCopies != null && this.seekBindingsInWorkingCopies(string2, n, iPackageFragment, n3, bl, string4, n2, iJavaElementRequestor)) {
                return;
            }
            switch (n4) {
                case 2: {
                    this.seekBindingsInBinaryPackage(string2, n, iPackageFragment, bl, n2, iJavaElementRequestor);
                    break;
                }
                case 1: {
                    this.seekBindingsInSourcePackage(string2, n, iPackageFragment, n3, bl, string4, n2, iJavaElementRequestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void seekBindingsInBinaryPackage(String var1_1, int var2_2, IPackageFragment var3_3, boolean var4_4, int var5_5, IJavaElementRequestor var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 708->712)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void seekTypesInSourcePackage(String var1_1, IPackageFragment var2_2, int var3_3, boolean var4_4, String var5_5, int var6_6, IJavaElementRequestor var7_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [7 : 303->307)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void seekBindingsInSourcePackage(String var1_1, int var2_2, IPackageFragment var3_3, int var4_4, boolean var5_5, String var6_6, int var7_7, IJavaElementRequestor var8_8) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [7 : 598->602)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean seekTypesInType(String string, int n, IType iType, IJavaElementRequestor iJavaElementRequestor, int n2) {
        IType[] iTypeArray = null;
        try {
            iTypeArray = iType.getTypes();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int n3 = iTypeArray.length;
        if (n3 == 0) {
            return false;
        }
        String string2 = string;
        boolean bl = false;
        if (n != -1) {
            string2 = string.substring(0, n);
            bl = true;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (iJavaElementRequestor.isCanceled()) {
                return false;
            }
            IType iType2 = iTypeArray[n4];
            if (iType2.getElementName().toLowerCase().startsWith(string2)) {
                if (bl) {
                    String string3 = string.substring(n + 1, string.length());
                    return this.seekTypesInType(string3, string3.indexOf(46), iType2, iJavaElementRequestor, n2);
                }
                if (this.acceptType(iType2, n2, true)) {
                    iJavaElementRequestor.acceptMemberType(iType2);
                    return true;
                }
            }
            ++n4;
        }
        return false;
    }

    protected boolean seekTypesInTopLevelType(String string, int n, IType iType, IJavaElementRequestor iJavaElementRequestor, int n2) {
        if (!iType.getElementName().toLowerCase().startsWith(string)) {
            return false;
        }
        if (n == -1) {
            if (this.acceptType(iType, n2, true)) {
                iJavaElementRequestor.acceptType(iType);
                return true;
            }
        } else {
            return this.seekTypesInType(string, n, iType, iJavaElementRequestor, n2);
        }
        return false;
    }

    protected boolean seekTypesInWorkingCopies(String string, IPackageFragment iPackageFragment, int n, boolean bl, String string2, int n2, IJavaElementRequestor iJavaElementRequestor) {
        block11: {
            block10: {
                Object v;
                block12: {
                    if (bl) break block10;
                    HashMap hashMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(iPackageFragment);
                    if (hashMap == null) break block11;
                    v = hashMap.get(string2);
                    if (!(v instanceof IType)) break block12;
                    IType iType = this.getMemberType((IType)v, string, n);
                    if (this.acceptType(iType, n2, true)) {
                        iJavaElementRequestor.acceptType(iType);
                        return true;
                    }
                    break block11;
                }
                if (!(v instanceof IType[])) break block11;
                if (v == NO_TYPES) {
                    return true;
                }
                IType[] iTypeArray = (IType[])v;
                int n3 = 0;
                int n4 = iTypeArray.length;
                while (n3 < n4) {
                    if (iJavaElementRequestor.isCanceled()) {
                        return false;
                    }
                    IType iType = this.getMemberType(iTypeArray[n3], string, n);
                    if (this.acceptType(iType, n2, true)) {
                        iJavaElementRequestor.acceptType(iType);
                        return true;
                    }
                    ++n3;
                }
                break block11;
            }
            HashMap hashMap = this.typesInWorkingCopies == null ? null : this.typesInWorkingCopies.get(iPackageFragment);
            if (hashMap != null) {
                Iterator iterator = hashMap.values().iterator();
                while (iterator.hasNext()) {
                    if (iJavaElementRequestor.isCanceled()) {
                        return false;
                    }
                    Object v = iterator.next();
                    if (v instanceof IType) {
                        this.seekTypesInTopLevelType(string, n, (IType)v, iJavaElementRequestor, n2);
                        continue;
                    }
                    if (!(v instanceof IType[])) continue;
                    IType[] iTypeArray = (IType[])v;
                    int n5 = 0;
                    int n6 = iTypeArray.length;
                    while (n5 < n6) {
                        this.seekTypesInTopLevelType(string, n, iTypeArray[n5], iJavaElementRequestor, n2);
                        ++n5;
                    }
                }
            }
        }
        return false;
    }

    private boolean checkBindingAccept(String string, HashMap[] hashMapArray, int n, IJavaElementRequestor iJavaElementRequestor) {
        Object v = hashMapArray[n].get(string);
        if (v instanceof IJavaElement) {
            if (this.doAcceptBinding((IJavaElement)v, n, true, iJavaElementRequestor)) {
                return true;
            }
        } else if (v instanceof IJavaElement[]) {
            if (v == NO_BINDINGS) {
                return true;
            }
            IJavaElement[] iJavaElementArray = (IJavaElement[])v;
            int n2 = 0;
            int n3 = iJavaElementArray.length;
            while (n2 < n3) {
                if (iJavaElementRequestor.isCanceled()) {
                    return false;
                }
                if (this.doAcceptBinding(iJavaElementArray[n2], n, true, iJavaElementRequestor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean seekBindingsInWorkingCopies(String string, int n, IPackageFragment iPackageFragment, int n2, boolean bl, String string2, int n3, IJavaElementRequestor iJavaElementRequestor) {
        n &= 0xF;
        if (!bl) {
            HashMap[] hashMapArray = this.bindingsInWorkingCopies == null ? null : this.bindingsInWorkingCopies.get(iPackageFragment);
            if (hashMapArray != null) {
                if (this.checkBindingAccept(string2, hashMapArray, n, iJavaElementRequestor)) {
                    return true;
                }
                if ((n & 3) > 0 && n != 3 && this.checkBindingAccept(string2, hashMapArray, 3, iJavaElementRequestor)) {
                    return true;
                }
                if ((n & 2) > 0 && n != 2 && this.checkBindingAccept(string2, hashMapArray, 2, iJavaElementRequestor)) {
                    return true;
                }
                if ((n & 8) > 0 && n != 8 && this.checkBindingAccept(string2, hashMapArray, 8, iJavaElementRequestor)) {
                    return true;
                }
                if ((n & 4) > 0 && n != 4 && this.checkBindingAccept(string2, hashMapArray, 4, iJavaElementRequestor)) {
                    return true;
                }
            }
        } else {
            HashMap[] hashMapArray = this.bindingsInWorkingCopies == null ? null : this.bindingsInWorkingCopies.get(iPackageFragment);
            if (hashMapArray != null) {
                Iterator iterator = hashMapArray[n].values().iterator();
                while (iterator.hasNext()) {
                    if (iJavaElementRequestor.isCanceled()) {
                        return false;
                    }
                    Object v = iterator.next();
                    if (v instanceof IType) {
                        this.seekTypesInTopLevelType(string, n2, (IType)v, iJavaElementRequestor, n3);
                        continue;
                    }
                    if (!(v instanceof IType[])) continue;
                    IType[] iTypeArray = (IType[])v;
                    int n4 = 0;
                    int n5 = iTypeArray.length;
                    while (n4 < n5) {
                        this.seekTypesInTopLevelType(string, n2, iTypeArray[n4], iJavaElementRequestor, n3);
                        ++n4;
                    }
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Answer findBindingSearch(String string, String string2, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, IProgressMonitor iProgressMonitor, boolean bl5, String string3) {
        if (this.searchScope == null) {
            this.searchScope = BasicSearchEngine.createJavaSearchScope(this.packageFragmentRoots);
        }
        ArrayList<IOpenable> arrayList = new ArrayList<IOpenable>();
        Path path = string3 != null ? new Path(string3) : null;
        class MyRequestor
        implements IJavaElementRequestor {
            IJavaElement element;
            final /* synthetic */ NameLookup this$0;

            MyRequestor(NameLookup nameLookup) {
                this.this$0 = nameLookup;
            }

            public void acceptField(IField iField) {
                this.element = iField;
            }

            public void acceptInitializer(IInitializer iInitializer) {
            }

            public void acceptMemberType(IType iType) {
                this.element = iType;
            }

            public void acceptMethod(IMethod iMethod) {
                this.element = iMethod;
            }

            public void acceptPackageFragment(IPackageFragment iPackageFragment) {
            }

            public void acceptType(IType iType) {
                this.element = iType;
            }

            public boolean isCanceled() {
                return false;
            }
        }
        MyRequestor myRequestor = new MyRequestor(this);
        JavaElementRequestor javaElementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(string2, false, javaElementRequestor);
        IPackageFragment[] iPackageFragmentArray = javaElementRequestor.getPackageFragments();
        int n3 = 0;
        while (n3 < iPackageFragmentArray.length) {
            this.seekBindingsInWorkingCopies(string, n, iPackageFragmentArray[n3], -1, bl, string, n2, myRequestor);
            if (myRequestor.element != null) {
                IOpenable iOpenable = myRequestor.element.getOpenable();
                if (path == null || !myRequestor.element.getPath().equals((Object)path)) {
                    if (!bl5) {
                        return new Answer(iOpenable, null);
                    }
                    arrayList.add(iOpenable);
                    myRequestor.element = null;
                }
            }
            ++n3;
        }
        try {
            IRestrictedAccessBindingRequestor iRestrictedAccessBindingRequestor = this.getRestrictedAccessRequestor();
            iRestrictedAccessBindingRequestor.setExcludePath(string3);
            try {
                block17: {
                    try {
                        int n4 = 8;
                        new BasicSearchEngine().searchAllBindingNames(null, string.toCharArray(), n, n4, this.searchScope, iRestrictedAccessBindingRequestor, 3, false, iProgressMonitor);
                        if (iRestrictedAccessBindingRequestor.getFoundPath() == null) break block17;
                        Iterator iterator = iRestrictedAccessBindingRequestor.getFoundPaths().iterator();
                        while (true) {
                            Openable openable;
                            if (!iterator.hasNext()) {
                                if (arrayList.size() > 0 && bl5) {
                                    break;
                                }
                                break block17;
                            }
                            String string4 = (String)iterator.next();
                            if (this.handleFactory == null) {
                                this.handleFactory = new HandleFactory();
                            }
                            if ((openable = this.handleFactory.createOpenable(string4, this.searchScope)) == null) continue;
                            if (!bl5) {
                                Answer answer = new Answer(openable, null);
                                Object var22_27 = null;
                                iRestrictedAccessBindingRequestor.reset();
                                return answer;
                            }
                            arrayList.add(openable);
                        }
                        Answer answer = new Answer(arrayList.toArray(), null);
                        Object var22_28 = null;
                        iRestrictedAccessBindingRequestor.reset();
                        return answer;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        Answer answer = this.findBinding(string, string2, n, bl, n2, bl2, bl3, bl4, iProgressMonitor);
                        Object var22_29 = null;
                        iRestrictedAccessBindingRequestor.reset();
                        return answer;
                    }
                }
                Object var22_31 = null;
                iRestrictedAccessBindingRequestor.reset();
                return null;
            }
            catch (Throwable throwable) {
                Object var22_30 = null;
                iRestrictedAccessBindingRequestor.reset();
                throw throwable;
            }
        }
        catch (JavaModelException javaModelException) {
            return this.findBinding(string, string2, n, bl, n2, bl2, bl3, bl4, iProgressMonitor);
        }
    }

    public IOpenable createOpenable(String string, IJavaSearchScope iJavaSearchScope) {
        if (this.packageFragmentRoots == null) {
            return null;
        }
        Path path = new Path(string);
        int n = 0;
        while (n < this.packageFragmentRoots.length) {
            int n2;
            int n3;
            IPackageFragmentRoot iPackageFragmentRoot = this.packageFragmentRoots[n];
            IPath iPath = iPackageFragmentRoot.getPath();
            String string2 = path.lastSegment();
            IPath iPath2 = null;
            if (iPackageFragmentRoot.isLanguageRuntime() && (n3 = iPath.segmentCount()) > (n2 = path.segmentCount())) {
                iPath2 = iPath.removeFirstSegments(n3 - n2).setDevice(null).makeAbsolute();
            }
            if (iPath.isPrefixOf((IPath)path) || iPath2 != null && iPath2.equals((Object)path.makeAbsolute())) {
                if (iPackageFragmentRoot instanceof LibraryFragmentRoot) {
                    IClassFile iClassFile = iPackageFragmentRoot.getPackageFragment(iPackageFragmentRoot.getPath().toString()).getClassFile(iPackageFragmentRoot.getPath().toString());
                    return iClassFile;
                }
                if (path.toFile().exists()) {
                    IClassFile iClassFile = iPackageFragmentRoot.getPackageFragment(string).getClassFile(string);
                    return iClassFile;
                }
                String string3 = string.substring(iPath.toString().length());
                n2 = string3.indexOf(string2);
                if (n2 > -1) {
                    string3 = string3.substring(0, n2 - 1);
                }
                ICompilationUnit iCompilationUnit = iPackageFragmentRoot.getPackageFragment(string3).getCompilationUnit(string2);
                return iCompilationUnit;
            }
            ++n;
        }
        return null;
    }

    public static class Answer {
        public IType type;
        public Object element;
        AccessRestriction restriction;

        Answer(IType iType, AccessRestriction accessRestriction) {
            this.type = iType;
            this.restriction = accessRestriction;
        }

        Answer(Object object, AccessRestriction accessRestriction) {
            this.element = object;
            this.restriction = accessRestriction;
        }

        public boolean ignoreIfBetter() {
            return this.restriction != null && this.restriction.ignoreIfBetter();
        }

        public boolean isBetter(Answer answer) {
            if (answer == null) {
                return true;
            }
            if (this.restriction == null) {
                return true;
            }
            return answer.restriction != null && this.restriction.getProblemId() < answer.restriction.getProblemId();
        }
    }
}

