/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.ChangeClasspathOperation;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class SetClasspathOperation
extends ChangeClasspathOperation {
    IClasspathEntry[] newRawClasspath;
    IPath newOutputLocation;
    JavaProject project;

    public SetClasspathOperation(JavaProject javaProject, IClasspathEntry[] iClasspathEntryArray, IPath iPath, boolean bl) {
        super(new IJavaElement[]{javaProject}, bl);
        this.project = javaProject;
        this.newRawClasspath = iClasspathEntryArray;
        this.newOutputLocation = iPath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            this.project.getPerProjectInfo().setClasspath(this.newRawClasspath, this.newOutputLocation, JavaModelStatus.VERIFIED_OK, null, null, null, null);
            this.classpathChanged(this.project);
            if (this.canChangeResources && this.project.saveClasspath(this.newRawClasspath, this.newOutputLocation)) {
                SetClasspathOperation.setAttribute("hasModifiedResource", "true");
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.done();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.done();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("SetClasspathOperation\n");
        stringBuffer.append(" - classpath : ");
        stringBuffer.append("{");
        int n = 0;
        while (n < this.newRawClasspath.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            IClasspathEntry iClasspathEntry = this.newRawClasspath[n];
            stringBuffer.append(" ").append(iClasspathEntry.toString());
            ++n;
        }
        stringBuffer.append("\n - output location : ");
        stringBuffer.append(this.newOutputLocation.toString());
        return stringBuffer.toString();
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus iJavaModelStatus = super.verify();
        if (!iJavaModelStatus.isOK()) {
            return iJavaModelStatus;
        }
        return ClasspathEntry.validateClasspath(this.project, this.newRawClasspath, this.newOutputLocation);
    }
}

