/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceField;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceImport;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.core.Initializer;
import org.eclipse.wst.jsdt.internal.core.InitializerElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.MemberElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.TypeParameterElementInfo;

public class SourceTypeElementInfo
extends MemberElementInfo
implements ISourceType {
    protected static final ISourceImport[] NO_IMPORTS = new ISourceImport[0];
    protected static final InitializerElementInfo[] NO_INITIALIZERS = new InitializerElementInfo[0];
    protected static final SourceField[] NO_FIELDS = new SourceField[0];
    protected static final SourceMethod[] NO_METHODS = new SourceMethod[0];
    protected static final SourceType[] NO_TYPES = new SourceType[0];
    protected char[] superclassName;
    protected char[][] superInterfaceNames;
    protected IType handle = null;
    protected ITypeParameter[] typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
    protected HashMap categories;
    protected boolean isBinary;

    public SourceTypeElementInfo(boolean bl) {
        this.isBinary = bl;
    }

    protected void addCategories(IJavaElement iJavaElement, char[][] cArray) {
        if (cArray == null) {
            return;
        }
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        this.categories.put(iJavaElement, CharOperation.toStrings(cArray));
    }

    public HashMap getCategories() {
        return this.categories;
    }

    public ISourceType getEnclosingType() {
        IJavaElement iJavaElement = this.handle.getParent();
        if (iJavaElement != null && iJavaElement.getElementType() == 7) {
            try {
                return (ISourceType)((JavaElement)iJavaElement).getElementInfo();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public ISourceField[] getFields() {
        SourceField[] sourceFieldArray = this.getFieldHandles();
        int n = sourceFieldArray.length;
        ISourceField[] iSourceFieldArray = new ISourceField[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                ISourceField iSourceField;
                iSourceFieldArray[n2] = iSourceField = (ISourceField)sourceFieldArray[n2].getElementInfo();
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        return iSourceFieldArray;
    }

    public SourceField[] getFieldHandles() {
        int n = this.children.length;
        if (n == 0) {
            return NO_FIELDS;
        }
        SourceField[] sourceFieldArray = new SourceField[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IJavaElement iJavaElement = this.children[n3];
            if (iJavaElement instanceof SourceField) {
                sourceFieldArray[n2++] = (SourceField)iJavaElement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_FIELDS;
        }
        if (n2 < n) {
            SourceField[] sourceFieldArray2 = sourceFieldArray;
            sourceFieldArray = new SourceField[n2];
            System.arraycopy(sourceFieldArray2, 0, sourceFieldArray, 0, n2);
        }
        return sourceFieldArray;
    }

    public char[] getFileName() {
        return this.handle.getPath().toString().toCharArray();
    }

    public IType getHandle() {
        return this.handle;
    }

    public InitializerElementInfo[] getInitializers() {
        int n = this.children.length;
        if (n == 0) {
            return NO_INITIALIZERS;
        }
        InitializerElementInfo[] initializerElementInfoArray = new InitializerElementInfo[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IJavaElement iJavaElement = this.children[n3];
            if (iJavaElement instanceof Initializer) {
                try {
                    InitializerElementInfo initializerElementInfo = (InitializerElementInfo)((Initializer)iJavaElement).getElementInfo();
                    initializerElementInfoArray[n2++] = initializerElementInfo;
                }
                catch (JavaModelException javaModelException) {}
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_INITIALIZERS;
        }
        InitializerElementInfo[] initializerElementInfoArray2 = initializerElementInfoArray;
        initializerElementInfoArray = new InitializerElementInfo[n2];
        System.arraycopy(initializerElementInfoArray2, 0, initializerElementInfoArray, 0, n2);
        return initializerElementInfoArray;
    }

    public char[][] getInterfaceNames() {
        if (this.handle.getElementName().length() == 0) {
            return null;
        }
        return this.superInterfaceNames;
    }

    public ISourceType[] getMemberTypes() {
        SourceType[] sourceTypeArray = this.getMemberTypeHandles();
        int n = sourceTypeArray.length;
        ISourceType[] iSourceTypeArray = new ISourceType[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                ISourceType iSourceType;
                iSourceTypeArray[n2] = iSourceType = (ISourceType)sourceTypeArray[n2].getElementInfo();
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        return iSourceTypeArray;
    }

    public SourceType[] getMemberTypeHandles() {
        int n = this.children.length;
        if (n == 0) {
            return NO_TYPES;
        }
        SourceType[] sourceTypeArray = new SourceType[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IJavaElement iJavaElement = this.children[n3];
            if (iJavaElement instanceof SourceType) {
                sourceTypeArray[n2++] = (SourceType)iJavaElement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_TYPES;
        }
        if (n2 < n) {
            SourceType[] sourceTypeArray2 = sourceTypeArray;
            sourceTypeArray = new SourceType[n2];
            System.arraycopy(sourceTypeArray2, 0, sourceTypeArray, 0, n2);
        }
        return sourceTypeArray;
    }

    public ISourceMethod[] getMethods() {
        SourceMethod[] sourceMethodArray = this.getMethodHandles();
        int n = sourceMethodArray.length;
        ISourceMethod[] iSourceMethodArray = new ISourceMethod[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                ISourceMethod iSourceMethod = (ISourceMethod)sourceMethodArray[n3].getElementInfo();
                iSourceMethodArray[n2++] = iSourceMethod;
            }
            catch (JavaModelException javaModelException) {}
            ++n3;
        }
        return iSourceMethodArray;
    }

    public SourceMethod[] getMethodHandles() {
        int n = this.children.length;
        if (n == 0) {
            return NO_METHODS;
        }
        SourceMethod[] sourceMethodArray = new SourceMethod[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IJavaElement iJavaElement = this.children[n3];
            if (iJavaElement instanceof SourceMethod) {
                sourceMethodArray[n2++] = (SourceMethod)iJavaElement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return NO_METHODS;
        }
        if (n2 < n) {
            SourceMethod[] sourceMethodArray2 = sourceMethodArray;
            sourceMethodArray = new SourceMethod[n2];
            System.arraycopy(sourceMethodArray2, 0, sourceMethodArray, 0, n2);
        }
        return sourceMethodArray;
    }

    public char[] getName() {
        return this.handle.getElementName().toCharArray();
    }

    public char[] getSuperclassName() {
        char[][] cArray;
        if (this.handle.getElementName().length() == 0 && (cArray = this.superInterfaceNames) != null && cArray.length > 0) {
            return cArray[0];
        }
        return this.superclassName;
    }

    public char[][][] getTypeParameterBounds() {
        int n = this.typeParameters.length;
        char[][][] cArrayArray = new char[n][][];
        int n2 = 0;
        while (n2 < n) {
            try {
                TypeParameterElementInfo typeParameterElementInfo = (TypeParameterElementInfo)((JavaElement)((Object)this.typeParameters[n2])).getElementInfo();
                cArrayArray[n2] = typeParameterElementInfo.bounds;
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        return cArrayArray;
    }

    public char[][] getTypeParameterNames() {
        int n = this.typeParameters.length;
        if (n == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = this.typeParameters[n2].getElementName().toCharArray();
            ++n2;
        }
        return cArrayArray;
    }

    public boolean isBinaryType() {
        return this.isBinary;
    }

    public boolean isAnonymousMember() {
        return false;
    }

    protected void setHandle(IType iType) {
        this.handle = iType;
    }

    protected void setSuperclassName(char[] cArray) {
        this.superclassName = cArray;
    }

    protected void setSuperInterfaceNames(char[][] cArray) {
        this.superInterfaceNames = cArray;
    }

    public String toString() {
        return "Info for " + this.handle.toString();
    }

    public char[][] getPackageName() {
        ISourceType iSourceType = this.getEnclosingType();
        if (iSourceType != null) {
            return iSourceType.getPackageName();
        }
        return new char[0][];
    }
}

