/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class BuildNotifier {
    protected IProgressMonitor monitor;
    protected boolean cancelling;
    protected float percentComplete;
    protected float progressPerCompilationUnit;
    protected int newErrorCount;
    protected int fixedErrorCount;
    protected int newWarningCount;
    protected int fixedWarningCount;
    protected int workDone;
    protected int totalWork;
    protected String previousSubtask;
    public static int NewErrorCount = 0;
    public static int FixedErrorCount = 0;
    public static int NewWarningCount = 0;
    public static int FixedWarningCount = 0;

    public static void resetProblemCounters() {
        NewErrorCount = 0;
        FixedErrorCount = 0;
        NewWarningCount = 0;
        FixedWarningCount = 0;
    }

    public BuildNotifier(IProgressMonitor iProgressMonitor, IProject iProject) {
        this.monitor = iProgressMonitor;
        this.cancelling = false;
        this.newErrorCount = NewErrorCount;
        this.fixedErrorCount = FixedErrorCount;
        this.newWarningCount = NewWarningCount;
        this.fixedWarningCount = FixedWarningCount;
        this.workDone = 0;
        this.totalWork = 1000000;
    }

    public void aboutToCompile(SourceFile sourceFile) {
        String string = Messages.bind(Messages.build_compiling, sourceFile.resource.getFullPath().removeLastSegments(1).makeRelative().toString());
        this.subTask(string);
    }

    public void begin() {
        if (this.monitor != null) {
            this.monitor.beginTask("", this.totalWork);
        }
        this.previousSubtask = null;
    }

    public void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void checkCancelWithinCompiler() {
        if (this.monitor != null && this.monitor.isCanceled() && !this.cancelling) {
            this.setCancelling(true);
            throw new AbortCompilation(true, null);
        }
    }

    public void compiled(SourceFile sourceFile) {
        String string = Messages.bind(Messages.build_compiling, sourceFile.resource.getFullPath().removeLastSegments(1).makeRelative().toString());
        this.subTask(string);
        this.updateProgressDelta(this.progressPerCompilationUnit);
        this.checkCancelWithinCompiler();
    }

    public void done() {
        NewErrorCount = this.newErrorCount;
        FixedErrorCount = this.fixedErrorCount;
        NewWarningCount = this.newWarningCount;
        FixedWarningCount = this.fixedWarningCount;
        this.updateProgress(1.0f);
        this.subTask(Messages.build_done);
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.previousSubtask = null;
    }

    protected String problemsMessage() {
        int n = this.newErrorCount + this.newWarningCount;
        int n2 = this.fixedErrorCount + this.fixedWarningCount;
        if (n == 0 && n2 == 0) {
            return "";
        }
        boolean bl = n > 0 && n2 > 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (n > 0) {
            stringBuffer.append(Messages.build_foundHeader);
            stringBuffer.append(' ');
            if (bl || this.newErrorCount > 0) {
                if (this.newErrorCount == 1) {
                    stringBuffer.append(Messages.build_oneError);
                } else {
                    stringBuffer.append(Messages.bind(Messages.build_multipleErrors, String.valueOf(this.newErrorCount)));
                }
                if (bl || this.newWarningCount > 0) {
                    stringBuffer.append(" + ");
                }
            }
            if (bl || this.newWarningCount > 0) {
                if (this.newWarningCount == 1) {
                    stringBuffer.append(Messages.build_oneWarning);
                } else {
                    stringBuffer.append(Messages.bind(Messages.build_multipleWarnings, String.valueOf(this.newWarningCount)));
                }
            }
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
        }
        if (n2 > 0) {
            stringBuffer.append(Messages.build_fixedHeader);
            stringBuffer.append(' ');
            if (bl) {
                stringBuffer.append(String.valueOf(this.fixedErrorCount));
                stringBuffer.append(" + ");
                stringBuffer.append(String.valueOf(this.fixedWarningCount));
            } else {
                if (this.fixedErrorCount > 0) {
                    if (this.fixedErrorCount == 1) {
                        stringBuffer.append(Messages.build_oneError);
                    } else {
                        stringBuffer.append(Messages.bind(Messages.build_multipleErrors, String.valueOf(this.fixedErrorCount)));
                    }
                    if (this.fixedWarningCount > 0) {
                        stringBuffer.append(" + ");
                    }
                }
                if (this.fixedWarningCount > 0) {
                    if (this.fixedWarningCount == 1) {
                        stringBuffer.append(Messages.build_oneWarning);
                    } else {
                        stringBuffer.append(Messages.bind(Messages.build_multipleWarnings, String.valueOf(this.fixedWarningCount)));
                    }
                }
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void setCancelling(boolean bl) {
        this.cancelling = bl;
    }

    public void setProgressPerCompilationUnit(float f) {
        this.progressPerCompilationUnit = f;
    }

    public void subTask(String string) {
        String string2;
        String string3 = this.problemsMessage();
        String string4 = string2 = string3.length() == 0 ? string : String.valueOf(string3) + " " + string;
        if (string2.equals(this.previousSubtask)) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.subTask(string2);
        }
        this.previousSubtask = string2;
    }

    protected void updateProblemCounts(CategorizedProblem[] categorizedProblemArray) {
        int n = 0;
        int n2 = categorizedProblemArray.length;
        while (n < n2) {
            if (categorizedProblemArray[n].isError()) {
                ++this.newErrorCount;
            } else {
                ++this.newWarningCount;
            }
            ++n;
        }
    }

    protected void updateProblemCounts(IMarker[] iMarkerArray, CategorizedProblem[] categorizedProblemArray) {
        Object object;
        int n;
        int n2;
        String string;
        boolean bl;
        CategorizedProblem categorizedProblem;
        int n3;
        int n4;
        if (categorizedProblemArray != null) {
            n4 = 0;
            n3 = categorizedProblemArray.length;
            while (n4 < n3) {
                block18: {
                    categorizedProblem = categorizedProblemArray[n4];
                    if (categorizedProblem.getID() != 536871362) {
                        bl = categorizedProblem.isError();
                        string = categorizedProblem.getMessage();
                        if (iMarkerArray != null) {
                            n2 = 0;
                            n = iMarkerArray.length;
                            while (n2 < n) {
                                object = iMarkerArray[n2];
                                if (object != null) {
                                    boolean bl2;
                                    boolean bl3 = bl2 = 2 == object.getAttribute("severity", 2);
                                    if (bl == bl2 && string.equals(object.getAttribute("message", ""))) {
                                        iMarkerArray[n2] = null;
                                        break block18;
                                    }
                                }
                                ++n2;
                            }
                        }
                        if (bl) {
                            ++this.newErrorCount;
                        } else {
                            ++this.newWarningCount;
                        }
                    }
                }
                ++n4;
            }
        }
        if (iMarkerArray != null) {
            n4 = 0;
            n3 = iMarkerArray.length;
            while (n4 < n3) {
                categorizedProblem = iMarkerArray[n4];
                if (categorizedProblem != null) {
                    bl = 2 == categorizedProblem.getAttribute("severity", 2);
                    string = categorizedProblem.getAttribute("message", "");
                    if (categorizedProblemArray != null) {
                        n2 = 0;
                        n = categorizedProblemArray.length;
                        while (n2 < n) {
                            object = categorizedProblemArray[n2];
                            if (object.getID() == 536871362 || bl != object.isError() || !string.equals(object.getMessage())) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    } else if (bl) {
                        ++this.fixedErrorCount;
                    } else {
                        ++this.fixedWarningCount;
                    }
                }
                ++n4;
            }
        }
    }

    public void updateProgress(float f) {
        if (f > this.percentComplete) {
            this.percentComplete = Math.min(f, 1.0f);
            int n = Math.round(this.percentComplete * (float)this.totalWork);
            if (n > this.workDone) {
                if (this.monitor != null) {
                    this.monitor.worked(n - this.workDone);
                }
                this.workDone = n;
            }
        }
    }

    public void updateProgressDelta(float f) {
        this.updateProgress(this.percentComplete + f);
    }
}

