/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;

public class TokenScanner {
    public static final int END_OF_FILE = 20001;
    public static final int LEXICAL_ERROR = 20002;
    public static final int DOCUMENT_ERROR = 20003;
    private final IScanner scanner;
    private final int endPosition;

    public TokenScanner(IScanner iScanner) {
        this.scanner = iScanner;
        this.endPosition = this.scanner.getSource().length - 1;
    }

    public IScanner getScanner() {
        return this.scanner;
    }

    public void setOffset(int n) {
        this.scanner.resetTo(n, this.endPosition);
    }

    public int getCurrentEndOffset() {
        return this.scanner.getCurrentTokenEndPosition() + 1;
    }

    public int getCurrentStartOffset() {
        return this.scanner.getCurrentTokenStartPosition();
    }

    public int getCurrentLength() {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public int readNext(boolean bl) throws CoreException {
        int n = 0;
        do {
            try {
                n = this.scanner.getNextToken();
                if (n == 158) {
                    throw new CoreException(TokenScanner.createError(20001, "End Of File", null));
                }
            }
            catch (InvalidInputException invalidInputException) {
                throw new CoreException(TokenScanner.createError(20002, invalidInputException.getMessage(), invalidInputException));
            }
        } while (bl && TokenScanner.isComment(n));
        return n;
    }

    public int readNext(int n, boolean bl) throws CoreException {
        this.setOffset(n);
        return this.readNext(bl);
    }

    public int getNextStartOffset(int n, boolean bl) throws CoreException {
        this.readNext(n, bl);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int n, boolean bl) throws CoreException {
        this.readNext(n, bl);
        return this.getCurrentEndOffset();
    }

    public void readToToken(int n) throws CoreException {
        int n2 = 0;
        while ((n2 = this.readNext(false)) != n) {
        }
    }

    public void readToToken(int n, int n2) throws CoreException {
        this.setOffset(n2);
        this.readToToken(n);
    }

    public int getTokenStartOffset(int n, int n2) throws CoreException {
        this.readToToken(n, n2);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(int n, int n2) throws CoreException {
        this.readToToken(n, n2);
        return this.getCurrentEndOffset();
    }

    public int getPreviousTokenEndOffset(int n, int n2) throws CoreException {
        this.setOffset(n2);
        int n3 = n2;
        int n4 = this.readNext(false);
        while (n4 != n) {
            n3 = this.getCurrentEndOffset();
            n4 = this.readNext(false);
        }
        return n3;
    }

    public static boolean isComment(int n) {
        return n == 1002 || n == 1003 || n == 1001;
    }

    public static boolean isModifier(int n) {
        switch (n) {
            case 85: 
            case 94: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return true;
            }
        }
        return false;
    }

    public static IStatus createError(int n, String string, Throwable throwable) {
        return new Status(4, "org.eclipse.wst.jsdt.core", n, string, throwable);
    }
}

