/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.jdom.DOMException;
import org.eclipse.wst.jsdt.core.jdom.IDOMField;
import org.eclipse.wst.jsdt.core.jdom.IDOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMBuilder;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMMember;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMType;
import org.eclipse.wst.jsdt.internal.core.jdom.ILineStartFinder;
import org.eclipse.wst.jsdt.internal.core.jdom.SiblingEnumeration;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class DOMField
extends DOMMember
implements IDOMField {
    protected String fType;
    protected int[] fTypeRange;
    protected String fInitializer;
    protected int[] fInitializerRange;

    DOMField() {
    }

    DOMField(char[] cArray, int[] nArray, String string, int[] nArray2, int[] nArray3, int n, int[] nArray4, int[] nArray5, String string2, boolean bl, int[] nArray6, boolean bl2) {
        super(cArray, nArray, string, nArray2, nArray3, n, nArray4);
        this.fType = string2;
        this.fTypeRange = nArray5;
        this.setHasInitializer(bl);
        this.fInitializerRange = nArray6;
        this.setIsVariableDeclarator(bl2);
        this.setMask(2048, true);
    }

    DOMField(char[] cArray, int[] nArray, String string, int[] nArray2, int n, String string2, boolean bl) {
        this(cArray, nArray, string, nArray2, new int[]{-1, -1}, n, new int[]{-1, -1}, new int[]{-1, -1}, string2, false, new int[]{-1, -1}, bl);
        this.setMask(2048, false);
    }

    protected void appendMemberBodyContents(CharArrayBuffer charArrayBuffer) {
    }

    protected void appendMemberDeclarationContents(CharArrayBuffer charArrayBuffer) {
        if (this.isVariableDeclarator()) {
            charArrayBuffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
        } else {
            charArrayBuffer.append(this.getTypeContents()).append(this.fDocument, this.fTypeRange[1] + 1, this.fNameRange[0] - this.fTypeRange[1] - 1);
        }
        charArrayBuffer.append(this.getNameContents());
        if (this.hasInitializer()) {
            if (this.fInitializerRange[0] < 0) {
                charArrayBuffer.append('=').append(this.fInitializer).append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
            } else {
                charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fInitializerRange[0] - this.fNameRange[1] - 1).append(this.getInitializer()).append(this.fDocument, this.fInitializerRange[1] + 1, this.fSourceRange[1] - this.fInitializerRange[1]);
            }
        } else if (this.fInitializerRange[0] < 0) {
            charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
        } else {
            charArrayBuffer.append(this.fDocument, this.fInitializerRange[1] + 1, this.fSourceRange[1] - this.fInitializerRange[1]);
        }
    }

    protected void appendMemberHeaderFragment(CharArrayBuffer charArrayBuffer) {
        if (this.isVariableDeclarator()) {
            return;
        }
        super.appendMemberHeaderFragment(charArrayBuffer);
    }

    protected void appendSimpleContents(CharArrayBuffer charArrayBuffer) {
        charArrayBuffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
        charArrayBuffer.append(this.fName);
        charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
    }

    protected void becomeDetailed() throws DOMException {
        if (!this.isDetailed()) {
            if (this.isVariableDeclarator() || this.hasMultipleVariableDeclarators()) {
                DOMField dOMField = this.getFirstFieldDeclaration();
                DOMField dOMField2 = this.getLastFieldDeclaration();
                DOMNode dOMNode = dOMField;
                String string = dOMField.getContents();
                while (dOMNode != dOMField2) {
                    dOMNode = dOMNode.fNextNode;
                    string = String.valueOf(string) + dOMNode.getContents();
                }
                DOMBuilder dOMBuilder = new DOMBuilder();
                IDOMField[] iDOMFieldArray = dOMBuilder.createFields(string.toCharArray());
                if (iDOMFieldArray.length == 0) {
                    throw new DOMException(Messages.dom_cannotDetail);
                }
                dOMNode = this;
                int n = 0;
                while (n < iDOMFieldArray.length) {
                    dOMNode.shareContents((DOMNode)((Object)iDOMFieldArray[n]));
                    dOMNode = dOMNode.fNextNode;
                    ++n;
                }
            } else {
                super.becomeDetailed();
            }
        }
    }

    public Object clone() {
        if (this.isVariableDeclarator() || this.hasMultipleVariableDeclarators()) {
            return this.getFactory().createField(new String(this.getSingleVariableDeclaratorContents()));
        }
        return super.clone();
    }

    protected void expand() {
        if (this.isVariableDeclarator() || this.hasMultipleVariableDeclarators()) {
            SiblingEnumeration siblingEnumeration = new SiblingEnumeration(this.getFirstFieldDeclaration());
            DOMField dOMField = (DOMField)siblingEnumeration.nextElement();
            DOMNode dOMNode = dOMField.fNextNode;
            while (siblingEnumeration.hasMoreElements() && dOMNode instanceof DOMField && ((DOMField)dOMNode).isVariableDeclarator()) {
                dOMField.localizeContents();
                if (dOMField.fParent != null) {
                    dOMField.fParent.fragment();
                }
                dOMField = (DOMField)siblingEnumeration.nextElement();
                dOMNode = dOMField.fNextNode;
            }
            dOMField.localizeContents();
        }
    }

    protected DOMNode getDetailedNode() {
        if (this.isVariableDeclarator() || this.hasMultipleVariableDeclarators()) {
            return (DOMNode)((Object)this.getFactory().createField(new String(this.getSingleVariableDeclaratorContents())));
        }
        return (DOMNode)((Object)this.getFactory().createField(this.getContents()));
    }

    protected DOMField getFirstFieldDeclaration() {
        if (this.isVariableDeclarator()) {
            return ((DOMField)this.fPreviousNode).getFirstFieldDeclaration();
        }
        return this;
    }

    public String getInitializer() {
        this.becomeDetailed();
        if (this.hasInitializer()) {
            if (this.fInitializer != null) {
                return this.fInitializer;
            }
            return new String(this.fDocument, this.fInitializerRange[0], this.fInitializerRange[1] + 1 - this.fInitializerRange[0]);
        }
        return null;
    }

    public IJavaElement getJavaElement(IJavaElement iJavaElement) throws IllegalArgumentException {
        if (iJavaElement.getElementType() == 7) {
            return ((IType)iJavaElement).getField(this.getName());
        }
        throw new IllegalArgumentException(Messages.element_illegalParent);
    }

    protected DOMField getLastFieldDeclaration() {
        DOMField dOMField = this;
        while (dOMField.isVariableDeclarator() || dOMField.hasMultipleVariableDeclarators()) {
            if (!(dOMField.fNextNode instanceof DOMField) || !((DOMField)dOMField.fNextNode).isVariableDeclarator()) break;
            dOMField = (DOMField)dOMField.fNextNode;
        }
        return dOMField;
    }

    protected int getMemberDeclarationStartPosition() {
        return this.fTypeRange[0];
    }

    public int getNodeType() {
        return 5;
    }

    protected char[] getSingleVariableDeclaratorContents() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer();
        DOMField dOMField = this.getFirstFieldDeclaration();
        if (dOMField.isDetailed()) {
            dOMField.appendMemberHeaderFragment(charArrayBuffer);
            charArrayBuffer.append(this.getType());
            if (this.isVariableDeclarator()) {
                charArrayBuffer.append(' ');
            } else {
                charArrayBuffer.append(this.fDocument, this.fTypeRange[1] + 1, this.fNameRange[0] - this.fTypeRange[1] - 1);
            }
        } else {
            charArrayBuffer.append(dOMField.fDocument, dOMField.fSourceRange[0], dOMField.fNameRange[0] - dOMField.fSourceRange[0]);
        }
        charArrayBuffer.append(this.getName());
        if (this.hasInitializer()) {
            if (this.fInitializerRange[0] < 0) {
                charArrayBuffer.append('=').append(this.fInitializer).append(';').append(Util.getLineSeparator(charArrayBuffer.toString(), null));
            } else {
                charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fInitializerRange[0] - this.fNameRange[1] - 1).append(this.getInitializer()).append(';').append(Util.getLineSeparator(charArrayBuffer.toString(), null));
            }
        } else {
            charArrayBuffer.append(';').append(Util.getLineSeparator(charArrayBuffer.toString(), null));
        }
        return charArrayBuffer.getContents();
    }

    public String getType() {
        return this.fType;
    }

    protected char[] getTypeContents() {
        if (this.isTypeAltered()) {
            return this.fType.toCharArray();
        }
        return CharOperation.subarray(this.fDocument, this.fTypeRange[0], this.fTypeRange[1] + 1);
    }

    protected boolean hasInitializer() {
        return this.getMask(1);
    }

    protected boolean hasMultipleVariableDeclarators() {
        return this.fNextNode != null && this.fNextNode instanceof DOMField && ((DOMField)this.fNextNode).isVariableDeclarator();
    }

    public void insertSibling(IDOMNode iDOMNode) throws IllegalArgumentException, DOMException {
        if (this.isVariableDeclarator()) {
            this.expand();
        }
        super.insertSibling(iDOMNode);
    }

    protected boolean isTypeAltered() {
        return this.getMask(4);
    }

    protected boolean isVariableDeclarator() {
        return this.getMask(2);
    }

    protected DOMNode newDOMNode() {
        return new DOMField();
    }

    void normalizeEndPosition(ILineStartFinder iLineStartFinder, DOMNode dOMNode) {
        if (dOMNode == null) {
            DOMNode dOMNode2 = (DOMNode)this.getParent();
            if (dOMNode2 == null || dOMNode2 instanceof DOMCompilationUnit) {
                this.setSourceRangeEnd(this.fDocument.length - 1);
            } else {
                int n = ((DOMType)dOMNode2).getCloseBodyPosition() - 1;
                this.setSourceRangeEnd(n);
                this.fInsertionPosition = Math.max(iLineStartFinder.getLineStart(n + 1), this.getEndPosition());
            }
        } else {
            DOMField dOMField;
            int n = dOMNode.getStartPosition() - 1;
            this.fInsertionPosition = Math.max(iLineStartFinder.getLineStart(n + 1), this.getEndPosition());
            dOMNode.normalizeStartPosition(this.getEndPosition(), iLineStartFinder);
            if (dOMNode instanceof DOMField && (dOMField = (DOMField)dOMNode).isVariableDeclarator() && this.fTypeRange[0] == dOMField.fTypeRange[0]) {
                return;
            }
            this.setSourceRangeEnd(dOMNode.getStartPosition() - 1);
        }
    }

    void normalizeStartPosition(int n, ILineStartFinder iLineStartFinder) {
        if (this.isVariableDeclarator()) {
            this.setStartPosition(this.fPreviousNode.getEndPosition() + 1);
        } else {
            super.normalizeStartPosition(n, iLineStartFinder);
        }
    }

    protected void offset(int n) {
        super.offset(n);
        this.offsetRange(this.fInitializerRange, n);
        this.offsetRange(this.fTypeRange, n);
    }

    public void remove() {
        this.expand();
        super.remove();
    }

    public void setComment(String string) {
        this.expand();
        super.setComment(string);
    }

    public void setFlags(int n) {
        this.expand();
        super.setFlags(n);
    }

    protected void setHasInitializer(boolean bl) {
        this.setMask(1, bl);
    }

    public void setInitializer(String string) {
        this.becomeDetailed();
        this.fragment();
        this.setHasInitializer(string != null);
        this.fInitializer = string;
    }

    void setInitializerRange(int n, int n2) {
        this.fInitializerRange[0] = n;
        this.fInitializerRange[1] = n2;
    }

    protected void setIsVariableDeclarator(boolean bl) {
        this.setMask(2, bl);
    }

    public void setName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        super.setName(string);
        this.setTypeAltered(true);
    }

    public void setType(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.element_nullType);
        }
        this.becomeDetailed();
        this.expand();
        this.fragment();
        this.setTypeAltered(true);
        this.setNameAltered(true);
        this.fType = string;
    }

    protected void setTypeAltered(boolean bl) {
        this.setMask(4, bl);
    }

    protected void shareContents(DOMNode dOMNode) {
        super.shareContents(dOMNode);
        DOMField dOMField = (DOMField)dOMNode;
        this.fInitializer = dOMField.fInitializer;
        this.fInitializerRange = this.rangeCopy(dOMField.fInitializerRange);
        this.fType = dOMField.fType;
        this.fTypeRange = this.rangeCopy(dOMField.fTypeRange);
    }

    public String toString() {
        return "FIELD: " + this.getName();
    }
}

