/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.search.HierarchyScope;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.wst.jsdt.internal.core.search.PathCollector;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BasicSearchEngine {
    private Parser parser;
    private CompilerOptions compilerOptions;
    private ICompilationUnit[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(ICompilationUnit[] iCompilationUnitArray) {
        this.workingCopies = iCompilationUnitArray;
    }

    char convertTypeKind(int n) {
        switch (n) {
            case 1: {
                return 'C';
            }
            case 2: {
                return 'I';
            }
            case 3: {
                return 'E';
            }
            case 4: {
                return 'A';
            }
        }
        return '\u0000';
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaSearchScope createHierarchyScope(IType iType) throws JavaModelException {
        return BasicSearchEngine.createHierarchyScope(iType, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaSearchScope createHierarchyScope(IType iType, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        return new HierarchyScope(iType, workingCopyOwner);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray) {
        return BasicSearchEngine.createJavaSearchScope(iJavaElementArray, true);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray, boolean bl) {
        int n = 7;
        if (bl) {
            n |= 8;
        }
        return BasicSearchEngine.createJavaSearchScope(iJavaElementArray, n);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray, int n) {
        JavaSearchScope javaSearchScope = new JavaSearchScope();
        HashSet hashSet = new HashSet(2);
        int n2 = 0;
        int n3 = iJavaElementArray.length;
        while (n2 < n3) {
            IJavaElement iJavaElement = iJavaElementArray[n2];
            if (iJavaElement != null) {
                try {
                    if (iJavaElement instanceof JavaProject) {
                        javaSearchScope.add((JavaProject)iJavaElement, n, hashSet);
                    } else {
                        javaSearchScope.add(iJavaElement);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            ++n2;
        }
        return javaSearchScope;
    }

    public static TypeNameMatch createTypeNameMatch(IType iType, int n) {
        return new JavaSearchTypeNameMatch(iType, n);
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return JavaModelManager.getJavaModelManager().getWorkspaceScope();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findMatches(SearchPattern searchPattern, SearchParticipant[] searchParticipantArray, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws CoreException {
        block20: {
            block19: {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    if (VERBOSE) {
                        Util.verbose("Searching for pattern: " + searchPattern.toString());
                        Util.verbose(iJavaSearchScope.toString());
                    }
                    if (searchParticipantArray == null) {
                        if (VERBOSE) {
                            Util.verbose("No participants => do nothing!");
                        }
                        Object var17_6 = null;
                        searchRequestor.endReporting();
                        if (iProgressMonitor == null) return;
                        break block19;
                    }
                    int n = searchParticipantArray.length;
                    if (iProgressMonitor != null) {
                        iProgressMonitor.beginTask(Messages.engine_searching, 100 * n);
                    }
                    IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
                    searchRequestor.beginReporting();
                    int n2 = 0;
                    while (n2 < n) {
                        Object var15_19;
                        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        SearchParticipant searchParticipant = searchParticipantArray[n2];
                        try {
                            String[] stringArray;
                            if (iProgressMonitor != null) {
                                iProgressMonitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{searchParticipant.getDescription()}));
                            }
                            searchParticipant.beginSearching();
                            searchRequestor.enterParticipant(searchParticipant);
                            PathCollector pathCollector = new PathCollector();
                            indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, searchParticipant, iJavaSearchScope, pathCollector), 3, (IProgressMonitor)(iProgressMonitor == null ? null : new SubProgressMonitor(iProgressMonitor, 50)));
                            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (iProgressMonitor != null) {
                                iProgressMonitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{searchParticipant.getDescription()}));
                            }
                            if ((stringArray = pathCollector.getPaths()) != null) {
                                SearchDocument[] searchDocumentArray;
                                pathCollector = null;
                                int n3 = stringArray.length;
                                SearchDocument[] searchDocumentArray2 = new SearchDocument[n3];
                                int n4 = 0;
                                while (true) {
                                    if (n4 >= n3) {
                                        searchDocumentArray = MatchLocator.addWorkingCopies(searchPattern, searchDocumentArray2, this.getWorkingCopies(), searchParticipant);
                                    }
                                    searchDocumentArray2[n4] = searchParticipant.getDocument(stringArray[n4]);
                                    ++n4;
                                }
                                searchParticipant.locateMatches(searchDocumentArray, searchPattern, iJavaSearchScope, searchRequestor, (IProgressMonitor)(iProgressMonitor == null ? null : new SubProgressMonitor(iProgressMonitor, 50)));
                            }
                        }
                        catch (Throwable throwable) {
                            var15_19 = null;
                            searchRequestor.exitParticipant(searchParticipant);
                            searchParticipant.doneSearching();
                            throw throwable;
                        }
                        {
                            var15_19 = null;
                            searchRequestor.exitParticipant(searchParticipant);
                            searchParticipant.doneSearching();
                            ++n2;
                        }
                    }
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var17_7 = null;
                    searchRequestor.endReporting();
                    if (iProgressMonitor == null) throw throwable;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var17_8 = null;
        searchRequestor.endReporting();
        if (iProgressMonitor == null) return;
        iProgressMonitor.done();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    public static String getMatchRuleString(int n) {
        if (n == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        while (n2 <= 8) {
            int n3 = n & 1 << n2 - 1;
            if (n3 != 0 && stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            switch (n3) {
                case 1: {
                    stringBuffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    stringBuffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    stringBuffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    stringBuffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    stringBuffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    stringBuffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    stringBuffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    stringBuffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getSearchForString(int n) {
        switch (n) {
            case 0: {
                return "TYPE";
            }
            case 1: {
                return "METHOD";
            }
            case 2: {
                return "PACKAGE";
            }
            case 3: {
                return "CONSTRUCTOR";
            }
            case 4: {
                return "FIELD";
            }
            case 5: {
                return "CLASS";
            }
            case 6: {
                return "INTERFACE";
            }
            case 7: {
                return "ENUM";
            }
            case 8: {
                return "ANNOTATION_TYPE";
            }
            case 9: {
                return "CLASS_AND_ENUM";
            }
            case 10: {
                return "CLASS_AND_INTERFACE";
            }
            case 11: {
                return "INTERFACE_AND_ANNOTATION";
            }
            case 12: {
                return "VAR";
            }
            case 13: {
                return "FUNCTION";
            }
        }
        return "UNKNOWN";
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private ICompilationUnit[] getWorkingCopies() {
        int n;
        int n2;
        ICompilationUnit[] iCompilationUnitArray;
        ICompilationUnit[] iCompilationUnitArray2;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                iCompilationUnitArray2 = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (iCompilationUnitArray2 == null) {
                    iCompilationUnitArray2 = this.workingCopies;
                } else {
                    ICompilationUnit iCompilationUnit;
                    iCompilationUnitArray = new HashMap();
                    n2 = 0;
                    n = iCompilationUnitArray2.length;
                    while (n2 < n) {
                        iCompilationUnit = iCompilationUnitArray2[n2];
                        iCompilationUnitArray.put(iCompilationUnit.getPath(), iCompilationUnit);
                        ++n2;
                    }
                    n2 = 0;
                    n = this.workingCopies.length;
                    while (n2 < n) {
                        iCompilationUnit = this.workingCopies[n2];
                        iCompilationUnitArray.put(iCompilationUnit.getPath(), iCompilationUnit);
                        ++n2;
                    }
                    n2 = iCompilationUnitArray.size();
                    iCompilationUnitArray2 = new ICompilationUnit[n2];
                    iCompilationUnitArray.values().toArray(iCompilationUnitArray2);
                }
            } else {
                iCompilationUnitArray2 = this.workingCopies;
            }
        } else {
            iCompilationUnitArray2 = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (iCompilationUnitArray2 == null) {
            return null;
        }
        iCompilationUnitArray = null;
        n2 = iCompilationUnitArray2.length;
        n = 0;
        int n3 = 0;
        while (n3 < n2) {
            CompilationUnit compilationUnit = (CompilationUnit)iCompilationUnitArray2[n3];
            try {
                if (!compilationUnit.isPrimary() || compilationUnit.hasUnsavedChanges() || compilationUnit.hasResourceChanged()) {
                    if (iCompilationUnitArray == null) {
                        iCompilationUnitArray = new ICompilationUnit[n2];
                    }
                    iCompilationUnitArray[n++] = compilationUnit;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n3;
        }
        if (n != n2 && iCompilationUnitArray != null) {
            ICompilationUnit[] iCompilationUnitArray3 = iCompilationUnitArray;
            iCompilationUnitArray = new ICompilationUnit[n];
            System.arraycopy(iCompilationUnitArray3, 0, iCompilationUnitArray, 0, n);
        }
        return iCompilationUnitArray;
    }

    private ICompilationUnit[] getWorkingCopies(IJavaElement iJavaElement) {
        ICompilationUnit iCompilationUnit;
        if (iJavaElement instanceof IMember && (iCompilationUnit = ((IMember)iJavaElement).getCompilationUnit()) != null && iCompilationUnit.isWorkingCopy()) {
            int n;
            ICompilationUnit[] iCompilationUnitArray = this.getWorkingCopies();
            int n2 = n = iCompilationUnitArray == null ? 0 : iCompilationUnitArray.length;
            if (n > 0) {
                ICompilationUnit[] iCompilationUnitArray2 = new ICompilationUnit[n + 1];
                System.arraycopy(iCompilationUnitArray, 0, iCompilationUnitArray2, 0, n);
                iCompilationUnitArray2[n] = iCompilationUnit;
                return iCompilationUnitArray2;
            }
            return new ICompilationUnit[]{iCompilationUnit};
        }
        return this.getWorkingCopies();
    }

    boolean match(char c, int n) {
        switch (c) {
            case 'C': {
                return (n & 0x6200) == 0;
            }
            case '\n': {
                return (n & 0x6000) == 0;
            }
            case '\t': {
                return (n & 0x2200) == 0;
            }
            case 'I': {
                return (n & 0x200) != 0;
            }
            case '\u000b': {
                return (n & 0x2200) != 0;
            }
            case 'E': {
                return (n & 0x4000) != 0;
            }
            case 'A': {
                return (n & 0x2000) != 0;
            }
        }
        return true;
    }

    boolean match(char c, char[] cArray, char[] cArray2, int n, int n2, char[] cArray3, char[] cArray4) {
        boolean bl;
        if (cArray4 == null) {
            cArray4 = CharOperation.NO_CHAR;
        }
        switch (c) {
            case 'C': {
                if (n2 == 1) break;
                return false;
            }
            case '\n': {
                if (n2 == 1 || n2 == 2) break;
                return false;
            }
            case '\t': {
                if (n2 == 1 || n2 == 3) break;
                return false;
            }
            case 'I': {
                if (n2 == 2) break;
                return false;
            }
            case '\u000b': {
                if (n2 == 2 || n2 == 4) break;
                return false;
            }
            case 'E': {
                if (n2 == 3) break;
                return false;
            }
            case 'A': {
                if (n2 == 4) break;
                return false;
            }
        }
        boolean bl2 = bl = (n & 8) != 0;
        if (cArray != null && !CharOperation.equals(cArray, cArray3, bl)) {
            return false;
        }
        if (cArray2 != null) {
            boolean bl3;
            boolean bl4 = (n & 0x80) != 0;
            int n3 = n & 7;
            if (!bl && !bl4) {
                cArray2 = CharOperation.toLowerCase(cArray2);
            }
            boolean bl5 = bl3 = !bl || cArray2[0] == cArray4[0];
            if (bl4 && bl3 && CharOperation.camelCaseMatch(cArray2, cArray4)) {
                return true;
            }
            switch (n3) {
                case 0: {
                    if (!bl4) {
                        return bl3 && CharOperation.equals(cArray2, cArray4, bl);
                    }
                }
                case 1: {
                    return bl3 && CharOperation.prefixEquals(cArray2, cArray4, bl);
                }
                case 2: {
                    return CharOperation.match(cArray2, cArray4, bl);
                }
            }
        }
        return true;
    }

    public void search(SearchPattern searchPattern, SearchParticipant[] searchParticipantArray, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaSearchScope, SearchRequestor, IProgressMonitor)");
        }
        this.findMatches(searchPattern, searchParticipantArray, iJavaSearchScope, searchRequestor, iProgressMonitor);
    }

    /*
     * Exception decompiling
     */
    public void searchAllBindingNames(char[] var1_1, char[] var2_2, int var3_3, int var4_4, IJavaSearchScope var5_5, IRestrictedAccessBindingRequestor var6_6, int var7_7, boolean var8_8, IProgressMonitor var9_9) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 1365->1369)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllSecondaryTypeNames(IPackageFragmentRoot[] var1_1, IRestrictedAccessTypeRequestor var2_2, boolean var3_3, IProgressMonitor var4_4) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 349->353)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(char[] var1_1, int var2_2, char[] var3_3, int var4_4, int var5_5, IJavaSearchScope var6_6, IRestrictedAccessTypeRequestor var7_7, int var8_8, IProgressMonitor var9_9) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 976->980)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(char[][] var1_1, char[][] var2_2, int var3_3, int var4_4, IJavaSearchScope var5_5, IRestrictedAccessTypeRequestor var6_6, int var7_7, IProgressMonitor var8_8) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 917->921)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchDeclarations(IJavaElement iJavaElement, SearchRequestor searchRequestor, SearchPattern searchPattern, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SearchDocument[] searchDocumentArray;
        Object object;
        if (VERBOSE) {
            Util.verbose("\t- java element: " + iJavaElement);
        }
        IJavaSearchScope iJavaSearchScope = BasicSearchEngine.createJavaSearchScope(new IJavaElement[]{iJavaElement});
        IResource iResource = iJavaElement.getResource();
        if (iJavaElement instanceof IMember) {
            object = (IMember)iJavaElement;
            searchDocumentArray = object.getCompilationUnit();
            if (searchDocumentArray != null) {
                iResource = searchDocumentArray.getResource();
            } else if (object.isBinary()) {
                iResource = null;
            }
        }
        try {
            if (!(iResource instanceof IFile)) {
                this.search(searchPattern, new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()}, iJavaSearchScope, searchRequestor, iProgressMonitor);
                return;
            }
            try {
                searchRequestor.beginReporting();
                if (VERBOSE) {
                    Util.verbose("Searching for " + searchPattern + " in " + iResource.getFullPath());
                }
                object = BasicSearchEngine.getDefaultSearchParticipant();
                searchDocumentArray = MatchLocator.addWorkingCopies(searchPattern, new SearchDocument[]{new JavaSearchDocument(iJavaElement.getPath().toString(), (SearchParticipant)object)}, this.getWorkingCopies(iJavaElement), (SearchParticipant)object);
                ((SearchParticipant)object).locateMatches(searchDocumentArray, searchPattern, iJavaSearchScope, searchRequestor, iProgressMonitor);
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                searchRequestor.endReporting();
                throw throwable;
            }
            {
                Object var9_12 = null;
                searchRequestor.endReporting();
                return;
            }
        }
        catch (CoreException coreException) {
            if (!(coreException instanceof JavaModelException)) throw new JavaModelException(coreException);
            throw (JavaModelException)coreException;
        }
    }

    public void searchDeclarationsOfAccessedFields(IJavaElement iJavaElement, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfAccessedFields(IJavaElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfAccessedFieldsPattern declarationOfAccessedFieldsPattern = new DeclarationOfAccessedFieldsPattern(iJavaElement);
        this.searchDeclarations(iJavaElement, searchRequestor, declarationOfAccessedFieldsPattern, iProgressMonitor);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaElement iJavaElement, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfReferencedTypes(IJavaElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedTypesPattern declarationOfReferencedTypesPattern = new DeclarationOfReferencedTypesPattern(iJavaElement);
        this.searchDeclarations(iJavaElement, searchRequestor, declarationOfReferencedTypesPattern, iProgressMonitor);
    }

    public void searchDeclarationsOfSentMessages(IJavaElement iJavaElement, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfSentMessages(IJavaElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedMethodsPattern declarationOfReferencedMethodsPattern = new DeclarationOfReferencedMethodsPattern(iJavaElement);
        this.searchDeclarations(iJavaElement, searchRequestor, declarationOfReferencedMethodsPattern, iProgressMonitor);
    }
}

