/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;

public class IndexSelector {
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;

    public IndexSelector(IJavaSearchScope iJavaSearchScope, SearchPattern searchPattern) {
        this.searchScope = iJavaSearchScope;
        this.pattern = searchPattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaElement iJavaElement, boolean bl, IPath iPath) {
        try {
            IJavaProject iJavaProject;
            IOpenable iOpenable;
            IClasspathEntry[] iClasspathEntryArray = null;
            if (bl) {
                iOpenable = iJavaElement instanceof JarPackageFragmentRoot ? (JavaProject)iJavaElement.getParent() : (JavaProject)iJavaElement;
                iClasspathEntryArray = ((JavaProject)iOpenable).getExpandedClasspath();
            }
            if ((iJavaProject = IndexSelector.getJavaProject(iPath, (IJavaModel)(iOpenable = iJavaElement.getJavaModel()))) != null) {
                return IndexSelector.canSeeFocus(iJavaElement, (JavaProject)iJavaProject, iClasspathEntryArray);
            }
            IJavaProject[] iJavaProjectArray = iOpenable.getJavaProjects();
            int n = 0;
            int n2 = iJavaProjectArray.length;
            while (true) {
                if (n >= n2) {
                    return false;
                }
                JavaProject javaProject = (JavaProject)iJavaProjectArray[n];
                IClasspathEntry iClasspathEntry = javaProject.getClasspathEntryFor(iPath);
                if (iClasspathEntry != null && iClasspathEntry.getEntryKind() == 1 && IndexSelector.canSeeFocus(iJavaElement, javaProject, iClasspathEntryArray)) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaElement iJavaElement, JavaProject javaProject, IClasspathEntry[] iClasspathEntryArray) {
        try {
            int n;
            IPath iPath;
            if (iJavaElement.equals(javaProject)) {
                return true;
            }
            if (iClasspathEntryArray != null) {
                iPath = javaProject.getProject().getFullPath();
                int n2 = 0;
                n = iClasspathEntryArray.length;
                while (n2 < n) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                    if (iClasspathEntry.getEntryKind() == 2 && iClasspathEntry.getPath().equals((Object)iPath)) {
                        return true;
                    }
                    ++n2;
                }
            }
            if (iJavaElement instanceof JarPackageFragmentRoot) {
                iPath = iJavaElement.getPath();
                IClasspathEntry[] iClasspathEntryArray2 = javaProject.getExpandedClasspath();
                n = 0;
                int n3 = iClasspathEntryArray2.length;
                while (n < n3) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n];
                    if (iClasspathEntry.getEntryKind() == 1 && iClasspathEntry.getPath().equals((Object)iPath)) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            iPath = ((JavaProject)iJavaElement).getProject().getFullPath();
            IClasspathEntry[] iClasspathEntryArray3 = javaProject.getExpandedClasspath();
            n = 0;
            int n4 = iClasspathEntryArray3.length;
            while (n < n4) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray3[n];
                if (iClasspathEntry.getEntryKind() == 2 && iClasspathEntry.getPath().equals((Object)iPath)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void initializeIndexLocations() {
        int n;
        IPath[] iPathArray = this.searchScope.enclosingProjectsAndJars();
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        SimpleSet simpleSet = new SimpleSet();
        IJavaElement iJavaElement = MatchLocator.projectOrJarFocus(this.pattern);
        if (iJavaElement == null) {
            n = 0;
            while (n < iPathArray.length) {
                simpleSet.add(indexManager.computeIndexLocation(iPathArray[n]));
                ++n;
            }
        } else {
            try {
                IClasspathEntry[] iClasspathEntryArray;
                Object object;
                IClasspathEntry[] iClasspathEntryArray2;
                Openable openable;
                n = iPathArray.length;
                JavaProject[] javaProjectArray = new JavaProject[n];
                SimpleSet simpleSet2 = new SimpleSet(n);
                int n2 = 0;
                SimpleSet simpleSet3 = new SimpleSet(n);
                IClasspathEntry[] iClasspathEntryArray3 = null;
                if (this.pattern instanceof MethodPattern) {
                    openable = iJavaElement instanceof JarPackageFragmentRoot ? (JavaProject)iJavaElement.getParent() : (JavaProject)iJavaElement;
                    iClasspathEntryArray3 = ((JavaProject)openable).getExpandedClasspath();
                }
                openable = JavaModelManager.getJavaModelManager().getJavaModel();
                int n3 = 0;
                while (n3 < n) {
                    iClasspathEntryArray2 = iPathArray[n3];
                    JavaProject javaProject = (JavaProject)IndexSelector.getJavaProject((IPath)iClasspathEntryArray2, (IJavaModel)((Object)openable));
                    if (javaProject != null) {
                        simpleSet2.add(javaProject);
                        if (IndexSelector.canSeeFocus(iJavaElement, javaProject, iClasspathEntryArray3)) {
                            simpleSet.add(indexManager.computeIndexLocation((IPath)iClasspathEntryArray2));
                            javaProjectArray[n2++] = javaProject;
                        }
                    } else {
                        simpleSet3.add(iClasspathEntryArray2);
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2 && simpleSet3.elementSize > 0) {
                    iClasspathEntryArray2 = javaProjectArray[n3].getResolvedClasspath();
                    int n4 = iClasspathEntryArray2.length;
                    while (--n4 >= 0) {
                        object = iClasspathEntryArray2[n4];
                        if (object.getEntryKind() != 1 || !simpleSet3.includes(iClasspathEntryArray = object.getPath())) continue;
                        simpleSet.add(indexManager.computeIndexLocation(object.getPath()));
                        simpleSet3.remove(iClasspathEntryArray);
                    }
                    ++n3;
                }
                if (simpleSet3.elementSize > 0) {
                    IJavaProject[] iJavaProjectArray = openable.getJavaProjects();
                    int n5 = 0;
                    int n6 = iJavaProjectArray.length;
                    while (n5 < n6 && simpleSet3.elementSize > 0) {
                        object = (JavaProject)iJavaProjectArray[n5];
                        if (!simpleSet2.includes(object)) {
                            iClasspathEntryArray = ((JavaProject)object).getResolvedClasspath();
                            int n7 = iClasspathEntryArray.length;
                            while (--n7 >= 0) {
                                IPath iPath;
                                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n7];
                                if (iClasspathEntry.getEntryKind() != 1 || !simpleSet3.includes(iPath = iClasspathEntry.getPath())) continue;
                                simpleSet.add(indexManager.computeIndexLocation(iClasspathEntry.getPath()));
                                simpleSet3.remove(iPath);
                            }
                        }
                        ++n5;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.indexLocations = new IPath[simpleSet.elementSize];
        Object[] objectArray = simpleSet.values;
        int n8 = 0;
        int n9 = objectArray.length;
        while (--n9 >= 0) {
            if (objectArray[n9] == null) continue;
            this.indexLocations[n8++] = (IPath)objectArray[n9];
        }
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IJavaProject getJavaProject(IPath iPath, IJavaModel iJavaModel) {
        IJavaProject iJavaProject = iJavaModel.getJavaProject(iPath.lastSegment());
        if (iJavaProject.exists()) {
            return iJavaProject;
        }
        return null;
    }
}

