/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.processing.IJob;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern searchPattern, SearchParticipant searchParticipant, IJavaSearchScope iJavaSearchScope, IndexQueryRequestor indexQueryRequestor) {
        this.pattern = searchPattern;
        this.participant = searchParticipant;
        this.scope = iJavaSearchScope;
        this.requestor = indexQueryRequestor;
    }

    public boolean belongsTo(String string) {
        return true;
    }

    public void cancel() {
    }

    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    public boolean execute(IProgressMonitor iProgressMonitor) {
        boolean bl;
        block8: {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean bl2 = true;
            this.executionTime = 0L;
            Index[] indexArray = this.getIndexes(iProgressMonitor);
            try {
                int n = indexArray.length;
                if (iProgressMonitor != null) {
                    iProgressMonitor.beginTask("", n);
                }
                int n2 = 0;
                while (n2 < n) {
                    bl2 &= this.search(indexArray[n2], iProgressMonitor);
                    if (iProgressMonitor != null) {
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        iProgressMonitor.worked(1);
                    }
                    ++n2;
                }
                if (JobManager.VERBOSE) {
                    Util.verbose("-> execution time: " + this.executionTime + "ms - " + this);
                }
                bl = bl2;
                Object var6_7 = null;
                if (iProgressMonitor == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_8 = null;
                    if (iProgressMonitor == null) break block9;
                    iProgressMonitor.done();
                }
                throw throwable;
            }
            iProgressMonitor.done();
        }
        return bl;
    }

    public Index[] getIndexes(IProgressMonitor iProgressMonitor) {
        IPath[] iPathArray = this.participant.selectIndexes(this.pattern, this.scope);
        int n = iPathArray.length;
        Index[] indexArray = new Index[n];
        int n2 = 0;
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        int n3 = 0;
        while (n3 < n) {
            IPath iPath;
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IPath iPath2 = iPathArray[n3];
            Index index = indexManager.getIndex(iPath2);
            if (index == null && (iPath = (IPath)indexManager.indexLocations.keyForValue(iPath2)) != null) {
                index = indexManager.getIndex(iPath, iPath2, true, false);
            }
            if (index != null) {
                indexArray[n2++] = index;
            }
            ++n3;
        }
        if (n2 == n) {
            this.areIndexesReady = true;
        } else {
            Index[] indexArray2 = indexArray;
            indexArray = new Index[n2];
            System.arraycopy(indexArray2, 0, indexArray, 0, n2);
        }
        return indexArray;
    }

    public boolean search(Index index, IProgressMonitor iProgressMonitor) {
        if (index == null) {
            return true;
        }
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor readWriteMonitor = index.monitor;
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            readWriteMonitor.enterRead();
            long l = System.currentTimeMillis();
            MatchLocator.findIndexMatches(this.pattern, index, this.requestor, this.participant, this.scope, iProgressMonitor);
            this.executionTime += System.currentTimeMillis() - l;
            Object var6_6 = null;
            readWriteMonitor.exitRead();
            return true;
        }
        catch (IOException iOException) {
            try {
                if (iOException instanceof EOFException) {
                    iOException.printStackTrace();
                }
                Object var6_7 = null;
                readWriteMonitor.exitRead();
                return false;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                readWriteMonitor.exitRead();
                throw throwable;
            }
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

